import * as iam from '@aws-cdk/aws-iam';
import { IResource, Resource } from '@aws-cdk/core';
import { ITopicSubscription } from './subscriber';
export interface ITopic extends IResource {
    /**
     * @attribute
     */
    readonly topicArn: string;
    /**
     * @attribute
     */
    readonly topicName: string;
    /**
     * Subscribe some endpoint to this topic
     */
    addSubscription(subscription: ITopicSubscription): void;
    /**
     * Adds a statement to the IAM resource policy associated with this topic.
     *
     * If this topic was created in this stack (`new Topic`), a topic policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the topic is improted (`Topic.import`), then this is a no-op.
     */
    addToResourcePolicy(statement: iam.PolicyStatement): void;
    /**
     * Grant topic publishing permissions to the given identity
     */
    grantPublish(identity: iam.IGrantable): iam.Grant;
}
/**
 * Either a new or imported Topic
 */
export declare abstract class TopicBase extends Resource implements ITopic {
    abstract readonly topicArn: string;
    abstract readonly topicName: string;
    /**
     * Controls automatic creation of policy objects.
     *
     * Set by subclasses.
     */
    protected abstract readonly autoCreatePolicy: boolean;
    private policy?;
    /**
     * Subscribe some endpoint to this topic
     */
    addSubscription(subscription: ITopicSubscription): void;
    /**
     * Adds a statement to the IAM resource policy associated with this topic.
     *
     * If this topic was created in this stack (`new Topic`), a topic policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the topic is improted (`Topic.import`), then this is a no-op.
     */
    addToResourcePolicy(statement: iam.PolicyStatement): void;
    /**
     * Grant topic publishing permissions to the given identity
     */
    grantPublish(grantee: iam.IGrantable): iam.Grant;
    private nextTokenId;
}
