"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A subscription filter for an attribute.
 */
class SubscriptionFilter {
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     */
    static stringFilter(stringConditions) {
        const conditions = new Array();
        if (stringConditions.whitelist) {
            conditions.push(...stringConditions.whitelist);
        }
        if (stringConditions.blacklist) {
            conditions.push({ 'anything-but': stringConditions.blacklist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     */
    static numericFilter(numericConditions) {
        const conditions = new Array();
        if (numericConditions.whitelist) {
            conditions.push(...numericConditions.whitelist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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