# PyBoke: 极简博客生成器（含一些小功能）

- 使用过程极简
- 功能极简，代码极简

因为功能少、代码简单，任何懂编程的人（只要懂 Python 基础）
就能在短时间内完全看明白本软件的全部代码并且随心所欲地修改。

## 主要功能

- 只支持 Markdown 格式，用户只需要用 Markdown 写文章，即可生成静态博客。
- 添加文章时，不需要在任何地方填写文章标题、文章分类、标签、日期…… 这些全部都不用管，只管写文章
- 博客页面有一个 "random" 按钮，可随机阅读文章
- 自带四个极简主题 (CSS style), 可自行添加更多主题
- 自动生成 RSS (但只提供有限支持，详见 readme)
- 有一个简单的设定图片最大宽度的功能
- 有一个简单的替换图片地址功能

## 为什么不需要填写文章标题、文章分类、标签？

- 自动提取文件第一行的内容作为标题
- 管理博客文章的最常见的思维是通过 "类别", "标签", "日期" 三个维度来实现
- 本软件的第一版也是这样做的，花了很多时间精力几乎全部功能都实现时
  (甚至还用 PyQt 做了一些 GUI), 又全部推倒重做，因为发现了新的文章管理方法。

### "类别", "标签", "日期" 的缺点

- 这套方法有很多优点，因此才会流行，但也有缺点。
- 我认为缺点是用户发布文章时，每次都要选择分类、填标签，产生额外的心智负担。
- 而且处理这些功能，要写很多代码。

### 三个维度发现文章

- 我认为可以从 "三个维度**管理**文章" 变成 "三个维度**发现**文章"。
- 管理的目的是使文章井井有条，但我发现我真正担心的并不是文章是否排列整齐，
  而是如何让读者（或我自己）从旧文章中挑选一些文章来看，避免旧文章被埋没。
- 因此，我只要提供一些**发现**文章的维度即可，不需要强迫用户（作者）花时间精力去**管理**。
- 对于文章数量不会很多的个人博客来说, "标题索引", "日期", "随机" 已经够用了，
  同时使代码大幅减少，使用过程也很畅快，这个 trade-off 是值得的。

## 替换图片地址

- 在 markdown 中可使用 `![photo-1](../output/pics/XXX.jpg)` 的形式插入图片。
- 在每篇文章对应的 toml 文件的 pairs 项目里，可指定图片的替换地址，例如：
  ```toml
  pairs =  [
    [ '''../output/pics/abc.jpg''', '''https://example.com/abc.jpg''' ],
  ]
  ```
- 一旦提供替换地址, markdown 文件的内容保持不变, HTML 文件中如有第一个字符串，会被替代为第二个字符串。
- 不只是图片地址，该功能可以替换任何字符，但主要用途是替换图片地址。

## 更多信息

- 代码仓库 <https://github.com/ahui2016/pyboke>
- 我的博客 <https://blog.ai42.cc/>
