"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
const core_1 = require("@aws-cdk/core");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 */
class IntegTestCase extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.id = id;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.id]: toTestCase(this.props) },
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests.IntegTestCase", version: "1.156.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    onPrepare() {
        core_1.attachCustomSynthesis(this, {
            onSynthesize: (session) => {
                const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.props.testCases);
                synthesizer.synthesize(session);
            },
        });
    }
}
exports.IntegTest = IntegTest;
_b = JSII_RTTI_SYMBOL_1;
IntegTest[_b] = { fqn: "@aws-cdk/integ-tests.IntegTest", version: "1.156.0" };
function toTestCase(props) {
    return {
        ...props,
        stacks: props.stacks.map(s => s.artifactId),
    };
}
//# sourceMappingURL=data:application/json;base64,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