import { IntegManifest, TestOptions } from '@aws-cdk/cloud-assembly-schema';
import { Stack } from '@aws-cdk/core';
import { Construct } from '@aws-cdk/core';
/**
 * Properties of an integration test case
 */
export interface IntegTestCaseProps extends TestOptions {
    /**
     * Stacks to be deployed during the test
     */
    readonly stacks: Stack[];
}
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 */
export declare class IntegTestCase extends Construct {
    private readonly id;
    private readonly props;
    constructor(scope: Construct, id: string, props: IntegTestCaseProps);
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest(): IntegManifest;
}
/**
 * Integration test properties
 */
export interface IntegTestProps {
    /**
     * List of test cases that make up this test
     */
    readonly testCases: IntegTestCase[];
}
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
export declare class IntegTest extends Construct {
    private readonly props;
    constructor(scope: Construct, id: string, props: IntegTestProps);
    protected onPrepare(): void;
}
