"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EqualsAssertion = void 0;
const core_1 = require("@aws-cdk/core");
const providers_1 = require("./providers");
//
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
class EqualsAssertion extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const assertionProvider = new providers_1.AssertionsProvider(this, 'AssertionProvider');
        const properties = {
            actual: props.inputResource.getAttString(props.inputResourceAtt),
            expected: props.expected,
            assertionType: providers_1.AssertionType.EQUALS,
        };
        const resource = new core_1.CustomResource(this, 'Default', {
            serviceToken: assertionProvider.serviceToken,
            properties,
            resourceType: providers_1.ASSERT_RESOURCE_TYPE,
        });
        this.result = resource.getAttString('data');
    }
}
exports.EqualsAssertion = EqualsAssertion;
//# sourceMappingURL=data:application/json;base64,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