# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List


class ActivateRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        router_interface_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class ActivateRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ActivateRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ActivateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ActiveFlowLogRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        flow_log_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ActiveFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: str = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ActiveFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ActiveFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ActiveFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBgpNetworkRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dst_cidr_block: str = None,
        vpc_id: str = None,
        router_id: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dst_cidr_block = dst_cidr_block
        self.vpc_id = vpc_id
        self.router_id = router_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dst_cidr_block is not None:
            result['DstCidrBlock'] = self.dst_cidr_block
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DstCidrBlock') is not None:
            self.dst_cidr_block = m.get('DstCidrBlock')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AddBgpNetworkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddBgpNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddBgpNetworkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddBgpNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCommonBandwidthPackageIpRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        bandwidth_package_id: str = None,
        ip_instance_id: str = None,
        ip_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.ip_instance_id = ip_instance_id
        self.ip_type = ip_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.ip_instance_id is not None:
            result['IpInstanceId'] = self.ip_instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('IpInstanceId') is not None:
            self.ip_instance_id = m.get('IpInstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        return self


class AddCommonBandwidthPackageIpResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCommonBandwidthPackageIpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCommonBandwidthPackageIpResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCommonBandwidthPackageIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCommonBandwidthPackageIpsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        bandwidth_package_id: str = None,
        ip_type: str = None,
        ip_instance_ids: List[str] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.ip_type = ip_type
        self.ip_instance_ids = ip_instance_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.ip_instance_ids is not None:
            result['IpInstanceIds'] = self.ip_instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('IpInstanceIds') is not None:
            self.ip_instance_ids = m.get('IpInstanceIds')
        return self


class AddCommonBandwidthPackageIpsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCommonBandwidthPackageIpsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddCommonBandwidthPackageIpsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddCommonBandwidthPackageIpsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGlobalAccelerationInstanceIpRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        global_acceleration_instance_id: str = None,
        ip_instance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.global_acceleration_instance_id = global_acceleration_instance_id
        self.ip_instance_id = ip_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.global_acceleration_instance_id is not None:
            result['GlobalAccelerationInstanceId'] = self.global_acceleration_instance_id
        if self.ip_instance_id is not None:
            result['IpInstanceId'] = self.ip_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('GlobalAccelerationInstanceId') is not None:
            self.global_acceleration_instance_id = m.get('GlobalAccelerationInstanceId')
        if m.get('IpInstanceId') is not None:
            self.ip_instance_id = m.get('IpInstanceId')
        return self


class AddGlobalAccelerationInstanceIpResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddGlobalAccelerationInstanceIpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddGlobalAccelerationInstanceIpResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddGlobalAccelerationInstanceIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddIPv6TranslatorAclListEntryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        acl_id: str = None,
        acl_entry_ip: str = None,
        acl_entry_comment: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.acl_id = acl_id
        self.acl_entry_ip = acl_entry_ip
        self.acl_entry_comment = acl_entry_comment

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acl_entry_ip is not None:
            result['AclEntryIp'] = self.acl_entry_ip
        if self.acl_entry_comment is not None:
            result['AclEntryComment'] = self.acl_entry_comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AclEntryIp') is not None:
            self.acl_entry_ip = m.get('AclEntryIp')
        if m.get('AclEntryComment') is not None:
            self.acl_entry_comment = m.get('AclEntryComment')
        return self


class AddIPv6TranslatorAclListEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        acl_entry_id: str = None,
    ):
        self.request_id = request_id
        self.acl_entry_id = acl_entry_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.acl_entry_id is not None:
            result['AclEntryId'] = self.acl_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AclEntryId') is not None:
            self.acl_entry_id = m.get('AclEntryId')
        return self


class AddIPv6TranslatorAclListEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddIPv6TranslatorAclListEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddIPv6TranslatorAclListEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateEipAddressRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        bandwidth: str = None,
        period: int = None,
        isp: str = None,
        activity_id: int = None,
        netmode: str = None,
        auto_pay: bool = None,
        pricing_cycle: str = None,
        instance_charge_type: str = None,
        internet_charge_type: str = None,
        resource_group_id: str = None,
        owner_account: str = None,
        client_token: str = None,
        name: str = None,
        description: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.bandwidth = bandwidth
        self.period = period
        self.isp = isp
        self.activity_id = activity_id
        self.netmode = netmode
        self.auto_pay = auto_pay
        self.pricing_cycle = pricing_cycle
        self.instance_charge_type = instance_charge_type
        self.internet_charge_type = internet_charge_type
        self.resource_group_id = resource_group_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.name = name
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.period is not None:
            result['Period'] = self.period
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.activity_id is not None:
            result['ActivityId'] = self.activity_id
        if self.netmode is not None:
            result['Netmode'] = self.netmode
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('ActivityId') is not None:
            self.activity_id = m.get('ActivityId')
        if m.get('Netmode') is not None:
            self.netmode = m.get('Netmode')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class AllocateEipAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_group_id: str = None,
        allocation_id: str = None,
        eip_address: str = None,
        order_id: int = None,
    ):
        self.request_id = request_id
        self.resource_group_id = resource_group_id
        self.allocation_id = allocation_id
        self.eip_address = eip_address
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class AllocateEipAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateEipAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateEipAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateEipAddressProRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ip_address: str = None,
        instance_id: str = None,
        bandwidth: str = None,
        period: int = None,
        isp: str = None,
        netmode: str = None,
        auto_pay: bool = None,
        pricing_cycle: str = None,
        instance_charge_type: str = None,
        internet_charge_type: str = None,
        resource_group_id: str = None,
        owner_account: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ip_address = ip_address
        self.instance_id = instance_id
        self.bandwidth = bandwidth
        self.period = period
        self.isp = isp
        self.netmode = netmode
        self.auto_pay = auto_pay
        self.pricing_cycle = pricing_cycle
        self.instance_charge_type = instance_charge_type
        self.internet_charge_type = internet_charge_type
        self.resource_group_id = resource_group_id
        self.owner_account = owner_account
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.period is not None:
            result['Period'] = self.period
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.netmode is not None:
            result['Netmode'] = self.netmode
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('Netmode') is not None:
            self.netmode = m.get('Netmode')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AllocateEipAddressProResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_group_id: str = None,
        allocation_id: str = None,
        eip_address: str = None,
        order_id: int = None,
    ):
        self.request_id = request_id
        self.resource_group_id = resource_group_id
        self.allocation_id = allocation_id
        self.eip_address = eip_address
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class AllocateEipAddressProResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateEipAddressProResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateEipAddressProResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateEipSegmentAddressRequest(TeaModel):
    def __init__(
        self,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        bandwidth: str = None,
        region_id: str = None,
        eip_mask: str = None,
        netmode: str = None,
        internet_charge_type: str = None,
        resource_group_id: str = None,
        isp: str = None,
    ):
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.bandwidth = bandwidth
        self.region_id = region_id
        self.eip_mask = eip_mask
        self.netmode = netmode
        self.internet_charge_type = internet_charge_type
        self.resource_group_id = resource_group_id
        self.isp = isp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.eip_mask is not None:
            result['EipMask'] = self.eip_mask
        if self.netmode is not None:
            result['Netmode'] = self.netmode
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.isp is not None:
            result['Isp'] = self.isp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EipMask') is not None:
            self.eip_mask = m.get('EipMask')
        if m.get('Netmode') is not None:
            self.netmode = m.get('Netmode')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        return self


class AllocateEipSegmentAddressResponseBody(TeaModel):
    def __init__(
        self,
        eip_segment_instance_id: str = None,
        request_id: str = None,
        order_id: int = None,
    ):
        self.eip_segment_instance_id = eip_segment_instance_id
        self.request_id = request_id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.eip_segment_instance_id is not None:
            result['EipSegmentInstanceId'] = self.eip_segment_instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EipSegmentInstanceId') is not None:
            self.eip_segment_instance_id = m.get('EipSegmentInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class AllocateEipSegmentAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateEipSegmentAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateEipSegmentAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateIpv6InternetBandwidthRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6gateway_id: str = None,
        ipv_6address_id: str = None,
        internet_charge_type: str = None,
        bandwidth: int = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6gateway_id = ipv_6gateway_id
        self.ipv_6address_id = ipv_6address_id
        self.internet_charge_type = internet_charge_type
        self.bandwidth = bandwidth
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.ipv_6address_id is not None:
            result['Ipv6AddressId'] = self.ipv_6address_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('Ipv6AddressId') is not None:
            self.ipv_6address_id = m.get('Ipv6AddressId')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AllocateIpv6InternetBandwidthResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        internet_bandwidth_id: str = None,
        ipv_6address_id: str = None,
    ):
        self.request_id = request_id
        self.internet_bandwidth_id = internet_bandwidth_id
        self.ipv_6address_id = ipv_6address_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.internet_bandwidth_id is not None:
            result['InternetBandwidthId'] = self.internet_bandwidth_id
        if self.ipv_6address_id is not None:
            result['Ipv6AddressId'] = self.ipv_6address_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InternetBandwidthId') is not None:
            self.internet_bandwidth_id = m.get('InternetBandwidthId')
        if m.get('Ipv6AddressId') is not None:
            self.ipv_6address_id = m.get('Ipv6AddressId')
        return self


class AllocateIpv6InternetBandwidthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateIpv6InternetBandwidthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateIpv6InternetBandwidthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateEipAddressRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        allocation_id: str = None,
        instance_id: str = None,
        owner_account: str = None,
        instance_type: str = None,
        instance_region_id: str = None,
        private_ip_address: str = None,
        mode: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.allocation_id = allocation_id
        self.instance_id = instance_id
        self.owner_account = owner_account
        self.instance_type = instance_type
        self.instance_region_id = instance_region_id
        self.private_ip_address = private_ip_address
        self.mode = mode
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_region_id is not None:
            result['InstanceRegionId'] = self.instance_region_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceRegionId') is not None:
            self.instance_region_id = m.get('InstanceRegionId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AssociateEipAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateEipAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateEipAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateEipAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateGlobalAccelerationInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        global_acceleration_instance_id: str = None,
        backend_server_id: str = None,
        backend_server_region_id: str = None,
        owner_account: str = None,
        backend_server_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.global_acceleration_instance_id = global_acceleration_instance_id
        self.backend_server_id = backend_server_id
        self.backend_server_region_id = backend_server_region_id
        self.owner_account = owner_account
        self.backend_server_type = backend_server_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.global_acceleration_instance_id is not None:
            result['GlobalAccelerationInstanceId'] = self.global_acceleration_instance_id
        if self.backend_server_id is not None:
            result['BackendServerId'] = self.backend_server_id
        if self.backend_server_region_id is not None:
            result['BackendServerRegionId'] = self.backend_server_region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.backend_server_type is not None:
            result['BackendServerType'] = self.backend_server_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('GlobalAccelerationInstanceId') is not None:
            self.global_acceleration_instance_id = m.get('GlobalAccelerationInstanceId')
        if m.get('BackendServerId') is not None:
            self.backend_server_id = m.get('BackendServerId')
        if m.get('BackendServerRegionId') is not None:
            self.backend_server_region_id = m.get('BackendServerRegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('BackendServerType') is not None:
            self.backend_server_type = m.get('BackendServerType')
        return self


class AssociateGlobalAccelerationInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateGlobalAccelerationInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateGlobalAccelerationInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateGlobalAccelerationInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateHaVipRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        ha_vip_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.ha_vip_id = ha_vip_id
        self.instance_id = instance_id
        self.instance_type = instance_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class AssociateHaVipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateHaVipResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateNetworkAclRequestResource(TeaModel):
    def __init__(
        self,
        resource_type: str = None,
        resource_id: str = None,
    ):
        self.resource_type = resource_type
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class AssociateNetworkAclRequest(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
        region_id: str = None,
        resource: List[AssociateNetworkAclRequestResource] = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
    ):
        self.network_acl_id = network_acl_id
        self.region_id = region_id
        self.resource = resource
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = AssociateNetworkAclRequestResource()
                self.resource.append(temp_model.from_map(k))
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AssociateNetworkAclResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateNetworkAclResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateNetworkAclResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateNetworkAclResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociatePhysicalConnectionToVirtualBorderRouterRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vbr_id: str = None,
        physical_connection_id: str = None,
        vlan_id: str = None,
        circuit_code: str = None,
        local_gateway_ip: str = None,
        peer_gateway_ip: str = None,
        peering_subnet_mask: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
        local_ipv_6gateway_ip: str = None,
        peer_ipv_6gateway_ip: str = None,
        peering_ipv_6subnet_mask: str = None,
        enable_ipv_6: str = None,
    ):
        self.region_id = region_id
        self.vbr_id = vbr_id
        self.physical_connection_id = physical_connection_id
        self.vlan_id = vlan_id
        self.circuit_code = circuit_code
        self.local_gateway_ip = local_gateway_ip
        self.peer_gateway_ip = peer_gateway_ip
        self.peering_subnet_mask = peering_subnet_mask
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.local_ipv_6gateway_ip = local_ipv_6gateway_ip
        self.peer_ipv_6gateway_ip = peer_ipv_6gateway_ip
        self.peering_ipv_6subnet_mask = peering_ipv_6subnet_mask
        self.enable_ipv_6 = enable_ipv_6

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.local_gateway_ip is not None:
            result['LocalGatewayIp'] = self.local_gateway_ip
        if self.peer_gateway_ip is not None:
            result['PeerGatewayIp'] = self.peer_gateway_ip
        if self.peering_subnet_mask is not None:
            result['PeeringSubnetMask'] = self.peering_subnet_mask
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.local_ipv_6gateway_ip is not None:
            result['LocalIpv6GatewayIp'] = self.local_ipv_6gateway_ip
        if self.peer_ipv_6gateway_ip is not None:
            result['PeerIpv6GatewayIp'] = self.peer_ipv_6gateway_ip
        if self.peering_ipv_6subnet_mask is not None:
            result['PeeringIpv6SubnetMask'] = self.peering_ipv_6subnet_mask
        if self.enable_ipv_6 is not None:
            result['EnableIpv6'] = self.enable_ipv_6
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('LocalGatewayIp') is not None:
            self.local_gateway_ip = m.get('LocalGatewayIp')
        if m.get('PeerGatewayIp') is not None:
            self.peer_gateway_ip = m.get('PeerGatewayIp')
        if m.get('PeeringSubnetMask') is not None:
            self.peering_subnet_mask = m.get('PeeringSubnetMask')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('LocalIpv6GatewayIp') is not None:
            self.local_ipv_6gateway_ip = m.get('LocalIpv6GatewayIp')
        if m.get('PeerIpv6GatewayIp') is not None:
            self.peer_ipv_6gateway_ip = m.get('PeerIpv6GatewayIp')
        if m.get('PeeringIpv6SubnetMask') is not None:
            self.peering_ipv_6subnet_mask = m.get('PeeringIpv6SubnetMask')
        if m.get('EnableIpv6') is not None:
            self.enable_ipv_6 = m.get('EnableIpv6')
        return self


class AssociatePhysicalConnectionToVirtualBorderRouterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociatePhysicalConnectionToVirtualBorderRouterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociatePhysicalConnectionToVirtualBorderRouterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociatePhysicalConnectionToVirtualBorderRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateRouteTableRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        route_table_id: str = None,
        v_switch_id: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.route_table_id = route_table_id
        self.v_switch_id = v_switch_id
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AssociateRouteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateRouteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateRouteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateVpcCidrBlockRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vpc_id: str = None,
        secondary_cidr_block: str = None,
        ipv_6cidr_block: str = None,
        ipv_6cidr_type: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.secondary_cidr_block = secondary_cidr_block
        self.ipv_6cidr_block = ipv_6cidr_block
        self.ipv_6cidr_type = ipv_6cidr_type
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.secondary_cidr_block is not None:
            result['SecondaryCidrBlock'] = self.secondary_cidr_block
        if self.ipv_6cidr_block is not None:
            result['IPv6CidrBlock'] = self.ipv_6cidr_block
        if self.ipv_6cidr_type is not None:
            result['IPv6CidrType'] = self.ipv_6cidr_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('SecondaryCidrBlock') is not None:
            self.secondary_cidr_block = m.get('SecondaryCidrBlock')
        if m.get('IPv6CidrBlock') is not None:
            self.ipv_6cidr_block = m.get('IPv6CidrBlock')
        if m.get('IPv6CidrType') is not None:
            self.ipv_6cidr_type = m.get('IPv6CidrType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AssociateVpcCidrBlockResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateVpcCidrBlockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateVpcCidrBlockResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateVpcCidrBlockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateVpnGatewayWithCertificateRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vpn_gateway_id: str = None,
        certificate_type: str = None,
        certificate_id: str = None,
        caller_bid: str = None,
        client_token: str = None,
        dry_run: bool = None,
        resource_owner_id: int = None,
    ):
        self.region_id = region_id
        self.vpn_gateway_id = vpn_gateway_id
        self.certificate_type = certificate_type
        self.certificate_id = certificate_id
        self.caller_bid = caller_bid
        self.client_token = client_token
        self.dry_run = dry_run
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.certificate_type is not None:
            result['CertificateType'] = self.certificate_type
        if self.certificate_id is not None:
            result['CertificateId'] = self.certificate_id
        if self.caller_bid is not None:
            result['callerBid'] = self.caller_bid
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('CertificateType') is not None:
            self.certificate_type = m.get('CertificateType')
        if m.get('CertificateId') is not None:
            self.certificate_id = m.get('CertificateId')
        if m.get('callerBid') is not None:
            self.caller_bid = m.get('callerBid')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AssociateVpnGatewayWithCertificateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateVpnGatewayWithCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateVpnGatewayWithCertificateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateVpnGatewayWithCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachDhcpOptionsSetToVpcRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        dhcp_options_set_id: str = None,
        vpc_id: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        dry_run: bool = None,
    ):
        self.region_id = region_id
        self.dhcp_options_set_id = dhcp_options_set_id
        self.vpc_id = vpc_id
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.dry_run = dry_run

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dhcp_options_set_id is not None:
            result['DhcpOptionsSetId'] = self.dhcp_options_set_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DhcpOptionsSetId') is not None:
            self.dhcp_options_set_id = m.get('DhcpOptionsSetId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        return self


class AttachDhcpOptionsSetToVpcResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachDhcpOptionsSetToVpcResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AttachDhcpOptionsSetToVpcResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AttachDhcpOptionsSetToVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCommonBandwidthPackageIpBandwidthRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        bandwidth_package_id: str = None,
        eip_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.eip_id = eip_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.eip_id is not None:
            result['EipId'] = self.eip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('EipId') is not None:
            self.eip_id = m.get('EipId')
        return self


class CancelCommonBandwidthPackageIpBandwidthResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelCommonBandwidthPackageIpBandwidthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelCommonBandwidthPackageIpBandwidthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelCommonBandwidthPackageIpBandwidthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelExpressCloudConnectionRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ecc_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ecc_id = ecc_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ecc_id is not None:
            result['EccId'] = self.ecc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EccId') is not None:
            self.ecc_id = m.get('EccId')
        return self


class CancelExpressCloudConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelExpressCloudConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelExpressCloudConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelExpressCloudConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelPhysicalConnectionRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        physical_connection_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CancelPhysicalConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelPhysicalConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelPhysicalConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelPhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmPhysicalConnectionRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        physical_connection_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ConfirmPhysicalConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfirmPhysicalConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ConfirmPhysicalConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ConfirmPhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConnectRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        router_interface_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class ConnectRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConnectRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ConnectRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ConnectRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConvertBandwidthPackageRequest(TeaModel):
    def __init__(
        self,
        bandwidth_package_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
    ):
        self.bandwidth_package_id = bandwidth_package_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class ConvertBandwidthPackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        convert_instance_id: str = None,
    ):
        self.request_id = request_id
        self.convert_instance_id = convert_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.convert_instance_id is not None:
            result['ConvertInstanceId'] = self.convert_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConvertInstanceId') is not None:
            self.convert_instance_id = m.get('ConvertInstanceId')
        return self


class ConvertBandwidthPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ConvertBandwidthPackageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ConvertBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyNetworkAclEntriesRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        network_acl_id: str = None,
        source_network_acl_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
    ):
        self.region_id = region_id
        self.network_acl_id = network_acl_id
        self.source_network_acl_id = source_network_acl_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.source_network_acl_id is not None:
            result['SourceNetworkAclId'] = self.source_network_acl_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('SourceNetworkAclId') is not None:
            self.source_network_acl_id = m.get('SourceNetworkAclId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CopyNetworkAclEntriesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyNetworkAclEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyNetworkAclEntriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyNetworkAclEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBgpGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        router_id: str = None,
        name: str = None,
        description: str = None,
        local_asn: int = None,
        peer_asn: int = None,
        auth_key: str = None,
        is_fake_asn: bool = None,
        client_token: str = None,
        owner_account: str = None,
        ip_version: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.router_id = router_id
        self.name = name
        self.description = description
        self.local_asn = local_asn
        self.peer_asn = peer_asn
        self.auth_key = auth_key
        self.is_fake_asn = is_fake_asn
        self.client_token = client_token
        self.owner_account = owner_account
        self.ip_version = ip_version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.local_asn is not None:
            result['LocalAsn'] = self.local_asn
        if self.peer_asn is not None:
            result['PeerAsn'] = self.peer_asn
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.is_fake_asn is not None:
            result['IsFakeAsn'] = self.is_fake_asn
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LocalAsn') is not None:
            self.local_asn = m.get('LocalAsn')
        if m.get('PeerAsn') is not None:
            self.peer_asn = m.get('PeerAsn')
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('IsFakeAsn') is not None:
            self.is_fake_asn = m.get('IsFakeAsn')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        return self


class CreateBgpGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        bgp_group_id: str = None,
    ):
        self.request_id = request_id
        self.bgp_group_id = bgp_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.bgp_group_id is not None:
            result['BgpGroupId'] = self.bgp_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('BgpGroupId') is not None:
            self.bgp_group_id = m.get('BgpGroupId')
        return self


class CreateBgpGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBgpGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBgpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBgpPeerRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        bgp_group_id: str = None,
        peer_ip_address: str = None,
        enable_bfd: bool = None,
        client_token: str = None,
        owner_account: str = None,
        ip_version: str = None,
        bfd_multi_hop: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.bgp_group_id = bgp_group_id
        self.peer_ip_address = peer_ip_address
        self.enable_bfd = enable_bfd
        self.client_token = client_token
        self.owner_account = owner_account
        self.ip_version = ip_version
        self.bfd_multi_hop = bfd_multi_hop

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bgp_group_id is not None:
            result['BgpGroupId'] = self.bgp_group_id
        if self.peer_ip_address is not None:
            result['PeerIpAddress'] = self.peer_ip_address
        if self.enable_bfd is not None:
            result['EnableBfd'] = self.enable_bfd
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.bfd_multi_hop is not None:
            result['BfdMultiHop'] = self.bfd_multi_hop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BgpGroupId') is not None:
            self.bgp_group_id = m.get('BgpGroupId')
        if m.get('PeerIpAddress') is not None:
            self.peer_ip_address = m.get('PeerIpAddress')
        if m.get('EnableBfd') is not None:
            self.enable_bfd = m.get('EnableBfd')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('BfdMultiHop') is not None:
            self.bfd_multi_hop = m.get('BfdMultiHop')
        return self


class CreateBgpPeerResponseBody(TeaModel):
    def __init__(
        self,
        bgp_peer_id: str = None,
        request_id: str = None,
    ):
        self.bgp_peer_id = bgp_peer_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.bgp_peer_id is not None:
            result['BgpPeerId'] = self.bgp_peer_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgpPeerId') is not None:
            self.bgp_peer_id = m.get('BgpPeerId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBgpPeerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBgpPeerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBgpPeerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCommonBandwidthPackageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        zone: str = None,
        isp: str = None,
        name: str = None,
        description: str = None,
        client_token: str = None,
        resource_group_id: str = None,
        bandwidth: int = None,
        ratio: int = None,
        internet_charge_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.zone = zone
        self.isp = isp
        self.name = name
        self.description = description
        self.client_token = client_token
        self.resource_group_id = resource_group_id
        self.bandwidth = bandwidth
        self.ratio = ratio
        self.internet_charge_type = internet_charge_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone is not None:
            result['Zone'] = self.zone
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        return self


class CreateCommonBandwidthPackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_group_id: str = None,
        bandwidth_package_id: str = None,
    ):
        self.request_id = request_id
        self.resource_group_id = resource_group_id
        self.bandwidth_package_id = bandwidth_package_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        return self


class CreateCommonBandwidthPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateCommonBandwidthPackageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCommonBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomerGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        ip_address: str = None,
        name: str = None,
        description: str = None,
        asn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.ip_address = ip_address
        self.name = name
        self.description = description
        self.asn = asn

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.asn is not None:
            result['Asn'] = self.asn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Asn') is not None:
            self.asn = m.get('Asn')
        return self


class CreateCustomerGatewayResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        customer_gateway_id: str = None,
        create_time: int = None,
        ip_address: str = None,
        name: str = None,
    ):
        self.description = description
        self.request_id = request_id
        self.customer_gateway_id = customer_gateway_id
        self.create_time = create_time
        self.ip_address = ip_address
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.customer_gateway_id is not None:
            result['CustomerGatewayId'] = self.customer_gateway_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CustomerGatewayId') is not None:
            self.customer_gateway_id = m.get('CustomerGatewayId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateCustomerGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateCustomerGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCustomerGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDhcpOptionsSetRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        domain_name_servers: str = None,
        dhcp_options_set_name: str = None,
        dhcp_options_set_description: str = None,
        domain_name: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        dry_run: bool = None,
    ):
        self.region_id = region_id
        self.domain_name_servers = domain_name_servers
        self.dhcp_options_set_name = dhcp_options_set_name
        self.dhcp_options_set_description = dhcp_options_set_description
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.dry_run = dry_run

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.domain_name_servers is not None:
            result['DomainNameServers'] = self.domain_name_servers
        if self.dhcp_options_set_name is not None:
            result['DhcpOptionsSetName'] = self.dhcp_options_set_name
        if self.dhcp_options_set_description is not None:
            result['DhcpOptionsSetDescription'] = self.dhcp_options_set_description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DomainNameServers') is not None:
            self.domain_name_servers = m.get('DomainNameServers')
        if m.get('DhcpOptionsSetName') is not None:
            self.dhcp_options_set_name = m.get('DhcpOptionsSetName')
        if m.get('DhcpOptionsSetDescription') is not None:
            self.dhcp_options_set_description = m.get('DhcpOptionsSetDescription')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        return self


class CreateDhcpOptionsSetResponseBody(TeaModel):
    def __init__(
        self,
        dhcp_options_set_id: str = None,
        request_id: str = None,
    ):
        self.dhcp_options_set_id = dhcp_options_set_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.dhcp_options_set_id is not None:
            result['DhcpOptionsSetId'] = self.dhcp_options_set_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DhcpOptionsSetId') is not None:
            self.dhcp_options_set_id = m.get('DhcpOptionsSetId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDhcpOptionsSetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDhcpOptionsSetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDhcpOptionsSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateExpressCloudConnectionRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        description: str = None,
        peer_city: str = None,
        peer_location: str = None,
        idc_sp: str = None,
        port_type: str = None,
        bandwidth: int = None,
        contact_tel: str = None,
        contact_mail: str = None,
        idcard_no: str = None,
        redundant_ecc_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.description = description
        self.peer_city = peer_city
        self.peer_location = peer_location
        self.idc_sp = idc_sp
        self.port_type = port_type
        self.bandwidth = bandwidth
        self.contact_tel = contact_tel
        self.contact_mail = contact_mail
        self.idcard_no = idcard_no
        self.redundant_ecc_id = redundant_ecc_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.peer_city is not None:
            result['PeerCity'] = self.peer_city
        if self.peer_location is not None:
            result['PeerLocation'] = self.peer_location
        if self.idc_sp is not None:
            result['IdcSP'] = self.idc_sp
        if self.port_type is not None:
            result['PortType'] = self.port_type
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.contact_tel is not None:
            result['ContactTel'] = self.contact_tel
        if self.contact_mail is not None:
            result['ContactMail'] = self.contact_mail
        if self.idcard_no is not None:
            result['IDCardNo'] = self.idcard_no
        if self.redundant_ecc_id is not None:
            result['RedundantEccId'] = self.redundant_ecc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('PeerCity') is not None:
            self.peer_city = m.get('PeerCity')
        if m.get('PeerLocation') is not None:
            self.peer_location = m.get('PeerLocation')
        if m.get('IdcSP') is not None:
            self.idc_sp = m.get('IdcSP')
        if m.get('PortType') is not None:
            self.port_type = m.get('PortType')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ContactTel') is not None:
            self.contact_tel = m.get('ContactTel')
        if m.get('ContactMail') is not None:
            self.contact_mail = m.get('ContactMail')
        if m.get('IDCardNo') is not None:
            self.idcard_no = m.get('IDCardNo')
        if m.get('RedundantEccId') is not None:
            self.redundant_ecc_id = m.get('RedundantEccId')
        return self


class CreateExpressCloudConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ecc_id: str = None,
    ):
        self.request_id = request_id
        self.ecc_id = ecc_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ecc_id is not None:
            result['EccId'] = self.ecc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EccId') is not None:
            self.ecc_id = m.get('EccId')
        return self


class CreateExpressCloudConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateExpressCloudConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateExpressCloudConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowLogRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        flow_log_name: str = None,
        description: str = None,
        resource_type: str = None,
        resource_id: str = None,
        traffic_type: str = None,
        project_name: str = None,
        log_store_name: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.flow_log_name = flow_log_name
        self.description = description
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.traffic_type = traffic_type
        self.project_name = project_name
        self.log_store_name = log_store_name
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.flow_log_name is not None:
            result['FlowLogName'] = self.flow_log_name
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.traffic_type is not None:
            result['TrafficType'] = self.traffic_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('FlowLogName') is not None:
            self.flow_log_name = m.get('FlowLogName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('TrafficType') is not None:
            self.traffic_type = m.get('TrafficType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        flow_log_id: str = None,
        success: str = None,
    ):
        self.request_id = request_id
        self.flow_log_id = flow_log_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateForwardEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        forward_table_id: str = None,
        external_ip: str = None,
        external_port: str = None,
        internal_ip: str = None,
        internal_port: str = None,
        ip_protocol: str = None,
        forward_entry_name: str = None,
        client_token: str = None,
        port_break: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.external_ip = external_ip
        self.external_port = external_port
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.ip_protocol = ip_protocol
        self.forward_entry_name = forward_entry_name
        self.client_token = client_token
        self.port_break = port_break

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.forward_entry_name is not None:
            result['ForwardEntryName'] = self.forward_entry_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.port_break is not None:
            result['PortBreak'] = self.port_break
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('ForwardEntryName') is not None:
            self.forward_entry_name = m.get('ForwardEntryName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('PortBreak') is not None:
            self.port_break = m.get('PortBreak')
        return self


class CreateForwardEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        forward_entry_id: str = None,
    ):
        self.request_id = request_id
        self.forward_entry_id = forward_entry_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        return self


class CreateForwardEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateForwardEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGlobalAccelerationInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        service_location: str = None,
        bandwidth: str = None,
        bandwidth_type: str = None,
        name: str = None,
        description: str = None,
        owner_account: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.service_location = service_location
        self.bandwidth = bandwidth
        self.bandwidth_type = bandwidth_type
        self.name = name
        self.description = description
        self.owner_account = owner_account
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_location is not None:
            result['ServiceLocation'] = self.service_location
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.bandwidth_type is not None:
            result['BandwidthType'] = self.bandwidth_type
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceLocation') is not None:
            self.service_location = m.get('ServiceLocation')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('BandwidthType') is not None:
            self.bandwidth_type = m.get('BandwidthType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateGlobalAccelerationInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ip_address: str = None,
        global_acceleration_instance_id: str = None,
    ):
        self.request_id = request_id
        self.ip_address = ip_address
        self.global_acceleration_instance_id = global_acceleration_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.global_acceleration_instance_id is not None:
            result['GlobalAccelerationInstanceId'] = self.global_acceleration_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('GlobalAccelerationInstanceId') is not None:
            self.global_acceleration_instance_id = m.get('GlobalAccelerationInstanceId')
        return self


class CreateGlobalAccelerationInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateGlobalAccelerationInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateGlobalAccelerationInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHaVipRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        v_switch_id: str = None,
        ip_address: str = None,
        description: str = None,
    ):
        self.name = name
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.v_switch_id = v_switch_id
        self.ip_address = ip_address
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateHaVipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ip_address: str = None,
        ha_vip_id: str = None,
    ):
        self.request_id = request_id
        self.ip_address = ip_address
        self.ha_vip_id = ha_vip_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        return self


class CreateHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateHaVipResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIpsecServerRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vpn_gateway_id: str = None,
        local_subnet: str = None,
        client_ip_pool: str = None,
        ip_sec_server_name: str = None,
        effect_immediately: bool = None,
        ike_config: str = None,
        ipsec_config: str = None,
        psk_enabled: bool = None,
        psk: str = None,
        multi_factor_auth_enabled: bool = None,
        idaa_sinstance_id: str = None,
        client_token: str = None,
        caller_bid: str = None,
        dry_run: str = None,
        resource_owner_id: int = None,
    ):
        self.region_id = region_id
        self.vpn_gateway_id = vpn_gateway_id
        self.local_subnet = local_subnet
        self.client_ip_pool = client_ip_pool
        self.ip_sec_server_name = ip_sec_server_name
        self.effect_immediately = effect_immediately
        self.ike_config = ike_config
        self.ipsec_config = ipsec_config
        self.psk_enabled = psk_enabled
        self.psk = psk
        self.multi_factor_auth_enabled = multi_factor_auth_enabled
        self.idaa_sinstance_id = idaa_sinstance_id
        self.client_token = client_token
        self.caller_bid = caller_bid
        self.dry_run = dry_run
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.local_subnet is not None:
            result['LocalSubnet'] = self.local_subnet
        if self.client_ip_pool is not None:
            result['ClientIpPool'] = self.client_ip_pool
        if self.ip_sec_server_name is not None:
            result['IpSecServerName'] = self.ip_sec_server_name
        if self.effect_immediately is not None:
            result['EffectImmediately'] = self.effect_immediately
        if self.ike_config is not None:
            result['IkeConfig'] = self.ike_config
        if self.ipsec_config is not None:
            result['IpsecConfig'] = self.ipsec_config
        if self.psk_enabled is not None:
            result['PskEnabled'] = self.psk_enabled
        if self.psk is not None:
            result['Psk'] = self.psk
        if self.multi_factor_auth_enabled is not None:
            result['MultiFactorAuthEnabled'] = self.multi_factor_auth_enabled
        if self.idaa_sinstance_id is not None:
            result['IDaaSInstanceId'] = self.idaa_sinstance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.caller_bid is not None:
            result['callerBid'] = self.caller_bid
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('LocalSubnet') is not None:
            self.local_subnet = m.get('LocalSubnet')
        if m.get('ClientIpPool') is not None:
            self.client_ip_pool = m.get('ClientIpPool')
        if m.get('IpSecServerName') is not None:
            self.ip_sec_server_name = m.get('IpSecServerName')
        if m.get('EffectImmediately') is not None:
            self.effect_immediately = m.get('EffectImmediately')
        if m.get('IkeConfig') is not None:
            self.ike_config = m.get('IkeConfig')
        if m.get('IpsecConfig') is not None:
            self.ipsec_config = m.get('IpsecConfig')
        if m.get('PskEnabled') is not None:
            self.psk_enabled = m.get('PskEnabled')
        if m.get('Psk') is not None:
            self.psk = m.get('Psk')
        if m.get('MultiFactorAuthEnabled') is not None:
            self.multi_factor_auth_enabled = m.get('MultiFactorAuthEnabled')
        if m.get('IDaaSInstanceId') is not None:
            self.idaa_sinstance_id = m.get('IDaaSInstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('callerBid') is not None:
            self.caller_bid = m.get('callerBid')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateIpsecServerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vpn_gateway_id: str = None,
        ipsec_server_id: str = None,
        creation_time: str = None,
        region_id: str = None,
        ipsec_server_name: str = None,
    ):
        self.request_id = request_id
        self.vpn_gateway_id = vpn_gateway_id
        self.ipsec_server_id = ipsec_server_id
        self.creation_time = creation_time
        self.region_id = region_id
        self.ipsec_server_name = ipsec_server_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.ipsec_server_id is not None:
            result['IpsecServerId'] = self.ipsec_server_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipsec_server_name is not None:
            result['IpsecServerName'] = self.ipsec_server_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('IpsecServerId') is not None:
            self.ipsec_server_id = m.get('IpsecServerId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IpsecServerName') is not None:
            self.ipsec_server_name = m.get('IpsecServerName')
        return self


class CreateIpsecServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIpsecServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIpsecServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIpv6EgressOnlyRuleRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6gateway_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
        name: str = None,
        description: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6gateway_id = ipv_6gateway_id
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.name = name
        self.description = description
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateIpv6EgressOnlyRuleResponseBody(TeaModel):
    def __init__(
        self,
        ipv_6egress_rule_id: str = None,
        request_id: str = None,
    ):
        self.ipv_6egress_rule_id = ipv_6egress_rule_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ipv_6egress_rule_id is not None:
            result['Ipv6EgressRuleId'] = self.ipv_6egress_rule_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ipv6EgressRuleId') is not None:
            self.ipv_6egress_rule_id = m.get('Ipv6EgressRuleId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateIpv6EgressOnlyRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIpv6EgressOnlyRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIpv6EgressOnlyRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIpv6GatewayRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vpc_id: str = None,
        spec: str = None,
        name: str = None,
        description: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.spec = spec
        self.name = name
        self.description = description
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateIpv6GatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ipv_6gateway_id: str = None,
    ):
        self.request_id = request_id
        self.ipv_6gateway_id = ipv_6gateway_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        return self


class CreateIpv6GatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIpv6GatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIpv6GatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIPv6TranslatorRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        name: str = None,
        spec: str = None,
        pay_type: str = None,
        pricing_cycle: str = None,
        duration: int = None,
        auto_pay: bool = None,
        bandwidth: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.name = name
        self.spec = spec
        self.pay_type = pay_type
        self.pricing_cycle = pricing_cycle
        self.duration = duration
        self.auto_pay = auto_pay
        self.bandwidth = bandwidth

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.name is not None:
            result['Name'] = self.name
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        return self


class CreateIPv6TranslatorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ipv_6translator_id: str = None,
        spec: str = None,
        order_id: int = None,
        name: str = None,
    ):
        self.request_id = request_id
        self.ipv_6translator_id = ipv_6translator_id
        self.spec = spec
        self.order_id = order_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateIPv6TranslatorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIPv6TranslatorResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIPv6TranslatorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIPv6TranslatorAclListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        acl_name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.acl_name = acl_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.acl_name is not None:
            result['AclName'] = self.acl_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('AclName') is not None:
            self.acl_name = m.get('AclName')
        return self


class CreateIPv6TranslatorAclListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        acl_id: str = None,
    ):
        self.request_id = request_id
        self.acl_id = acl_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        return self


class CreateIPv6TranslatorAclListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIPv6TranslatorAclListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIPv6TranslatorAclListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIPv6TranslatorEntryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ipv_6translator_id: str = None,
        entry_name: str = None,
        entry_description: str = None,
        allocate_ipv_6port: int = None,
        backend_ipv_4addr: str = None,
        backend_ipv_4port: int = None,
        trans_protocol: str = None,
        entry_bandwidth: int = None,
        acl_status: str = None,
        acl_type: str = None,
        acl_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ipv_6translator_id = ipv_6translator_id
        self.entry_name = entry_name
        self.entry_description = entry_description
        self.allocate_ipv_6port = allocate_ipv_6port
        self.backend_ipv_4addr = backend_ipv_4addr
        self.backend_ipv_4port = backend_ipv_4port
        self.trans_protocol = trans_protocol
        self.entry_bandwidth = entry_bandwidth
        self.acl_status = acl_status
        self.acl_type = acl_type
        self.acl_id = acl_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        if self.entry_name is not None:
            result['EntryName'] = self.entry_name
        if self.entry_description is not None:
            result['EntryDescription'] = self.entry_description
        if self.allocate_ipv_6port is not None:
            result['AllocateIpv6Port'] = self.allocate_ipv_6port
        if self.backend_ipv_4addr is not None:
            result['BackendIpv4Addr'] = self.backend_ipv_4addr
        if self.backend_ipv_4port is not None:
            result['BackendIpv4Port'] = self.backend_ipv_4port
        if self.trans_protocol is not None:
            result['TransProtocol'] = self.trans_protocol
        if self.entry_bandwidth is not None:
            result['EntryBandwidth'] = self.entry_bandwidth
        if self.acl_status is not None:
            result['AclStatus'] = self.acl_status
        if self.acl_type is not None:
            result['AclType'] = self.acl_type
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        if m.get('EntryName') is not None:
            self.entry_name = m.get('EntryName')
        if m.get('EntryDescription') is not None:
            self.entry_description = m.get('EntryDescription')
        if m.get('AllocateIpv6Port') is not None:
            self.allocate_ipv_6port = m.get('AllocateIpv6Port')
        if m.get('BackendIpv4Addr') is not None:
            self.backend_ipv_4addr = m.get('BackendIpv4Addr')
        if m.get('BackendIpv4Port') is not None:
            self.backend_ipv_4port = m.get('BackendIpv4Port')
        if m.get('TransProtocol') is not None:
            self.trans_protocol = m.get('TransProtocol')
        if m.get('EntryBandwidth') is not None:
            self.entry_bandwidth = m.get('EntryBandwidth')
        if m.get('AclStatus') is not None:
            self.acl_status = m.get('AclStatus')
        if m.get('AclType') is not None:
            self.acl_type = m.get('AclType')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        return self


class CreateIPv6TranslatorEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ipv_6translator_entry_id: str = None,
    ):
        self.request_id = request_id
        self.ipv_6translator_entry_id = ipv_6translator_entry_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ipv_6translator_entry_id is not None:
            result['Ipv6TranslatorEntryId'] = self.ipv_6translator_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Ipv6TranslatorEntryId') is not None:
            self.ipv_6translator_entry_id = m.get('Ipv6TranslatorEntryId')
        return self


class CreateIPv6TranslatorEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIPv6TranslatorEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIPv6TranslatorEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNatGatewayRequestBandwidthPackage(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateNatGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        vpc_id: str = None,
        name: str = None,
        description: str = None,
        client_token: str = None,
        spec: str = None,
        instance_charge_type: str = None,
        pricing_cycle: str = None,
        duration: str = None,
        auto_pay: bool = None,
        v_switch_id: str = None,
        nat_type: str = None,
        internet_charge_type: str = None,
        bandwidth_package: List[CreateNatGatewayRequestBandwidthPackage] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.name = name
        self.description = description
        self.client_token = client_token
        self.spec = spec
        self.instance_charge_type = instance_charge_type
        self.pricing_cycle = pricing_cycle
        self.duration = duration
        self.auto_pay = auto_pay
        self.v_switch_id = v_switch_id
        self.nat_type = nat_type
        self.internet_charge_type = internet_charge_type
        self.bandwidth_package = bandwidth_package

    def validate(self):
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.nat_type is not None:
            result['NatType'] = self.nat_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NatType') is not None:
            self.nat_type = m.get('NatType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        self.bandwidth_package = []
        if m.get('BandwidthPackage') is not None:
            for k in m.get('BandwidthPackage'):
                temp_model = CreateNatGatewayRequestBandwidthPackage()
                self.bandwidth_package.append(temp_model.from_map(k))
        return self


class CreateNatGatewayResponseBodySnatTableIds(TeaModel):
    def __init__(
        self,
        snat_table_id: List[str] = None,
    ):
        self.snat_table_id = snat_table_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.snat_table_id is not None:
            result['SnatTableId'] = self.snat_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnatTableId') is not None:
            self.snat_table_id = m.get('SnatTableId')
        return self


class CreateNatGatewayResponseBodyForwardTableIds(TeaModel):
    def __init__(
        self,
        forward_table_id: List[str] = None,
    ):
        self.forward_table_id = forward_table_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        return self


class CreateNatGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snat_table_ids: CreateNatGatewayResponseBodySnatTableIds = None,
        forward_table_ids: CreateNatGatewayResponseBodyForwardTableIds = None,
        nat_gateway_id: str = None,
    ):
        self.request_id = request_id
        self.snat_table_ids = snat_table_ids
        self.forward_table_ids = forward_table_ids
        self.nat_gateway_id = nat_gateway_id

    def validate(self):
        if self.snat_table_ids:
            self.snat_table_ids.validate()
        if self.forward_table_ids:
            self.forward_table_ids.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snat_table_ids is not None:
            result['SnatTableIds'] = self.snat_table_ids.to_map()
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnatTableIds') is not None:
            temp_model = CreateNatGatewayResponseBodySnatTableIds()
            self.snat_table_ids = temp_model.from_map(m['SnatTableIds'])
        if m.get('ForwardTableIds') is not None:
            temp_model = CreateNatGatewayResponseBodyForwardTableIds()
            self.forward_table_ids = temp_model.from_map(m['ForwardTableIds'])
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        return self


class CreateNatGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateNatGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkAclRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        network_acl_name: str = None,
        description: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
    ):
        self.vpc_id = vpc_id
        self.network_acl_name = network_acl_name
        self.description = description
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        if self.description is not None:
            result['Description'] = self.description
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateNetworkAclResponseBodyNetworkAclAttributeEgressAclEntriesEgressAclEntry(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
        entry_type: str = None,
        network_acl_entry_name: str = None,
        policy: str = None,
        description: str = None,
        protocol: str = None,
        destination_cidr_ip: str = None,
        port: str = None,
    ):
        self.network_acl_entry_id = network_acl_entry_id
        self.entry_type = entry_type
        self.network_acl_entry_name = network_acl_entry_name
        self.policy = policy
        self.description = description
        self.protocol = protocol
        self.destination_cidr_ip = destination_cidr_ip
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.description is not None:
            result['Description'] = self.description
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.destination_cidr_ip is not None:
            result['DestinationCidrIp'] = self.destination_cidr_ip
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('DestinationCidrIp') is not None:
            self.destination_cidr_ip = m.get('DestinationCidrIp')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class CreateNetworkAclResponseBodyNetworkAclAttributeEgressAclEntries(TeaModel):
    def __init__(
        self,
        egress_acl_entry: List[CreateNetworkAclResponseBodyNetworkAclAttributeEgressAclEntriesEgressAclEntry] = None,
    ):
        self.egress_acl_entry = egress_acl_entry

    def validate(self):
        if self.egress_acl_entry:
            for k in self.egress_acl_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EgressAclEntry'] = []
        if self.egress_acl_entry is not None:
            for k in self.egress_acl_entry:
                result['EgressAclEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.egress_acl_entry = []
        if m.get('EgressAclEntry') is not None:
            for k in m.get('EgressAclEntry'):
                temp_model = CreateNetworkAclResponseBodyNetworkAclAttributeEgressAclEntriesEgressAclEntry()
                self.egress_acl_entry.append(temp_model.from_map(k))
        return self


class CreateNetworkAclResponseBodyNetworkAclAttributeIngressAclEntriesIngressAclEntry(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
        entry_type: str = None,
        network_acl_entry_name: str = None,
        policy: str = None,
        description: str = None,
        source_cidr_ip: str = None,
        protocol: str = None,
        port: str = None,
    ):
        self.network_acl_entry_id = network_acl_entry_id
        self.entry_type = entry_type
        self.network_acl_entry_name = network_acl_entry_name
        self.policy = policy
        self.description = description
        self.source_cidr_ip = source_cidr_ip
        self.protocol = protocol
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.description is not None:
            result['Description'] = self.description
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class CreateNetworkAclResponseBodyNetworkAclAttributeIngressAclEntries(TeaModel):
    def __init__(
        self,
        ingress_acl_entry: List[CreateNetworkAclResponseBodyNetworkAclAttributeIngressAclEntriesIngressAclEntry] = None,
    ):
        self.ingress_acl_entry = ingress_acl_entry

    def validate(self):
        if self.ingress_acl_entry:
            for k in self.ingress_acl_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['IngressAclEntry'] = []
        if self.ingress_acl_entry is not None:
            for k in self.ingress_acl_entry:
                result['IngressAclEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ingress_acl_entry = []
        if m.get('IngressAclEntry') is not None:
            for k in m.get('IngressAclEntry'):
                temp_model = CreateNetworkAclResponseBodyNetworkAclAttributeIngressAclEntriesIngressAclEntry()
                self.ingress_acl_entry.append(temp_model.from_map(k))
        return self


class CreateNetworkAclResponseBodyNetworkAclAttributeResourcesResource(TeaModel):
    def __init__(
        self,
        status: str = None,
        resource_type: str = None,
        resource_id: str = None,
    ):
        self.status = status
        self.resource_type = resource_type
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class CreateNetworkAclResponseBodyNetworkAclAttributeResources(TeaModel):
    def __init__(
        self,
        resource: List[CreateNetworkAclResponseBodyNetworkAclAttributeResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = CreateNetworkAclResponseBodyNetworkAclAttributeResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class CreateNetworkAclResponseBodyNetworkAclAttribute(TeaModel):
    def __init__(
        self,
        status: str = None,
        vpc_id: str = None,
        creation_time: str = None,
        description: str = None,
        egress_acl_entries: CreateNetworkAclResponseBodyNetworkAclAttributeEgressAclEntries = None,
        network_acl_name: str = None,
        ingress_acl_entries: CreateNetworkAclResponseBodyNetworkAclAttributeIngressAclEntries = None,
        network_acl_id: str = None,
        resources: CreateNetworkAclResponseBodyNetworkAclAttributeResources = None,
        region_id: str = None,
    ):
        self.status = status
        self.vpc_id = vpc_id
        self.creation_time = creation_time
        self.description = description
        self.egress_acl_entries = egress_acl_entries
        self.network_acl_name = network_acl_name
        self.ingress_acl_entries = ingress_acl_entries
        self.network_acl_id = network_acl_id
        self.resources = resources
        self.region_id = region_id

    def validate(self):
        if self.egress_acl_entries:
            self.egress_acl_entries.validate()
        if self.ingress_acl_entries:
            self.ingress_acl_entries.validate()
        if self.resources:
            self.resources.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.egress_acl_entries is not None:
            result['EgressAclEntries'] = self.egress_acl_entries.to_map()
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        if self.ingress_acl_entries is not None:
            result['IngressAclEntries'] = self.ingress_acl_entries.to_map()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EgressAclEntries') is not None:
            temp_model = CreateNetworkAclResponseBodyNetworkAclAttributeEgressAclEntries()
            self.egress_acl_entries = temp_model.from_map(m['EgressAclEntries'])
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        if m.get('IngressAclEntries') is not None:
            temp_model = CreateNetworkAclResponseBodyNetworkAclAttributeIngressAclEntries()
            self.ingress_acl_entries = temp_model.from_map(m['IngressAclEntries'])
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('Resources') is not None:
            temp_model = CreateNetworkAclResponseBodyNetworkAclAttributeResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateNetworkAclResponseBody(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
        request_id: str = None,
        network_acl_attribute: CreateNetworkAclResponseBodyNetworkAclAttribute = None,
    ):
        self.network_acl_id = network_acl_id
        self.request_id = request_id
        self.network_acl_attribute = network_acl_attribute

    def validate(self):
        if self.network_acl_attribute:
            self.network_acl_attribute.validate()

    def to_map(self):
        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.network_acl_attribute is not None:
            result['NetworkAclAttribute'] = self.network_acl_attribute.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NetworkAclAttribute') is not None:
            temp_model = CreateNetworkAclResponseBodyNetworkAclAttribute()
            self.network_acl_attribute = temp_model.from_map(m['NetworkAclAttribute'])
        return self


class CreateNetworkAclResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateNetworkAclResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateNetworkAclResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePhysicalConnectionOccupancyOrderRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        physical_connection_id: str = None,
        period: int = None,
        instance_charge_type: str = None,
        auto_pay: bool = None,
        pricing_cycle: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.period = period
        self.instance_charge_type = instance_charge_type
        self.auto_pay = auto_pay
        self.pricing_cycle = pricing_cycle
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.period is not None:
            result['Period'] = self.period
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreatePhysicalConnectionOccupancyOrderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePhysicalConnectionOccupancyOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreatePhysicalConnectionOccupancyOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePhysicalConnectionOccupancyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRouteEntryRequestNextHopList(TeaModel):
    def __init__(
        self,
        next_hop_id: str = None,
        weight: int = None,
        next_hop_type: str = None,
    ):
        self.next_hop_id = next_hop_id
        self.weight = weight
        self.next_hop_type = next_hop_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        return self


class CreateRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        route_table_id: str = None,
        destination_cidr_block: str = None,
        next_hop_id: str = None,
        private_ip_address: str = None,
        client_token: str = None,
        route_entry_name: str = None,
        description: str = None,
        next_hop_type: str = None,
        owner_account: str = None,
        next_hop_list: List[CreateRouteEntryRequestNextHopList] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.route_table_id = route_table_id
        self.destination_cidr_block = destination_cidr_block
        self.next_hop_id = next_hop_id
        self.private_ip_address = private_ip_address
        self.client_token = client_token
        self.route_entry_name = route_entry_name
        self.description = description
        self.next_hop_type = next_hop_type
        self.owner_account = owner_account
        self.next_hop_list = next_hop_list

    def validate(self):
        if self.next_hop_list:
            for k in self.next_hop_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.route_entry_name is not None:
            result['RouteEntryName'] = self.route_entry_name
        if self.description is not None:
            result['Description'] = self.description
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        result['NextHopList'] = []
        if self.next_hop_list is not None:
            for k in self.next_hop_list:
                result['NextHopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RouteEntryName') is not None:
            self.route_entry_name = m.get('RouteEntryName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        self.next_hop_list = []
        if m.get('NextHopList') is not None:
            for k in m.get('NextHopList'):
                temp_model = CreateRouteEntryRequestNextHopList()
                self.next_hop_list.append(temp_model.from_map(k))
        return self


class CreateRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRouteTableRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vpc_id: str = None,
        route_table_name: str = None,
        description: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
    ):
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.route_table_name = route_table_name
        self.description = description
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.route_table_name is not None:
            result['RouteTableName'] = self.route_table_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RouteTableName') is not None:
            self.route_table_name = m.get('RouteTableName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateRouteTableResponseBody(TeaModel):
    def __init__(
        self,
        route_table_id: str = None,
        request_id: str = None,
    ):
        self.route_table_id = route_table_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRouteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRouteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnatEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        snat_table_id: str = None,
        source_vswitch_id: str = None,
        source_cidr: str = None,
        snat_ip: str = None,
        snat_entry_name: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.snat_table_id = snat_table_id
        self.source_vswitch_id = source_vswitch_id
        self.source_cidr = source_cidr
        self.snat_ip = snat_ip
        self.snat_entry_name = snat_entry_name
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snat_table_id is not None:
            result['SnatTableId'] = self.snat_table_id
        if self.source_vswitch_id is not None:
            result['SourceVSwitchId'] = self.source_vswitch_id
        if self.source_cidr is not None:
            result['SourceCIDR'] = self.source_cidr
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        if self.snat_entry_name is not None:
            result['SnatEntryName'] = self.snat_entry_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnatTableId') is not None:
            self.snat_table_id = m.get('SnatTableId')
        if m.get('SourceVSwitchId') is not None:
            self.source_vswitch_id = m.get('SourceVSwitchId')
        if m.get('SourceCIDR') is not None:
            self.source_cidr = m.get('SourceCIDR')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        if m.get('SnatEntryName') is not None:
            self.snat_entry_name = m.get('SnatEntryName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snat_entry_id: str = None,
    ):
        self.request_id = request_id
        self.snat_entry_id = snat_entry_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        return self


class CreateSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSslVpnClientCertRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
        ssl_vpn_server_id: str = None,
        name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.region_id = region_id
        self.ssl_vpn_server_id = ssl_vpn_server_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateSslVpnClientCertResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ssl_vpn_client_cert_id: str = None,
        name: str = None,
    ):
        self.request_id = request_id
        self.ssl_vpn_client_cert_id = ssl_vpn_client_cert_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ssl_vpn_client_cert_id is not None:
            result['SslVpnClientCertId'] = self.ssl_vpn_client_cert_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SslVpnClientCertId') is not None:
            self.ssl_vpn_client_cert_id = m.get('SslVpnClientCertId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateSslVpnClientCertResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSslVpnClientCertResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSslVpnClientCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSslVpnServerRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
        vpn_gateway_id: str = None,
        name: str = None,
        client_ip_pool: str = None,
        local_subnet: str = None,
        proto: str = None,
        cipher: str = None,
        port: int = None,
        compress: bool = None,
        enable_multi_factor_auth: bool = None,
        idaa_sinstance_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.region_id = region_id
        self.vpn_gateway_id = vpn_gateway_id
        self.name = name
        self.client_ip_pool = client_ip_pool
        self.local_subnet = local_subnet
        self.proto = proto
        self.cipher = cipher
        self.port = port
        self.compress = compress
        self.enable_multi_factor_auth = enable_multi_factor_auth
        self.idaa_sinstance_id = idaa_sinstance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.name is not None:
            result['Name'] = self.name
        if self.client_ip_pool is not None:
            result['ClientIpPool'] = self.client_ip_pool
        if self.local_subnet is not None:
            result['LocalSubnet'] = self.local_subnet
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.cipher is not None:
            result['Cipher'] = self.cipher
        if self.port is not None:
            result['Port'] = self.port
        if self.compress is not None:
            result['Compress'] = self.compress
        if self.enable_multi_factor_auth is not None:
            result['EnableMultiFactorAuth'] = self.enable_multi_factor_auth
        if self.idaa_sinstance_id is not None:
            result['IDaaSInstanceId'] = self.idaa_sinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ClientIpPool') is not None:
            self.client_ip_pool = m.get('ClientIpPool')
        if m.get('LocalSubnet') is not None:
            self.local_subnet = m.get('LocalSubnet')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Cipher') is not None:
            self.cipher = m.get('Cipher')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Compress') is not None:
            self.compress = m.get('Compress')
        if m.get('EnableMultiFactorAuth') is not None:
            self.enable_multi_factor_auth = m.get('EnableMultiFactorAuth')
        if m.get('IDaaSInstanceId') is not None:
            self.idaa_sinstance_id = m.get('IDaaSInstanceId')
        return self


class CreateSslVpnServerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ssl_vpn_server_id: str = None,
        name: str = None,
    ):
        self.request_id = request_id
        self.ssl_vpn_server_id = ssl_vpn_server_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateSslVpnServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSslVpnServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSslVpnServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        cidr_block: str = None,
        ipv_6cidr_block: str = None,
        enable_ipv_6: bool = None,
        vpc_name: str = None,
        description: str = None,
        resource_group_id: str = None,
        dry_run: bool = None,
        user_cidr: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cidr_block = cidr_block
        self.ipv_6cidr_block = ipv_6cidr_block
        self.enable_ipv_6 = enable_ipv_6
        self.vpc_name = vpc_name
        self.description = description
        self.resource_group_id = resource_group_id
        self.dry_run = dry_run
        self.user_cidr = user_cidr
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.ipv_6cidr_block is not None:
            result['Ipv6CidrBlock'] = self.ipv_6cidr_block
        if self.enable_ipv_6 is not None:
            result['EnableIpv6'] = self.enable_ipv_6
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Ipv6CidrBlock') is not None:
            self.ipv_6cidr_block = m.get('Ipv6CidrBlock')
        if m.get('EnableIpv6') is not None:
            self.enable_ipv_6 = m.get('EnableIpv6')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateVpcResponseBody(TeaModel):
    def __init__(
        self,
        vrouter_id: str = None,
        route_table_id: str = None,
        vpc_id: str = None,
        request_id: str = None,
        resource_group_id: str = None,
    ):
        self.vrouter_id = vrouter_id
        self.route_table_id = route_table_id
        self.vpc_id = vpc_id
        self.request_id = request_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.vrouter_id is not None:
            result['VRouterId'] = self.vrouter_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VRouterId') is not None:
            self.vrouter_id = m.get('VRouterId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateVpcResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVpcResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpnConnectionRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        customer_gateway_id: str = None,
        vpn_gateway_id: str = None,
        name: str = None,
        local_subnet: str = None,
        remote_subnet: str = None,
        effect_immediately: bool = None,
        ike_config: str = None,
        ipsec_config: str = None,
        health_check_config: str = None,
        auto_config_route: bool = None,
        enable_dpd: bool = None,
        enable_nat_traversal: bool = None,
        bgp_config: str = None,
        remote_ca_certificate: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.customer_gateway_id = customer_gateway_id
        self.vpn_gateway_id = vpn_gateway_id
        self.name = name
        self.local_subnet = local_subnet
        self.remote_subnet = remote_subnet
        self.effect_immediately = effect_immediately
        self.ike_config = ike_config
        self.ipsec_config = ipsec_config
        self.health_check_config = health_check_config
        self.auto_config_route = auto_config_route
        self.enable_dpd = enable_dpd
        self.enable_nat_traversal = enable_nat_traversal
        self.bgp_config = bgp_config
        self.remote_ca_certificate = remote_ca_certificate

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.customer_gateway_id is not None:
            result['CustomerGatewayId'] = self.customer_gateway_id
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.name is not None:
            result['Name'] = self.name
        if self.local_subnet is not None:
            result['LocalSubnet'] = self.local_subnet
        if self.remote_subnet is not None:
            result['RemoteSubnet'] = self.remote_subnet
        if self.effect_immediately is not None:
            result['EffectImmediately'] = self.effect_immediately
        if self.ike_config is not None:
            result['IkeConfig'] = self.ike_config
        if self.ipsec_config is not None:
            result['IpsecConfig'] = self.ipsec_config
        if self.health_check_config is not None:
            result['HealthCheckConfig'] = self.health_check_config
        if self.auto_config_route is not None:
            result['AutoConfigRoute'] = self.auto_config_route
        if self.enable_dpd is not None:
            result['EnableDpd'] = self.enable_dpd
        if self.enable_nat_traversal is not None:
            result['EnableNatTraversal'] = self.enable_nat_traversal
        if self.bgp_config is not None:
            result['BgpConfig'] = self.bgp_config
        if self.remote_ca_certificate is not None:
            result['RemoteCaCertificate'] = self.remote_ca_certificate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CustomerGatewayId') is not None:
            self.customer_gateway_id = m.get('CustomerGatewayId')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('LocalSubnet') is not None:
            self.local_subnet = m.get('LocalSubnet')
        if m.get('RemoteSubnet') is not None:
            self.remote_subnet = m.get('RemoteSubnet')
        if m.get('EffectImmediately') is not None:
            self.effect_immediately = m.get('EffectImmediately')
        if m.get('IkeConfig') is not None:
            self.ike_config = m.get('IkeConfig')
        if m.get('IpsecConfig') is not None:
            self.ipsec_config = m.get('IpsecConfig')
        if m.get('HealthCheckConfig') is not None:
            self.health_check_config = m.get('HealthCheckConfig')
        if m.get('AutoConfigRoute') is not None:
            self.auto_config_route = m.get('AutoConfigRoute')
        if m.get('EnableDpd') is not None:
            self.enable_dpd = m.get('EnableDpd')
        if m.get('EnableNatTraversal') is not None:
            self.enable_nat_traversal = m.get('EnableNatTraversal')
        if m.get('BgpConfig') is not None:
            self.bgp_config = m.get('BgpConfig')
        if m.get('RemoteCaCertificate') is not None:
            self.remote_ca_certificate = m.get('RemoteCaCertificate')
        return self


class CreateVpnConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        create_time: int = None,
        vpn_connection_id: str = None,
        name: str = None,
    ):
        self.request_id = request_id
        self.create_time = create_time
        self.vpn_connection_id = vpn_connection_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.vpn_connection_id is not None:
            result['VpnConnectionId'] = self.vpn_connection_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('VpnConnectionId') is not None:
            self.vpn_connection_id = m.get('VpnConnectionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateVpnConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVpnConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVpnConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpnGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        vpc_id: str = None,
        instance_charge_type: str = None,
        period: int = None,
        auto_pay: bool = None,
        bandwidth: int = None,
        enable_ipsec: bool = None,
        enable_ssl: bool = None,
        ssl_connections: int = None,
        v_switch_id: str = None,
        vpn_type: str = None,
        client_token: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.vpc_id = vpc_id
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.auto_pay = auto_pay
        self.bandwidth = bandwidth
        self.enable_ipsec = enable_ipsec
        self.enable_ssl = enable_ssl
        self.ssl_connections = ssl_connections
        self.v_switch_id = v_switch_id
        self.vpn_type = vpn_type
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.enable_ipsec is not None:
            result['EnableIpsec'] = self.enable_ipsec
        if self.enable_ssl is not None:
            result['EnableSsl'] = self.enable_ssl
        if self.ssl_connections is not None:
            result['SslConnections'] = self.ssl_connections
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpn_type is not None:
            result['VpnType'] = self.vpn_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('EnableIpsec') is not None:
            self.enable_ipsec = m.get('EnableIpsec')
        if m.get('EnableSsl') is not None:
            self.enable_ssl = m.get('EnableSsl')
        if m.get('SslConnections') is not None:
            self.ssl_connections = m.get('SslConnections')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpnType') is not None:
            self.vpn_type = m.get('VpnType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateVpnGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vpn_gateway_id: str = None,
        order_id: int = None,
        name: str = None,
    ):
        self.request_id = request_id
        self.vpn_gateway_id = vpn_gateway_id
        self.order_id = order_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateVpnGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVpnGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVpnGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpnPbrRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        vpn_gateway_id: str = None,
        route_source: str = None,
        route_dest: str = None,
        next_hop: str = None,
        weight: int = None,
        publish_vpc: bool = None,
        description: str = None,
        overlay_mode: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.vpn_gateway_id = vpn_gateway_id
        self.route_source = route_source
        self.route_dest = route_dest
        self.next_hop = next_hop
        self.weight = weight
        self.publish_vpc = publish_vpc
        self.description = description
        self.overlay_mode = overlay_mode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.route_source is not None:
            result['RouteSource'] = self.route_source
        if self.route_dest is not None:
            result['RouteDest'] = self.route_dest
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.publish_vpc is not None:
            result['PublishVpc'] = self.publish_vpc
        if self.description is not None:
            result['Description'] = self.description
        if self.overlay_mode is not None:
            result['OverlayMode'] = self.overlay_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('RouteSource') is not None:
            self.route_source = m.get('RouteSource')
        if m.get('RouteDest') is not None:
            self.route_dest = m.get('RouteDest')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('PublishVpc') is not None:
            self.publish_vpc = m.get('PublishVpc')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OverlayMode') is not None:
            self.overlay_mode = m.get('OverlayMode')
        return self


class CreateVpnPbrRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        route_dest: str = None,
        description: str = None,
        vpn_instance_id: str = None,
        request_id: str = None,
        overlay_mode: str = None,
        next_hop: str = None,
        state: str = None,
        create_time: int = None,
        route_source: str = None,
        weight: int = None,
    ):
        self.route_dest = route_dest
        self.description = description
        self.vpn_instance_id = vpn_instance_id
        self.request_id = request_id
        self.overlay_mode = overlay_mode
        self.next_hop = next_hop
        self.state = state
        self.create_time = create_time
        self.route_source = route_source
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.route_dest is not None:
            result['RouteDest'] = self.route_dest
        if self.description is not None:
            result['Description'] = self.description
        if self.vpn_instance_id is not None:
            result['VpnInstanceId'] = self.vpn_instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.overlay_mode is not None:
            result['OverlayMode'] = self.overlay_mode
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.state is not None:
            result['State'] = self.state
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.route_source is not None:
            result['RouteSource'] = self.route_source
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RouteDest') is not None:
            self.route_dest = m.get('RouteDest')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('VpnInstanceId') is not None:
            self.vpn_instance_id = m.get('VpnInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OverlayMode') is not None:
            self.overlay_mode = m.get('OverlayMode')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('RouteSource') is not None:
            self.route_source = m.get('RouteSource')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateVpnPbrRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVpnPbrRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVpnPbrRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpnRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        vpn_gateway_id: str = None,
        route_dest: str = None,
        next_hop: str = None,
        weight: int = None,
        publish_vpc: bool = None,
        description: str = None,
        overlay_mode: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.vpn_gateway_id = vpn_gateway_id
        self.route_dest = route_dest
        self.next_hop = next_hop
        self.weight = weight
        self.publish_vpc = publish_vpc
        self.description = description
        self.overlay_mode = overlay_mode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.route_dest is not None:
            result['RouteDest'] = self.route_dest
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.publish_vpc is not None:
            result['PublishVpc'] = self.publish_vpc
        if self.description is not None:
            result['Description'] = self.description
        if self.overlay_mode is not None:
            result['OverlayMode'] = self.overlay_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('RouteDest') is not None:
            self.route_dest = m.get('RouteDest')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('PublishVpc') is not None:
            self.publish_vpc = m.get('PublishVpc')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OverlayMode') is not None:
            self.overlay_mode = m.get('OverlayMode')
        return self


class CreateVpnRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        route_dest: str = None,
        description: str = None,
        vpn_instance_id: str = None,
        request_id: str = None,
        overlay_mode: str = None,
        next_hop: str = None,
        state: str = None,
        create_time: int = None,
        weight: int = None,
    ):
        self.route_dest = route_dest
        self.description = description
        self.vpn_instance_id = vpn_instance_id
        self.request_id = request_id
        self.overlay_mode = overlay_mode
        self.next_hop = next_hop
        self.state = state
        self.create_time = create_time
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.route_dest is not None:
            result['RouteDest'] = self.route_dest
        if self.description is not None:
            result['Description'] = self.description
        if self.vpn_instance_id is not None:
            result['VpnInstanceId'] = self.vpn_instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.overlay_mode is not None:
            result['OverlayMode'] = self.overlay_mode
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.state is not None:
            result['State'] = self.state
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RouteDest') is not None:
            self.route_dest = m.get('RouteDest')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('VpnInstanceId') is not None:
            self.vpn_instance_id = m.get('VpnInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OverlayMode') is not None:
            self.overlay_mode = m.get('OverlayMode')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateVpnRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVpnRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVpnRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVSwitchRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        zone_id: str = None,
        region_id: str = None,
        cidr_block: str = None,
        ipv_6cidr_block: int = None,
        vpc_id: str = None,
        v_switch_name: str = None,
        description: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.zone_id = zone_id
        self.region_id = region_id
        self.cidr_block = cidr_block
        self.ipv_6cidr_block = ipv_6cidr_block
        self.vpc_id = vpc_id
        self.v_switch_name = v_switch_name
        self.description = description
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.ipv_6cidr_block is not None:
            result['Ipv6CidrBlock'] = self.ipv_6cidr_block
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        if self.description is not None:
            result['Description'] = self.description
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Ipv6CidrBlock') is not None:
            self.ipv_6cidr_block = m.get('Ipv6CidrBlock')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateVSwitchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        v_switch_id: str = None,
    ):
        self.request_id = request_id
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateVSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVSwitchResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactivateRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        router_interface_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class DeactivateRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactivateRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeactivateRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeactivateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactiveFlowLogRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        flow_log_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeactiveFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: str = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeactiveFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeactiveFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeactiveFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBgpGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        bgp_group_id: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.bgp_group_id = bgp_group_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bgp_group_id is not None:
            result['BgpGroupId'] = self.bgp_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BgpGroupId') is not None:
            self.bgp_group_id = m.get('BgpGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteBgpGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBgpGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBgpGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBgpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBgpNetworkRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dst_cidr_block: str = None,
        router_id: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dst_cidr_block = dst_cidr_block
        self.router_id = router_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dst_cidr_block is not None:
            result['DstCidrBlock'] = self.dst_cidr_block
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DstCidrBlock') is not None:
            self.dst_cidr_block = m.get('DstCidrBlock')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteBgpNetworkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBgpNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBgpNetworkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBgpNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBgpPeerRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        bgp_peer_id: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.bgp_peer_id = bgp_peer_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bgp_peer_id is not None:
            result['BgpPeerId'] = self.bgp_peer_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BgpPeerId') is not None:
            self.bgp_peer_id = m.get('BgpPeerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteBgpPeerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBgpPeerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBgpPeerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBgpPeerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCommonBandwidthPackageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        force: str = None,
        bandwidth_package_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.force = force
        self.bandwidth_package_id = bandwidth_package_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.force is not None:
            result['Force'] = self.force
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        return self


class DeleteCommonBandwidthPackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCommonBandwidthPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCommonBandwidthPackageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCommonBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomerGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        customer_gateway_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.customer_gateway_id = customer_gateway_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.customer_gateway_id is not None:
            result['CustomerGatewayId'] = self.customer_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CustomerGatewayId') is not None:
            self.customer_gateway_id = m.get('CustomerGatewayId')
        return self


class DeleteCustomerGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomerGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCustomerGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCustomerGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDhcpOptionsSetRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        dhcp_options_set_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        dry_run: bool = None,
    ):
        self.region_id = region_id
        self.dhcp_options_set_id = dhcp_options_set_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.dry_run = dry_run

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dhcp_options_set_id is not None:
            result['DhcpOptionsSetId'] = self.dhcp_options_set_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DhcpOptionsSetId') is not None:
            self.dhcp_options_set_id = m.get('DhcpOptionsSetId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        return self


class DeleteDhcpOptionsSetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDhcpOptionsSetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDhcpOptionsSetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDhcpOptionsSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExpressCloudConnectionRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ecc_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ecc_id = ecc_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ecc_id is not None:
            result['EccId'] = self.ecc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EccId') is not None:
            self.ecc_id = m.get('EccId')
        return self


class DeleteExpressCloudConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteExpressCloudConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteExpressCloudConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteExpressCloudConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExpressConnectRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        router_interface_id: str = None,
        force: bool = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.router_interface_id = router_interface_id
        self.force = force
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteExpressConnectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteExpressConnectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteExpressConnectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteExpressConnectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowLogRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        flow_log_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: str = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteForwardEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        forward_table_id: str = None,
        forward_entry_id: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.forward_entry_id = forward_entry_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class DeleteForwardEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteForwardEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteForwardEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGlobalAccelerationInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        global_acceleration_instance_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.global_acceleration_instance_id = global_acceleration_instance_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.global_acceleration_instance_id is not None:
            result['GlobalAccelerationInstanceId'] = self.global_acceleration_instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('GlobalAccelerationInstanceId') is not None:
            self.global_acceleration_instance_id = m.get('GlobalAccelerationInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteGlobalAccelerationInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGlobalAccelerationInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteGlobalAccelerationInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteGlobalAccelerationInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHaVipRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        ha_vip_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.ha_vip_id = ha_vip_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        return self


class DeleteHaVipResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHaVipResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteHaVipResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIpsecServerRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipsec_server_id: str = None,
        client_token: str = None,
        caller_bid: str = None,
        dry_run: str = None,
        resource_owner_id: int = None,
    ):
        self.region_id = region_id
        self.ipsec_server_id = ipsec_server_id
        self.client_token = client_token
        self.caller_bid = caller_bid
        self.dry_run = dry_run
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipsec_server_id is not None:
            result['IpsecServerId'] = self.ipsec_server_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.caller_bid is not None:
            result['callerBid'] = self.caller_bid
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IpsecServerId') is not None:
            self.ipsec_server_id = m.get('IpsecServerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('callerBid') is not None:
            self.caller_bid = m.get('callerBid')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteIpsecServerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIpsecServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIpsecServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIpsecServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIpv6EgressOnlyRuleRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6egress_only_rule_id: str = None,
        client_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6egress_only_rule_id = ipv_6egress_only_rule_id
        self.client_token = client_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6egress_only_rule_id is not None:
            result['Ipv6EgressOnlyRuleId'] = self.ipv_6egress_only_rule_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6EgressOnlyRuleId') is not None:
            self.ipv_6egress_only_rule_id = m.get('Ipv6EgressOnlyRuleId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteIpv6EgressOnlyRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIpv6EgressOnlyRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIpv6EgressOnlyRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIpv6EgressOnlyRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIpv6GatewayRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6gateway_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6gateway_id = ipv_6gateway_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteIpv6GatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIpv6GatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIpv6GatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIpv6GatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIpv6InternetBandwidthRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6address_id: str = None,
        ipv_6internet_bandwidth_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6address_id = ipv_6address_id
        self.ipv_6internet_bandwidth_id = ipv_6internet_bandwidth_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6address_id is not None:
            result['Ipv6AddressId'] = self.ipv_6address_id
        if self.ipv_6internet_bandwidth_id is not None:
            result['Ipv6InternetBandwidthId'] = self.ipv_6internet_bandwidth_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6AddressId') is not None:
            self.ipv_6address_id = m.get('Ipv6AddressId')
        if m.get('Ipv6InternetBandwidthId') is not None:
            self.ipv_6internet_bandwidth_id = m.get('Ipv6InternetBandwidthId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteIpv6InternetBandwidthResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIpv6InternetBandwidthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIpv6InternetBandwidthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIpv6InternetBandwidthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIPv6TranslatorRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
        ipv_6translator_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.region_id = region_id
        self.ipv_6translator_id = ipv_6translator_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        return self


class DeleteIPv6TranslatorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIPv6TranslatorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIPv6TranslatorResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIPv6TranslatorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIPv6TranslatorAclListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
        acl_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.region_id = region_id
        self.acl_id = acl_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        return self


class DeleteIPv6TranslatorAclListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIPv6TranslatorAclListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIPv6TranslatorAclListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIPv6TranslatorAclListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIPv6TranslatorEntryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
        ipv_6translator_entry_id: str = None,
        ipv_6translator_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.region_id = region_id
        self.ipv_6translator_entry_id = ipv_6translator_entry_id
        self.ipv_6translator_id = ipv_6translator_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6translator_entry_id is not None:
            result['Ipv6TranslatorEntryId'] = self.ipv_6translator_entry_id
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6TranslatorEntryId') is not None:
            self.ipv_6translator_entry_id = m.get('Ipv6TranslatorEntryId')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        return self


class DeleteIPv6TranslatorEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIPv6TranslatorEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIPv6TranslatorEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIPv6TranslatorEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNatGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        nat_gateway_id: str = None,
        force: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.nat_gateway_id = nat_gateway_id
        self.force = force

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.force is not None:
            result['Force'] = self.force
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        return self


class DeleteNatGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNatGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteNatGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkAclRequest(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
    ):
        self.network_acl_id = network_acl_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class DeleteNetworkAclResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkAclResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteNetworkAclResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteNetworkAclResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePhysicalConnectionRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        physical_connection_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeletePhysicalConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePhysicalConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeletePhysicalConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletePhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouteEntryRequestNextHopList(TeaModel):
    def __init__(
        self,
        next_hop_id: str = None,
        next_hop_type: str = None,
    ):
        self.next_hop_id = next_hop_id
        self.next_hop_type = next_hop_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        return self


class DeleteRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        route_table_id: str = None,
        route_entry_id: str = None,
        destination_cidr_block: str = None,
        next_hop_id: str = None,
        owner_account: str = None,
        next_hop_list: List[DeleteRouteEntryRequestNextHopList] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.route_table_id = route_table_id
        self.route_entry_id = route_entry_id
        self.destination_cidr_block = destination_cidr_block
        self.next_hop_id = next_hop_id
        self.owner_account = owner_account
        self.next_hop_list = next_hop_list

    def validate(self):
        if self.next_hop_list:
            for k in self.next_hop_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        result['NextHopList'] = []
        if self.next_hop_list is not None:
            for k in self.next_hop_list:
                result['NextHopList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        self.next_hop_list = []
        if m.get('NextHopList') is not None:
            for k in m.get('NextHopList'):
                temp_model = DeleteRouteEntryRequestNextHopList()
                self.next_hop_list.append(temp_model.from_map(k))
        return self


class DeleteRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouterInterfaceRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        router_interface_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.router_interface_id = router_interface_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteRouterInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouterInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRouterInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouteTableRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        route_table_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.route_table_id = route_table_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteRouteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRouteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnatEntryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        snat_table_id: str = None,
        snat_entry_id: str = None,
        client_token: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.snat_table_id = snat_table_id
        self.snat_entry_id = snat_entry_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snat_table_id is not None:
            result['SnatTableId'] = self.snat_table_id
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnatTableId') is not None:
            self.snat_table_id = m.get('SnatTableId')
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class DeleteSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSslVpnClientCertRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        ssl_vpn_client_cert_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.ssl_vpn_client_cert_id = ssl_vpn_client_cert_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ssl_vpn_client_cert_id is not None:
            result['SslVpnClientCertId'] = self.ssl_vpn_client_cert_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('SslVpnClientCertId') is not None:
            self.ssl_vpn_client_cert_id = m.get('SslVpnClientCertId')
        return self


class DeleteSslVpnClientCertResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSslVpnClientCertResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSslVpnClientCertResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSslVpnClientCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSslVpnServerRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        ssl_vpn_server_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.ssl_vpn_server_id = ssl_vpn_server_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        return self


class DeleteSslVpnServerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSslVpnServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSslVpnServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSslVpnServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVirtualBorderRouterRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vbr_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.vbr_id = vbr_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteVirtualBorderRouterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVirtualBorderRouterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVirtualBorderRouterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVirtualBorderRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        vpc_id: str = None,
        region_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.vpc_id = vpc_id
        self.region_id = region_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteVpcResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpcResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpnConnectionRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        vpn_connection_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.vpn_connection_id = vpn_connection_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.vpn_connection_id is not None:
            result['VpnConnectionId'] = self.vpn_connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('VpnConnectionId') is not None:
            self.vpn_connection_id = m.get('VpnConnectionId')
        return self


class DeleteVpnConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpnConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpnConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpnConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpnGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        vpn_gateway_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.vpn_gateway_id = vpn_gateway_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        return self


class DeleteVpnGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpnGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpnGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpnGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpnPbrRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        vpn_gateway_id: str = None,
        route_source: str = None,
        route_dest: str = None,
        next_hop: str = None,
        weight: int = None,
        overlay_mode: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.vpn_gateway_id = vpn_gateway_id
        self.route_source = route_source
        self.route_dest = route_dest
        self.next_hop = next_hop
        self.weight = weight
        self.overlay_mode = overlay_mode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.route_source is not None:
            result['RouteSource'] = self.route_source
        if self.route_dest is not None:
            result['RouteDest'] = self.route_dest
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.overlay_mode is not None:
            result['OverlayMode'] = self.overlay_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('RouteSource') is not None:
            self.route_source = m.get('RouteSource')
        if m.get('RouteDest') is not None:
            self.route_dest = m.get('RouteDest')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('OverlayMode') is not None:
            self.overlay_mode = m.get('OverlayMode')
        return self


class DeleteVpnPbrRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpnPbrRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpnPbrRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpnPbrRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpnRouteEntryRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        vpn_gateway_id: str = None,
        route_dest: str = None,
        next_hop: str = None,
        weight: int = None,
        overlay_mode: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.vpn_gateway_id = vpn_gateway_id
        self.route_dest = route_dest
        self.next_hop = next_hop
        self.weight = weight
        self.overlay_mode = overlay_mode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.route_dest is not None:
            result['RouteDest'] = self.route_dest
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.overlay_mode is not None:
            result['OverlayMode'] = self.overlay_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('RouteDest') is not None:
            self.route_dest = m.get('RouteDest')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('OverlayMode') is not None:
            self.overlay_mode = m.get('OverlayMode')
        return self


class DeleteVpnRouteEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpnRouteEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpnRouteEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpnRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVSwitchRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        v_switch_id: str = None,
        region_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.v_switch_id = v_switch_id
        self.region_id = region_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteVSwitchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVSwitchResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletionProtectionRequest(TeaModel):
    def __init__(
        self,
        protection_enable: bool = None,
        type: str = None,
        instance_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
    ):
        self.protection_enable = protection_enable
        self.type = type
        self.instance_id = instance_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.protection_enable is not None:
            result['ProtectionEnable'] = self.protection_enable
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProtectionEnable') is not None:
            self.protection_enable = m.get('ProtectionEnable')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeletionProtectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletionProtectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeletionProtectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletionProtectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessPointsRequestFilter(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeAccessPointsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        type: str = None,
        name: str = None,
        host_operator: str = None,
        page_number: int = None,
        page_size: int = None,
        filter: List[DescribeAccessPointsRequestFilter] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.type = type
        self.name = name
        self.host_operator = host_operator
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.host_operator is not None:
            result['HostOperator'] = self.host_operator
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('HostOperator') is not None:
            self.host_operator = m.get('HostOperator')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeAccessPointsRequestFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeAccessPointsResponseBodyAccessPointSetAccessPointTypeAccessPointFeatureModelsAccessPointFeatureModel(TeaModel):
    def __init__(
        self,
        feature_value: str = None,
        feature_key: str = None,
    ):
        self.feature_value = feature_value
        self.feature_key = feature_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.feature_value is not None:
            result['FeatureValue'] = self.feature_value
        if self.feature_key is not None:
            result['FeatureKey'] = self.feature_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FeatureValue') is not None:
            self.feature_value = m.get('FeatureValue')
        if m.get('FeatureKey') is not None:
            self.feature_key = m.get('FeatureKey')
        return self


class DescribeAccessPointsResponseBodyAccessPointSetAccessPointTypeAccessPointFeatureModels(TeaModel):
    def __init__(
        self,
        access_point_feature_model: List[DescribeAccessPointsResponseBodyAccessPointSetAccessPointTypeAccessPointFeatureModelsAccessPointFeatureModel] = None,
    ):
        self.access_point_feature_model = access_point_feature_model

    def validate(self):
        if self.access_point_feature_model:
            for k in self.access_point_feature_model:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AccessPointFeatureModel'] = []
        if self.access_point_feature_model is not None:
            for k in self.access_point_feature_model:
                result['AccessPointFeatureModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_point_feature_model = []
        if m.get('AccessPointFeatureModel') is not None:
            for k in m.get('AccessPointFeatureModel'):
                temp_model = DescribeAccessPointsResponseBodyAccessPointSetAccessPointTypeAccessPointFeatureModelsAccessPointFeatureModel()
                self.access_point_feature_model.append(temp_model.from_map(k))
        return self


class DescribeAccessPointsResponseBodyAccessPointSetAccessPointType(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        host_operator: str = None,
        description: str = None,
        attached_region_no: str = None,
        access_point_feature_models: DescribeAccessPointsResponseBodyAccessPointSetAccessPointTypeAccessPointFeatureModels = None,
        name: str = None,
        access_point_id: str = None,
        location: str = None,
    ):
        self.status = status
        self.type = type
        self.host_operator = host_operator
        self.description = description
        self.attached_region_no = attached_region_no
        self.access_point_feature_models = access_point_feature_models
        self.name = name
        self.access_point_id = access_point_id
        self.location = location

    def validate(self):
        if self.access_point_feature_models:
            self.access_point_feature_models.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.host_operator is not None:
            result['HostOperator'] = self.host_operator
        if self.description is not None:
            result['Description'] = self.description
        if self.attached_region_no is not None:
            result['AttachedRegionNo'] = self.attached_region_no
        if self.access_point_feature_models is not None:
            result['AccessPointFeatureModels'] = self.access_point_feature_models.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.location is not None:
            result['Location'] = self.location
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('HostOperator') is not None:
            self.host_operator = m.get('HostOperator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AttachedRegionNo') is not None:
            self.attached_region_no = m.get('AttachedRegionNo')
        if m.get('AccessPointFeatureModels') is not None:
            temp_model = DescribeAccessPointsResponseBodyAccessPointSetAccessPointTypeAccessPointFeatureModels()
            self.access_point_feature_models = temp_model.from_map(m['AccessPointFeatureModels'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        return self


class DescribeAccessPointsResponseBodyAccessPointSet(TeaModel):
    def __init__(
        self,
        access_point_type: List[DescribeAccessPointsResponseBodyAccessPointSetAccessPointType] = None,
    ):
        self.access_point_type = access_point_type

    def validate(self):
        if self.access_point_type:
            for k in self.access_point_type:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AccessPointType'] = []
        if self.access_point_type is not None:
            for k in self.access_point_type:
                result['AccessPointType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_point_type = []
        if m.get('AccessPointType') is not None:
            for k in m.get('AccessPointType'):
                temp_model = DescribeAccessPointsResponseBodyAccessPointSetAccessPointType()
                self.access_point_type.append(temp_model.from_map(k))
        return self


class DescribeAccessPointsResponseBody(TeaModel):
    def __init__(
        self,
        access_point_set: DescribeAccessPointsResponseBodyAccessPointSet = None,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.access_point_set = access_point_set
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        if self.access_point_set:
            self.access_point_set.validate()

    def to_map(self):
        result = dict()
        if self.access_point_set is not None:
            result['AccessPointSet'] = self.access_point_set.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessPointSet') is not None:
            temp_model = DescribeAccessPointsResponseBodyAccessPointSet()
            self.access_point_set = temp_model.from_map(m['AccessPointSet'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeAccessPointsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAccessPointsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAccessPointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBgpGroupsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        router_id: str = None,
        bgp_group_id: str = None,
        region_id: str = None,
        is_default: bool = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.router_id = router_id
        self.bgp_group_id = bgp_group_id
        self.region_id = region_id
        self.is_default = is_default
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.bgp_group_id is not None:
            result['BgpGroupId'] = self.bgp_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('BgpGroupId') is not None:
            self.bgp_group_id = m.get('BgpGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeBgpGroupsResponseBodyBgpGroupsBgpGroup(TeaModel):
    def __init__(
        self,
        status: str = None,
        router_id: str = None,
        bgp_group_id: str = None,
        peer_asn: str = None,
        local_asn: str = None,
        region_id: str = None,
        hold: str = None,
        keepalive: str = None,
        description: str = None,
        ip_version: str = None,
        route_limit: str = None,
        is_fake: str = None,
        name: str = None,
        auth_key: str = None,
    ):
        self.status = status
        self.router_id = router_id
        self.bgp_group_id = bgp_group_id
        self.peer_asn = peer_asn
        self.local_asn = local_asn
        self.region_id = region_id
        self.hold = hold
        self.keepalive = keepalive
        self.description = description
        self.ip_version = ip_version
        self.route_limit = route_limit
        self.is_fake = is_fake
        self.name = name
        self.auth_key = auth_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.bgp_group_id is not None:
            result['BgpGroupId'] = self.bgp_group_id
        if self.peer_asn is not None:
            result['PeerAsn'] = self.peer_asn
        if self.local_asn is not None:
            result['LocalAsn'] = self.local_asn
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.hold is not None:
            result['Hold'] = self.hold
        if self.keepalive is not None:
            result['Keepalive'] = self.keepalive
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.route_limit is not None:
            result['RouteLimit'] = self.route_limit
        if self.is_fake is not None:
            result['IsFake'] = self.is_fake
        if self.name is not None:
            result['Name'] = self.name
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('BgpGroupId') is not None:
            self.bgp_group_id = m.get('BgpGroupId')
        if m.get('PeerAsn') is not None:
            self.peer_asn = m.get('PeerAsn')
        if m.get('LocalAsn') is not None:
            self.local_asn = m.get('LocalAsn')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Hold') is not None:
            self.hold = m.get('Hold')
        if m.get('Keepalive') is not None:
            self.keepalive = m.get('Keepalive')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('RouteLimit') is not None:
            self.route_limit = m.get('RouteLimit')
        if m.get('IsFake') is not None:
            self.is_fake = m.get('IsFake')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        return self


class DescribeBgpGroupsResponseBodyBgpGroups(TeaModel):
    def __init__(
        self,
        bgp_group: List[DescribeBgpGroupsResponseBodyBgpGroupsBgpGroup] = None,
    ):
        self.bgp_group = bgp_group

    def validate(self):
        if self.bgp_group:
            for k in self.bgp_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['BgpGroup'] = []
        if self.bgp_group is not None:
            for k in self.bgp_group:
                result['BgpGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bgp_group = []
        if m.get('BgpGroup') is not None:
            for k in m.get('BgpGroup'):
                temp_model = DescribeBgpGroupsResponseBodyBgpGroupsBgpGroup()
                self.bgp_group.append(temp_model.from_map(k))
        return self


class DescribeBgpGroupsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        bgp_groups: DescribeBgpGroupsResponseBodyBgpGroups = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.bgp_groups = bgp_groups

    def validate(self):
        if self.bgp_groups:
            self.bgp_groups.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.bgp_groups is not None:
            result['BgpGroups'] = self.bgp_groups.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('BgpGroups') is not None:
            temp_model = DescribeBgpGroupsResponseBodyBgpGroups()
            self.bgp_groups = temp_model.from_map(m['BgpGroups'])
        return self


class DescribeBgpGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBgpGroupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBgpGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBgpNetworksRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        router_id: str = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.router_id = router_id
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeBgpNetworksResponseBodyBgpNetworksBgpNetwork(TeaModel):
    def __init__(
        self,
        status: str = None,
        vpc_id: str = None,
        router_id: str = None,
        dst_cidr_block: str = None,
    ):
        self.status = status
        self.vpc_id = vpc_id
        self.router_id = router_id
        self.dst_cidr_block = dst_cidr_block

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.dst_cidr_block is not None:
            result['DstCidrBlock'] = self.dst_cidr_block
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('DstCidrBlock') is not None:
            self.dst_cidr_block = m.get('DstCidrBlock')
        return self


class DescribeBgpNetworksResponseBodyBgpNetworks(TeaModel):
    def __init__(
        self,
        bgp_network: List[DescribeBgpNetworksResponseBodyBgpNetworksBgpNetwork] = None,
    ):
        self.bgp_network = bgp_network

    def validate(self):
        if self.bgp_network:
            for k in self.bgp_network:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['BgpNetwork'] = []
        if self.bgp_network is not None:
            for k in self.bgp_network:
                result['BgpNetwork'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bgp_network = []
        if m.get('BgpNetwork') is not None:
            for k in m.get('BgpNetwork'):
                temp_model = DescribeBgpNetworksResponseBodyBgpNetworksBgpNetwork()
                self.bgp_network.append(temp_model.from_map(k))
        return self


class DescribeBgpNetworksResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        bgp_networks: DescribeBgpNetworksResponseBodyBgpNetworks = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.bgp_networks = bgp_networks

    def validate(self):
        if self.bgp_networks:
            self.bgp_networks.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.bgp_networks is not None:
            result['BgpNetworks'] = self.bgp_networks.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('BgpNetworks') is not None:
            temp_model = DescribeBgpNetworksResponseBodyBgpNetworks()
            self.bgp_networks = temp_model.from_map(m['BgpNetworks'])
        return self


class DescribeBgpNetworksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBgpNetworksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBgpNetworksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBgpPeersRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        router_id: str = None,
        bgp_peer_id: str = None,
        bgp_group_id: str = None,
        region_id: str = None,
        is_default: bool = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.router_id = router_id
        self.bgp_peer_id = bgp_peer_id
        self.bgp_group_id = bgp_group_id
        self.region_id = region_id
        self.is_default = is_default
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.bgp_peer_id is not None:
            result['BgpPeerId'] = self.bgp_peer_id
        if self.bgp_group_id is not None:
            result['BgpGroupId'] = self.bgp_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('BgpPeerId') is not None:
            self.bgp_peer_id = m.get('BgpPeerId')
        if m.get('BgpGroupId') is not None:
            self.bgp_group_id = m.get('BgpGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeBgpPeersResponseBodyBgpPeersBgpPeer(TeaModel):
    def __init__(
        self,
        peer_ip_address: str = None,
        status: str = None,
        bgp_group_id: str = None,
        router_id: str = None,
        bgp_status: str = None,
        peer_asn: str = None,
        bfd_multi_hop: int = None,
        local_asn: str = None,
        region_id: str = None,
        bgp_peer_id: str = None,
        enable_bfd: bool = None,
        hold: str = None,
        ip_version: str = None,
        keepalive: str = None,
        description: str = None,
        route_limit: str = None,
        is_fake: str = None,
        auth_key: str = None,
        name: str = None,
    ):
        self.peer_ip_address = peer_ip_address
        self.status = status
        self.bgp_group_id = bgp_group_id
        self.router_id = router_id
        self.bgp_status = bgp_status
        self.peer_asn = peer_asn
        self.bfd_multi_hop = bfd_multi_hop
        self.local_asn = local_asn
        self.region_id = region_id
        self.bgp_peer_id = bgp_peer_id
        self.enable_bfd = enable_bfd
        self.hold = hold
        self.ip_version = ip_version
        self.keepalive = keepalive
        self.description = description
        self.route_limit = route_limit
        self.is_fake = is_fake
        self.auth_key = auth_key
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.peer_ip_address is not None:
            result['PeerIpAddress'] = self.peer_ip_address
        if self.status is not None:
            result['Status'] = self.status
        if self.bgp_group_id is not None:
            result['BgpGroupId'] = self.bgp_group_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.bgp_status is not None:
            result['BgpStatus'] = self.bgp_status
        if self.peer_asn is not None:
            result['PeerAsn'] = self.peer_asn
        if self.bfd_multi_hop is not None:
            result['BfdMultiHop'] = self.bfd_multi_hop
        if self.local_asn is not None:
            result['LocalAsn'] = self.local_asn
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bgp_peer_id is not None:
            result['BgpPeerId'] = self.bgp_peer_id
        if self.enable_bfd is not None:
            result['EnableBfd'] = self.enable_bfd
        if self.hold is not None:
            result['Hold'] = self.hold
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.keepalive is not None:
            result['Keepalive'] = self.keepalive
        if self.description is not None:
            result['Description'] = self.description
        if self.route_limit is not None:
            result['RouteLimit'] = self.route_limit
        if self.is_fake is not None:
            result['IsFake'] = self.is_fake
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PeerIpAddress') is not None:
            self.peer_ip_address = m.get('PeerIpAddress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BgpGroupId') is not None:
            self.bgp_group_id = m.get('BgpGroupId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('BgpStatus') is not None:
            self.bgp_status = m.get('BgpStatus')
        if m.get('PeerAsn') is not None:
            self.peer_asn = m.get('PeerAsn')
        if m.get('BfdMultiHop') is not None:
            self.bfd_multi_hop = m.get('BfdMultiHop')
        if m.get('LocalAsn') is not None:
            self.local_asn = m.get('LocalAsn')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BgpPeerId') is not None:
            self.bgp_peer_id = m.get('BgpPeerId')
        if m.get('EnableBfd') is not None:
            self.enable_bfd = m.get('EnableBfd')
        if m.get('Hold') is not None:
            self.hold = m.get('Hold')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Keepalive') is not None:
            self.keepalive = m.get('Keepalive')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RouteLimit') is not None:
            self.route_limit = m.get('RouteLimit')
        if m.get('IsFake') is not None:
            self.is_fake = m.get('IsFake')
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeBgpPeersResponseBodyBgpPeers(TeaModel):
    def __init__(
        self,
        bgp_peer: List[DescribeBgpPeersResponseBodyBgpPeersBgpPeer] = None,
    ):
        self.bgp_peer = bgp_peer

    def validate(self):
        if self.bgp_peer:
            for k in self.bgp_peer:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['BgpPeer'] = []
        if self.bgp_peer is not None:
            for k in self.bgp_peer:
                result['BgpPeer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bgp_peer = []
        if m.get('BgpPeer') is not None:
            for k in m.get('BgpPeer'):
                temp_model = DescribeBgpPeersResponseBodyBgpPeersBgpPeer()
                self.bgp_peer.append(temp_model.from_map(k))
        return self


class DescribeBgpPeersResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        bgp_peers: DescribeBgpPeersResponseBodyBgpPeers = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
    ):
        self.total_count = total_count
        self.bgp_peers = bgp_peers
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.bgp_peers:
            self.bgp_peers.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.bgp_peers is not None:
            result['BgpPeers'] = self.bgp_peers.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('BgpPeers') is not None:
            temp_model = DescribeBgpPeersResponseBodyBgpPeers()
            self.bgp_peers = temp_model.from_map(m['BgpPeers'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeBgpPeersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBgpPeersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBgpPeersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonBandwidthPackagesRequestTag(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeCommonBandwidthPackagesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        include_reservation_data: bool = None,
        owner_account: str = None,
        region_id: str = None,
        bandwidth_package_id: str = None,
        resource_group_id: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        dry_run: bool = None,
        tag: List[DescribeCommonBandwidthPackagesRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.include_reservation_data = include_reservation_data
        self.owner_account = owner_account
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.resource_group_id = resource_group_id
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.dry_run = dry_run
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.include_reservation_data is not None:
            result['IncludeReservationData'] = self.include_reservation_data
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('IncludeReservationData') is not None:
            self.include_reservation_data = m.get('IncludeReservationData')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCommonBandwidthPackagesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackagePublicIpAddressesPublicIpAddresse(TeaModel):
    def __init__(
        self,
        ip_address: str = None,
        allocation_id: str = None,
        bandwidth_package_ip_relation_status: str = None,
    ):
        self.ip_address = ip_address
        self.allocation_id = allocation_id
        self.bandwidth_package_ip_relation_status = bandwidth_package_ip_relation_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.bandwidth_package_ip_relation_status is not None:
            result['BandwidthPackageIpRelationStatus'] = self.bandwidth_package_ip_relation_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('BandwidthPackageIpRelationStatus') is not None:
            self.bandwidth_package_ip_relation_status = m.get('BandwidthPackageIpRelationStatus')
        return self


class DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackagePublicIpAddresses(TeaModel):
    def __init__(
        self,
        public_ip_addresse: List[DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackagePublicIpAddressesPublicIpAddresse] = None,
    ):
        self.public_ip_addresse = public_ip_addresse

    def validate(self):
        if self.public_ip_addresse:
            for k in self.public_ip_addresse:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PublicIpAddresse'] = []
        if self.public_ip_addresse is not None:
            for k in self.public_ip_addresse:
                result['PublicIpAddresse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.public_ip_addresse = []
        if m.get('PublicIpAddresse') is not None:
            for k in m.get('PublicIpAddresse'):
                temp_model = DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackagePublicIpAddressesPublicIpAddresse()
                self.public_ip_addresse.append(temp_model.from_map(k))
        return self


class DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackage(TeaModel):
    def __init__(
        self,
        public_ip_addresses: DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackagePublicIpAddresses = None,
        creation_time: str = None,
        status: str = None,
        reservation_active_time: str = None,
        reservation_order_type: str = None,
        deletion_protection: bool = None,
        region_id: str = None,
        instance_charge_type: str = None,
        ratio: int = None,
        reservation_internet_charge_type: str = None,
        bandwidth_package_id: str = None,
        service_managed: int = None,
        bandwidth: str = None,
        description: str = None,
        expired_time: str = None,
        reservation_bandwidth: str = None,
        resource_group_id: str = None,
        internet_charge_type: str = None,
        business_status: str = None,
        name: str = None,
        isp: str = None,
        has_reservation_data: str = None,
    ):
        self.public_ip_addresses = public_ip_addresses
        self.creation_time = creation_time
        self.status = status
        self.reservation_active_time = reservation_active_time
        self.reservation_order_type = reservation_order_type
        self.deletion_protection = deletion_protection
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.ratio = ratio
        self.reservation_internet_charge_type = reservation_internet_charge_type
        self.bandwidth_package_id = bandwidth_package_id
        self.service_managed = service_managed
        self.bandwidth = bandwidth
        self.description = description
        self.expired_time = expired_time
        self.reservation_bandwidth = reservation_bandwidth
        self.resource_group_id = resource_group_id
        self.internet_charge_type = internet_charge_type
        self.business_status = business_status
        self.name = name
        self.isp = isp
        self.has_reservation_data = has_reservation_data

    def validate(self):
        if self.public_ip_addresses:
            self.public_ip_addresses.validate()

    def to_map(self):
        result = dict()
        if self.public_ip_addresses is not None:
            result['PublicIpAddresses'] = self.public_ip_addresses.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.reservation_order_type is not None:
            result['ReservationOrderType'] = self.reservation_order_type
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.description is not None:
            result['Description'] = self.description
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.name is not None:
            result['Name'] = self.name
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.has_reservation_data is not None:
            result['HasReservationData'] = self.has_reservation_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PublicIpAddresses') is not None:
            temp_model = DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackagePublicIpAddresses()
            self.public_ip_addresses = temp_model.from_map(m['PublicIpAddresses'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('ReservationOrderType') is not None:
            self.reservation_order_type = m.get('ReservationOrderType')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('HasReservationData') is not None:
            self.has_reservation_data = m.get('HasReservationData')
        return self


class DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackages(TeaModel):
    def __init__(
        self,
        common_bandwidth_package: List[DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackage] = None,
    ):
        self.common_bandwidth_package = common_bandwidth_package

    def validate(self):
        if self.common_bandwidth_package:
            for k in self.common_bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CommonBandwidthPackage'] = []
        if self.common_bandwidth_package is not None:
            for k in self.common_bandwidth_package:
                result['CommonBandwidthPackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.common_bandwidth_package = []
        if m.get('CommonBandwidthPackage') is not None:
            for k in m.get('CommonBandwidthPackage'):
                temp_model = DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackagesCommonBandwidthPackage()
                self.common_bandwidth_package.append(temp_model.from_map(k))
        return self


class DescribeCommonBandwidthPackagesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        common_bandwidth_packages: DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackages = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.common_bandwidth_packages = common_bandwidth_packages

    def validate(self):
        if self.common_bandwidth_packages:
            self.common_bandwidth_packages.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.common_bandwidth_packages is not None:
            result['CommonBandwidthPackages'] = self.common_bandwidth_packages.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('CommonBandwidthPackages') is not None:
            temp_model = DescribeCommonBandwidthPackagesResponseBodyCommonBandwidthPackages()
            self.common_bandwidth_packages = temp_model.from_map(m['CommonBandwidthPackages'])
        return self


class DescribeCommonBandwidthPackagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCommonBandwidthPackagesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCommonBandwidthPackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomerGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        customer_gateway_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.customer_gateway_id = customer_gateway_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.customer_gateway_id is not None:
            result['CustomerGatewayId'] = self.customer_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CustomerGatewayId') is not None:
            self.customer_gateway_id = m.get('CustomerGatewayId')
        return self


class DescribeCustomerGatewayResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        customer_gateway_id: str = None,
        create_time: int = None,
        ip_address: str = None,
        asn: int = None,
        name: str = None,
    ):
        self.description = description
        self.request_id = request_id
        self.customer_gateway_id = customer_gateway_id
        self.create_time = create_time
        self.ip_address = ip_address
        self.asn = asn
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.customer_gateway_id is not None:
            result['CustomerGatewayId'] = self.customer_gateway_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.asn is not None:
            result['Asn'] = self.asn
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CustomerGatewayId') is not None:
            self.customer_gateway_id = m.get('CustomerGatewayId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Asn') is not None:
            self.asn = m.get('Asn')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeCustomerGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCustomerGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCustomerGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomerGatewaysRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        customer_gateway_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.customer_gateway_id = customer_gateway_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.customer_gateway_id is not None:
            result['CustomerGatewayId'] = self.customer_gateway_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CustomerGatewayId') is not None:
            self.customer_gateway_id = m.get('CustomerGatewayId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeCustomerGatewaysResponseBodyCustomerGatewaysCustomerGateway(TeaModel):
    def __init__(
        self,
        ip_address: str = None,
        asn: int = None,
        description: str = None,
        customer_gateway_id: str = None,
        create_time: int = None,
        name: str = None,
    ):
        self.ip_address = ip_address
        self.asn = asn
        self.description = description
        self.customer_gateway_id = customer_gateway_id
        self.create_time = create_time
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.asn is not None:
            result['Asn'] = self.asn
        if self.description is not None:
            result['Description'] = self.description
        if self.customer_gateway_id is not None:
            result['CustomerGatewayId'] = self.customer_gateway_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Asn') is not None:
            self.asn = m.get('Asn')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CustomerGatewayId') is not None:
            self.customer_gateway_id = m.get('CustomerGatewayId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeCustomerGatewaysResponseBodyCustomerGateways(TeaModel):
    def __init__(
        self,
        customer_gateway: List[DescribeCustomerGatewaysResponseBodyCustomerGatewaysCustomerGateway] = None,
    ):
        self.customer_gateway = customer_gateway

    def validate(self):
        if self.customer_gateway:
            for k in self.customer_gateway:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CustomerGateway'] = []
        if self.customer_gateway is not None:
            for k in self.customer_gateway:
                result['CustomerGateway'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.customer_gateway = []
        if m.get('CustomerGateway') is not None:
            for k in m.get('CustomerGateway'):
                temp_model = DescribeCustomerGatewaysResponseBodyCustomerGatewaysCustomerGateway()
                self.customer_gateway.append(temp_model.from_map(k))
        return self


class DescribeCustomerGatewaysResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        customer_gateways: DescribeCustomerGatewaysResponseBodyCustomerGateways = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.customer_gateways = customer_gateways

    def validate(self):
        if self.customer_gateways:
            self.customer_gateways.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.customer_gateways is not None:
            result['CustomerGateways'] = self.customer_gateways.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('CustomerGateways') is not None:
            temp_model = DescribeCustomerGatewaysResponseBodyCustomerGateways()
            self.customer_gateways = temp_model.from_map(m['CustomerGateways'])
        return self


class DescribeCustomerGatewaysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCustomerGatewaysResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCustomerGatewaysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEipAddressesRequestFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEipAddressesRequestTag(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeEipAddressesRequest(TeaModel):
    def __init__(
        self,
        filter: List[DescribeEipAddressesRequestFilter] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        include_reservation_data: bool = None,
        status: str = None,
        eip_address: str = None,
        allocation_id: str = None,
        segment_instance_id: str = None,
        resource_group_id: str = None,
        page_number: int = None,
        page_size: int = None,
        isp: str = None,
        owner_account: str = None,
        lock_reason: str = None,
        associated_instance_type: str = None,
        associated_instance_id: str = None,
        charge_type: str = None,
        dry_run: bool = None,
        tag: List[DescribeEipAddressesRequestTag] = None,
    ):
        self.filter = filter
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.include_reservation_data = include_reservation_data
        self.status = status
        self.eip_address = eip_address
        self.allocation_id = allocation_id
        self.segment_instance_id = segment_instance_id
        self.resource_group_id = resource_group_id
        self.page_number = page_number
        self.page_size = page_size
        self.isp = isp
        self.owner_account = owner_account
        self.lock_reason = lock_reason
        self.associated_instance_type = associated_instance_type
        self.associated_instance_id = associated_instance_id
        self.charge_type = charge_type
        self.dry_run = dry_run
        self.tag = tag

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.include_reservation_data is not None:
            result['IncludeReservationData'] = self.include_reservation_data
        if self.status is not None:
            result['Status'] = self.status
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.segment_instance_id is not None:
            result['SegmentInstanceId'] = self.segment_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.associated_instance_type is not None:
            result['AssociatedInstanceType'] = self.associated_instance_type
        if self.associated_instance_id is not None:
            result['AssociatedInstanceId'] = self.associated_instance_id
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeEipAddressesRequestFilter()
                self.filter.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IncludeReservationData') is not None:
            self.include_reservation_data = m.get('IncludeReservationData')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('SegmentInstanceId') is not None:
            self.segment_instance_id = m.get('SegmentInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('AssociatedInstanceType') is not None:
            self.associated_instance_type = m.get('AssociatedInstanceType')
        if m.get('AssociatedInstanceId') is not None:
            self.associated_instance_id = m.get('AssociatedInstanceId')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeEipAddressesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeEipAddressesResponseBodyEipAddressesEipAddressOperationLocksLockReason(TeaModel):
    def __init__(
        self,
        lock_reason: str = None,
    ):
        self.lock_reason = lock_reason

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        return self


class DescribeEipAddressesResponseBodyEipAddressesEipAddressOperationLocks(TeaModel):
    def __init__(
        self,
        lock_reason: List[DescribeEipAddressesResponseBodyEipAddressesEipAddressOperationLocksLockReason] = None,
    ):
        self.lock_reason = lock_reason

    def validate(self):
        if self.lock_reason:
            for k in self.lock_reason:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LockReason'] = []
        if self.lock_reason is not None:
            for k in self.lock_reason:
                result['LockReason'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.lock_reason = []
        if m.get('LockReason') is not None:
            for k in m.get('LockReason'):
                temp_model = DescribeEipAddressesResponseBodyEipAddressesEipAddressOperationLocksLockReason()
                self.lock_reason.append(temp_model.from_map(k))
        return self


class DescribeEipAddressesResponseBodyEipAddressesEipAddressAvailableRegions(TeaModel):
    def __init__(
        self,
        available_region: List[str] = None,
    ):
        self.available_region = available_region

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.available_region is not None:
            result['AvailableRegion'] = self.available_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableRegion') is not None:
            self.available_region = m.get('AvailableRegion')
        return self


class DescribeEipAddressesResponseBodyEipAddressesEipAddress(TeaModel):
    def __init__(
        self,
        reservation_active_time: str = None,
        status: str = None,
        reservation_order_type: str = None,
        allocation_time: str = None,
        operation_locks: DescribeEipAddressesResponseBodyEipAddressesEipAddressOperationLocks = None,
        netmode: str = None,
        charge_type: str = None,
        descritpion: str = None,
        segment_instance_id: str = None,
        reservation_internet_charge_type: str = None,
        bandwidth_package_id: str = None,
        ip_address: str = None,
        bandwidth: str = None,
        reservation_bandwidth: str = None,
        eip_bandwidth: str = None,
        available_regions: DescribeEipAddressesResponseBodyEipAddressesEipAddressAvailableRegions = None,
        name: str = None,
        instance_region_id: str = None,
        deletion_protection: bool = None,
        instance_id: str = None,
        second_limited: bool = None,
        instance_type: str = None,
        hdmonitor_status: str = None,
        region_id: str = None,
        bandwidth_package_bandwidth: str = None,
        service_managed: int = None,
        expired_time: str = None,
        resource_group_id: str = None,
        allocation_id: str = None,
        internet_charge_type: str = None,
        business_status: str = None,
        bandwidth_package_type: str = None,
        has_reservation_data: str = None,
        isp: str = None,
    ):
        self.reservation_active_time = reservation_active_time
        self.status = status
        self.reservation_order_type = reservation_order_type
        self.allocation_time = allocation_time
        self.operation_locks = operation_locks
        self.netmode = netmode
        self.charge_type = charge_type
        self.descritpion = descritpion
        self.segment_instance_id = segment_instance_id
        self.reservation_internet_charge_type = reservation_internet_charge_type
        self.bandwidth_package_id = bandwidth_package_id
        self.ip_address = ip_address
        self.bandwidth = bandwidth
        self.reservation_bandwidth = reservation_bandwidth
        self.eip_bandwidth = eip_bandwidth
        self.available_regions = available_regions
        self.name = name
        self.instance_region_id = instance_region_id
        self.deletion_protection = deletion_protection
        self.instance_id = instance_id
        self.second_limited = second_limited
        self.instance_type = instance_type
        self.hdmonitor_status = hdmonitor_status
        self.region_id = region_id
        self.bandwidth_package_bandwidth = bandwidth_package_bandwidth
        self.service_managed = service_managed
        self.expired_time = expired_time
        self.resource_group_id = resource_group_id
        self.allocation_id = allocation_id
        self.internet_charge_type = internet_charge_type
        self.business_status = business_status
        self.bandwidth_package_type = bandwidth_package_type
        self.has_reservation_data = has_reservation_data
        self.isp = isp

    def validate(self):
        if self.operation_locks:
            self.operation_locks.validate()
        if self.available_regions:
            self.available_regions.validate()

    def to_map(self):
        result = dict()
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.status is not None:
            result['Status'] = self.status
        if self.reservation_order_type is not None:
            result['ReservationOrderType'] = self.reservation_order_type
        if self.allocation_time is not None:
            result['AllocationTime'] = self.allocation_time
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.netmode is not None:
            result['Netmode'] = self.netmode
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.descritpion is not None:
            result['Descritpion'] = self.descritpion
        if self.segment_instance_id is not None:
            result['SegmentInstanceId'] = self.segment_instance_id
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.eip_bandwidth is not None:
            result['EipBandwidth'] = self.eip_bandwidth
        if self.available_regions is not None:
            result['AvailableRegions'] = self.available_regions.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.instance_region_id is not None:
            result['InstanceRegionId'] = self.instance_region_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.second_limited is not None:
            result['SecondLimited'] = self.second_limited
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.hdmonitor_status is not None:
            result['HDMonitorStatus'] = self.hdmonitor_status
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.bandwidth_package_bandwidth is not None:
            result['BandwidthPackageBandwidth'] = self.bandwidth_package_bandwidth
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.bandwidth_package_type is not None:
            result['BandwidthPackageType'] = self.bandwidth_package_type
        if self.has_reservation_data is not None:
            result['HasReservationData'] = self.has_reservation_data
        if self.isp is not None:
            result['ISP'] = self.isp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ReservationOrderType') is not None:
            self.reservation_order_type = m.get('ReservationOrderType')
        if m.get('AllocationTime') is not None:
            self.allocation_time = m.get('AllocationTime')
        if m.get('OperationLocks') is not None:
            temp_model = DescribeEipAddressesResponseBodyEipAddressesEipAddressOperationLocks()
            self.operation_locks = temp_model.from_map(m['OperationLocks'])
        if m.get('Netmode') is not None:
            self.netmode = m.get('Netmode')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Descritpion') is not None:
            self.descritpion = m.get('Descritpion')
        if m.get('SegmentInstanceId') is not None:
            self.segment_instance_id = m.get('SegmentInstanceId')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('EipBandwidth') is not None:
            self.eip_bandwidth = m.get('EipBandwidth')
        if m.get('AvailableRegions') is not None:
            temp_model = DescribeEipAddressesResponseBodyEipAddressesEipAddressAvailableRegions()
            self.available_regions = temp_model.from_map(m['AvailableRegions'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('InstanceRegionId') is not None:
            self.instance_region_id = m.get('InstanceRegionId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecondLimited') is not None:
            self.second_limited = m.get('SecondLimited')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HDMonitorStatus') is not None:
            self.hdmonitor_status = m.get('HDMonitorStatus')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BandwidthPackageBandwidth') is not None:
            self.bandwidth_package_bandwidth = m.get('BandwidthPackageBandwidth')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('BandwidthPackageType') is not None:
            self.bandwidth_package_type = m.get('BandwidthPackageType')
        if m.get('HasReservationData') is not None:
            self.has_reservation_data = m.get('HasReservationData')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        return self


class DescribeEipAddressesResponseBodyEipAddresses(TeaModel):
    def __init__(
        self,
        eip_address: List[DescribeEipAddressesResponseBodyEipAddressesEipAddress] = None,
    ):
        self.eip_address = eip_address

    def validate(self):
        if self.eip_address:
            for k in self.eip_address:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EipAddress'] = []
        if self.eip_address is not None:
            for k in self.eip_address:
                result['EipAddress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.eip_address = []
        if m.get('EipAddress') is not None:
            for k in m.get('EipAddress'):
                temp_model = DescribeEipAddressesResponseBodyEipAddressesEipAddress()
                self.eip_address.append(temp_model.from_map(k))
        return self


class DescribeEipAddressesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        eip_addresses: DescribeEipAddressesResponseBodyEipAddresses = None,
        page_number: int = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.eip_addresses = eip_addresses
        self.page_number = page_number

    def validate(self):
        if self.eip_addresses:
            self.eip_addresses.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.eip_addresses is not None:
            result['EipAddresses'] = self.eip_addresses.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EipAddresses') is not None:
            temp_model = DescribeEipAddressesResponseBodyEipAddresses()
            self.eip_addresses = temp_model.from_map(m['EipAddresses'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeEipAddressesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeEipAddressesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEipAddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEipGatewayInfoRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        region_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.instance_id = instance_id
        self.region_id = region_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeEipGatewayInfoResponseBodyEipInfosEipInfo(TeaModel):
    def __init__(
        self,
        ip_gw: str = None,
        ip_mask: str = None,
        ip: str = None,
    ):
        self.ip_gw = ip_gw
        self.ip_mask = ip_mask
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ip_gw is not None:
            result['IpGw'] = self.ip_gw
        if self.ip_mask is not None:
            result['IpMask'] = self.ip_mask
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpGw') is not None:
            self.ip_gw = m.get('IpGw')
        if m.get('IpMask') is not None:
            self.ip_mask = m.get('IpMask')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeEipGatewayInfoResponseBodyEipInfos(TeaModel):
    def __init__(
        self,
        eip_info: List[DescribeEipGatewayInfoResponseBodyEipInfosEipInfo] = None,
    ):
        self.eip_info = eip_info

    def validate(self):
        if self.eip_info:
            for k in self.eip_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EipInfo'] = []
        if self.eip_info is not None:
            for k in self.eip_info:
                result['EipInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.eip_info = []
        if m.get('EipInfo') is not None:
            for k in m.get('EipInfo'):
                temp_model = DescribeEipGatewayInfoResponseBodyEipInfosEipInfo()
                self.eip_info.append(temp_model.from_map(k))
        return self


class DescribeEipGatewayInfoResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        code: str = None,
        eip_infos: DescribeEipGatewayInfoResponseBodyEipInfos = None,
    ):
        self.message = message
        self.request_id = request_id
        self.code = code
        self.eip_infos = eip_infos

    def validate(self):
        if self.eip_infos:
            self.eip_infos.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.code is not None:
            result['Code'] = self.code
        if self.eip_infos is not None:
            result['EipInfos'] = self.eip_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EipInfos') is not None:
            temp_model = DescribeEipGatewayInfoResponseBodyEipInfos()
            self.eip_infos = temp_model.from_map(m['EipInfos'])
        return self


class DescribeEipGatewayInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeEipGatewayInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEipGatewayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEipMonitorDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        allocation_id: str = None,
        start_time: str = None,
        end_time: str = None,
        period: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.allocation_id = allocation_id
        self.start_time = start_time
        self.end_time = end_time
        self.period = period
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.period is not None:
            result['Period'] = self.period
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeEipMonitorDataResponseBodyEipMonitorDatasEipMonitorData(TeaModel):
    def __init__(
        self,
        eip_tx: int = None,
        eip_packets: int = None,
        eip_bandwidth: int = None,
        time_stamp: str = None,
        eip_flow: int = None,
        eip_rx: int = None,
    ):
        self.eip_tx = eip_tx
        self.eip_packets = eip_packets
        self.eip_bandwidth = eip_bandwidth
        self.time_stamp = time_stamp
        self.eip_flow = eip_flow
        self.eip_rx = eip_rx

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.eip_tx is not None:
            result['EipTX'] = self.eip_tx
        if self.eip_packets is not None:
            result['EipPackets'] = self.eip_packets
        if self.eip_bandwidth is not None:
            result['EipBandwidth'] = self.eip_bandwidth
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.eip_flow is not None:
            result['EipFlow'] = self.eip_flow
        if self.eip_rx is not None:
            result['EipRX'] = self.eip_rx
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EipTX') is not None:
            self.eip_tx = m.get('EipTX')
        if m.get('EipPackets') is not None:
            self.eip_packets = m.get('EipPackets')
        if m.get('EipBandwidth') is not None:
            self.eip_bandwidth = m.get('EipBandwidth')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('EipFlow') is not None:
            self.eip_flow = m.get('EipFlow')
        if m.get('EipRX') is not None:
            self.eip_rx = m.get('EipRX')
        return self


class DescribeEipMonitorDataResponseBodyEipMonitorDatas(TeaModel):
    def __init__(
        self,
        eip_monitor_data: List[DescribeEipMonitorDataResponseBodyEipMonitorDatasEipMonitorData] = None,
    ):
        self.eip_monitor_data = eip_monitor_data

    def validate(self):
        if self.eip_monitor_data:
            for k in self.eip_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EipMonitorData'] = []
        if self.eip_monitor_data is not None:
            for k in self.eip_monitor_data:
                result['EipMonitorData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.eip_monitor_data = []
        if m.get('EipMonitorData') is not None:
            for k in m.get('EipMonitorData'):
                temp_model = DescribeEipMonitorDataResponseBodyEipMonitorDatasEipMonitorData()
                self.eip_monitor_data.append(temp_model.from_map(k))
        return self


class DescribeEipMonitorDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        eip_monitor_datas: DescribeEipMonitorDataResponseBodyEipMonitorDatas = None,
    ):
        self.request_id = request_id
        self.eip_monitor_datas = eip_monitor_datas

    def validate(self):
        if self.eip_monitor_datas:
            self.eip_monitor_datas.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.eip_monitor_datas is not None:
            result['EipMonitorDatas'] = self.eip_monitor_datas.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EipMonitorDatas') is not None:
            temp_model = DescribeEipMonitorDataResponseBodyEipMonitorDatas()
            self.eip_monitor_datas = temp_model.from_map(m['EipMonitorDatas'])
        return self


class DescribeEipMonitorDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeEipMonitorDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEipMonitorDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEipSegmentRequest(TeaModel):
    def __init__(
        self,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        owner_account: str = None,
        client_token: str = None,
        region_id: str = None,
        segment_instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.owner_account = owner_account
        self.client_token = client_token
        self.region_id = region_id
        self.segment_instance_id = segment_instance_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.segment_instance_id is not None:
            result['SegmentInstanceId'] = self.segment_instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SegmentInstanceId') is not None:
            self.segment_instance_id = m.get('SegmentInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeEipSegmentResponseBodyEipSegmentsEipSegment(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        status: str = None,
        descritpion: str = None,
        instance_id: str = None,
        ip_count: str = None,
        name: str = None,
        segment: str = None,
        region_id: str = None,
    ):
        self.creation_time = creation_time
        self.status = status
        self.descritpion = descritpion
        self.instance_id = instance_id
        self.ip_count = ip_count
        self.name = name
        self.segment = segment
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.descritpion is not None:
            result['Descritpion'] = self.descritpion
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.name is not None:
            result['Name'] = self.name
        if self.segment is not None:
            result['Segment'] = self.segment
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Descritpion') is not None:
            self.descritpion = m.get('Descritpion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Segment') is not None:
            self.segment = m.get('Segment')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeEipSegmentResponseBodyEipSegments(TeaModel):
    def __init__(
        self,
        eip_segment: List[DescribeEipSegmentResponseBodyEipSegmentsEipSegment] = None,
    ):
        self.eip_segment = eip_segment

    def validate(self):
        if self.eip_segment:
            for k in self.eip_segment:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EipSegment'] = []
        if self.eip_segment is not None:
            for k in self.eip_segment:
                result['EipSegment'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.eip_segment = []
        if m.get('EipSegment') is not None:
            for k in m.get('EipSegment'):
                temp_model = DescribeEipSegmentResponseBodyEipSegmentsEipSegment()
                self.eip_segment.append(temp_model.from_map(k))
        return self


class DescribeEipSegmentResponseBody(TeaModel):
    def __init__(
        self,
        eip_segments: DescribeEipSegmentResponseBodyEipSegments = None,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
    ):
        self.eip_segments = eip_segments
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.eip_segments:
            self.eip_segments.validate()

    def to_map(self):
        result = dict()
        if self.eip_segments is not None:
            result['EipSegments'] = self.eip_segments.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EipSegments') is not None:
            temp_model = DescribeEipSegmentResponseBodyEipSegments()
            self.eip_segments = temp_model.from_map(m['EipSegments'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeEipSegmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeEipSegmentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEipSegmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExpressCloudConnectionsRequestFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeExpressCloudConnectionsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        filter: List[DescribeExpressCloudConnectionsRequestFilter] = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeExpressCloudConnectionsRequestFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionTypeVirtualBorderRouterModelsVirtualBorderRouterModel(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        access_point_id: str = None,
        physical_connection_id: str = None,
    ):
        self.instance_id = instance_id
        self.access_point_id = access_point_id
        self.physical_connection_id = physical_connection_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        return self


class DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionTypeVirtualBorderRouterModels(TeaModel):
    def __init__(
        self,
        virtual_border_router_model: List[DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionTypeVirtualBorderRouterModelsVirtualBorderRouterModel] = None,
    ):
        self.virtual_border_router_model = virtual_border_router_model

    def validate(self):
        if self.virtual_border_router_model:
            for k in self.virtual_border_router_model:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['VirtualBorderRouterModel'] = []
        if self.virtual_border_router_model is not None:
            for k in self.virtual_border_router_model:
                result['VirtualBorderRouterModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.virtual_border_router_model = []
        if m.get('VirtualBorderRouterModel') is not None:
            for k in m.get('VirtualBorderRouterModel'):
                temp_model = DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionTypeVirtualBorderRouterModelsVirtualBorderRouterModel()
                self.virtual_border_router_model.append(temp_model.from_map(k))
        return self


class DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionType(TeaModel):
    def __init__(
        self,
        reservation_active_time: str = None,
        type: str = None,
        status: str = None,
        reservation_order_type: str = None,
        distance: int = None,
        construction_period: str = None,
        charge_type: str = None,
        application_bandwidth: str = None,
        ce_ip: str = None,
        bgp_as: str = None,
        idcard_no: str = None,
        reservation_internet_charge_type: str = None,
        description: str = None,
        bandwidth: int = None,
        reservation_bandwidth: str = None,
        application_status: str = None,
        peer_city: str = None,
        name: str = None,
        peer_location: str = None,
        pe_ip: str = None,
        contact_mail: str = None,
        gmt_modify: str = None,
        circuit_code: str = None,
        application_type: str = None,
        instance_id: str = None,
        redundant_ecc_id: str = None,
        virtual_border_router_models: DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionTypeVirtualBorderRouterModels = None,
        isp: str = None,
        end_time: str = None,
        contact_tel: str = None,
        idc_sp: str = None,
        estimated_time: str = None,
        port_type: str = None,
        gmt_create: str = None,
        business_status: str = None,
        application_id: str = None,
        has_reservation_data: str = None,
    ):
        self.reservation_active_time = reservation_active_time
        self.type = type
        self.status = status
        self.reservation_order_type = reservation_order_type
        self.distance = distance
        self.construction_period = construction_period
        self.charge_type = charge_type
        self.application_bandwidth = application_bandwidth
        self.ce_ip = ce_ip
        self.bgp_as = bgp_as
        self.idcard_no = idcard_no
        self.reservation_internet_charge_type = reservation_internet_charge_type
        self.description = description
        self.bandwidth = bandwidth
        self.reservation_bandwidth = reservation_bandwidth
        self.application_status = application_status
        self.peer_city = peer_city
        self.name = name
        self.peer_location = peer_location
        self.pe_ip = pe_ip
        self.contact_mail = contact_mail
        self.gmt_modify = gmt_modify
        self.circuit_code = circuit_code
        self.application_type = application_type
        self.instance_id = instance_id
        self.redundant_ecc_id = redundant_ecc_id
        self.virtual_border_router_models = virtual_border_router_models
        self.isp = isp
        self.end_time = end_time
        self.contact_tel = contact_tel
        self.idc_sp = idc_sp
        self.estimated_time = estimated_time
        self.port_type = port_type
        self.gmt_create = gmt_create
        self.business_status = business_status
        self.application_id = application_id
        self.has_reservation_data = has_reservation_data

    def validate(self):
        if self.virtual_border_router_models:
            self.virtual_border_router_models.validate()

    def to_map(self):
        result = dict()
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.reservation_order_type is not None:
            result['ReservationOrderType'] = self.reservation_order_type
        if self.distance is not None:
            result['Distance'] = self.distance
        if self.construction_period is not None:
            result['ConstructionPeriod'] = self.construction_period
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.application_bandwidth is not None:
            result['ApplicationBandwidth'] = self.application_bandwidth
        if self.ce_ip is not None:
            result['CeIp'] = self.ce_ip
        if self.bgp_as is not None:
            result['BgpAs'] = self.bgp_as
        if self.idcard_no is not None:
            result['IDCardNo'] = self.idcard_no
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        if self.description is not None:
            result['Description'] = self.description
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.application_status is not None:
            result['ApplicationStatus'] = self.application_status
        if self.peer_city is not None:
            result['PeerCity'] = self.peer_city
        if self.name is not None:
            result['Name'] = self.name
        if self.peer_location is not None:
            result['PeerLocation'] = self.peer_location
        if self.pe_ip is not None:
            result['PeIp'] = self.pe_ip
        if self.contact_mail is not None:
            result['ContactMail'] = self.contact_mail
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.redundant_ecc_id is not None:
            result['RedundantEccId'] = self.redundant_ecc_id
        if self.virtual_border_router_models is not None:
            result['VirtualBorderRouterModels'] = self.virtual_border_router_models.to_map()
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.contact_tel is not None:
            result['ContactTel'] = self.contact_tel
        if self.idc_sp is not None:
            result['IdcSP'] = self.idc_sp
        if self.estimated_time is not None:
            result['EstimatedTime'] = self.estimated_time
        if self.port_type is not None:
            result['PortType'] = self.port_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.has_reservation_data is not None:
            result['HasReservationData'] = self.has_reservation_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ReservationOrderType') is not None:
            self.reservation_order_type = m.get('ReservationOrderType')
        if m.get('Distance') is not None:
            self.distance = m.get('Distance')
        if m.get('ConstructionPeriod') is not None:
            self.construction_period = m.get('ConstructionPeriod')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ApplicationBandwidth') is not None:
            self.application_bandwidth = m.get('ApplicationBandwidth')
        if m.get('CeIp') is not None:
            self.ce_ip = m.get('CeIp')
        if m.get('BgpAs') is not None:
            self.bgp_as = m.get('BgpAs')
        if m.get('IDCardNo') is not None:
            self.idcard_no = m.get('IDCardNo')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('ApplicationStatus') is not None:
            self.application_status = m.get('ApplicationStatus')
        if m.get('PeerCity') is not None:
            self.peer_city = m.get('PeerCity')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PeerLocation') is not None:
            self.peer_location = m.get('PeerLocation')
        if m.get('PeIp') is not None:
            self.pe_ip = m.get('PeIp')
        if m.get('ContactMail') is not None:
            self.contact_mail = m.get('ContactMail')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RedundantEccId') is not None:
            self.redundant_ecc_id = m.get('RedundantEccId')
        if m.get('VirtualBorderRouterModels') is not None:
            temp_model = DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionTypeVirtualBorderRouterModels()
            self.virtual_border_router_models = temp_model.from_map(m['VirtualBorderRouterModels'])
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ContactTel') is not None:
            self.contact_tel = m.get('ContactTel')
        if m.get('IdcSP') is not None:
            self.idc_sp = m.get('IdcSP')
        if m.get('EstimatedTime') is not None:
            self.estimated_time = m.get('EstimatedTime')
        if m.get('PortType') is not None:
            self.port_type = m.get('PortType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('HasReservationData') is not None:
            self.has_reservation_data = m.get('HasReservationData')
        return self


class DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSet(TeaModel):
    def __init__(
        self,
        express_cloud_connection_type: List[DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionType] = None,
    ):
        self.express_cloud_connection_type = express_cloud_connection_type

    def validate(self):
        if self.express_cloud_connection_type:
            for k in self.express_cloud_connection_type:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ExpressCloudConnectionType'] = []
        if self.express_cloud_connection_type is not None:
            for k in self.express_cloud_connection_type:
                result['ExpressCloudConnectionType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.express_cloud_connection_type = []
        if m.get('ExpressCloudConnectionType') is not None:
            for k in m.get('ExpressCloudConnectionType'):
                temp_model = DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSetExpressCloudConnectionType()
                self.express_cloud_connection_type.append(temp_model.from_map(k))
        return self


class DescribeExpressCloudConnectionsResponseBody(TeaModel):
    def __init__(
        self,
        express_cloud_connection_set: DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSet = None,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.express_cloud_connection_set = express_cloud_connection_set
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        if self.express_cloud_connection_set:
            self.express_cloud_connection_set.validate()

    def to_map(self):
        result = dict()
        if self.express_cloud_connection_set is not None:
            result['ExpressCloudConnectionSet'] = self.express_cloud_connection_set.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpressCloudConnectionSet') is not None:
            temp_model = DescribeExpressCloudConnectionsResponseBodyExpressCloudConnectionSet()
            self.express_cloud_connection_set = temp_model.from_map(m['ExpressCloudConnectionSet'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeExpressCloudConnectionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExpressCloudConnectionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExpressCloudConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowLogsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        flow_log_name: str = None,
        flow_log_id: str = None,
        description: str = None,
        resource_type: str = None,
        resource_id: str = None,
        traffic_type: str = None,
        project_name: str = None,
        log_store_name: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
        vpc_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.flow_log_name = flow_log_name
        self.flow_log_id = flow_log_id
        self.description = description
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.traffic_type = traffic_type
        self.project_name = project_name
        self.log_store_name = log_store_name
        self.status = status
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.flow_log_name is not None:
            result['FlowLogName'] = self.flow_log_name
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.traffic_type is not None:
            result['TrafficType'] = self.traffic_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('FlowLogName') is not None:
            self.flow_log_name = m.get('FlowLogName')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('TrafficType') is not None:
            self.traffic_type = m.get('TrafficType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeFlowLogsResponseBodyFlowLogsFlowLog(TeaModel):
    def __init__(
        self,
        status: str = None,
        creation_time: str = None,
        flow_log_name: str = None,
        traffic_type: str = None,
        resource_type: str = None,
        description: str = None,
        project_name: str = None,
        log_store_name: str = None,
        resource_id: str = None,
        region_id: str = None,
        flow_log_id: str = None,
    ):
        self.status = status
        self.creation_time = creation_time
        self.flow_log_name = flow_log_name
        self.traffic_type = traffic_type
        self.resource_type = resource_type
        self.description = description
        self.project_name = project_name
        self.log_store_name = log_store_name
        self.resource_id = resource_id
        self.region_id = region_id
        self.flow_log_id = flow_log_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.flow_log_name is not None:
            result['FlowLogName'] = self.flow_log_name
        if self.traffic_type is not None:
            result['TrafficType'] = self.traffic_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.description is not None:
            result['Description'] = self.description
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FlowLogName') is not None:
            self.flow_log_name = m.get('FlowLogName')
        if m.get('TrafficType') is not None:
            self.traffic_type = m.get('TrafficType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        return self


class DescribeFlowLogsResponseBodyFlowLogs(TeaModel):
    def __init__(
        self,
        flow_log: List[DescribeFlowLogsResponseBodyFlowLogsFlowLog] = None,
    ):
        self.flow_log = flow_log

    def validate(self):
        if self.flow_log:
            for k in self.flow_log:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FlowLog'] = []
        if self.flow_log is not None:
            for k in self.flow_log:
                result['FlowLog'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.flow_log = []
        if m.get('FlowLog') is not None:
            for k in m.get('FlowLog'):
                temp_model = DescribeFlowLogsResponseBodyFlowLogsFlowLog()
                self.flow_log.append(temp_model.from_map(k))
        return self


class DescribeFlowLogsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: str = None,
        flow_logs: DescribeFlowLogsResponseBodyFlowLogs = None,
        page_size: str = None,
        request_id: str = None,
        page_number: str = None,
        success: str = None,
    ):
        self.total_count = total_count
        self.flow_logs = flow_logs
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.success = success

    def validate(self):
        if self.flow_logs:
            self.flow_logs.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.flow_logs is not None:
            result['FlowLogs'] = self.flow_logs.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('FlowLogs') is not None:
            temp_model = DescribeFlowLogsResponseBodyFlowLogs()
            self.flow_logs = temp_model.from_map(m['FlowLogs'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeFlowLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowLogsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeForwardTableEntriesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        forward_table_id: str = None,
        forward_entry_id: str = None,
        external_ip: str = None,
        external_port: str = None,
        internal_ip: str = None,
        internal_port: str = None,
        ip_protocol: str = None,
        forward_entry_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.forward_entry_id = forward_entry_id
        self.external_ip = external_ip
        self.external_port = external_port
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.ip_protocol = ip_protocol
        self.forward_entry_name = forward_entry_name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.forward_entry_name is not None:
            result['ForwardEntryName'] = self.forward_entry_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('ForwardEntryName') is not None:
            self.forward_entry_name = m.get('ForwardEntryName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeForwardTableEntriesResponseBodyForwardTableEntriesForwardTableEntry(TeaModel):
    def __init__(
        self,
        status: str = None,
        forward_entry_id: str = None,
        internal_ip: str = None,
        internal_port: str = None,
        forward_entry_name: str = None,
        forward_table_id: str = None,
        ip_protocol: str = None,
        external_port: str = None,
        external_ip: str = None,
    ):
        self.status = status
        self.forward_entry_id = forward_entry_id
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.forward_entry_name = forward_entry_name
        self.forward_table_id = forward_table_id
        self.ip_protocol = ip_protocol
        self.external_port = external_port
        self.external_ip = external_ip

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.forward_entry_name is not None:
            result['ForwardEntryName'] = self.forward_entry_name
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('ForwardEntryName') is not None:
            self.forward_entry_name = m.get('ForwardEntryName')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        return self


class DescribeForwardTableEntriesResponseBodyForwardTableEntries(TeaModel):
    def __init__(
        self,
        forward_table_entry: List[DescribeForwardTableEntriesResponseBodyForwardTableEntriesForwardTableEntry] = None,
    ):
        self.forward_table_entry = forward_table_entry

    def validate(self):
        if self.forward_table_entry:
            for k in self.forward_table_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ForwardTableEntry'] = []
        if self.forward_table_entry is not None:
            for k in self.forward_table_entry:
                result['ForwardTableEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.forward_table_entry = []
        if m.get('ForwardTableEntry') is not None:
            for k in m.get('ForwardTableEntry'):
                temp_model = DescribeForwardTableEntriesResponseBodyForwardTableEntriesForwardTableEntry()
                self.forward_table_entry.append(temp_model.from_map(k))
        return self


class DescribeForwardTableEntriesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        forward_table_entries: DescribeForwardTableEntriesResponseBodyForwardTableEntries = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.forward_table_entries = forward_table_entries

    def validate(self):
        if self.forward_table_entries:
            self.forward_table_entries.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.forward_table_entries is not None:
            result['ForwardTableEntries'] = self.forward_table_entries.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ForwardTableEntries') is not None:
            temp_model = DescribeForwardTableEntriesResponseBodyForwardTableEntries()
            self.forward_table_entries = temp_model.from_map(m['ForwardTableEntries'])
        return self


class DescribeForwardTableEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeForwardTableEntriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeForwardTableEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGlobalAccelerationInstancesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        include_reservation_data: bool = None,
        global_acceleration_instance_id: str = None,
        ip_address: str = None,
        name: str = None,
        status: str = None,
        bandwidth_type: str = None,
        service_location: str = None,
        server_id: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.include_reservation_data = include_reservation_data
        self.global_acceleration_instance_id = global_acceleration_instance_id
        self.ip_address = ip_address
        self.name = name
        self.status = status
        self.bandwidth_type = bandwidth_type
        self.service_location = service_location
        self.server_id = server_id
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.include_reservation_data is not None:
            result['IncludeReservationData'] = self.include_reservation_data
        if self.global_acceleration_instance_id is not None:
            result['GlobalAccelerationInstanceId'] = self.global_acceleration_instance_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.bandwidth_type is not None:
            result['BandwidthType'] = self.bandwidth_type
        if self.service_location is not None:
            result['ServiceLocation'] = self.service_location
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IncludeReservationData') is not None:
            self.include_reservation_data = m.get('IncludeReservationData')
        if m.get('GlobalAccelerationInstanceId') is not None:
            self.global_acceleration_instance_id = m.get('GlobalAccelerationInstanceId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BandwidthType') is not None:
            self.bandwidth_type = m.get('BandwidthType')
        if m.get('ServiceLocation') is not None:
            self.service_location = m.get('ServiceLocation')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstancePublicIpAddressesPublicIpAddress(TeaModel):
    def __init__(
        self,
        ip_address: str = None,
        allocation_id: str = None,
    ):
        self.ip_address = ip_address
        self.allocation_id = allocation_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        return self


class DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstancePublicIpAddresses(TeaModel):
    def __init__(
        self,
        public_ip_address: List[DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstancePublicIpAddressesPublicIpAddress] = None,
    ):
        self.public_ip_address = public_ip_address

    def validate(self):
        if self.public_ip_address:
            for k in self.public_ip_address:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PublicIpAddress'] = []
        if self.public_ip_address is not None:
            for k in self.public_ip_address:
                result['PublicIpAddress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.public_ip_address = []
        if m.get('PublicIpAddress') is not None:
            for k in m.get('PublicIpAddress'):
                temp_model = DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstancePublicIpAddressesPublicIpAddress()
                self.public_ip_address.append(temp_model.from_map(k))
        return self


class DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstanceBackendServersBackendServer(TeaModel):
    def __init__(
        self,
        server_ip_address: str = None,
        server_id: str = None,
        server_type: str = None,
        region_id: str = None,
    ):
        self.server_ip_address = server_ip_address
        self.server_id = server_id
        self.server_type = server_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.server_ip_address is not None:
            result['ServerIpAddress'] = self.server_ip_address
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_type is not None:
            result['ServerType'] = self.server_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServerIpAddress') is not None:
            self.server_ip_address = m.get('ServerIpAddress')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerType') is not None:
            self.server_type = m.get('ServerType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstanceBackendServers(TeaModel):
    def __init__(
        self,
        backend_server: List[DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstanceBackendServersBackendServer] = None,
    ):
        self.backend_server = backend_server

    def validate(self):
        if self.backend_server:
            for k in self.backend_server:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['BackendServer'] = []
        if self.backend_server is not None:
            for k in self.backend_server:
                result['BackendServer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backend_server = []
        if m.get('BackendServer') is not None:
            for k in m.get('BackendServer'):
                temp_model = DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstanceBackendServersBackendServer()
                self.backend_server.append(temp_model.from_map(k))
        return self


class DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstance(TeaModel):
    def __init__(
        self,
        public_ip_addresses: DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstancePublicIpAddresses = None,
        status: str = None,
        creation_time: str = None,
        backend_servers: DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstanceBackendServers = None,
        bandwidth_type: str = None,
        charge_type: str = None,
        global_acceleration_instance_id: str = None,
        service_location: str = None,
        region_id: str = None,
        acceleration_location: str = None,
        ip_address: str = None,
        description: str = None,
        bandwidth: str = None,
        expired_time: str = None,
        internet_charge_type: str = None,
        name: str = None,
    ):
        self.public_ip_addresses = public_ip_addresses
        self.status = status
        self.creation_time = creation_time
        self.backend_servers = backend_servers
        self.bandwidth_type = bandwidth_type
        self.charge_type = charge_type
        self.global_acceleration_instance_id = global_acceleration_instance_id
        self.service_location = service_location
        self.region_id = region_id
        self.acceleration_location = acceleration_location
        self.ip_address = ip_address
        self.description = description
        self.bandwidth = bandwidth
        self.expired_time = expired_time
        self.internet_charge_type = internet_charge_type
        self.name = name

    def validate(self):
        if self.public_ip_addresses:
            self.public_ip_addresses.validate()
        if self.backend_servers:
            self.backend_servers.validate()

    def to_map(self):
        result = dict()
        if self.public_ip_addresses is not None:
            result['PublicIpAddresses'] = self.public_ip_addresses.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.backend_servers is not None:
            result['BackendServers'] = self.backend_servers.to_map()
        if self.bandwidth_type is not None:
            result['BandwidthType'] = self.bandwidth_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.global_acceleration_instance_id is not None:
            result['GlobalAccelerationInstanceId'] = self.global_acceleration_instance_id
        if self.service_location is not None:
            result['ServiceLocation'] = self.service_location
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.acceleration_location is not None:
            result['AccelerationLocation'] = self.acceleration_location
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.description is not None:
            result['Description'] = self.description
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PublicIpAddresses') is not None:
            temp_model = DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstancePublicIpAddresses()
            self.public_ip_addresses = temp_model.from_map(m['PublicIpAddresses'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('BackendServers') is not None:
            temp_model = DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstanceBackendServers()
            self.backend_servers = temp_model.from_map(m['BackendServers'])
        if m.get('BandwidthType') is not None:
            self.bandwidth_type = m.get('BandwidthType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('GlobalAccelerationInstanceId') is not None:
            self.global_acceleration_instance_id = m.get('GlobalAccelerationInstanceId')
        if m.get('ServiceLocation') is not None:
            self.service_location = m.get('ServiceLocation')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AccelerationLocation') is not None:
            self.acceleration_location = m.get('AccelerationLocation')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstances(TeaModel):
    def __init__(
        self,
        global_acceleration_instance: List[DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstance] = None,
    ):
        self.global_acceleration_instance = global_acceleration_instance

    def validate(self):
        if self.global_acceleration_instance:
            for k in self.global_acceleration_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GlobalAccelerationInstance'] = []
        if self.global_acceleration_instance is not None:
            for k in self.global_acceleration_instance:
                result['GlobalAccelerationInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.global_acceleration_instance = []
        if m.get('GlobalAccelerationInstance') is not None:
            for k in m.get('GlobalAccelerationInstance'):
                temp_model = DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstance()
                self.global_acceleration_instance.append(temp_model.from_map(k))
        return self


class DescribeGlobalAccelerationInstancesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        global_acceleration_instances: DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstances = None,
        page_number: int = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.global_acceleration_instances = global_acceleration_instances
        self.page_number = page_number

    def validate(self):
        if self.global_acceleration_instances:
            self.global_acceleration_instances.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.global_acceleration_instances is not None:
            result['GlobalAccelerationInstances'] = self.global_acceleration_instances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('GlobalAccelerationInstances') is not None:
            temp_model = DescribeGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstances()
            self.global_acceleration_instances = temp_model.from_map(m['GlobalAccelerationInstances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeGlobalAccelerationInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGlobalAccelerationInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGlobalAccelerationInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGrantRulesToCenRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
        resource_group_id: str = None,
        client_token: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.resource_group_id = resource_group_id
        self.client_token = client_token
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeGrantRulesToCenResponseBodyCenGrantRulesCbnGrantRule(TeaModel):
    def __init__(
        self,
        cen_instance_id: str = None,
        cen_owner_id: int = None,
        creation_time: str = None,
    ):
        self.cen_instance_id = cen_instance_id
        self.cen_owner_id = cen_owner_id
        self.creation_time = creation_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cen_instance_id is not None:
            result['CenInstanceId'] = self.cen_instance_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenInstanceId') is not None:
            self.cen_instance_id = m.get('CenInstanceId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        return self


class DescribeGrantRulesToCenResponseBodyCenGrantRules(TeaModel):
    def __init__(
        self,
        cbn_grant_rule: List[DescribeGrantRulesToCenResponseBodyCenGrantRulesCbnGrantRule] = None,
    ):
        self.cbn_grant_rule = cbn_grant_rule

    def validate(self):
        if self.cbn_grant_rule:
            for k in self.cbn_grant_rule:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CbnGrantRule'] = []
        if self.cbn_grant_rule is not None:
            for k in self.cbn_grant_rule:
                result['CbnGrantRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cbn_grant_rule = []
        if m.get('CbnGrantRule') is not None:
            for k in m.get('CbnGrantRule'):
                temp_model = DescribeGrantRulesToCenResponseBodyCenGrantRulesCbnGrantRule()
                self.cbn_grant_rule.append(temp_model.from_map(k))
        return self


class DescribeGrantRulesToCenResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        cen_grant_rules: DescribeGrantRulesToCenResponseBodyCenGrantRules = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.cen_grant_rules = cen_grant_rules

    def validate(self):
        if self.cen_grant_rules:
            self.cen_grant_rules.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.cen_grant_rules is not None:
            result['CenGrantRules'] = self.cen_grant_rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('CenGrantRules') is not None:
            temp_model = DescribeGrantRulesToCenResponseBodyCenGrantRules()
            self.cen_grant_rules = temp_model.from_map(m['CenGrantRules'])
        return self


class DescribeGrantRulesToCenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGrantRulesToCenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGrantRulesToCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHaVipsRequestFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHaVipsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        filter: List[DescribeHaVipsRequestFilter] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeHaVipsRequestFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeHaVipsResponseBodyHaVipsHaVipAssociatedInstances(TeaModel):
    def __init__(
        self,
        associated_instance: List[str] = None,
    ):
        self.associated_instance = associated_instance

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.associated_instance is not None:
            result['associatedInstance'] = self.associated_instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('associatedInstance') is not None:
            self.associated_instance = m.get('associatedInstance')
        return self


class DescribeHaVipsResponseBodyHaVipsHaVipAssociatedEipAddresses(TeaModel):
    def __init__(
        self,
        associated_eip_addresse: List[str] = None,
    ):
        self.associated_eip_addresse = associated_eip_addresse

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.associated_eip_addresse is not None:
            result['associatedEipAddresse'] = self.associated_eip_addresse
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('associatedEipAddresse') is not None:
            self.associated_eip_addresse = m.get('associatedEipAddresse')
        return self


class DescribeHaVipsResponseBodyHaVipsHaVip(TeaModel):
    def __init__(
        self,
        status: str = None,
        vpc_id: str = None,
        associated_instance_type: str = None,
        ha_vip_id: str = None,
        create_time: str = None,
        charge_type: str = None,
        region_id: str = None,
        v_switch_id: str = None,
        ip_address: str = None,
        description: str = None,
        associated_instances: DescribeHaVipsResponseBodyHaVipsHaVipAssociatedInstances = None,
        master_instance_id: str = None,
        associated_eip_addresses: DescribeHaVipsResponseBodyHaVipsHaVipAssociatedEipAddresses = None,
        name: str = None,
    ):
        self.status = status
        self.vpc_id = vpc_id
        self.associated_instance_type = associated_instance_type
        self.ha_vip_id = ha_vip_id
        self.create_time = create_time
        self.charge_type = charge_type
        self.region_id = region_id
        self.v_switch_id = v_switch_id
        self.ip_address = ip_address
        self.description = description
        self.associated_instances = associated_instances
        self.master_instance_id = master_instance_id
        self.associated_eip_addresses = associated_eip_addresses
        self.name = name

    def validate(self):
        if self.associated_instances:
            self.associated_instances.validate()
        if self.associated_eip_addresses:
            self.associated_eip_addresses.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.associated_instance_type is not None:
            result['AssociatedInstanceType'] = self.associated_instance_type
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.description is not None:
            result['Description'] = self.description
        if self.associated_instances is not None:
            result['AssociatedInstances'] = self.associated_instances.to_map()
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.associated_eip_addresses is not None:
            result['AssociatedEipAddresses'] = self.associated_eip_addresses.to_map()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('AssociatedInstanceType') is not None:
            self.associated_instance_type = m.get('AssociatedInstanceType')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AssociatedInstances') is not None:
            temp_model = DescribeHaVipsResponseBodyHaVipsHaVipAssociatedInstances()
            self.associated_instances = temp_model.from_map(m['AssociatedInstances'])
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('AssociatedEipAddresses') is not None:
            temp_model = DescribeHaVipsResponseBodyHaVipsHaVipAssociatedEipAddresses()
            self.associated_eip_addresses = temp_model.from_map(m['AssociatedEipAddresses'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeHaVipsResponseBodyHaVips(TeaModel):
    def __init__(
        self,
        ha_vip: List[DescribeHaVipsResponseBodyHaVipsHaVip] = None,
    ):
        self.ha_vip = ha_vip

    def validate(self):
        if self.ha_vip:
            for k in self.ha_vip:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['HaVip'] = []
        if self.ha_vip is not None:
            for k in self.ha_vip:
                result['HaVip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ha_vip = []
        if m.get('HaVip') is not None:
            for k in m.get('HaVip'):
                temp_model = DescribeHaVipsResponseBodyHaVipsHaVip()
                self.ha_vip.append(temp_model.from_map(k))
        return self


class DescribeHaVipsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        ha_vips: DescribeHaVipsResponseBodyHaVips = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
    ):
        self.total_count = total_count
        self.ha_vips = ha_vips
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.ha_vips:
            self.ha_vips.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.ha_vips is not None:
            result['HaVips'] = self.ha_vips.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('HaVips') is not None:
            temp_model = DescribeHaVipsResponseBodyHaVips()
            self.ha_vips = temp_model.from_map(m['HaVips'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeHaVipsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHaVipsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHaVipsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHighDefinitionMonitorLogAttributeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeHighDefinitionMonitorLogAttributeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        log_store: str = None,
        instance_id: str = None,
        instance_type: str = None,
        log_project: str = None,
        success: str = None,
    ):
        self.request_id = request_id
        self.log_store = log_store
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.log_project = log_project
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.log_project is not None:
            result['LogProject'] = self.log_project
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('LogProject') is not None:
            self.log_project = m.get('LogProject')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeHighDefinitionMonitorLogAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHighDefinitionMonitorLogAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHighDefinitionMonitorLogAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAutoRenewAttributeRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
        renewal_status: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.region_id = region_id
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.renewal_status = renewal_status
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('RenewalStatus') is not None:
            self.renewal_status = m.get('RenewalStatus')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeInstanceAutoRenewAttributeResponseBodyInstanceRenewAttributesInstanceRenewAttribute(TeaModel):
    def __init__(
        self,
        duration: int = None,
        instance_id: str = None,
        renewal_status: str = None,
        pricing_cycle: str = None,
    ):
        self.duration = duration
        self.instance_id = instance_id
        self.renewal_status = renewal_status
        self.pricing_cycle = pricing_cycle

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RenewalStatus') is not None:
            self.renewal_status = m.get('RenewalStatus')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        return self


class DescribeInstanceAutoRenewAttributeResponseBodyInstanceRenewAttributes(TeaModel):
    def __init__(
        self,
        instance_renew_attribute: List[DescribeInstanceAutoRenewAttributeResponseBodyInstanceRenewAttributesInstanceRenewAttribute] = None,
    ):
        self.instance_renew_attribute = instance_renew_attribute

    def validate(self):
        if self.instance_renew_attribute:
            for k in self.instance_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['InstanceRenewAttribute'] = []
        if self.instance_renew_attribute is not None:
            for k in self.instance_renew_attribute:
                result['InstanceRenewAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_renew_attribute = []
        if m.get('InstanceRenewAttribute') is not None:
            for k in m.get('InstanceRenewAttribute'):
                temp_model = DescribeInstanceAutoRenewAttributeResponseBodyInstanceRenewAttributesInstanceRenewAttribute()
                self.instance_renew_attribute.append(temp_model.from_map(k))
        return self


class DescribeInstanceAutoRenewAttributeResponseBody(TeaModel):
    def __init__(
        self,
        total_count: str = None,
        instance_renew_attributes: DescribeInstanceAutoRenewAttributeResponseBodyInstanceRenewAttributes = None,
        request_id: str = None,
        page_size: str = None,
        page_number: str = None,
    ):
        self.total_count = total_count
        self.instance_renew_attributes = instance_renew_attributes
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        if self.instance_renew_attributes:
            self.instance_renew_attributes.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.instance_renew_attributes is not None:
            result['InstanceRenewAttributes'] = self.instance_renew_attributes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('InstanceRenewAttributes') is not None:
            temp_model = DescribeInstanceAutoRenewAttributeResponseBodyInstanceRenewAttributes()
            self.instance_renew_attributes = temp_model.from_map(m['InstanceRenewAttributes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeInstanceAutoRenewAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceAutoRenewAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAutoRenewAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIpv6AddressesRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6address_id: str = None,
        ipv_6address: str = None,
        name: str = None,
        associated_instance_id: str = None,
        associated_instance_type: str = None,
        network_type: str = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        ipv_6internet_bandwidth_id: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6address_id = ipv_6address_id
        self.ipv_6address = ipv_6address
        self.name = name
        self.associated_instance_id = associated_instance_id
        self.associated_instance_type = associated_instance_type
        self.network_type = network_type
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.ipv_6internet_bandwidth_id = ipv_6internet_bandwidth_id
        self.page_number = page_number
        self.page_size = page_size
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6address_id is not None:
            result['Ipv6AddressId'] = self.ipv_6address_id
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.name is not None:
            result['Name'] = self.name
        if self.associated_instance_id is not None:
            result['AssociatedInstanceId'] = self.associated_instance_id
        if self.associated_instance_type is not None:
            result['AssociatedInstanceType'] = self.associated_instance_type
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.ipv_6internet_bandwidth_id is not None:
            result['Ipv6InternetBandwidthId'] = self.ipv_6internet_bandwidth_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6AddressId') is not None:
            self.ipv_6address_id = m.get('Ipv6AddressId')
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AssociatedInstanceId') is not None:
            self.associated_instance_id = m.get('AssociatedInstanceId')
        if m.get('AssociatedInstanceType') is not None:
            self.associated_instance_type = m.get('AssociatedInstanceType')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Ipv6InternetBandwidthId') is not None:
            self.ipv_6internet_bandwidth_id = m.get('Ipv6InternetBandwidthId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeIpv6AddressesResponseBodyIpv6AddressesIpv6AddressIpv6InternetBandwidth(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        internet_charge_type: str = None,
        business_status: str = None,
        ipv_6internet_bandwidth_id: str = None,
        instance_charge_type: str = None,
    ):
        self.bandwidth = bandwidth
        self.internet_charge_type = internet_charge_type
        self.business_status = business_status
        self.ipv_6internet_bandwidth_id = ipv_6internet_bandwidth_id
        self.instance_charge_type = instance_charge_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.ipv_6internet_bandwidth_id is not None:
            result['Ipv6InternetBandwidthId'] = self.ipv_6internet_bandwidth_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('Ipv6InternetBandwidthId') is not None:
            self.ipv_6internet_bandwidth_id = m.get('Ipv6InternetBandwidthId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        return self


class DescribeIpv6AddressesResponseBodyIpv6AddressesIpv6Address(TeaModel):
    def __init__(
        self,
        status: str = None,
        vpc_id: str = None,
        ipv_6address_id: str = None,
        allocation_time: str = None,
        associated_instance_type: str = None,
        ipv_6address_name: str = None,
        associated_instance_id: str = None,
        network_type: str = None,
        ipv_6address: str = None,
        v_switch_id: str = None,
        ipv_6internet_bandwidth: DescribeIpv6AddressesResponseBodyIpv6AddressesIpv6AddressIpv6InternetBandwidth = None,
        ipv_6gateway_id: str = None,
        real_bandwidth: int = None,
    ):
        self.status = status
        self.vpc_id = vpc_id
        self.ipv_6address_id = ipv_6address_id
        self.allocation_time = allocation_time
        self.associated_instance_type = associated_instance_type
        self.ipv_6address_name = ipv_6address_name
        self.associated_instance_id = associated_instance_id
        self.network_type = network_type
        self.ipv_6address = ipv_6address
        self.v_switch_id = v_switch_id
        self.ipv_6internet_bandwidth = ipv_6internet_bandwidth
        self.ipv_6gateway_id = ipv_6gateway_id
        self.real_bandwidth = real_bandwidth

    def validate(self):
        if self.ipv_6internet_bandwidth:
            self.ipv_6internet_bandwidth.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.ipv_6address_id is not None:
            result['Ipv6AddressId'] = self.ipv_6address_id
        if self.allocation_time is not None:
            result['AllocationTime'] = self.allocation_time
        if self.associated_instance_type is not None:
            result['AssociatedInstanceType'] = self.associated_instance_type
        if self.ipv_6address_name is not None:
            result['Ipv6AddressName'] = self.ipv_6address_name
        if self.associated_instance_id is not None:
            result['AssociatedInstanceId'] = self.associated_instance_id
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.ipv_6internet_bandwidth is not None:
            result['Ipv6InternetBandwidth'] = self.ipv_6internet_bandwidth.to_map()
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.real_bandwidth is not None:
            result['RealBandwidth'] = self.real_bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('Ipv6AddressId') is not None:
            self.ipv_6address_id = m.get('Ipv6AddressId')
        if m.get('AllocationTime') is not None:
            self.allocation_time = m.get('AllocationTime')
        if m.get('AssociatedInstanceType') is not None:
            self.associated_instance_type = m.get('AssociatedInstanceType')
        if m.get('Ipv6AddressName') is not None:
            self.ipv_6address_name = m.get('Ipv6AddressName')
        if m.get('AssociatedInstanceId') is not None:
            self.associated_instance_id = m.get('AssociatedInstanceId')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Ipv6InternetBandwidth') is not None:
            temp_model = DescribeIpv6AddressesResponseBodyIpv6AddressesIpv6AddressIpv6InternetBandwidth()
            self.ipv_6internet_bandwidth = temp_model.from_map(m['Ipv6InternetBandwidth'])
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('RealBandwidth') is not None:
            self.real_bandwidth = m.get('RealBandwidth')
        return self


class DescribeIpv6AddressesResponseBodyIpv6Addresses(TeaModel):
    def __init__(
        self,
        ipv_6address: List[DescribeIpv6AddressesResponseBodyIpv6AddressesIpv6Address] = None,
    ):
        self.ipv_6address = ipv_6address

    def validate(self):
        if self.ipv_6address:
            for k in self.ipv_6address:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Ipv6Address'] = []
        if self.ipv_6address is not None:
            for k in self.ipv_6address:
                result['Ipv6Address'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6address = []
        if m.get('Ipv6Address') is not None:
            for k in m.get('Ipv6Address'):
                temp_model = DescribeIpv6AddressesResponseBodyIpv6AddressesIpv6Address()
                self.ipv_6address.append(temp_model.from_map(k))
        return self


class DescribeIpv6AddressesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ipv_6addresses: DescribeIpv6AddressesResponseBodyIpv6Addresses = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ipv_6addresses = ipv_6addresses

    def validate(self):
        if self.ipv_6addresses:
            self.ipv_6addresses.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ipv_6addresses is not None:
            result['Ipv6Addresses'] = self.ipv_6addresses.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Ipv6Addresses') is not None:
            temp_model = DescribeIpv6AddressesResponseBodyIpv6Addresses()
            self.ipv_6addresses = temp_model.from_map(m['Ipv6Addresses'])
        return self


class DescribeIpv6AddressesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIpv6AddressesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIpv6AddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIpv6EgressOnlyRulesRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6gateway_id: str = None,
        ipv_6egress_only_rule_id: str = None,
        name: str = None,
        instance_type: str = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6gateway_id = ipv_6gateway_id
        self.ipv_6egress_only_rule_id = ipv_6egress_only_rule_id
        self.name = name
        self.instance_type = instance_type
        self.instance_id = instance_id
        self.page_number = page_number
        self.page_size = page_size
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.ipv_6egress_only_rule_id is not None:
            result['Ipv6EgressOnlyRuleId'] = self.ipv_6egress_only_rule_id
        if self.name is not None:
            result['Name'] = self.name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('Ipv6EgressOnlyRuleId') is not None:
            self.ipv_6egress_only_rule_id = m.get('Ipv6EgressOnlyRuleId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeIpv6EgressOnlyRulesResponseBodyIpv6EgressOnlyRulesIpv6EgressOnlyRule(TeaModel):
    def __init__(
        self,
        status: str = None,
        description: str = None,
        ipv_6egress_only_rule_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
        name: str = None,
    ):
        self.status = status
        self.description = description
        self.ipv_6egress_only_rule_id = ipv_6egress_only_rule_id
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.ipv_6egress_only_rule_id is not None:
            result['Ipv6EgressOnlyRuleId'] = self.ipv_6egress_only_rule_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ipv6EgressOnlyRuleId') is not None:
            self.ipv_6egress_only_rule_id = m.get('Ipv6EgressOnlyRuleId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeIpv6EgressOnlyRulesResponseBodyIpv6EgressOnlyRules(TeaModel):
    def __init__(
        self,
        ipv_6egress_only_rule: List[DescribeIpv6EgressOnlyRulesResponseBodyIpv6EgressOnlyRulesIpv6EgressOnlyRule] = None,
    ):
        self.ipv_6egress_only_rule = ipv_6egress_only_rule

    def validate(self):
        if self.ipv_6egress_only_rule:
            for k in self.ipv_6egress_only_rule:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Ipv6EgressOnlyRule'] = []
        if self.ipv_6egress_only_rule is not None:
            for k in self.ipv_6egress_only_rule:
                result['Ipv6EgressOnlyRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6egress_only_rule = []
        if m.get('Ipv6EgressOnlyRule') is not None:
            for k in m.get('Ipv6EgressOnlyRule'):
                temp_model = DescribeIpv6EgressOnlyRulesResponseBodyIpv6EgressOnlyRulesIpv6EgressOnlyRule()
                self.ipv_6egress_only_rule.append(temp_model.from_map(k))
        return self


class DescribeIpv6EgressOnlyRulesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ipv_6egress_only_rules: DescribeIpv6EgressOnlyRulesResponseBodyIpv6EgressOnlyRules = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ipv_6egress_only_rules = ipv_6egress_only_rules

    def validate(self):
        if self.ipv_6egress_only_rules:
            self.ipv_6egress_only_rules.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ipv_6egress_only_rules is not None:
            result['Ipv6EgressOnlyRules'] = self.ipv_6egress_only_rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Ipv6EgressOnlyRules') is not None:
            temp_model = DescribeIpv6EgressOnlyRulesResponseBodyIpv6EgressOnlyRules()
            self.ipv_6egress_only_rules = temp_model.from_map(m['Ipv6EgressOnlyRules'])
        return self


class DescribeIpv6EgressOnlyRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIpv6EgressOnlyRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIpv6EgressOnlyRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIpv6GatewayAttributeRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6gateway_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6gateway_id = ipv_6gateway_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeIpv6GatewayAttributeResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        description: str = None,
        request_id: str = None,
        vpc_id: str = None,
        instance_charge_type: str = None,
        expired_time: str = None,
        creation_time: str = None,
        ipv_6gateway_id: str = None,
        region_id: str = None,
        spec: str = None,
        business_status: str = None,
        name: str = None,
    ):
        self.status = status
        self.description = description
        self.request_id = request_id
        self.vpc_id = vpc_id
        self.instance_charge_type = instance_charge_type
        self.expired_time = expired_time
        self.creation_time = creation_time
        self.ipv_6gateway_id = ipv_6gateway_id
        self.region_id = region_id
        self.spec = spec
        self.business_status = business_status
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeIpv6GatewayAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIpv6GatewayAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIpv6GatewayAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIpv6GatewaysRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        ipv_6gateway_id: str = None,
        vpc_id: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.ipv_6gateway_id = ipv_6gateway_id
        self.vpc_id = vpc_id
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeIpv6GatewaysResponseBodyIpv6GatewaysIpv6Gateway(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        status: str = None,
        vpc_id: str = None,
        spec: str = None,
        description: str = None,
        ipv_6gateway_id: str = None,
        expired_time: str = None,
        business_status: str = None,
        name: str = None,
        instance_charge_type: str = None,
        region_id: str = None,
    ):
        self.creation_time = creation_time
        self.status = status
        self.vpc_id = vpc_id
        self.spec = spec
        self.description = description
        self.ipv_6gateway_id = ipv_6gateway_id
        self.expired_time = expired_time
        self.business_status = business_status
        self.name = name
        self.instance_charge_type = instance_charge_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.description is not None:
            result['Description'] = self.description
        if self.ipv_6gateway_id is not None:
            result['Ipv6GatewayId'] = self.ipv_6gateway_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.name is not None:
            result['Name'] = self.name
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ipv6GatewayId') is not None:
            self.ipv_6gateway_id = m.get('Ipv6GatewayId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeIpv6GatewaysResponseBodyIpv6Gateways(TeaModel):
    def __init__(
        self,
        ipv_6gateway: List[DescribeIpv6GatewaysResponseBodyIpv6GatewaysIpv6Gateway] = None,
    ):
        self.ipv_6gateway = ipv_6gateway

    def validate(self):
        if self.ipv_6gateway:
            for k in self.ipv_6gateway:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Ipv6Gateway'] = []
        if self.ipv_6gateway is not None:
            for k in self.ipv_6gateway:
                result['Ipv6Gateway'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6gateway = []
        if m.get('Ipv6Gateway') is not None:
            for k in m.get('Ipv6Gateway'):
                temp_model = DescribeIpv6GatewaysResponseBodyIpv6GatewaysIpv6Gateway()
                self.ipv_6gateway.append(temp_model.from_map(k))
        return self


class DescribeIpv6GatewaysResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ipv_6gateways: DescribeIpv6GatewaysResponseBodyIpv6Gateways = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ipv_6gateways = ipv_6gateways

    def validate(self):
        if self.ipv_6gateways:
            self.ipv_6gateways.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ipv_6gateways is not None:
            result['Ipv6Gateways'] = self.ipv_6gateways.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Ipv6Gateways') is not None:
            temp_model = DescribeIpv6GatewaysResponseBodyIpv6Gateways()
            self.ipv_6gateways = temp_model.from_map(m['Ipv6Gateways'])
        return self


class DescribeIpv6GatewaysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIpv6GatewaysResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIpv6GatewaysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIPv6TranslatorAclListAttributesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        acl_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.acl_id = acl_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeIPv6TranslatorAclListAttributesResponseBodyAclEntriesAclEntry(TeaModel):
    def __init__(
        self,
        acl_entry_comment: str = None,
        acl_entry_id: str = None,
        acl_entry_ip: str = None,
    ):
        self.acl_entry_comment = acl_entry_comment
        self.acl_entry_id = acl_entry_id
        self.acl_entry_ip = acl_entry_ip

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.acl_entry_comment is not None:
            result['AclEntryComment'] = self.acl_entry_comment
        if self.acl_entry_id is not None:
            result['AclEntryId'] = self.acl_entry_id
        if self.acl_entry_ip is not None:
            result['AclEntryIp'] = self.acl_entry_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclEntryComment') is not None:
            self.acl_entry_comment = m.get('AclEntryComment')
        if m.get('AclEntryId') is not None:
            self.acl_entry_id = m.get('AclEntryId')
        if m.get('AclEntryIp') is not None:
            self.acl_entry_ip = m.get('AclEntryIp')
        return self


class DescribeIPv6TranslatorAclListAttributesResponseBodyAclEntries(TeaModel):
    def __init__(
        self,
        acl_entry: List[DescribeIPv6TranslatorAclListAttributesResponseBodyAclEntriesAclEntry] = None,
    ):
        self.acl_entry = acl_entry

    def validate(self):
        if self.acl_entry:
            for k in self.acl_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AclEntry'] = []
        if self.acl_entry is not None:
            for k in self.acl_entry:
                result['AclEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acl_entry = []
        if m.get('AclEntry') is not None:
            for k in m.get('AclEntry'):
                temp_model = DescribeIPv6TranslatorAclListAttributesResponseBodyAclEntriesAclEntry()
                self.acl_entry.append(temp_model.from_map(k))
        return self


class DescribeIPv6TranslatorAclListAttributesResponseBody(TeaModel):
    def __init__(
        self,
        acl_entries: DescribeIPv6TranslatorAclListAttributesResponseBodyAclEntries = None,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        acl_id: str = None,
        acl_name: str = None,
    ):
        self.acl_entries = acl_entries
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.acl_id = acl_id
        self.acl_name = acl_name

    def validate(self):
        if self.acl_entries:
            self.acl_entries.validate()

    def to_map(self):
        result = dict()
        if self.acl_entries is not None:
            result['AclEntries'] = self.acl_entries.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acl_name is not None:
            result['AclName'] = self.acl_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclEntries') is not None:
            temp_model = DescribeIPv6TranslatorAclListAttributesResponseBodyAclEntries()
            self.acl_entries = temp_model.from_map(m['AclEntries'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AclName') is not None:
            self.acl_name = m.get('AclName')
        return self


class DescribeIPv6TranslatorAclListAttributesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIPv6TranslatorAclListAttributesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIPv6TranslatorAclListAttributesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIPv6TranslatorAclListsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        acl_id: str = None,
        page_number: int = None,
        page_size: int = None,
        acl_name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.acl_id = acl_id
        self.page_number = page_number
        self.page_size = page_size
        self.acl_name = acl_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.acl_name is not None:
            result['AclName'] = self.acl_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AclName') is not None:
            self.acl_name = m.get('AclName')
        return self


class DescribeIPv6TranslatorAclListsResponseBodyIpv6TranslatorAclsIPv6TranslatorAcl(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        acl_name: str = None,
    ):
        self.acl_id = acl_id
        self.acl_name = acl_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acl_name is not None:
            result['AclName'] = self.acl_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AclName') is not None:
            self.acl_name = m.get('AclName')
        return self


class DescribeIPv6TranslatorAclListsResponseBodyIpv6TranslatorAcls(TeaModel):
    def __init__(
        self,
        ipv_6translator_acl: List[DescribeIPv6TranslatorAclListsResponseBodyIpv6TranslatorAclsIPv6TranslatorAcl] = None,
    ):
        self.ipv_6translator_acl = ipv_6translator_acl

    def validate(self):
        if self.ipv_6translator_acl:
            for k in self.ipv_6translator_acl:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['IPv6TranslatorAcl'] = []
        if self.ipv_6translator_acl is not None:
            for k in self.ipv_6translator_acl:
                result['IPv6TranslatorAcl'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6translator_acl = []
        if m.get('IPv6TranslatorAcl') is not None:
            for k in m.get('IPv6TranslatorAcl'):
                temp_model = DescribeIPv6TranslatorAclListsResponseBodyIpv6TranslatorAclsIPv6TranslatorAcl()
                self.ipv_6translator_acl.append(temp_model.from_map(k))
        return self


class DescribeIPv6TranslatorAclListsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ipv_6translator_acls: DescribeIPv6TranslatorAclListsResponseBodyIpv6TranslatorAcls = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ipv_6translator_acls = ipv_6translator_acls

    def validate(self):
        if self.ipv_6translator_acls:
            self.ipv_6translator_acls.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ipv_6translator_acls is not None:
            result['Ipv6TranslatorAcls'] = self.ipv_6translator_acls.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Ipv6TranslatorAcls') is not None:
            temp_model = DescribeIPv6TranslatorAclListsResponseBodyIpv6TranslatorAcls()
            self.ipv_6translator_acls = temp_model.from_map(m['Ipv6TranslatorAcls'])
        return self


class DescribeIPv6TranslatorAclListsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIPv6TranslatorAclListsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIPv6TranslatorAclListsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIPv6TranslatorEntriesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ipv_6translator_id: str = None,
        ipv_6translator_entry_id: str = None,
        entry_name: str = None,
        allocate_ipv_6addr: str = None,
        allocate_ipv_6port: int = None,
        backend_ipv_4addr: str = None,
        backend_ipv_4port: int = None,
        trans_protocol: str = None,
        acl_status: str = None,
        acl_type: str = None,
        acl_id: str = None,
        page_number: int = None,
        page_size: int = None,
        client_token: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ipv_6translator_id = ipv_6translator_id
        self.ipv_6translator_entry_id = ipv_6translator_entry_id
        self.entry_name = entry_name
        self.allocate_ipv_6addr = allocate_ipv_6addr
        self.allocate_ipv_6port = allocate_ipv_6port
        self.backend_ipv_4addr = backend_ipv_4addr
        self.backend_ipv_4port = backend_ipv_4port
        self.trans_protocol = trans_protocol
        self.acl_status = acl_status
        self.acl_type = acl_type
        self.acl_id = acl_id
        self.page_number = page_number
        self.page_size = page_size
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        if self.ipv_6translator_entry_id is not None:
            result['Ipv6TranslatorEntryId'] = self.ipv_6translator_entry_id
        if self.entry_name is not None:
            result['EntryName'] = self.entry_name
        if self.allocate_ipv_6addr is not None:
            result['AllocateIpv6Addr'] = self.allocate_ipv_6addr
        if self.allocate_ipv_6port is not None:
            result['AllocateIpv6Port'] = self.allocate_ipv_6port
        if self.backend_ipv_4addr is not None:
            result['BackendIpv4Addr'] = self.backend_ipv_4addr
        if self.backend_ipv_4port is not None:
            result['BackendIpv4Port'] = self.backend_ipv_4port
        if self.trans_protocol is not None:
            result['TransProtocol'] = self.trans_protocol
        if self.acl_status is not None:
            result['AclStatus'] = self.acl_status
        if self.acl_type is not None:
            result['AclType'] = self.acl_type
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        if m.get('Ipv6TranslatorEntryId') is not None:
            self.ipv_6translator_entry_id = m.get('Ipv6TranslatorEntryId')
        if m.get('EntryName') is not None:
            self.entry_name = m.get('EntryName')
        if m.get('AllocateIpv6Addr') is not None:
            self.allocate_ipv_6addr = m.get('AllocateIpv6Addr')
        if m.get('AllocateIpv6Port') is not None:
            self.allocate_ipv_6port = m.get('AllocateIpv6Port')
        if m.get('BackendIpv4Addr') is not None:
            self.backend_ipv_4addr = m.get('BackendIpv4Addr')
        if m.get('BackendIpv4Port') is not None:
            self.backend_ipv_4port = m.get('BackendIpv4Port')
        if m.get('TransProtocol') is not None:
            self.trans_protocol = m.get('TransProtocol')
        if m.get('AclStatus') is not None:
            self.acl_status = m.get('AclStatus')
        if m.get('AclType') is not None:
            self.acl_type = m.get('AclType')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class DescribeIPv6TranslatorEntriesResponseBodyIpv6TranslatorEntriesIpv6TranslatorEntry(TeaModel):
    def __init__(
        self,
        entry_status: str = None,
        acl_type: str = None,
        trans_protocol: str = None,
        entry_description: str = None,
        ipv_6translator_id: str = None,
        backend_ipv_4addr: str = None,
        allocate_ipv_6port: int = None,
        ipv_6translator_entry_id: str = None,
        backend_ipv_4port: str = None,
        region_id: str = None,
        entry_bandwidth: str = None,
        acl_id: str = None,
        entry_name: str = None,
        acl_status: str = None,
        allocate_ipv_6addr: str = None,
    ):
        self.entry_status = entry_status
        self.acl_type = acl_type
        self.trans_protocol = trans_protocol
        self.entry_description = entry_description
        self.ipv_6translator_id = ipv_6translator_id
        self.backend_ipv_4addr = backend_ipv_4addr
        self.allocate_ipv_6port = allocate_ipv_6port
        self.ipv_6translator_entry_id = ipv_6translator_entry_id
        self.backend_ipv_4port = backend_ipv_4port
        self.region_id = region_id
        self.entry_bandwidth = entry_bandwidth
        self.acl_id = acl_id
        self.entry_name = entry_name
        self.acl_status = acl_status
        self.allocate_ipv_6addr = allocate_ipv_6addr

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.entry_status is not None:
            result['EntryStatus'] = self.entry_status
        if self.acl_type is not None:
            result['AclType'] = self.acl_type
        if self.trans_protocol is not None:
            result['TransProtocol'] = self.trans_protocol
        if self.entry_description is not None:
            result['EntryDescription'] = self.entry_description
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        if self.backend_ipv_4addr is not None:
            result['BackendIpv4Addr'] = self.backend_ipv_4addr
        if self.allocate_ipv_6port is not None:
            result['AllocateIpv6Port'] = self.allocate_ipv_6port
        if self.ipv_6translator_entry_id is not None:
            result['Ipv6TranslatorEntryId'] = self.ipv_6translator_entry_id
        if self.backend_ipv_4port is not None:
            result['BackendIpv4Port'] = self.backend_ipv_4port
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.entry_bandwidth is not None:
            result['EntryBandwidth'] = self.entry_bandwidth
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.entry_name is not None:
            result['EntryName'] = self.entry_name
        if self.acl_status is not None:
            result['AclStatus'] = self.acl_status
        if self.allocate_ipv_6addr is not None:
            result['AllocateIpv6Addr'] = self.allocate_ipv_6addr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntryStatus') is not None:
            self.entry_status = m.get('EntryStatus')
        if m.get('AclType') is not None:
            self.acl_type = m.get('AclType')
        if m.get('TransProtocol') is not None:
            self.trans_protocol = m.get('TransProtocol')
        if m.get('EntryDescription') is not None:
            self.entry_description = m.get('EntryDescription')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        if m.get('BackendIpv4Addr') is not None:
            self.backend_ipv_4addr = m.get('BackendIpv4Addr')
        if m.get('AllocateIpv6Port') is not None:
            self.allocate_ipv_6port = m.get('AllocateIpv6Port')
        if m.get('Ipv6TranslatorEntryId') is not None:
            self.ipv_6translator_entry_id = m.get('Ipv6TranslatorEntryId')
        if m.get('BackendIpv4Port') is not None:
            self.backend_ipv_4port = m.get('BackendIpv4Port')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EntryBandwidth') is not None:
            self.entry_bandwidth = m.get('EntryBandwidth')
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('EntryName') is not None:
            self.entry_name = m.get('EntryName')
        if m.get('AclStatus') is not None:
            self.acl_status = m.get('AclStatus')
        if m.get('AllocateIpv6Addr') is not None:
            self.allocate_ipv_6addr = m.get('AllocateIpv6Addr')
        return self


class DescribeIPv6TranslatorEntriesResponseBodyIpv6TranslatorEntries(TeaModel):
    def __init__(
        self,
        ipv_6translator_entry: List[DescribeIPv6TranslatorEntriesResponseBodyIpv6TranslatorEntriesIpv6TranslatorEntry] = None,
    ):
        self.ipv_6translator_entry = ipv_6translator_entry

    def validate(self):
        if self.ipv_6translator_entry:
            for k in self.ipv_6translator_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Ipv6TranslatorEntry'] = []
        if self.ipv_6translator_entry is not None:
            for k in self.ipv_6translator_entry:
                result['Ipv6TranslatorEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6translator_entry = []
        if m.get('Ipv6TranslatorEntry') is not None:
            for k in m.get('Ipv6TranslatorEntry'):
                temp_model = DescribeIPv6TranslatorEntriesResponseBodyIpv6TranslatorEntriesIpv6TranslatorEntry()
                self.ipv_6translator_entry.append(temp_model.from_map(k))
        return self


class DescribeIPv6TranslatorEntriesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ipv_6translator_entries: DescribeIPv6TranslatorEntriesResponseBodyIpv6TranslatorEntries = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ipv_6translator_entries = ipv_6translator_entries

    def validate(self):
        if self.ipv_6translator_entries:
            self.ipv_6translator_entries.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ipv_6translator_entries is not None:
            result['Ipv6TranslatorEntries'] = self.ipv_6translator_entries.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Ipv6TranslatorEntries') is not None:
            temp_model = DescribeIPv6TranslatorEntriesResponseBodyIpv6TranslatorEntries()
            self.ipv_6translator_entries = temp_model.from_map(m['Ipv6TranslatorEntries'])
        return self


class DescribeIPv6TranslatorEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIPv6TranslatorEntriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIPv6TranslatorEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIPv6TranslatorsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ipv_6translator_id: str = None,
        name: str = None,
        spec: str = None,
        status: str = None,
        allocate_ipv_6addr: str = None,
        allocate_ipv_4addr: str = None,
        pay_type: str = None,
        page_number: int = None,
        page_size: int = None,
        business_status: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ipv_6translator_id = ipv_6translator_id
        self.name = name
        self.spec = spec
        self.status = status
        self.allocate_ipv_6addr = allocate_ipv_6addr
        self.allocate_ipv_4addr = allocate_ipv_4addr
        self.pay_type = pay_type
        self.page_number = page_number
        self.page_size = page_size
        self.business_status = business_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        if self.name is not None:
            result['Name'] = self.name
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.status is not None:
            result['Status'] = self.status
        if self.allocate_ipv_6addr is not None:
            result['AllocateIpv6Addr'] = self.allocate_ipv_6addr
        if self.allocate_ipv_4addr is not None:
            result['AllocateIpv4Addr'] = self.allocate_ipv_4addr
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AllocateIpv6Addr') is not None:
            self.allocate_ipv_6addr = m.get('AllocateIpv6Addr')
        if m.get('AllocateIpv4Addr') is not None:
            self.allocate_ipv_4addr = m.get('AllocateIpv4Addr')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        return self


class DescribeIPv6TranslatorsResponseBodyIpv6TranslatorsIpv6TranslatorIpv6TranslatorEntryIds(TeaModel):
    def __init__(
        self,
        ipv_6translator_entry_id: List[str] = None,
    ):
        self.ipv_6translator_entry_id = ipv_6translator_entry_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ipv_6translator_entry_id is not None:
            result['Ipv6TranslatorEntryId'] = self.ipv_6translator_entry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ipv6TranslatorEntryId') is not None:
            self.ipv_6translator_entry_id = m.get('Ipv6TranslatorEntryId')
        return self


class DescribeIPv6TranslatorsResponseBodyIpv6TranslatorsIpv6Translator(TeaModel):
    def __init__(
        self,
        status: str = None,
        spec: str = None,
        create_time: int = None,
        pay_type: str = None,
        allocate_ipv_4addr: str = None,
        ipv_6translator_id: str = None,
        ipv_6translator_entry_ids: DescribeIPv6TranslatorsResponseBodyIpv6TranslatorsIpv6TranslatorIpv6TranslatorEntryIds = None,
        available_bandwidth: str = None,
        region_id: str = None,
        end_time: int = None,
        bandwidth: int = None,
        description: str = None,
        business_status: str = None,
        allocate_ipv_6addr: str = None,
        name: str = None,
    ):
        self.status = status
        self.spec = spec
        self.create_time = create_time
        self.pay_type = pay_type
        self.allocate_ipv_4addr = allocate_ipv_4addr
        self.ipv_6translator_id = ipv_6translator_id
        self.ipv_6translator_entry_ids = ipv_6translator_entry_ids
        self.available_bandwidth = available_bandwidth
        self.region_id = region_id
        self.end_time = end_time
        self.bandwidth = bandwidth
        self.description = description
        self.business_status = business_status
        self.allocate_ipv_6addr = allocate_ipv_6addr
        self.name = name

    def validate(self):
        if self.ipv_6translator_entry_ids:
            self.ipv_6translator_entry_ids.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.allocate_ipv_4addr is not None:
            result['AllocateIpv4Addr'] = self.allocate_ipv_4addr
        if self.ipv_6translator_id is not None:
            result['Ipv6TranslatorId'] = self.ipv_6translator_id
        if self.ipv_6translator_entry_ids is not None:
            result['Ipv6TranslatorEntryIds'] = self.ipv_6translator_entry_ids.to_map()
        if self.available_bandwidth is not None:
            result['AvailableBandwidth'] = self.available_bandwidth
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.description is not None:
            result['Description'] = self.description
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.allocate_ipv_6addr is not None:
            result['AllocateIpv6Addr'] = self.allocate_ipv_6addr
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('AllocateIpv4Addr') is not None:
            self.allocate_ipv_4addr = m.get('AllocateIpv4Addr')
        if m.get('Ipv6TranslatorId') is not None:
            self.ipv_6translator_id = m.get('Ipv6TranslatorId')
        if m.get('Ipv6TranslatorEntryIds') is not None:
            temp_model = DescribeIPv6TranslatorsResponseBodyIpv6TranslatorsIpv6TranslatorIpv6TranslatorEntryIds()
            self.ipv_6translator_entry_ids = temp_model.from_map(m['Ipv6TranslatorEntryIds'])
        if m.get('AvailableBandwidth') is not None:
            self.available_bandwidth = m.get('AvailableBandwidth')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('AllocateIpv6Addr') is not None:
            self.allocate_ipv_6addr = m.get('AllocateIpv6Addr')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeIPv6TranslatorsResponseBodyIpv6Translators(TeaModel):
    def __init__(
        self,
        ipv_6translator: List[DescribeIPv6TranslatorsResponseBodyIpv6TranslatorsIpv6Translator] = None,
    ):
        self.ipv_6translator = ipv_6translator

    def validate(self):
        if self.ipv_6translator:
            for k in self.ipv_6translator:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Ipv6Translator'] = []
        if self.ipv_6translator is not None:
            for k in self.ipv_6translator:
                result['Ipv6Translator'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6translator = []
        if m.get('Ipv6Translator') is not None:
            for k in m.get('Ipv6Translator'):
                temp_model = DescribeIPv6TranslatorsResponseBodyIpv6TranslatorsIpv6Translator()
                self.ipv_6translator.append(temp_model.from_map(k))
        return self


class DescribeIPv6TranslatorsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ipv_6translators: DescribeIPv6TranslatorsResponseBodyIpv6Translators = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ipv_6translators = ipv_6translators

    def validate(self):
        if self.ipv_6translators:
            self.ipv_6translators.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ipv_6translators is not None:
            result['Ipv6Translators'] = self.ipv_6translators.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Ipv6Translators') is not None:
            temp_model = DescribeIPv6TranslatorsResponseBodyIpv6Translators()
            self.ipv_6translators = temp_model.from_map(m['Ipv6Translators'])
        return self


class DescribeIPv6TranslatorsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeIPv6TranslatorsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeIPv6TranslatorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatGatewaysRequestTag(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeNatGatewaysRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        nat_gateway_id: str = None,
        vpc_id: str = None,
        name: str = None,
        instance_charge_type: str = None,
        spec: str = None,
        nat_type: str = None,
        resource_group_id: str = None,
        page_number: int = None,
        page_size: int = None,
        dry_run: bool = None,
        status: str = None,
        tag: List[DescribeNatGatewaysRequestTag] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.nat_gateway_id = nat_gateway_id
        self.vpc_id = vpc_id
        self.name = name
        self.instance_charge_type = instance_charge_type
        self.spec = spec
        self.nat_type = nat_type
        self.resource_group_id = resource_group_id
        self.page_number = page_number
        self.page_size = page_size
        self.dry_run = dry_run
        self.status = status
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.name is not None:
            result['Name'] = self.name
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.nat_type is not None:
            result['NatType'] = self.nat_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('NatType') is not None:
            self.nat_type = m.get('NatType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeNatGatewaysRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayIpListsIpList(TeaModel):
    def __init__(
        self,
        ip_address: str = None,
        snat_entry_enabled: bool = None,
    ):
        self.ip_address = ip_address
        self.snat_entry_enabled = snat_entry_enabled

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.snat_entry_enabled is not None:
            result['SnatEntryEnabled'] = self.snat_entry_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('SnatEntryEnabled') is not None:
            self.snat_entry_enabled = m.get('SnatEntryEnabled')
        return self


class DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayIpLists(TeaModel):
    def __init__(
        self,
        ip_list: List[DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayIpListsIpList] = None,
    ):
        self.ip_list = ip_list

    def validate(self):
        if self.ip_list:
            for k in self.ip_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['IpList'] = []
        if self.ip_list is not None:
            for k in self.ip_list:
                result['IpList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ip_list = []
        if m.get('IpList') is not None:
            for k in m.get('IpList'):
                temp_model = DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayIpListsIpList()
                self.ip_list.append(temp_model.from_map(k))
        return self


class DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayNatGatewayPrivateInfo(TeaModel):
    def __init__(
        self,
        vswitch_id: str = None,
        eni_instance_id: str = None,
        max_bandwidth: int = None,
        private_ip_address: str = None,
        iz_no: str = None,
    ):
        self.vswitch_id = vswitch_id
        self.eni_instance_id = eni_instance_id
        self.max_bandwidth = max_bandwidth
        self.private_ip_address = private_ip_address
        self.iz_no = iz_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.eni_instance_id is not None:
            result['EniInstanceId'] = self.eni_instance_id
        if self.max_bandwidth is not None:
            result['MaxBandwidth'] = self.max_bandwidth
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.iz_no is not None:
            result['IzNo'] = self.iz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('EniInstanceId') is not None:
            self.eni_instance_id = m.get('EniInstanceId')
        if m.get('MaxBandwidth') is not None:
            self.max_bandwidth = m.get('MaxBandwidth')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('IzNo') is not None:
            self.iz_no = m.get('IzNo')
        return self


class DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayForwardTableIds(TeaModel):
    def __init__(
        self,
        forward_table_id: List[str] = None,
    ):
        self.forward_table_id = forward_table_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        return self


class DescribeNatGatewaysResponseBodyNatGatewaysNatGatewaySnatTableIds(TeaModel):
    def __init__(
        self,
        snat_table_id: List[str] = None,
    ):
        self.snat_table_id = snat_table_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.snat_table_id is not None:
            result['SnatTableId'] = self.snat_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SnatTableId') is not None:
            self.snat_table_id = m.get('SnatTableId')
        return self


class DescribeNatGatewaysResponseBodyNatGatewaysNatGateway(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        creation_time: str = None,
        status: str = None,
        nat_type: str = None,
        spec: str = None,
        deletion_protection: bool = None,
        region_id: str = None,
        instance_charge_type: str = None,
        ecs_metric_enabled: bool = None,
        description: str = None,
        expired_time: str = None,
        ip_lists: DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayIpLists = None,
        nat_gateway_private_info: DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayNatGatewayPrivateInfo = None,
        resource_group_id: str = None,
        nat_gateway_id: str = None,
        internet_charge_type: str = None,
        business_status: str = None,
        forward_table_ids: DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayForwardTableIds = None,
        snat_table_ids: DescribeNatGatewaysResponseBodyNatGatewaysNatGatewaySnatTableIds = None,
        name: str = None,
    ):
        self.vpc_id = vpc_id
        self.creation_time = creation_time
        self.status = status
        self.nat_type = nat_type
        self.spec = spec
        self.deletion_protection = deletion_protection
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.ecs_metric_enabled = ecs_metric_enabled
        self.description = description
        self.expired_time = expired_time
        self.ip_lists = ip_lists
        self.nat_gateway_private_info = nat_gateway_private_info
        self.resource_group_id = resource_group_id
        self.nat_gateway_id = nat_gateway_id
        self.internet_charge_type = internet_charge_type
        self.business_status = business_status
        self.forward_table_ids = forward_table_ids
        self.snat_table_ids = snat_table_ids
        self.name = name

    def validate(self):
        if self.ip_lists:
            self.ip_lists.validate()
        if self.nat_gateway_private_info:
            self.nat_gateway_private_info.validate()
        if self.forward_table_ids:
            self.forward_table_ids.validate()
        if self.snat_table_ids:
            self.snat_table_ids.validate()

    def to_map(self):
        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.nat_type is not None:
            result['NatType'] = self.nat_type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.ecs_metric_enabled is not None:
            result['EcsMetricEnabled'] = self.ecs_metric_enabled
        if self.description is not None:
            result['Description'] = self.description
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.ip_lists is not None:
            result['IpLists'] = self.ip_lists.to_map()
        if self.nat_gateway_private_info is not None:
            result['NatGatewayPrivateInfo'] = self.nat_gateway_private_info.to_map()
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        if self.snat_table_ids is not None:
            result['SnatTableIds'] = self.snat_table_ids.to_map()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NatType') is not None:
            self.nat_type = m.get('NatType')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('EcsMetricEnabled') is not None:
            self.ecs_metric_enabled = m.get('EcsMetricEnabled')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('IpLists') is not None:
            temp_model = DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayIpLists()
            self.ip_lists = temp_model.from_map(m['IpLists'])
        if m.get('NatGatewayPrivateInfo') is not None:
            temp_model = DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayNatGatewayPrivateInfo()
            self.nat_gateway_private_info = temp_model.from_map(m['NatGatewayPrivateInfo'])
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ForwardTableIds') is not None:
            temp_model = DescribeNatGatewaysResponseBodyNatGatewaysNatGatewayForwardTableIds()
            self.forward_table_ids = temp_model.from_map(m['ForwardTableIds'])
        if m.get('SnatTableIds') is not None:
            temp_model = DescribeNatGatewaysResponseBodyNatGatewaysNatGatewaySnatTableIds()
            self.snat_table_ids = temp_model.from_map(m['SnatTableIds'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeNatGatewaysResponseBodyNatGateways(TeaModel):
    def __init__(
        self,
        nat_gateway: List[DescribeNatGatewaysResponseBodyNatGatewaysNatGateway] = None,
    ):
        self.nat_gateway = nat_gateway

    def validate(self):
        if self.nat_gateway:
            for k in self.nat_gateway:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['NatGateway'] = []
        if self.nat_gateway is not None:
            for k in self.nat_gateway:
                result['NatGateway'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nat_gateway = []
        if m.get('NatGateway') is not None:
            for k in m.get('NatGateway'):
                temp_model = DescribeNatGatewaysResponseBodyNatGatewaysNatGateway()
                self.nat_gateway.append(temp_model.from_map(k))
        return self


class DescribeNatGatewaysResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        nat_gateways: DescribeNatGatewaysResponseBodyNatGateways = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.nat_gateways = nat_gateways

    def validate(self):
        if self.nat_gateways:
            self.nat_gateways.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.nat_gateways is not None:
            result['NatGateways'] = self.nat_gateways.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('NatGateways') is not None:
            temp_model = DescribeNatGatewaysResponseBodyNatGateways()
            self.nat_gateways = temp_model.from_map(m['NatGateways'])
        return self


class DescribeNatGatewaysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeNatGatewaysResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeNatGatewaysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkAclAttributesRequest(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
    ):
        self.network_acl_id = network_acl_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeEgressAclEntriesEgressAclEntry(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
        entry_type: str = None,
        network_acl_entry_name: str = None,
        policy: str = None,
        description: str = None,
        protocol: str = None,
        destination_cidr_ip: str = None,
        port: str = None,
    ):
        self.network_acl_entry_id = network_acl_entry_id
        self.entry_type = entry_type
        self.network_acl_entry_name = network_acl_entry_name
        self.policy = policy
        self.description = description
        self.protocol = protocol
        self.destination_cidr_ip = destination_cidr_ip
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.description is not None:
            result['Description'] = self.description
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.destination_cidr_ip is not None:
            result['DestinationCidrIp'] = self.destination_cidr_ip
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('DestinationCidrIp') is not None:
            self.destination_cidr_ip = m.get('DestinationCidrIp')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeEgressAclEntries(TeaModel):
    def __init__(
        self,
        egress_acl_entry: List[DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeEgressAclEntriesEgressAclEntry] = None,
    ):
        self.egress_acl_entry = egress_acl_entry

    def validate(self):
        if self.egress_acl_entry:
            for k in self.egress_acl_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EgressAclEntry'] = []
        if self.egress_acl_entry is not None:
            for k in self.egress_acl_entry:
                result['EgressAclEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.egress_acl_entry = []
        if m.get('EgressAclEntry') is not None:
            for k in m.get('EgressAclEntry'):
                temp_model = DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeEgressAclEntriesEgressAclEntry()
                self.egress_acl_entry.append(temp_model.from_map(k))
        return self


class DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeIngressAclEntriesIngressAclEntry(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
        entry_type: str = None,
        network_acl_entry_name: str = None,
        policy: str = None,
        description: str = None,
        source_cidr_ip: str = None,
        protocol: str = None,
        port: str = None,
    ):
        self.network_acl_entry_id = network_acl_entry_id
        self.entry_type = entry_type
        self.network_acl_entry_name = network_acl_entry_name
        self.policy = policy
        self.description = description
        self.source_cidr_ip = source_cidr_ip
        self.protocol = protocol
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.description is not None:
            result['Description'] = self.description
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeIngressAclEntries(TeaModel):
    def __init__(
        self,
        ingress_acl_entry: List[DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeIngressAclEntriesIngressAclEntry] = None,
    ):
        self.ingress_acl_entry = ingress_acl_entry

    def validate(self):
        if self.ingress_acl_entry:
            for k in self.ingress_acl_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['IngressAclEntry'] = []
        if self.ingress_acl_entry is not None:
            for k in self.ingress_acl_entry:
                result['IngressAclEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ingress_acl_entry = []
        if m.get('IngressAclEntry') is not None:
            for k in m.get('IngressAclEntry'):
                temp_model = DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeIngressAclEntriesIngressAclEntry()
                self.ingress_acl_entry.append(temp_model.from_map(k))
        return self


class DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeResourcesResource(TeaModel):
    def __init__(
        self,
        status: str = None,
        resource_type: str = None,
        resource_id: str = None,
    ):
        self.status = status
        self.resource_type = resource_type
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeNetworkAclAttributesResponseBodyNetworkAclAttribute(TeaModel):
    def __init__(
        self,
        status: str = None,
        vpc_id: str = None,
        creation_time: str = None,
        description: str = None,
        egress_acl_entries: DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeEgressAclEntries = None,
        network_acl_name: str = None,
        ingress_acl_entries: DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeIngressAclEntries = None,
        network_acl_id: str = None,
        owner_id: int = None,
        resources: DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeResources = None,
        region_id: str = None,
    ):
        self.status = status
        self.vpc_id = vpc_id
        self.creation_time = creation_time
        self.description = description
        self.egress_acl_entries = egress_acl_entries
        self.network_acl_name = network_acl_name
        self.ingress_acl_entries = ingress_acl_entries
        self.network_acl_id = network_acl_id
        self.owner_id = owner_id
        self.resources = resources
        self.region_id = region_id

    def validate(self):
        if self.egress_acl_entries:
            self.egress_acl_entries.validate()
        if self.ingress_acl_entries:
            self.ingress_acl_entries.validate()
        if self.resources:
            self.resources.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.egress_acl_entries is not None:
            result['EgressAclEntries'] = self.egress_acl_entries.to_map()
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        if self.ingress_acl_entries is not None:
            result['IngressAclEntries'] = self.ingress_acl_entries.to_map()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EgressAclEntries') is not None:
            temp_model = DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeEgressAclEntries()
            self.egress_acl_entries = temp_model.from_map(m['EgressAclEntries'])
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        if m.get('IngressAclEntries') is not None:
            temp_model = DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeIngressAclEntries()
            self.ingress_acl_entries = temp_model.from_map(m['IngressAclEntries'])
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Resources') is not None:
            temp_model = DescribeNetworkAclAttributesResponseBodyNetworkAclAttributeResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeNetworkAclAttributesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        network_acl_attribute: DescribeNetworkAclAttributesResponseBodyNetworkAclAttribute = None,
    ):
        self.request_id = request_id
        self.network_acl_attribute = network_acl_attribute

    def validate(self):
        if self.network_acl_attribute:
            self.network_acl_attribute.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.network_acl_attribute is not None:
            result['NetworkAclAttribute'] = self.network_acl_attribute.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NetworkAclAttribute') is not None:
            temp_model = DescribeNetworkAclAttributesResponseBodyNetworkAclAttribute()
            self.network_acl_attribute = temp_model.from_map(m['NetworkAclAttribute'])
        return self


class DescribeNetworkAclAttributesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeNetworkAclAttributesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeNetworkAclAttributesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkAclsRequest(TeaModel):
    def __init__(
        self,
        network_acl_id: str = None,
        network_acl_name: str = None,
        vpc_id: str = None,
        resource_type: str = None,
        resource_id: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_id: int = None,
        client_token: str = None,
    ):
        self.network_acl_id = network_acl_id
        self.network_acl_name = network_acl_name
        self.vpc_id = vpc_id
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_id = owner_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclEgressAclEntriesEgressAclEntry(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
        entry_type: str = None,
        network_acl_entry_name: str = None,
        policy: str = None,
        description: str = None,
        protocol: str = None,
        destination_cidr_ip: str = None,
        port: str = None,
    ):
        self.network_acl_entry_id = network_acl_entry_id
        self.entry_type = entry_type
        self.network_acl_entry_name = network_acl_entry_name
        self.policy = policy
        self.description = description
        self.protocol = protocol
        self.destination_cidr_ip = destination_cidr_ip
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.description is not None:
            result['Description'] = self.description
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.destination_cidr_ip is not None:
            result['DestinationCidrIp'] = self.destination_cidr_ip
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('DestinationCidrIp') is not None:
            self.destination_cidr_ip = m.get('DestinationCidrIp')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclEgressAclEntries(TeaModel):
    def __init__(
        self,
        egress_acl_entry: List[DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclEgressAclEntriesEgressAclEntry] = None,
    ):
        self.egress_acl_entry = egress_acl_entry

    def validate(self):
        if self.egress_acl_entry:
            for k in self.egress_acl_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EgressAclEntry'] = []
        if self.egress_acl_entry is not None:
            for k in self.egress_acl_entry:
                result['EgressAclEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.egress_acl_entry = []
        if m.get('EgressAclEntry') is not None:
            for k in m.get('EgressAclEntry'):
                temp_model = DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclEgressAclEntriesEgressAclEntry()
                self.egress_acl_entry.append(temp_model.from_map(k))
        return self


class DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclIngressAclEntriesIngressAclEntry(TeaModel):
    def __init__(
        self,
        network_acl_entry_id: str = None,
        entry_type: str = None,
        network_acl_entry_name: str = None,
        policy: str = None,
        description: str = None,
        source_cidr_ip: str = None,
        protocol: str = None,
        port: str = None,
    ):
        self.network_acl_entry_id = network_acl_entry_id
        self.entry_type = entry_type
        self.network_acl_entry_name = network_acl_entry_name
        self.policy = policy
        self.description = description
        self.source_cidr_ip = source_cidr_ip
        self.protocol = protocol
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.description is not None:
            result['Description'] = self.description
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclIngressAclEntries(TeaModel):
    def __init__(
        self,
        ingress_acl_entry: List[DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclIngressAclEntriesIngressAclEntry] = None,
    ):
        self.ingress_acl_entry = ingress_acl_entry

    def validate(self):
        if self.ingress_acl_entry:
            for k in self.ingress_acl_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['IngressAclEntry'] = []
        if self.ingress_acl_entry is not None:
            for k in self.ingress_acl_entry:
                result['IngressAclEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ingress_acl_entry = []
        if m.get('IngressAclEntry') is not None:
            for k in m.get('IngressAclEntry'):
                temp_model = DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclIngressAclEntriesIngressAclEntry()
                self.ingress_acl_entry.append(temp_model.from_map(k))
        return self


class DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclResourcesResource(TeaModel):
    def __init__(
        self,
        status: str = None,
        resource_type: str = None,
        resource_id: str = None,
    ):
        self.status = status
        self.resource_type = resource_type
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeNetworkAclsResponseBodyNetworkAclsNetworkAcl(TeaModel):
    def __init__(
        self,
        status: str = None,
        vpc_id: str = None,
        creation_time: str = None,
        description: str = None,
        egress_acl_entries: DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclEgressAclEntries = None,
        network_acl_name: str = None,
        ingress_acl_entries: DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclIngressAclEntries = None,
        network_acl_id: str = None,
        owner_id: int = None,
        resources: DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclResources = None,
        region_id: str = None,
    ):
        self.status = status
        self.vpc_id = vpc_id
        self.creation_time = creation_time
        self.description = description
        self.egress_acl_entries = egress_acl_entries
        self.network_acl_name = network_acl_name
        self.ingress_acl_entries = ingress_acl_entries
        self.network_acl_id = network_acl_id
        self.owner_id = owner_id
        self.resources = resources
        self.region_id = region_id

    def validate(self):
        if self.egress_acl_entries:
            self.egress_acl_entries.validate()
        if self.ingress_acl_entries:
            self.ingress_acl_entries.validate()
        if self.resources:
            self.resources.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.egress_acl_entries is not None:
            result['EgressAclEntries'] = self.egress_acl_entries.to_map()
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        if self.ingress_acl_entries is not None:
            result['IngressAclEntries'] = self.ingress_acl_entries.to_map()
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EgressAclEntries') is not None:
            temp_model = DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclEgressAclEntries()
            self.egress_acl_entries = temp_model.from_map(m['EgressAclEntries'])
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        if m.get('IngressAclEntries') is not None:
            temp_model = DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclIngressAclEntries()
            self.ingress_acl_entries = temp_model.from_map(m['IngressAclEntries'])
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Resources') is not None:
            temp_model = DescribeNetworkAclsResponseBodyNetworkAclsNetworkAclResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeNetworkAclsResponseBodyNetworkAcls(TeaModel):
    def __init__(
        self,
        network_acl: List[DescribeNetworkAclsResponseBodyNetworkAclsNetworkAcl] = None,
    ):
        self.network_acl = network_acl

    def validate(self):
        if self.network_acl:
            for k in self.network_acl:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['NetworkAcl'] = []
        if self.network_acl is not None:
            for k in self.network_acl:
                result['NetworkAcl'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.network_acl = []
        if m.get('NetworkAcl') is not None:
            for k in m.get('NetworkAcl'):
                temp_model = DescribeNetworkAclsResponseBodyNetworkAclsNetworkAcl()
                self.network_acl.append(temp_model.from_map(k))
        return self


class DescribeNetworkAclsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: str = None,
        network_acls: DescribeNetworkAclsResponseBodyNetworkAcls = None,
        page_size: str = None,
        request_id: str = None,
        page_number: str = None,
    ):
        self.total_count = total_count
        self.network_acls = network_acls
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.network_acls:
            self.network_acls.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.network_acls is not None:
            result['NetworkAcls'] = self.network_acls.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NetworkAcls') is not None:
            temp_model = DescribeNetworkAclsResponseBodyNetworkAcls()
            self.network_acls = temp_model.from_map(m['NetworkAcls'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeNetworkAclsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeNetworkAclsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeNetworkAclsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNewProjectEipMonitorDataRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        allocation_id: str = None,
        start_time: str = None,
        end_time: str = None,
        period: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.allocation_id = allocation_id
        self.start_time = start_time
        self.end_time = end_time
        self.period = period
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.period is not None:
            result['Period'] = self.period
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeNewProjectEipMonitorDataResponseBodyEipMonitorDatasEipMonitorData(TeaModel):
    def __init__(
        self,
        eip_tx: int = None,
        eip_packets: int = None,
        eip_bandwidth: int = None,
        time_stamp: str = None,
        eip_flow: int = None,
        eip_rx: int = None,
    ):
        self.eip_tx = eip_tx
        self.eip_packets = eip_packets
        self.eip_bandwidth = eip_bandwidth
        self.time_stamp = time_stamp
        self.eip_flow = eip_flow
        self.eip_rx = eip_rx

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.eip_tx is not None:
            result['EipTX'] = self.eip_tx
        if self.eip_packets is not None:
            result['EipPackets'] = self.eip_packets
        if self.eip_bandwidth is not None:
            result['EipBandwidth'] = self.eip_bandwidth
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.eip_flow is not None:
            result['EipFlow'] = self.eip_flow
        if self.eip_rx is not None:
            result['EipRX'] = self.eip_rx
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EipTX') is not None:
            self.eip_tx = m.get('EipTX')
        if m.get('EipPackets') is not None:
            self.eip_packets = m.get('EipPackets')
        if m.get('EipBandwidth') is not None:
            self.eip_bandwidth = m.get('EipBandwidth')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('EipFlow') is not None:
            self.eip_flow = m.get('EipFlow')
        if m.get('EipRX') is not None:
            self.eip_rx = m.get('EipRX')
        return self


class DescribeNewProjectEipMonitorDataResponseBodyEipMonitorDatas(TeaModel):
    def __init__(
        self,
        eip_monitor_data: List[DescribeNewProjectEipMonitorDataResponseBodyEipMonitorDatasEipMonitorData] = None,
    ):
        self.eip_monitor_data = eip_monitor_data

    def validate(self):
        if self.eip_monitor_data:
            for k in self.eip_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EipMonitorData'] = []
        if self.eip_monitor_data is not None:
            for k in self.eip_monitor_data:
                result['EipMonitorData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.eip_monitor_data = []
        if m.get('EipMonitorData') is not None:
            for k in m.get('EipMonitorData'):
                temp_model = DescribeNewProjectEipMonitorDataResponseBodyEipMonitorDatasEipMonitorData()
                self.eip_monitor_data.append(temp_model.from_map(k))
        return self


class DescribeNewProjectEipMonitorDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        eip_monitor_datas: DescribeNewProjectEipMonitorDataResponseBodyEipMonitorDatas = None,
    ):
        self.request_id = request_id
        self.eip_monitor_datas = eip_monitor_datas

    def validate(self):
        if self.eip_monitor_datas:
            self.eip_monitor_datas.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.eip_monitor_datas is not None:
            result['EipMonitorDatas'] = self.eip_monitor_datas.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EipMonitorDatas') is not None:
            temp_model = DescribeNewProjectEipMonitorDataResponseBodyEipMonitorDatas()
            self.eip_monitor_datas = temp_model.from_map(m['EipMonitorDatas'])
        return self


class DescribeNewProjectEipMonitorDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeNewProjectEipMonitorDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeNewProjectEipMonitorDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePhysicalConnectionLOARequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
        instance_id: str = None,
    ):
        self.region_id = region_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOATypePMInfoPMInfo(TeaModel):
    def __init__(
        self,
        pmcertificate_no: str = None,
        pmname: str = None,
        pmcertificate_type: str = None,
        pmgender: str = None,
        pmcontact_info: str = None,
    ):
        self.pmcertificate_no = pmcertificate_no
        self.pmname = pmname
        self.pmcertificate_type = pmcertificate_type
        self.pmgender = pmgender
        self.pmcontact_info = pmcontact_info

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.pmcertificate_no is not None:
            result['PMCertificateNo'] = self.pmcertificate_no
        if self.pmname is not None:
            result['PMName'] = self.pmname
        if self.pmcertificate_type is not None:
            result['PMCertificateType'] = self.pmcertificate_type
        if self.pmgender is not None:
            result['PMGender'] = self.pmgender
        if self.pmcontact_info is not None:
            result['PMContactInfo'] = self.pmcontact_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PMCertificateNo') is not None:
            self.pmcertificate_no = m.get('PMCertificateNo')
        if m.get('PMName') is not None:
            self.pmname = m.get('PMName')
        if m.get('PMCertificateType') is not None:
            self.pmcertificate_type = m.get('PMCertificateType')
        if m.get('PMGender') is not None:
            self.pmgender = m.get('PMGender')
        if m.get('PMContactInfo') is not None:
            self.pmcontact_info = m.get('PMContactInfo')
        return self


class DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOATypePMInfo(TeaModel):
    def __init__(
        self,
        pminfo: List[DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOATypePMInfoPMInfo] = None,
    ):
        self.pminfo = pminfo

    def validate(self):
        if self.pminfo:
            for k in self.pminfo:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PMInfo'] = []
        if self.pminfo is not None:
            for k in self.pminfo:
                result['PMInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pminfo = []
        if m.get('PMInfo') is not None:
            for k in m.get('PMInfo'):
                temp_model = DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOATypePMInfoPMInfo()
                self.pminfo.append(temp_model.from_map(k))
        return self


class DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOAType(TeaModel):
    def __init__(
        self,
        status: str = None,
        line_label: str = None,
        line_code: str = None,
        construction_time: str = None,
        si: str = None,
        loa_url: str = None,
        company_localized_name: str = None,
        instance_id: str = None,
        pminfo: DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOATypePMInfo = None,
        line_type: str = None,
        company_name: str = None,
    ):
        self.status = status
        self.line_label = line_label
        self.line_code = line_code
        self.construction_time = construction_time
        self.si = si
        self.loa_url = loa_url
        self.company_localized_name = company_localized_name
        self.instance_id = instance_id
        self.pminfo = pminfo
        self.line_type = line_type
        self.company_name = company_name

    def validate(self):
        if self.pminfo:
            self.pminfo.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.line_label is not None:
            result['LineLabel'] = self.line_label
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.construction_time is not None:
            result['ConstructionTime'] = self.construction_time
        if self.si is not None:
            result['SI'] = self.si
        if self.loa_url is not None:
            result['LoaUrl'] = self.loa_url
        if self.company_localized_name is not None:
            result['CompanyLocalizedName'] = self.company_localized_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.pminfo is not None:
            result['PMInfo'] = self.pminfo.to_map()
        if self.line_type is not None:
            result['LineType'] = self.line_type
        if self.company_name is not None:
            result['CompanyName'] = self.company_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LineLabel') is not None:
            self.line_label = m.get('LineLabel')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('ConstructionTime') is not None:
            self.construction_time = m.get('ConstructionTime')
        if m.get('SI') is not None:
            self.si = m.get('SI')
        if m.get('LoaUrl') is not None:
            self.loa_url = m.get('LoaUrl')
        if m.get('CompanyLocalizedName') is not None:
            self.company_localized_name = m.get('CompanyLocalizedName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PMInfo') is not None:
            temp_model = DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOATypePMInfo()
            self.pminfo = temp_model.from_map(m['PMInfo'])
        if m.get('LineType') is not None:
            self.line_type = m.get('LineType')
        if m.get('CompanyName') is not None:
            self.company_name = m.get('CompanyName')
        return self


class DescribePhysicalConnectionLOAResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        physical_connection_loatype: DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOAType = None,
    ):
        self.request_id = request_id
        self.physical_connection_loatype = physical_connection_loatype

    def validate(self):
        if self.physical_connection_loatype:
            self.physical_connection_loatype.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.physical_connection_loatype is not None:
            result['PhysicalConnectionLOAType'] = self.physical_connection_loatype.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PhysicalConnectionLOAType') is not None:
            temp_model = DescribePhysicalConnectionLOAResponseBodyPhysicalConnectionLOAType()
            self.physical_connection_loatype = temp_model.from_map(m['PhysicalConnectionLOAType'])
        return self


class DescribePhysicalConnectionLOAResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePhysicalConnectionLOAResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePhysicalConnectionLOAResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(
        self,
        product_type: str = None,
        accept_language: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.product_type = product_type
        self.accept_language = accept_language
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeRegionsResponseBodyRegionsRegion(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        region_endpoint: str = None,
        region_id: str = None,
    ):
        self.local_name = local_name
        self.region_endpoint = region_endpoint
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_endpoint is not None:
            result['RegionEndpoint'] = self.region_endpoint
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionEndpoint') is not None:
            self.region_endpoint = m.get('RegionEndpoint')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        region: List[DescribeRegionsResponseBodyRegionsRegion] = None,
    ):
        self.region = region

    def validate(self):
        if self.region:
            for k in self.region:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Region'] = []
        if self.region is not None:
            for k in self.region:
                result['Region'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.region = []
        if m.get('Region') is not None:
            for k in m.get('Region'):
                temp_model = DescribeRegionsResponseBodyRegionsRegion()
                self.region.append(temp_model.from_map(k))
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        regions: DescribeRegionsResponseBodyRegions = None,
    ):
        self.request_id = request_id
        self.regions = regions

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Regions') is not None:
            temp_model = DescribeRegionsResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRegionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouteEntryListRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        route_table_id: str = None,
        route_entry_id: str = None,
        destination_cidr_block: str = None,
        route_entry_name: str = None,
        ip_version: str = None,
        route_entry_type: str = None,
        next_hop_id: str = None,
        next_hop_type: str = None,
        max_result: int = None,
        next_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.route_table_id = route_table_id
        self.route_entry_id = route_entry_id
        self.destination_cidr_block = destination_cidr_block
        self.route_entry_name = route_entry_name
        self.ip_version = ip_version
        self.route_entry_type = route_entry_type
        self.next_hop_id = next_hop_id
        self.next_hop_type = next_hop_type
        self.max_result = max_result
        self.next_token = next_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.route_entry_name is not None:
            result['RouteEntryName'] = self.route_entry_name
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.route_entry_type is not None:
            result['RouteEntryType'] = self.route_entry_type
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.max_result is not None:
            result['MaxResult'] = self.max_result
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('RouteEntryName') is not None:
            self.route_entry_name = m.get('RouteEntryName')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('RouteEntryType') is not None:
            self.route_entry_type = m.get('RouteEntryType')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('MaxResult') is not None:
            self.max_result = m.get('MaxResult')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHopsNextHopNextHopRelatedInfo(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        instance_type: str = None,
        region_id: str = None,
    ):
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHopsNextHop(TeaModel):
    def __init__(
        self,
        weight: int = None,
        next_hop_id: str = None,
        enabled: int = None,
        next_hop_type: str = None,
        next_hop_related_info: DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHopsNextHopNextHopRelatedInfo = None,
        next_hop_region_id: str = None,
    ):
        self.weight = weight
        self.next_hop_id = next_hop_id
        self.enabled = enabled
        self.next_hop_type = next_hop_type
        self.next_hop_related_info = next_hop_related_info
        self.next_hop_region_id = next_hop_region_id

    def validate(self):
        if self.next_hop_related_info:
            self.next_hop_related_info.validate()

    def to_map(self):
        result = dict()
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.next_hop_related_info is not None:
            result['NextHopRelatedInfo'] = self.next_hop_related_info.to_map()
        if self.next_hop_region_id is not None:
            result['NextHopRegionId'] = self.next_hop_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('NextHopRelatedInfo') is not None:
            temp_model = DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHopsNextHopNextHopRelatedInfo()
            self.next_hop_related_info = temp_model.from_map(m['NextHopRelatedInfo'])
        if m.get('NextHopRegionId') is not None:
            self.next_hop_region_id = m.get('NextHopRegionId')
        return self


class DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHops(TeaModel):
    def __init__(
        self,
        next_hop: List[DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHopsNextHop] = None,
    ):
        self.next_hop = next_hop

    def validate(self):
        if self.next_hop:
            for k in self.next_hop:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['NextHop'] = []
        if self.next_hop is not None:
            for k in self.next_hop:
                result['NextHop'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.next_hop = []
        if m.get('NextHop') is not None:
            for k in m.get('NextHop'):
                temp_model = DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHopsNextHop()
                self.next_hop.append(temp_model.from_map(k))
        return self


class DescribeRouteEntryListResponseBodyRouteEntrysRouteEntry(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        ip_version: str = None,
        description: str = None,
        route_entry_name: str = None,
        destination_cidr_block: str = None,
        route_entry_id: str = None,
        next_hops: DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHops = None,
        route_table_id: str = None,
    ):
        self.status = status
        self.type = type
        self.ip_version = ip_version
        self.description = description
        self.route_entry_name = route_entry_name
        self.destination_cidr_block = destination_cidr_block
        self.route_entry_id = route_entry_id
        self.next_hops = next_hops
        self.route_table_id = route_table_id

    def validate(self):
        if self.next_hops:
            self.next_hops.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.description is not None:
            result['Description'] = self.description
        if self.route_entry_name is not None:
            result['RouteEntryName'] = self.route_entry_name
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        if self.next_hops is not None:
            result['NextHops'] = self.next_hops.to_map()
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RouteEntryName') is not None:
            self.route_entry_name = m.get('RouteEntryName')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        if m.get('NextHops') is not None:
            temp_model = DescribeRouteEntryListResponseBodyRouteEntrysRouteEntryNextHops()
            self.next_hops = temp_model.from_map(m['NextHops'])
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class DescribeRouteEntryListResponseBodyRouteEntrys(TeaModel):
    def __init__(
        self,
        route_entry: List[DescribeRouteEntryListResponseBodyRouteEntrysRouteEntry] = None,
    ):
        self.route_entry = route_entry

    def validate(self):
        if self.route_entry:
            for k in self.route_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RouteEntry'] = []
        if self.route_entry is not None:
            for k in self.route_entry:
                result['RouteEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.route_entry = []
        if m.get('RouteEntry') is not None:
            for k in m.get('RouteEntry'):
                temp_model = DescribeRouteEntryListResponseBodyRouteEntrysRouteEntry()
                self.route_entry.append(temp_model.from_map(k))
        return self


class DescribeRouteEntryListResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        route_entrys: DescribeRouteEntryListResponseBodyRouteEntrys = None,
    ):
        self.next_token = next_token
        self.request_id = request_id
        self.route_entrys = route_entrys

    def validate(self):
        if self.route_entrys:
            self.route_entrys.validate()

    def to_map(self):
        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_entrys is not None:
            result['RouteEntrys'] = self.route_entrys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteEntrys') is not None:
            temp_model = DescribeRouteEntryListResponseBodyRouteEntrys()
            self.route_entrys = temp_model.from_map(m['RouteEntrys'])
        return self


class DescribeRouteEntryListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRouteEntryListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRouteEntryListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouterInterfaceAttributeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        instance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeRouterInterfaceAttributeResponseBody(TeaModel):
    def __init__(
        self,
        opposite_interface_id: str = None,
        opposite_interface_status: str = None,
        description: str = None,
        opposite_router_id: str = None,
        message: str = None,
        end_time: str = None,
        gmt_modified: str = None,
        router_id: str = None,
        business_status: str = None,
        success: bool = None,
        name: str = None,
        reservation_order_type: str = None,
        opposite_router_type: str = None,
        opposite_bandwidth: int = None,
        bandwidth: int = None,
        connected_time: str = None,
        reservation_active_time: str = None,
        hc_threshold: int = None,
        reservation_bandwidth: str = None,
        status: str = None,
        opposite_interface_owner_id: str = None,
        request_id: str = None,
        opposite_region_id: str = None,
        health_check_source_ip: str = None,
        has_reservation_data: str = None,
        cross_border: bool = None,
        hc_rate: int = None,
        code: str = None,
        reservation_internet_charge_type: str = None,
        opposite_interface_spec: str = None,
        role: str = None,
        opposite_vpc_instance_id: str = None,
        router_type: str = None,
        charge_type: str = None,
        creation_time: str = None,
        access_point_id: str = None,
        vpc_instance_id: str = None,
        opposite_interface_business_status: str = None,
        opposite_access_point_id: str = None,
        spec: str = None,
        health_check_status: str = None,
        health_check_target_ip: str = None,
        router_interface_id: str = None,
    ):
        self.opposite_interface_id = opposite_interface_id
        self.opposite_interface_status = opposite_interface_status
        self.description = description
        self.opposite_router_id = opposite_router_id
        self.message = message
        self.end_time = end_time
        self.gmt_modified = gmt_modified
        self.router_id = router_id
        self.business_status = business_status
        self.success = success
        self.name = name
        self.reservation_order_type = reservation_order_type
        self.opposite_router_type = opposite_router_type
        self.opposite_bandwidth = opposite_bandwidth
        self.bandwidth = bandwidth
        self.connected_time = connected_time
        self.reservation_active_time = reservation_active_time
        self.hc_threshold = hc_threshold
        self.reservation_bandwidth = reservation_bandwidth
        self.status = status
        self.opposite_interface_owner_id = opposite_interface_owner_id
        self.request_id = request_id
        self.opposite_region_id = opposite_region_id
        self.health_check_source_ip = health_check_source_ip
        self.has_reservation_data = has_reservation_data
        self.cross_border = cross_border
        self.hc_rate = hc_rate
        self.code = code
        self.reservation_internet_charge_type = reservation_internet_charge_type
        self.opposite_interface_spec = opposite_interface_spec
        self.role = role
        self.opposite_vpc_instance_id = opposite_vpc_instance_id
        self.router_type = router_type
        self.charge_type = charge_type
        self.creation_time = creation_time
        self.access_point_id = access_point_id
        self.vpc_instance_id = vpc_instance_id
        self.opposite_interface_business_status = opposite_interface_business_status
        self.opposite_access_point_id = opposite_access_point_id
        self.spec = spec
        self.health_check_status = health_check_status
        self.health_check_target_ip = health_check_target_ip
        self.router_interface_id = router_interface_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.opposite_interface_id is not None:
            result['OppositeInterfaceId'] = self.opposite_interface_id
        if self.opposite_interface_status is not None:
            result['OppositeInterfaceStatus'] = self.opposite_interface_status
        if self.description is not None:
            result['Description'] = self.description
        if self.opposite_router_id is not None:
            result['OppositeRouterId'] = self.opposite_router_id
        if self.message is not None:
            result['Message'] = self.message
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.success is not None:
            result['Success'] = self.success
        if self.name is not None:
            result['Name'] = self.name
        if self.reservation_order_type is not None:
            result['ReservationOrderType'] = self.reservation_order_type
        if self.opposite_router_type is not None:
            result['OppositeRouterType'] = self.opposite_router_type
        if self.opposite_bandwidth is not None:
            result['OppositeBandwidth'] = self.opposite_bandwidth
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.connected_time is not None:
            result['ConnectedTime'] = self.connected_time
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.hc_threshold is not None:
            result['HcThreshold'] = self.hc_threshold
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.status is not None:
            result['Status'] = self.status
        if self.opposite_interface_owner_id is not None:
            result['OppositeInterfaceOwnerId'] = self.opposite_interface_owner_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.opposite_region_id is not None:
            result['OppositeRegionId'] = self.opposite_region_id
        if self.health_check_source_ip is not None:
            result['HealthCheckSourceIp'] = self.health_check_source_ip
        if self.has_reservation_data is not None:
            result['HasReservationData'] = self.has_reservation_data
        if self.cross_border is not None:
            result['CrossBorder'] = self.cross_border
        if self.hc_rate is not None:
            result['HcRate'] = self.hc_rate
        if self.code is not None:
            result['Code'] = self.code
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        if self.opposite_interface_spec is not None:
            result['OppositeInterfaceSpec'] = self.opposite_interface_spec
        if self.role is not None:
            result['Role'] = self.role
        if self.opposite_vpc_instance_id is not None:
            result['OppositeVpcInstanceId'] = self.opposite_vpc_instance_id
        if self.router_type is not None:
            result['RouterType'] = self.router_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.opposite_interface_business_status is not None:
            result['OppositeInterfaceBusinessStatus'] = self.opposite_interface_business_status
        if self.opposite_access_point_id is not None:
            result['OppositeAccessPointId'] = self.opposite_access_point_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.health_check_status is not None:
            result['HealthCheckStatus'] = self.health_check_status
        if self.health_check_target_ip is not None:
            result['HealthCheckTargetIp'] = self.health_check_target_ip
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OppositeInterfaceId') is not None:
            self.opposite_interface_id = m.get('OppositeInterfaceId')
        if m.get('OppositeInterfaceStatus') is not None:
            self.opposite_interface_status = m.get('OppositeInterfaceStatus')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OppositeRouterId') is not None:
            self.opposite_router_id = m.get('OppositeRouterId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReservationOrderType') is not None:
            self.reservation_order_type = m.get('ReservationOrderType')
        if m.get('OppositeRouterType') is not None:
            self.opposite_router_type = m.get('OppositeRouterType')
        if m.get('OppositeBandwidth') is not None:
            self.opposite_bandwidth = m.get('OppositeBandwidth')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ConnectedTime') is not None:
            self.connected_time = m.get('ConnectedTime')
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('HcThreshold') is not None:
            self.hc_threshold = m.get('HcThreshold')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('OppositeInterfaceOwnerId') is not None:
            self.opposite_interface_owner_id = m.get('OppositeInterfaceOwnerId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OppositeRegionId') is not None:
            self.opposite_region_id = m.get('OppositeRegionId')
        if m.get('HealthCheckSourceIp') is not None:
            self.health_check_source_ip = m.get('HealthCheckSourceIp')
        if m.get('HasReservationData') is not None:
            self.has_reservation_data = m.get('HasReservationData')
        if m.get('CrossBorder') is not None:
            self.cross_border = m.get('CrossBorder')
        if m.get('HcRate') is not None:
            self.hc_rate = m.get('HcRate')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        if m.get('OppositeInterfaceSpec') is not None:
            self.opposite_interface_spec = m.get('OppositeInterfaceSpec')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('OppositeVpcInstanceId') is not None:
            self.opposite_vpc_instance_id = m.get('OppositeVpcInstanceId')
        if m.get('RouterType') is not None:
            self.router_type = m.get('RouterType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('OppositeInterfaceBusinessStatus') is not None:
            self.opposite_interface_business_status = m.get('OppositeInterfaceBusinessStatus')
        if m.get('OppositeAccessPointId') is not None:
            self.opposite_access_point_id = m.get('OppositeAccessPointId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('HealthCheckStatus') is not None:
            self.health_check_status = m.get('HealthCheckStatus')
        if m.get('HealthCheckTargetIp') is not None:
            self.health_check_target_ip = m.get('HealthCheckTargetIp')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class DescribeRouterInterfaceAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRouterInterfaceAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRouterInterfaceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouterInterfacesRequestFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeRouterInterfacesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        include_reservation_data: bool = None,
        page_number: int = None,
        page_size: int = None,
        filter: List[DescribeRouterInterfacesRequestFilter] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.include_reservation_data = include_reservation_data
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.include_reservation_data is not None:
            result['IncludeReservationData'] = self.include_reservation_data
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IncludeReservationData') is not None:
            self.include_reservation_data = m.get('IncludeReservationData')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeRouterInterfacesRequestFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeRouterInterfacesResponseBodyRouterInterfaceSetRouterInterfaceType(TeaModel):
    def __init__(
        self,
        reservation_active_time: str = None,
        health_check_target_ip: str = None,
        status: str = None,
        creation_time: str = None,
        reservation_order_type: str = None,
        opposite_interface_id: str = None,
        spec: str = None,
        charge_type: str = None,
        router_interface_id: str = None,
        hc_threshold: int = None,
        opposite_router_type: str = None,
        opposite_interface_owner_id: str = None,
        vpc_instance_id: str = None,
        opposite_vpc_instance_id: str = None,
        reservation_internet_charge_type: str = None,
        cross_border: bool = None,
        description: str = None,
        bandwidth: int = None,
        reservation_bandwidth: str = None,
        hc_rate: int = None,
        name: str = None,
        opposite_router_id: str = None,
        opposite_interface_spec: str = None,
        router_id: str = None,
        opposite_interface_business_status: str = None,
        connected_time: str = None,
        health_check_source_ip: str = None,
        opposite_interface_status: str = None,
        end_time: str = None,
        opposite_region_id: str = None,
        opposite_access_point_id: str = None,
        business_status: str = None,
        opposite_bandwidth: int = None,
        router_type: str = None,
        role: str = None,
        has_reservation_data: str = None,
        access_point_id: str = None,
    ):
        self.reservation_active_time = reservation_active_time
        self.health_check_target_ip = health_check_target_ip
        self.status = status
        self.creation_time = creation_time
        self.reservation_order_type = reservation_order_type
        self.opposite_interface_id = opposite_interface_id
        self.spec = spec
        self.charge_type = charge_type
        self.router_interface_id = router_interface_id
        self.hc_threshold = hc_threshold
        self.opposite_router_type = opposite_router_type
        self.opposite_interface_owner_id = opposite_interface_owner_id
        self.vpc_instance_id = vpc_instance_id
        self.opposite_vpc_instance_id = opposite_vpc_instance_id
        self.reservation_internet_charge_type = reservation_internet_charge_type
        self.cross_border = cross_border
        self.description = description
        self.bandwidth = bandwidth
        self.reservation_bandwidth = reservation_bandwidth
        self.hc_rate = hc_rate
        self.name = name
        self.opposite_router_id = opposite_router_id
        self.opposite_interface_spec = opposite_interface_spec
        self.router_id = router_id
        self.opposite_interface_business_status = opposite_interface_business_status
        self.connected_time = connected_time
        self.health_check_source_ip = health_check_source_ip
        self.opposite_interface_status = opposite_interface_status
        self.end_time = end_time
        self.opposite_region_id = opposite_region_id
        self.opposite_access_point_id = opposite_access_point_id
        self.business_status = business_status
        self.opposite_bandwidth = opposite_bandwidth
        self.router_type = router_type
        self.role = role
        self.has_reservation_data = has_reservation_data
        self.access_point_id = access_point_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.health_check_target_ip is not None:
            result['HealthCheckTargetIp'] = self.health_check_target_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.reservation_order_type is not None:
            result['ReservationOrderType'] = self.reservation_order_type
        if self.opposite_interface_id is not None:
            result['OppositeInterfaceId'] = self.opposite_interface_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        if self.hc_threshold is not None:
            result['HcThreshold'] = self.hc_threshold
        if self.opposite_router_type is not None:
            result['OppositeRouterType'] = self.opposite_router_type
        if self.opposite_interface_owner_id is not None:
            result['OppositeInterfaceOwnerId'] = self.opposite_interface_owner_id
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.opposite_vpc_instance_id is not None:
            result['OppositeVpcInstanceId'] = self.opposite_vpc_instance_id
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        if self.cross_border is not None:
            result['CrossBorder'] = self.cross_border
        if self.description is not None:
            result['Description'] = self.description
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.hc_rate is not None:
            result['HcRate'] = self.hc_rate
        if self.name is not None:
            result['Name'] = self.name
        if self.opposite_router_id is not None:
            result['OppositeRouterId'] = self.opposite_router_id
        if self.opposite_interface_spec is not None:
            result['OppositeInterfaceSpec'] = self.opposite_interface_spec
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.opposite_interface_business_status is not None:
            result['OppositeInterfaceBusinessStatus'] = self.opposite_interface_business_status
        if self.connected_time is not None:
            result['ConnectedTime'] = self.connected_time
        if self.health_check_source_ip is not None:
            result['HealthCheckSourceIp'] = self.health_check_source_ip
        if self.opposite_interface_status is not None:
            result['OppositeInterfaceStatus'] = self.opposite_interface_status
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.opposite_region_id is not None:
            result['OppositeRegionId'] = self.opposite_region_id
        if self.opposite_access_point_id is not None:
            result['OppositeAccessPointId'] = self.opposite_access_point_id
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.opposite_bandwidth is not None:
            result['OppositeBandwidth'] = self.opposite_bandwidth
        if self.router_type is not None:
            result['RouterType'] = self.router_type
        if self.role is not None:
            result['Role'] = self.role
        if self.has_reservation_data is not None:
            result['HasReservationData'] = self.has_reservation_data
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('HealthCheckTargetIp') is not None:
            self.health_check_target_ip = m.get('HealthCheckTargetIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ReservationOrderType') is not None:
            self.reservation_order_type = m.get('ReservationOrderType')
        if m.get('OppositeInterfaceId') is not None:
            self.opposite_interface_id = m.get('OppositeInterfaceId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        if m.get('HcThreshold') is not None:
            self.hc_threshold = m.get('HcThreshold')
        if m.get('OppositeRouterType') is not None:
            self.opposite_router_type = m.get('OppositeRouterType')
        if m.get('OppositeInterfaceOwnerId') is not None:
            self.opposite_interface_owner_id = m.get('OppositeInterfaceOwnerId')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('OppositeVpcInstanceId') is not None:
            self.opposite_vpc_instance_id = m.get('OppositeVpcInstanceId')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        if m.get('CrossBorder') is not None:
            self.cross_border = m.get('CrossBorder')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('HcRate') is not None:
            self.hc_rate = m.get('HcRate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OppositeRouterId') is not None:
            self.opposite_router_id = m.get('OppositeRouterId')
        if m.get('OppositeInterfaceSpec') is not None:
            self.opposite_interface_spec = m.get('OppositeInterfaceSpec')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('OppositeInterfaceBusinessStatus') is not None:
            self.opposite_interface_business_status = m.get('OppositeInterfaceBusinessStatus')
        if m.get('ConnectedTime') is not None:
            self.connected_time = m.get('ConnectedTime')
        if m.get('HealthCheckSourceIp') is not None:
            self.health_check_source_ip = m.get('HealthCheckSourceIp')
        if m.get('OppositeInterfaceStatus') is not None:
            self.opposite_interface_status = m.get('OppositeInterfaceStatus')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OppositeRegionId') is not None:
            self.opposite_region_id = m.get('OppositeRegionId')
        if m.get('OppositeAccessPointId') is not None:
            self.opposite_access_point_id = m.get('OppositeAccessPointId')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('OppositeBandwidth') is not None:
            self.opposite_bandwidth = m.get('OppositeBandwidth')
        if m.get('RouterType') is not None:
            self.router_type = m.get('RouterType')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('HasReservationData') is not None:
            self.has_reservation_data = m.get('HasReservationData')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        return self


class DescribeRouterInterfacesResponseBodyRouterInterfaceSet(TeaModel):
    def __init__(
        self,
        router_interface_type: List[DescribeRouterInterfacesResponseBodyRouterInterfaceSetRouterInterfaceType] = None,
    ):
        self.router_interface_type = router_interface_type

    def validate(self):
        if self.router_interface_type:
            for k in self.router_interface_type:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RouterInterfaceType'] = []
        if self.router_interface_type is not None:
            for k in self.router_interface_type:
                result['RouterInterfaceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.router_interface_type = []
        if m.get('RouterInterfaceType') is not None:
            for k in m.get('RouterInterfaceType'):
                temp_model = DescribeRouterInterfacesResponseBodyRouterInterfaceSetRouterInterfaceType()
                self.router_interface_type.append(temp_model.from_map(k))
        return self


class DescribeRouterInterfacesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        router_interface_set: DescribeRouterInterfacesResponseBodyRouterInterfaceSet = None,
    ):
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.router_interface_set = router_interface_set

    def validate(self):
        if self.router_interface_set:
            self.router_interface_set.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.router_interface_set is not None:
            result['RouterInterfaceSet'] = self.router_interface_set.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RouterInterfaceSet') is not None:
            temp_model = DescribeRouterInterfacesResponseBodyRouterInterfaceSet()
            self.router_interface_set = temp_model.from_map(m['RouterInterfaceSet'])
        return self


class DescribeRouterInterfacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRouterInterfacesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRouterInterfacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouteTableListRequestTag(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeRouteTableListRequest(TeaModel):
    def __init__(
        self,
        router_type: str = None,
        router_id: str = None,
        vpc_id: str = None,
        route_table_id: str = None,
        route_table_name: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_group_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        tag: List[DescribeRouteTableListRequestTag] = None,
    ):
        self.router_type = router_type
        self.router_id = router_id
        self.vpc_id = vpc_id
        self.route_table_id = route_table_id
        self.route_table_name = route_table_name
        self.page_number = page_number
        self.page_size = page_size
        self.resource_group_id = resource_group_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.router_type is not None:
            result['RouterType'] = self.router_type
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.route_table_name is not None:
            result['RouteTableName'] = self.route_table_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RouterType') is not None:
            self.router_type = m.get('RouterType')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('RouteTableName') is not None:
            self.route_table_name = m.get('RouteTableName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeRouteTableListRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeVSwitchIds(TeaModel):
    def __init__(
        self,
        v_switch_id: List[str] = None,
    ):
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeRouteTableListResponseBodyRouterTableListRouterTableListType(TeaModel):
    def __init__(
        self,
        status: str = None,
        creation_time: str = None,
        vpc_id: str = None,
        router_id: str = None,
        tags: DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeTags = None,
        route_table_id: str = None,
        owner_id: int = None,
        description: str = None,
        resource_group_id: str = None,
        route_table_type: str = None,
        v_switch_ids: DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeVSwitchIds = None,
        router_type: str = None,
        route_table_name: str = None,
    ):
        self.status = status
        self.creation_time = creation_time
        self.vpc_id = vpc_id
        self.router_id = router_id
        self.tags = tags
        self.route_table_id = route_table_id
        self.owner_id = owner_id
        self.description = description
        self.resource_group_id = resource_group_id
        self.route_table_type = route_table_type
        self.v_switch_ids = v_switch_ids
        self.router_type = router_type
        self.route_table_name = route_table_name

    def validate(self):
        if self.tags:
            self.tags.validate()
        if self.v_switch_ids:
            self.v_switch_ids.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.route_table_type is not None:
            result['RouteTableType'] = self.route_table_type
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids.to_map()
        if self.router_type is not None:
            result['RouterType'] = self.router_type
        if self.route_table_name is not None:
            result['RouteTableName'] = self.route_table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('Tags') is not None:
            temp_model = DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RouteTableType') is not None:
            self.route_table_type = m.get('RouteTableType')
        if m.get('VSwitchIds') is not None:
            temp_model = DescribeRouteTableListResponseBodyRouterTableListRouterTableListTypeVSwitchIds()
            self.v_switch_ids = temp_model.from_map(m['VSwitchIds'])
        if m.get('RouterType') is not None:
            self.router_type = m.get('RouterType')
        if m.get('RouteTableName') is not None:
            self.route_table_name = m.get('RouteTableName')
        return self


class DescribeRouteTableListResponseBodyRouterTableList(TeaModel):
    def __init__(
        self,
        router_table_list_type: List[DescribeRouteTableListResponseBodyRouterTableListRouterTableListType] = None,
    ):
        self.router_table_list_type = router_table_list_type

    def validate(self):
        if self.router_table_list_type:
            for k in self.router_table_list_type:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RouterTableListType'] = []
        if self.router_table_list_type is not None:
            for k in self.router_table_list_type:
                result['RouterTableListType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.router_table_list_type = []
        if m.get('RouterTableListType') is not None:
            for k in m.get('RouterTableListType'):
                temp_model = DescribeRouteTableListResponseBodyRouterTableListRouterTableListType()
                self.router_table_list_type.append(temp_model.from_map(k))
        return self


class DescribeRouteTableListResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        router_table_list: DescribeRouteTableListResponseBodyRouterTableList = None,
    ):
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.router_table_list = router_table_list

    def validate(self):
        if self.router_table_list:
            self.router_table_list.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.router_table_list is not None:
            result['RouterTableList'] = self.router_table_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RouterTableList') is not None:
            temp_model = DescribeRouteTableListResponseBodyRouterTableList()
            self.router_table_list = temp_model.from_map(m['RouterTableList'])
        return self


class DescribeRouteTableListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRouteTableListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRouteTableListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouteTablesRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        vrouter_id: str = None,
        route_table_id: str = None,
        router_type: str = None,
        router_id: str = None,
        type: str = None,
        route_table_name: str = None,
        resource_group_id: str = None,
        page_number: int = None,
        page_size: int = None,
        owner_account: str = None,
    ):
        self.region_id = region_id
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.vrouter_id = vrouter_id
        self.route_table_id = route_table_id
        self.router_type = router_type
        self.router_id = router_id
        self.type = type
        self.route_table_name = route_table_name
        self.resource_group_id = resource_group_id
        self.page_number = page_number
        self.page_size = page_size
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vrouter_id is not None:
            result['VRouterId'] = self.vrouter_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.router_type is not None:
            result['RouterType'] = self.router_type
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.type is not None:
            result['Type'] = self.type
        if self.route_table_name is not None:
            result['RouteTableName'] = self.route_table_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VRouterId') is not None:
            self.vrouter_id = m.get('VRouterId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('RouterType') is not None:
            self.router_type = m.get('RouterType')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('RouteTableName') is not None:
            self.route_table_name = m.get('RouteTableName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntryNextHopsNextHop(TeaModel):
    def __init__(
        self,
        next_hop_id: str = None,
        weight: int = None,
        next_hop_type: str = None,
        enabled: int = None,
    ):
        self.next_hop_id = next_hop_id
        self.weight = weight
        self.next_hop_type = next_hop_type
        self.enabled = enabled

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        return self


class DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntryNextHops(TeaModel):
    def __init__(
        self,
        next_hop: List[DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntryNextHopsNextHop] = None,
    ):
        self.next_hop = next_hop

    def validate(self):
        if self.next_hop:
            for k in self.next_hop:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['NextHop'] = []
        if self.next_hop is not None:
            for k in self.next_hop:
                result['NextHop'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.next_hop = []
        if m.get('NextHop') is not None:
            for k in m.get('NextHop'):
                temp_model = DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntryNextHopsNextHop()
                self.next_hop.append(temp_model.from_map(k))
        return self


class DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntry(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        next_hop_type: str = None,
        route_entry_name: str = None,
        route_entry_id: str = None,
        instance_id: str = None,
        route_table_id: str = None,
        description: str = None,
        destination_cidr_block: str = None,
        next_hops: DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntryNextHops = None,
    ):
        self.status = status
        self.type = type
        self.next_hop_type = next_hop_type
        self.route_entry_name = route_entry_name
        self.route_entry_id = route_entry_id
        self.instance_id = instance_id
        self.route_table_id = route_table_id
        self.description = description
        self.destination_cidr_block = destination_cidr_block
        self.next_hops = next_hops

    def validate(self):
        if self.next_hops:
            self.next_hops.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.route_entry_name is not None:
            result['RouteEntryName'] = self.route_entry_name
        if self.route_entry_id is not None:
            result['RouteEntryId'] = self.route_entry_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hops is not None:
            result['NextHops'] = self.next_hops.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('RouteEntryName') is not None:
            self.route_entry_name = m.get('RouteEntryName')
        if m.get('RouteEntryId') is not None:
            self.route_entry_id = m.get('RouteEntryId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHops') is not None:
            temp_model = DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntryNextHops()
            self.next_hops = temp_model.from_map(m['NextHops'])
        return self


class DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrys(TeaModel):
    def __init__(
        self,
        route_entry: List[DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntry] = None,
    ):
        self.route_entry = route_entry

    def validate(self):
        if self.route_entry:
            for k in self.route_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RouteEntry'] = []
        if self.route_entry is not None:
            for k in self.route_entry:
                result['RouteEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.route_entry = []
        if m.get('RouteEntry') is not None:
            for k in m.get('RouteEntry'):
                temp_model = DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrysRouteEntry()
                self.route_entry.append(temp_model.from_map(k))
        return self


class DescribeRouteTablesResponseBodyRouteTablesRouteTableVSwitchIds(TeaModel):
    def __init__(
        self,
        v_switch_id: List[str] = None,
    ):
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeRouteTablesResponseBodyRouteTablesRouteTable(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        status: str = None,
        vrouter_id: str = None,
        route_entrys: DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrys = None,
        route_table_type: str = None,
        resource_group_id: str = None,
        v_switch_ids: DescribeRouteTablesResponseBodyRouteTablesRouteTableVSwitchIds = None,
        route_table_id: str = None,
    ):
        self.creation_time = creation_time
        self.status = status
        self.vrouter_id = vrouter_id
        self.route_entrys = route_entrys
        self.route_table_type = route_table_type
        self.resource_group_id = resource_group_id
        self.v_switch_ids = v_switch_ids
        self.route_table_id = route_table_id

    def validate(self):
        if self.route_entrys:
            self.route_entrys.validate()
        if self.v_switch_ids:
            self.v_switch_ids.validate()

    def to_map(self):
        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.vrouter_id is not None:
            result['VRouterId'] = self.vrouter_id
        if self.route_entrys is not None:
            result['RouteEntrys'] = self.route_entrys.to_map()
        if self.route_table_type is not None:
            result['RouteTableType'] = self.route_table_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids.to_map()
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VRouterId') is not None:
            self.vrouter_id = m.get('VRouterId')
        if m.get('RouteEntrys') is not None:
            temp_model = DescribeRouteTablesResponseBodyRouteTablesRouteTableRouteEntrys()
            self.route_entrys = temp_model.from_map(m['RouteEntrys'])
        if m.get('RouteTableType') is not None:
            self.route_table_type = m.get('RouteTableType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('VSwitchIds') is not None:
            temp_model = DescribeRouteTablesResponseBodyRouteTablesRouteTableVSwitchIds()
            self.v_switch_ids = temp_model.from_map(m['VSwitchIds'])
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class DescribeRouteTablesResponseBodyRouteTables(TeaModel):
    def __init__(
        self,
        route_table: List[DescribeRouteTablesResponseBodyRouteTablesRouteTable] = None,
    ):
        self.route_table = route_table

    def validate(self):
        if self.route_table:
            for k in self.route_table:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RouteTable'] = []
        if self.route_table is not None:
            for k in self.route_table:
                result['RouteTable'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.route_table = []
        if m.get('RouteTable') is not None:
            for k in m.get('RouteTable'):
                temp_model = DescribeRouteTablesResponseBodyRouteTablesRouteTable()
                self.route_table.append(temp_model.from_map(k))
        return self


class DescribeRouteTablesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        route_tables: DescribeRouteTablesResponseBodyRouteTables = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.route_tables = route_tables

    def validate(self):
        if self.route_tables:
            self.route_tables.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.route_tables is not None:
            result['RouteTables'] = self.route_tables.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RouteTables') is not None:
            temp_model = DescribeRouteTablesResponseBodyRouteTables()
            self.route_tables = temp_model.from_map(m['RouteTables'])
        return self


class DescribeRouteTablesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRouteTablesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRouteTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeServerRelatedGlobalAccelerationInstancesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        server_id: str = None,
        server_type: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.server_id = server_id
        self.server_type = server_type
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_type is not None:
            result['ServerType'] = self.server_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerType') is not None:
            self.server_type = m.get('ServerType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeServerRelatedGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstance(TeaModel):
    def __init__(
        self,
        server_ip_address: str = None,
        ip_address: str = None,
        global_acceleration_instance_id: str = None,
        region_id: str = None,
    ):
        self.server_ip_address = server_ip_address
        self.ip_address = ip_address
        self.global_acceleration_instance_id = global_acceleration_instance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.server_ip_address is not None:
            result['ServerIpAddress'] = self.server_ip_address
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.global_acceleration_instance_id is not None:
            result['GlobalAccelerationInstanceId'] = self.global_acceleration_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServerIpAddress') is not None:
            self.server_ip_address = m.get('ServerIpAddress')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('GlobalAccelerationInstanceId') is not None:
            self.global_acceleration_instance_id = m.get('GlobalAccelerationInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeServerRelatedGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstances(TeaModel):
    def __init__(
        self,
        global_acceleration_instance: List[DescribeServerRelatedGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstance] = None,
    ):
        self.global_acceleration_instance = global_acceleration_instance

    def validate(self):
        if self.global_acceleration_instance:
            for k in self.global_acceleration_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GlobalAccelerationInstance'] = []
        if self.global_acceleration_instance is not None:
            for k in self.global_acceleration_instance:
                result['GlobalAccelerationInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.global_acceleration_instance = []
        if m.get('GlobalAccelerationInstance') is not None:
            for k in m.get('GlobalAccelerationInstance'):
                temp_model = DescribeServerRelatedGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstancesGlobalAccelerationInstance()
                self.global_acceleration_instance.append(temp_model.from_map(k))
        return self


class DescribeServerRelatedGlobalAccelerationInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        global_acceleration_instances: DescribeServerRelatedGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstances = None,
    ):
        self.request_id = request_id
        self.global_acceleration_instances = global_acceleration_instances

    def validate(self):
        if self.global_acceleration_instances:
            self.global_acceleration_instances.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.global_acceleration_instances is not None:
            result['GlobalAccelerationInstances'] = self.global_acceleration_instances.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('GlobalAccelerationInstances') is not None:
            temp_model = DescribeServerRelatedGlobalAccelerationInstancesResponseBodyGlobalAccelerationInstances()
            self.global_acceleration_instances = temp_model.from_map(m['GlobalAccelerationInstances'])
        return self


class DescribeServerRelatedGlobalAccelerationInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeServerRelatedGlobalAccelerationInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeServerRelatedGlobalAccelerationInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSnatTableEntriesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        snat_table_id: str = None,
        snat_entry_id: str = None,
        source_vswitch_id: str = None,
        source_cidr: str = None,
        snat_ip: str = None,
        snat_entry_name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.snat_table_id = snat_table_id
        self.snat_entry_id = snat_entry_id
        self.source_vswitch_id = source_vswitch_id
        self.source_cidr = source_cidr
        self.snat_ip = snat_ip
        self.snat_entry_name = snat_entry_name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snat_table_id is not None:
            result['SnatTableId'] = self.snat_table_id
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        if self.source_vswitch_id is not None:
            result['SourceVSwitchId'] = self.source_vswitch_id
        if self.source_cidr is not None:
            result['SourceCIDR'] = self.source_cidr
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        if self.snat_entry_name is not None:
            result['SnatEntryName'] = self.snat_entry_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnatTableId') is not None:
            self.snat_table_id = m.get('SnatTableId')
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        if m.get('SourceVSwitchId') is not None:
            self.source_vswitch_id = m.get('SourceVSwitchId')
        if m.get('SourceCIDR') is not None:
            self.source_cidr = m.get('SourceCIDR')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        if m.get('SnatEntryName') is not None:
            self.snat_entry_name = m.get('SnatEntryName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeSnatTableEntriesResponseBodySnatTableEntriesSnatTableEntry(TeaModel):
    def __init__(
        self,
        status: str = None,
        snat_entry_name: str = None,
        source_vswitch_id: str = None,
        source_cidr: str = None,
        snat_entry_id: str = None,
        snat_table_id: str = None,
        snat_ip: str = None,
    ):
        self.status = status
        self.snat_entry_name = snat_entry_name
        self.source_vswitch_id = source_vswitch_id
        self.source_cidr = source_cidr
        self.snat_entry_id = snat_entry_id
        self.snat_table_id = snat_table_id
        self.snat_ip = snat_ip

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.snat_entry_name is not None:
            result['SnatEntryName'] = self.snat_entry_name
        if self.source_vswitch_id is not None:
            result['SourceVSwitchId'] = self.source_vswitch_id
        if self.source_cidr is not None:
            result['SourceCIDR'] = self.source_cidr
        if self.snat_entry_id is not None:
            result['SnatEntryId'] = self.snat_entry_id
        if self.snat_table_id is not None:
            result['SnatTableId'] = self.snat_table_id
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SnatEntryName') is not None:
            self.snat_entry_name = m.get('SnatEntryName')
        if m.get('SourceVSwitchId') is not None:
            self.source_vswitch_id = m.get('SourceVSwitchId')
        if m.get('SourceCIDR') is not None:
            self.source_cidr = m.get('SourceCIDR')
        if m.get('SnatEntryId') is not None:
            self.snat_entry_id = m.get('SnatEntryId')
        if m.get('SnatTableId') is not None:
            self.snat_table_id = m.get('SnatTableId')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        return self


class DescribeSnatTableEntriesResponseBodySnatTableEntries(TeaModel):
    def __init__(
        self,
        snat_table_entry: List[DescribeSnatTableEntriesResponseBodySnatTableEntriesSnatTableEntry] = None,
    ):
        self.snat_table_entry = snat_table_entry

    def validate(self):
        if self.snat_table_entry:
            for k in self.snat_table_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SnatTableEntry'] = []
        if self.snat_table_entry is not None:
            for k in self.snat_table_entry:
                result['SnatTableEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.snat_table_entry = []
        if m.get('SnatTableEntry') is not None:
            for k in m.get('SnatTableEntry'):
                temp_model = DescribeSnatTableEntriesResponseBodySnatTableEntriesSnatTableEntry()
                self.snat_table_entry.append(temp_model.from_map(k))
        return self


class DescribeSnatTableEntriesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        snat_table_entries: DescribeSnatTableEntriesResponseBodySnatTableEntries = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.snat_table_entries = snat_table_entries

    def validate(self):
        if self.snat_table_entries:
            self.snat_table_entries.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.snat_table_entries is not None:
            result['SnatTableEntries'] = self.snat_table_entries.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('SnatTableEntries') is not None:
            temp_model = DescribeSnatTableEntriesResponseBodySnatTableEntries()
            self.snat_table_entries = temp_model.from_map(m['SnatTableEntries'])
        return self


class DescribeSnatTableEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSnatTableEntriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSnatTableEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSslVpnClientCertRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ssl_vpn_client_cert_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ssl_vpn_client_cert_id = ssl_vpn_client_cert_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ssl_vpn_client_cert_id is not None:
            result['SslVpnClientCertId'] = self.ssl_vpn_client_cert_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SslVpnClientCertId') is not None:
            self.ssl_vpn_client_cert_id = m.get('SslVpnClientCertId')
        return self


class DescribeSslVpnClientCertResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        client_cert: str = None,
        end_time: int = None,
        request_id: str = None,
        create_time: int = None,
        client_key: str = None,
        ssl_vpn_client_cert_id: str = None,
        ssl_vpn_server_id: str = None,
        ca_cert: str = None,
        region_id: str = None,
        client_config: str = None,
        name: str = None,
    ):
        self.status = status
        self.client_cert = client_cert
        self.end_time = end_time
        self.request_id = request_id
        self.create_time = create_time
        self.client_key = client_key
        self.ssl_vpn_client_cert_id = ssl_vpn_client_cert_id
        self.ssl_vpn_server_id = ssl_vpn_server_id
        self.ca_cert = ca_cert
        self.region_id = region_id
        self.client_config = client_config
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.client_cert is not None:
            result['ClientCert'] = self.client_cert
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.client_key is not None:
            result['ClientKey'] = self.client_key
        if self.ssl_vpn_client_cert_id is not None:
            result['SslVpnClientCertId'] = self.ssl_vpn_client_cert_id
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        if self.ca_cert is not None:
            result['CaCert'] = self.ca_cert
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_config is not None:
            result['ClientConfig'] = self.client_config
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClientCert') is not None:
            self.client_cert = m.get('ClientCert')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ClientKey') is not None:
            self.client_key = m.get('ClientKey')
        if m.get('SslVpnClientCertId') is not None:
            self.ssl_vpn_client_cert_id = m.get('SslVpnClientCertId')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        if m.get('CaCert') is not None:
            self.ca_cert = m.get('CaCert')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientConfig') is not None:
            self.client_config = m.get('ClientConfig')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeSslVpnClientCertResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSslVpnClientCertResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSslVpnClientCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSslVpnClientCertsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ssl_vpn_server_id: str = None,
        ssl_vpn_client_cert_id: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ssl_vpn_server_id = ssl_vpn_server_id
        self.ssl_vpn_client_cert_id = ssl_vpn_client_cert_id
        self.name = name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        if self.ssl_vpn_client_cert_id is not None:
            result['SslVpnClientCertId'] = self.ssl_vpn_client_cert_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        if m.get('SslVpnClientCertId') is not None:
            self.ssl_vpn_client_cert_id = m.get('SslVpnClientCertId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeSslVpnClientCertsResponseBodySslVpnClientCertKeysSslVpnClientCertKey(TeaModel):
    def __init__(
        self,
        status: str = None,
        end_time: int = None,
        create_time: int = None,
        ssl_vpn_client_cert_id: str = None,
        ssl_vpn_server_id: str = None,
        name: str = None,
        region_id: str = None,
    ):
        self.status = status
        self.end_time = end_time
        self.create_time = create_time
        self.ssl_vpn_client_cert_id = ssl_vpn_client_cert_id
        self.ssl_vpn_server_id = ssl_vpn_server_id
        self.name = name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.ssl_vpn_client_cert_id is not None:
            result['SslVpnClientCertId'] = self.ssl_vpn_client_cert_id
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('SslVpnClientCertId') is not None:
            self.ssl_vpn_client_cert_id = m.get('SslVpnClientCertId')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSslVpnClientCertsResponseBodySslVpnClientCertKeys(TeaModel):
    def __init__(
        self,
        ssl_vpn_client_cert_key: List[DescribeSslVpnClientCertsResponseBodySslVpnClientCertKeysSslVpnClientCertKey] = None,
    ):
        self.ssl_vpn_client_cert_key = ssl_vpn_client_cert_key

    def validate(self):
        if self.ssl_vpn_client_cert_key:
            for k in self.ssl_vpn_client_cert_key:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SslVpnClientCertKey'] = []
        if self.ssl_vpn_client_cert_key is not None:
            for k in self.ssl_vpn_client_cert_key:
                result['SslVpnClientCertKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ssl_vpn_client_cert_key = []
        if m.get('SslVpnClientCertKey') is not None:
            for k in m.get('SslVpnClientCertKey'):
                temp_model = DescribeSslVpnClientCertsResponseBodySslVpnClientCertKeysSslVpnClientCertKey()
                self.ssl_vpn_client_cert_key.append(temp_model.from_map(k))
        return self


class DescribeSslVpnClientCertsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ssl_vpn_client_cert_keys: DescribeSslVpnClientCertsResponseBodySslVpnClientCertKeys = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ssl_vpn_client_cert_keys = ssl_vpn_client_cert_keys

    def validate(self):
        if self.ssl_vpn_client_cert_keys:
            self.ssl_vpn_client_cert_keys.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ssl_vpn_client_cert_keys is not None:
            result['SslVpnClientCertKeys'] = self.ssl_vpn_client_cert_keys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('SslVpnClientCertKeys') is not None:
            temp_model = DescribeSslVpnClientCertsResponseBodySslVpnClientCertKeys()
            self.ssl_vpn_client_cert_keys = temp_model.from_map(m['SslVpnClientCertKeys'])
        return self


class DescribeSslVpnClientCertsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSslVpnClientCertsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSslVpnClientCertsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSslVpnServersRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        ssl_vpn_server_id: str = None,
        vpn_gateway_id: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.ssl_vpn_server_id = ssl_vpn_server_id
        self.vpn_gateway_id = vpn_gateway_id
        self.name = name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeSslVpnServersResponseBodySslVpnServersSslVpnServer(TeaModel):
    def __init__(
        self,
        internet_ip: str = None,
        idaa_sinstance_id: str = None,
        create_time: int = None,
        vpn_gateway_id: str = None,
        compress: bool = None,
        port: int = None,
        local_subnet: str = None,
        region_id: str = None,
        cipher: str = None,
        connections: int = None,
        ssl_vpn_server_id: str = None,
        max_connections: int = None,
        name: str = None,
        enable_multi_factor_auth: bool = None,
        client_ip_pool: str = None,
        proto: str = None,
    ):
        self.internet_ip = internet_ip
        self.idaa_sinstance_id = idaa_sinstance_id
        self.create_time = create_time
        self.vpn_gateway_id = vpn_gateway_id
        self.compress = compress
        self.port = port
        self.local_subnet = local_subnet
        self.region_id = region_id
        self.cipher = cipher
        self.connections = connections
        self.ssl_vpn_server_id = ssl_vpn_server_id
        self.max_connections = max_connections
        self.name = name
        self.enable_multi_factor_auth = enable_multi_factor_auth
        self.client_ip_pool = client_ip_pool
        self.proto = proto

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.idaa_sinstance_id is not None:
            result['IDaaSInstanceId'] = self.idaa_sinstance_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.vpn_gateway_id is not None:
            result['VpnGatewayId'] = self.vpn_gateway_id
        if self.compress is not None:
            result['Compress'] = self.compress
        if self.port is not None:
            result['Port'] = self.port
        if self.local_subnet is not None:
            result['LocalSubnet'] = self.local_subnet
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cipher is not None:
            result['Cipher'] = self.cipher
        if self.connections is not None:
            result['Connections'] = self.connections
        if self.ssl_vpn_server_id is not None:
            result['SslVpnServerId'] = self.ssl_vpn_server_id
        if self.max_connections is not None:
            result['MaxConnections'] = self.max_connections
        if self.name is not None:
            result['Name'] = self.name
        if self.enable_multi_factor_auth is not None:
            result['EnableMultiFactorAuth'] = self.enable_multi_factor_auth
        if self.client_ip_pool is not None:
            result['ClientIpPool'] = self.client_ip_pool
        if self.proto is not None:
            result['Proto'] = self.proto
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IDaaSInstanceId') is not None:
            self.idaa_sinstance_id = m.get('IDaaSInstanceId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('VpnGatewayId') is not None:
            self.vpn_gateway_id = m.get('VpnGatewayId')
        if m.get('Compress') is not None:
            self.compress = m.get('Compress')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('LocalSubnet') is not None:
            self.local_subnet = m.get('LocalSubnet')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Cipher') is not None:
            self.cipher = m.get('Cipher')
        if m.get('Connections') is not None:
            self.connections = m.get('Connections')
        if m.get('SslVpnServerId') is not None:
            self.ssl_vpn_server_id = m.get('SslVpnServerId')
        if m.get('MaxConnections') is not None:
            self.max_connections = m.get('MaxConnections')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EnableMultiFactorAuth') is not None:
            self.enable_multi_factor_auth = m.get('EnableMultiFactorAuth')
        if m.get('ClientIpPool') is not None:
            self.client_ip_pool = m.get('ClientIpPool')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        return self


class DescribeSslVpnServersResponseBodySslVpnServers(TeaModel):
    def __init__(
        self,
        ssl_vpn_server: List[DescribeSslVpnServersResponseBodySslVpnServersSslVpnServer] = None,
    ):
        self.ssl_vpn_server = ssl_vpn_server

    def validate(self):
        if self.ssl_vpn_server:
            for k in self.ssl_vpn_server:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SslVpnServer'] = []
        if self.ssl_vpn_server is not None:
            for k in self.ssl_vpn_server:
                result['SslVpnServer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ssl_vpn_server = []
        if m.get('SslVpnServer') is not None:
            for k in m.get('SslVpnServer'):
                temp_model = DescribeSslVpnServersResponseBodySslVpnServersSslVpnServer()
                self.ssl_vpn_server.append(temp_model.from_map(k))
        return self


class DescribeSslVpnServersResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        ssl_vpn_servers: DescribeSslVpnServersResponseBodySslVpnServers = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.ssl_vpn_servers = ssl_vpn_servers

    def validate(self):
        if self.ssl_vpn_servers:
            self.ssl_vpn_servers.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.ssl_vpn_servers is not None:
            result['SslVpnServers'] = self.ssl_vpn_servers.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('SslVpnServers') is not None:
            temp_model = DescribeSslVpnServersResponseBodySslVpnServers()
            self.ssl_vpn_servers = temp_model.from_map(m['SslVpnServers'])
        return self


class DescribeSslVpnServersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSslVpnServersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSslVpnServersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVirtualBorderRoutersRequestFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeVirtualBorderRoutersRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        filter: List[DescribeVirtualBorderRoutersRequestFilter] = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeVirtualBorderRoutersRequestFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedCensAssociatedCen(TeaModel):
    def __init__(
        self,
        cen_owner_id: int = None,
        cen_id: str = None,
        cen_status: str = None,
    ):
        self.cen_owner_id = cen_owner_id
        self.cen_id = cen_id
        self.cen_status = cen_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_status is not None:
            result['CenStatus'] = self.cen_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenStatus') is not None:
            self.cen_status = m.get('CenStatus')
        return self


class DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedCens(TeaModel):
    def __init__(
        self,
        associated_cen: List[DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedCensAssociatedCen] = None,
    ):
        self.associated_cen = associated_cen

    def validate(self):
        if self.associated_cen:
            for k in self.associated_cen:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AssociatedCen'] = []
        if self.associated_cen is not None:
            for k in self.associated_cen:
                result['AssociatedCen'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.associated_cen = []
        if m.get('AssociatedCen') is not None:
            for k in m.get('AssociatedCen'):
                temp_model = DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedCensAssociatedCen()
                self.associated_cen.append(temp_model.from_map(k))
        return self


class DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedPhysicalConnectionsAssociatedPhysicalConnection(TeaModel):
    def __init__(
        self,
        vlan_interface_id: str = None,
        status: str = None,
        peer_ipv_6gateway_ip: str = None,
        circuit_code: str = None,
        local_ipv_6gateway_ip: str = None,
        physical_connection_owner_uid: str = None,
        local_gateway_ip: str = None,
        physical_connection_business_status: str = None,
        peering_subnet_mask: str = None,
        enable_ipv_6: bool = None,
        physical_connection_status: str = None,
        peer_gateway_ip: str = None,
        peering_ipv_6subnet_mask: str = None,
        physical_connection_id: str = None,
        vlan_id: str = None,
    ):
        self.vlan_interface_id = vlan_interface_id
        self.status = status
        self.peer_ipv_6gateway_ip = peer_ipv_6gateway_ip
        self.circuit_code = circuit_code
        self.local_ipv_6gateway_ip = local_ipv_6gateway_ip
        self.physical_connection_owner_uid = physical_connection_owner_uid
        self.local_gateway_ip = local_gateway_ip
        self.physical_connection_business_status = physical_connection_business_status
        self.peering_subnet_mask = peering_subnet_mask
        self.enable_ipv_6 = enable_ipv_6
        self.physical_connection_status = physical_connection_status
        self.peer_gateway_ip = peer_gateway_ip
        self.peering_ipv_6subnet_mask = peering_ipv_6subnet_mask
        self.physical_connection_id = physical_connection_id
        self.vlan_id = vlan_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.vlan_interface_id is not None:
            result['VlanInterfaceId'] = self.vlan_interface_id
        if self.status is not None:
            result['Status'] = self.status
        if self.peer_ipv_6gateway_ip is not None:
            result['PeerIpv6GatewayIp'] = self.peer_ipv_6gateway_ip
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.local_ipv_6gateway_ip is not None:
            result['LocalIpv6GatewayIp'] = self.local_ipv_6gateway_ip
        if self.physical_connection_owner_uid is not None:
            result['PhysicalConnectionOwnerUid'] = self.physical_connection_owner_uid
        if self.local_gateway_ip is not None:
            result['LocalGatewayIp'] = self.local_gateway_ip
        if self.physical_connection_business_status is not None:
            result['PhysicalConnectionBusinessStatus'] = self.physical_connection_business_status
        if self.peering_subnet_mask is not None:
            result['PeeringSubnetMask'] = self.peering_subnet_mask
        if self.enable_ipv_6 is not None:
            result['EnableIpv6'] = self.enable_ipv_6
        if self.physical_connection_status is not None:
            result['PhysicalConnectionStatus'] = self.physical_connection_status
        if self.peer_gateway_ip is not None:
            result['PeerGatewayIp'] = self.peer_gateway_ip
        if self.peering_ipv_6subnet_mask is not None:
            result['PeeringIpv6SubnetMask'] = self.peering_ipv_6subnet_mask
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VlanInterfaceId') is not None:
            self.vlan_interface_id = m.get('VlanInterfaceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PeerIpv6GatewayIp') is not None:
            self.peer_ipv_6gateway_ip = m.get('PeerIpv6GatewayIp')
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('LocalIpv6GatewayIp') is not None:
            self.local_ipv_6gateway_ip = m.get('LocalIpv6GatewayIp')
        if m.get('PhysicalConnectionOwnerUid') is not None:
            self.physical_connection_owner_uid = m.get('PhysicalConnectionOwnerUid')
        if m.get('LocalGatewayIp') is not None:
            self.local_gateway_ip = m.get('LocalGatewayIp')
        if m.get('PhysicalConnectionBusinessStatus') is not None:
            self.physical_connection_business_status = m.get('PhysicalConnectionBusinessStatus')
        if m.get('PeeringSubnetMask') is not None:
            self.peering_subnet_mask = m.get('PeeringSubnetMask')
        if m.get('EnableIpv6') is not None:
            self.enable_ipv_6 = m.get('EnableIpv6')
        if m.get('PhysicalConnectionStatus') is not None:
            self.physical_connection_status = m.get('PhysicalConnectionStatus')
        if m.get('PeerGatewayIp') is not None:
            self.peer_gateway_ip = m.get('PeerGatewayIp')
        if m.get('PeeringIpv6SubnetMask') is not None:
            self.peering_ipv_6subnet_mask = m.get('PeeringIpv6SubnetMask')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        return self


class DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedPhysicalConnections(TeaModel):
    def __init__(
        self,
        associated_physical_connection: List[DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedPhysicalConnectionsAssociatedPhysicalConnection] = None,
    ):
        self.associated_physical_connection = associated_physical_connection

    def validate(self):
        if self.associated_physical_connection:
            for k in self.associated_physical_connection:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AssociatedPhysicalConnection'] = []
        if self.associated_physical_connection is not None:
            for k in self.associated_physical_connection:
                result['AssociatedPhysicalConnection'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.associated_physical_connection = []
        if m.get('AssociatedPhysicalConnection') is not None:
            for k in m.get('AssociatedPhysicalConnection'):
                temp_model = DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedPhysicalConnectionsAssociatedPhysicalConnection()
                self.associated_physical_connection.append(temp_model.from_map(k))
        return self


class DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterType(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        status: str = None,
        type: str = None,
        min_tx_interval: int = None,
        associated_cens: DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedCens = None,
        peer_ipv_6gateway_ip: str = None,
        pconn_vbr_expire_time: str = None,
        physical_connection_owner_uid: str = None,
        activation_time: str = None,
        physical_connection_business_status: str = None,
        description: str = None,
        termination_time: str = None,
        peer_gateway_ip: str = None,
        min_rx_interval: int = None,
        name: str = None,
        vbr_id: str = None,
        vlan_id: int = None,
        vlan_interface_id: str = None,
        circuit_code: str = None,
        local_ipv_6gateway_ip: str = None,
        associated_physical_connections: DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedPhysicalConnections = None,
        local_gateway_ip: str = None,
        peering_subnet_mask: str = None,
        enable_ipv_6: bool = None,
        route_table_id: str = None,
        detect_multiplier: int = None,
        ecc_id: str = None,
        recovery_time: str = None,
        physical_connection_status: str = None,
        peering_ipv_6subnet_mask: str = None,
        access_point_id: str = None,
        physical_connection_id: str = None,
    ):
        self.creation_time = creation_time
        self.status = status
        self.type = type
        self.min_tx_interval = min_tx_interval
        self.associated_cens = associated_cens
        self.peer_ipv_6gateway_ip = peer_ipv_6gateway_ip
        self.pconn_vbr_expire_time = pconn_vbr_expire_time
        self.physical_connection_owner_uid = physical_connection_owner_uid
        self.activation_time = activation_time
        self.physical_connection_business_status = physical_connection_business_status
        self.description = description
        self.termination_time = termination_time
        self.peer_gateway_ip = peer_gateway_ip
        self.min_rx_interval = min_rx_interval
        self.name = name
        self.vbr_id = vbr_id
        self.vlan_id = vlan_id
        self.vlan_interface_id = vlan_interface_id
        self.circuit_code = circuit_code
        self.local_ipv_6gateway_ip = local_ipv_6gateway_ip
        self.associated_physical_connections = associated_physical_connections
        self.local_gateway_ip = local_gateway_ip
        self.peering_subnet_mask = peering_subnet_mask
        self.enable_ipv_6 = enable_ipv_6
        self.route_table_id = route_table_id
        self.detect_multiplier = detect_multiplier
        self.ecc_id = ecc_id
        self.recovery_time = recovery_time
        self.physical_connection_status = physical_connection_status
        self.peering_ipv_6subnet_mask = peering_ipv_6subnet_mask
        self.access_point_id = access_point_id
        self.physical_connection_id = physical_connection_id

    def validate(self):
        if self.associated_cens:
            self.associated_cens.validate()
        if self.associated_physical_connections:
            self.associated_physical_connections.validate()

    def to_map(self):
        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.min_tx_interval is not None:
            result['MinTxInterval'] = self.min_tx_interval
        if self.associated_cens is not None:
            result['AssociatedCens'] = self.associated_cens.to_map()
        if self.peer_ipv_6gateway_ip is not None:
            result['PeerIpv6GatewayIp'] = self.peer_ipv_6gateway_ip
        if self.pconn_vbr_expire_time is not None:
            result['PConnVbrExpireTime'] = self.pconn_vbr_expire_time
        if self.physical_connection_owner_uid is not None:
            result['PhysicalConnectionOwnerUid'] = self.physical_connection_owner_uid
        if self.activation_time is not None:
            result['ActivationTime'] = self.activation_time
        if self.physical_connection_business_status is not None:
            result['PhysicalConnectionBusinessStatus'] = self.physical_connection_business_status
        if self.description is not None:
            result['Description'] = self.description
        if self.termination_time is not None:
            result['TerminationTime'] = self.termination_time
        if self.peer_gateway_ip is not None:
            result['PeerGatewayIp'] = self.peer_gateway_ip
        if self.min_rx_interval is not None:
            result['MinRxInterval'] = self.min_rx_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        if self.vlan_interface_id is not None:
            result['VlanInterfaceId'] = self.vlan_interface_id
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.local_ipv_6gateway_ip is not None:
            result['LocalIpv6GatewayIp'] = self.local_ipv_6gateway_ip
        if self.associated_physical_connections is not None:
            result['AssociatedPhysicalConnections'] = self.associated_physical_connections.to_map()
        if self.local_gateway_ip is not None:
            result['LocalGatewayIp'] = self.local_gateway_ip
        if self.peering_subnet_mask is not None:
            result['PeeringSubnetMask'] = self.peering_subnet_mask
        if self.enable_ipv_6 is not None:
            result['EnableIpv6'] = self.enable_ipv_6
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.detect_multiplier is not None:
            result['DetectMultiplier'] = self.detect_multiplier
        if self.ecc_id is not None:
            result['EccId'] = self.ecc_id
        if self.recovery_time is not None:
            result['RecoveryTime'] = self.recovery_time
        if self.physical_connection_status is not None:
            result['PhysicalConnectionStatus'] = self.physical_connection_status
        if self.peering_ipv_6subnet_mask is not None:
            result['PeeringIpv6SubnetMask'] = self.peering_ipv_6subnet_mask
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('MinTxInterval') is not None:
            self.min_tx_interval = m.get('MinTxInterval')
        if m.get('AssociatedCens') is not None:
            temp_model = DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedCens()
            self.associated_cens = temp_model.from_map(m['AssociatedCens'])
        if m.get('PeerIpv6GatewayIp') is not None:
            self.peer_ipv_6gateway_ip = m.get('PeerIpv6GatewayIp')
        if m.get('PConnVbrExpireTime') is not None:
            self.pconn_vbr_expire_time = m.get('PConnVbrExpireTime')
        if m.get('PhysicalConnectionOwnerUid') is not None:
            self.physical_connection_owner_uid = m.get('PhysicalConnectionOwnerUid')
        if m.get('ActivationTime') is not None:
            self.activation_time = m.get('ActivationTime')
        if m.get('PhysicalConnectionBusinessStatus') is not None:
            self.physical_connection_business_status = m.get('PhysicalConnectionBusinessStatus')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TerminationTime') is not None:
            self.termination_time = m.get('TerminationTime')
        if m.get('PeerGatewayIp') is not None:
            self.peer_gateway_ip = m.get('PeerGatewayIp')
        if m.get('MinRxInterval') is not None:
            self.min_rx_interval = m.get('MinRxInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        if m.get('VlanInterfaceId') is not None:
            self.vlan_interface_id = m.get('VlanInterfaceId')
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('LocalIpv6GatewayIp') is not None:
            self.local_ipv_6gateway_ip = m.get('LocalIpv6GatewayIp')
        if m.get('AssociatedPhysicalConnections') is not None:
            temp_model = DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterTypeAssociatedPhysicalConnections()
            self.associated_physical_connections = temp_model.from_map(m['AssociatedPhysicalConnections'])
        if m.get('LocalGatewayIp') is not None:
            self.local_gateway_ip = m.get('LocalGatewayIp')
        if m.get('PeeringSubnetMask') is not None:
            self.peering_subnet_mask = m.get('PeeringSubnetMask')
        if m.get('EnableIpv6') is not None:
            self.enable_ipv_6 = m.get('EnableIpv6')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('DetectMultiplier') is not None:
            self.detect_multiplier = m.get('DetectMultiplier')
        if m.get('EccId') is not None:
            self.ecc_id = m.get('EccId')
        if m.get('RecoveryTime') is not None:
            self.recovery_time = m.get('RecoveryTime')
        if m.get('PhysicalConnectionStatus') is not None:
            self.physical_connection_status = m.get('PhysicalConnectionStatus')
        if m.get('PeeringIpv6SubnetMask') is not None:
            self.peering_ipv_6subnet_mask = m.get('PeeringIpv6SubnetMask')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        return self


class DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSet(TeaModel):
    def __init__(
        self,
        virtual_border_router_type: List[DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterType] = None,
    ):
        self.virtual_border_router_type = virtual_border_router_type

    def validate(self):
        if self.virtual_border_router_type:
            for k in self.virtual_border_router_type:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['VirtualBorderRouterType'] = []
        if self.virtual_border_router_type is not None:
            for k in self.virtual_border_router_type:
                result['VirtualBorderRouterType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.virtual_border_router_type = []
        if m.get('VirtualBorderRouterType') is not None:
            for k in m.get('VirtualBorderRouterType'):
                temp_model = DescribeVirtualBorderRoutersResponseBodyVirtualBorderRouterSetVirtualBorderRouterType()
           