# Docker configs

Configs objects present in Swarm mode

Don't use the constructor directly. Instead use 
```python
from python_on_whales import docker

my_config = docker.config.inspect("my-config-name")

# or

my_config = docker.config.create("my_config_name", "my_config_file")
```
For type hints, use this

```python
from python_on_whales import Config

def print_config_labels(config: Config):
    print(config.spec.labels)
```


## Attributes

It attributes are the same that you get with the command line:
`docker config inspect ...`

To get a complete description of those attributes, you 
can take a look at the [daemon api reference page](https://docs.docker.com/engine/api/v1.40/#operation/ConfigInspect) 
and click on "200 No error".

An example is worth many lines of descriptions.

```
In [1]: from python_on_whales import docker

In [2]: config = docker.config.create("my_config_name", "my_config_file")

In [3]: def super_print(obj):
   ...:     print(f"type={type(obj)}, value={obj}")
   ...:

@INSERT_GENERATED_CODE@
```

## Methods

{{autogenerated}}
