"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encryptValue = void 0;
// Need to import it like that because projen doesnt support esModuleInterop
// eslint-disable-next-line @typescript-eslint/no-require-imports
const _sodium = require('libsodium-wrappers');
// Compatible with the same `Uint8Array` arguments as `tweetsodium.seal()`
async function async_encrypt(messageBytes, publicKey) {
    await _sodium.ready;
    const libsodium = _sodium;
    return libsodium.crypto_box_seal(messageBytes, publicKey);
}
exports.encryptValue = async (valueToEncrypt, key) => {
    // Convert the message and key to Uint8Array's (Buffer implements that interface)
    const messageBytes = Buffer.from(valueToEncrypt);
    const keyBytes = Buffer.from(key, 'base64');
    // Encrypt using LibSodium.
    const encryptedBytes = await async_encrypt(messageBytes, keyBytes);
    // Base64 the encrypted secret
    const encrypted = Buffer.from(encryptedBytes).toString('base64');
    return encrypted;
};
//# sourceMappingURL=data:application/json;base64,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