"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionEnvironmentSecretStack = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("../../constructs");
class ActionEnvironmentSecretStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const sourceSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'secretToStoreInGitHub', 'testcdkgithub');
        const githubTokenSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'ghSecret', 'GITHUB_TOKEN');
        new constructs_1.ActionEnvironmentSecret(this, 'GitHubActionEnvironmentSecret', {
            githubTokenSecret,
            environment: 'dev',
            repositoryName: 'cdk-github',
            repositoryOwner: 'wtfjoke',
            repositorySecretName: 'aRandomGitHubSecret',
            sourceSecret,
        });
    }
}
exports.ActionEnvironmentSecretStack = ActionEnvironmentSecretStack;
//# sourceMappingURL=data:application/json;base64,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