"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_secrets_1 = require("../handler/action-secrets");
class ActionSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const handler = new action_secrets_1.ActionSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionSecretCustomResourceHandler',
            description: 'Handles the creation/deletion of a GitHub Action (repository) secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'SecretProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionSecret = ActionSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionSecret[_a] = { fqn: "cdk-github.ActionSecret", version: "0.0.6" };
//# sourceMappingURL=data:application/json;base64,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