/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
export declare enum Platform {
    linux = "linux",
    mac = "mac",
    windows = "windows"
}
export declare enum Product {
    deadline = "Deadline",
    deadlineDocker = "DeadlineDocker"
}
export interface IVersionProviderProperties {
    readonly versionString?: string;
    readonly product: Product;
    readonly platform?: Platform;
}
export interface IUris {
    readonly bundle: string;
    readonly clientInstaller?: string;
    readonly repositoryInstaller?: string;
    readonly certificateInstaller?: string;
}
export interface IVersionedUris {
    /**
     * The major version number.
     */
    readonly MajorVersion: string;
    /**
     * The minor version number.
     */
    readonly MinorVersion: string;
    /**
     * The release version number.
     */
    readonly ReleaseVersion: string;
    /**
     * The patch version number.
     */
    readonly PatchVersion: string;
    /**
     * The URLs to installers
     */
    readonly Uris: IUris;
}
/**
 * The version provider parses a JSON file containing version information for the Deadline and DockerDeadline products.
 * It  can be downloaded or loaded from local file and returns URIs for the specific products.
 * By default returns the last version of URIs or specified full or partial version.
 * If platform is not defined returns URIs for each platform.
 */
export declare class VersionProvider {
    private static readonly VERSION_INDEX_URL;
    private readonly indexFilePath;
    constructor(indexFilePath?: string);
    /**
     * Returns URIs for specified product
     */
    getVersionUris(resourceProperties: IVersionProviderProperties): Promise<Map<Platform, IVersionedUris>>;
    private downloadInstallerIndex;
    /**
     * This method reads index file and return parsed JSON object from this file content.
     */
    private readInstallersIndex;
    /**
     * This method returns IVersionedUris (the patch version plus installer URI's) for a specific platform.
     */
    private getUrisForPlatform;
    /**
     * This method returns the latest version for specified platform.
     */
    private getLatestVersion;
    /**
     * This method looks for the requested version (partial or complete) in the
     * indexed version information. Based on the input, it iterates through all
     * four numbers in the version string and compares the requested version
     * with the indexed info.
     * If any of the requested version number is missing, it fetches the latest
     * (highest) available version for it.
     */
    private getRequestedUriVersion;
}
