"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const key_1 = require("../key");
test('success', () => {
    const arn = 'arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab';
    const key = key_1.Key.fromArn(arn);
    expect(key.arn).toEqual(arn);
});
test('bad arn', () => {
    const arn = 'badArn';
    expect(() => key_1.Key.fromArn(arn)).toThrowError(`Not a KMS ARN: ${arn}`);
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2V5LnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJrZXkudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztHQUdHOztBQUVILGdDQUE2QjtBQUU3QixJQUFJLENBQUMsU0FBUyxFQUFFLEdBQUcsRUFBRTtJQUNuQixNQUFNLEdBQUcsR0FBRyw2RUFBNkUsQ0FBQztJQUMxRixNQUFNLEdBQUcsR0FBRyxTQUFHLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQzdCLE1BQU0sQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0FBQy9CLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLFNBQVMsRUFBRSxHQUFHLEVBQUU7SUFDbkIsTUFBTSxHQUFHLEdBQUcsUUFBUSxDQUFDO0lBQ3JCLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxTQUFHLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsWUFBWSxDQUFDLGtCQUFrQixHQUFHLEVBQUUsQ0FBQyxDQUFDO0FBQ3ZFLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgS2V5IH0gZnJvbSAnLi4va2V5JztcblxudGVzdCgnc3VjY2VzcycsICgpID0+IHtcbiAgY29uc3QgYXJuID0gJ2Fybjphd3M6a21zOnVzLXdlc3QtMjoxMTExMjIyMjMzMzM6a2V5LzEyMzRhYmNkLTEyYWItMzRjZC01NmVmLTEyMzQ1Njc4OTBhYic7XG4gIGNvbnN0IGtleSA9IEtleS5mcm9tQXJuKGFybik7XG4gIGV4cGVjdChrZXkuYXJuKS50b0VxdWFsKGFybik7XG59KTtcblxudGVzdCgnYmFkIGFybicsICgpID0+IHtcbiAgY29uc3QgYXJuID0gJ2JhZEFybic7XG4gIGV4cGVjdCgoKSA9PiBLZXkuZnJvbUFybihhcm4pKS50b1Rocm93RXJyb3IoYE5vdCBhIEtNUyBBUk46ICR7YXJufWApO1xufSk7XG4iXX0=