import * as ec2 from 'aws-cdk-lib/aws-ec2';
import { IResource, RemovalPolicy, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * (experimental) Interface for a cluster subnet group.
 *
 * @experimental
 */
export interface IClusterSubnetGroup extends IResource {
    /**
     * (experimental) The name of the cluster subnet group.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterSubnetGroupName: string;
}
/**
 * (experimental) Properties for creating a ClusterSubnetGroup.
 *
 * @experimental
 */
export interface ClusterSubnetGroupProps {
    /**
     * (experimental) Description of the subnet group.
     *
     * @experimental
     */
    readonly description: string;
    /**
     * (experimental) The VPC to place the subnet group in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Which subnets within the VPC to associate with this group.
     *
     * @default - private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) The removal policy to apply when the subnet group are removed from the stack or replaced during an update.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Class for creating a Redshift cluster subnet group.
 *
 * @experimental
 * @resource AWS::Redshift::ClusterSubnetGroup
 */
export declare class ClusterSubnetGroup extends Resource implements IClusterSubnetGroup {
    /**
     * (experimental) Imports an existing subnet group by name.
     *
     * @experimental
     */
    static fromClusterSubnetGroupName(scope: Construct, id: string, clusterSubnetGroupName: string): IClusterSubnetGroup;
    /**
     * (experimental) The name of the cluster subnet group.
     *
     * @experimental
     */
    readonly clusterSubnetGroupName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClusterSubnetGroupProps);
}
