import numpy as np

from hyperstatic.common.csys import Cartesian
from hyperstatic.core.fe_model.element import Element
from hyperstatic.common.tolerance import Tolerance

class Quad(Element):
    def __init__(self,name,node_i,node_j,node_k,node_l,dof):
        #Initialize local CSys
        o=(node_i.loc+node_j.loc+node_k.loc+node_l.loc)/4
        vec1=node_i.loc-node_j.loc
        vec2=node_j.loc-node_k.loc
        n=np.cross(vec1,vec2)
        n=n/np.linalg.norm(n)
        tol=Tolerance.abs_tol()
        if np.linalg.norm(n-np.array([0,0,1]))<tol or np.linalg.norm(n+np.array([0,0,1]))<tol:
            csys = Cartesian.create_by_normal(o, n, guide=[0,1,0])
        else:
            csys = Cartesian.create_by_normal(o, n)
        super(Quad,self).__init__(name,[node_i,node_j,node_k,node_l],2,dof,csys)
        #area is considered as the average of trangles generated by splitting the quand with diagonals
        area=0.5*np.linalg.det(np.array([[1,1,1],
                            [node_j.x-node_i.x,node_j.y-node_i.y,node_j.z-node_i.z],
                            [node_k.x-node_i.x,node_k.y-node_i.y,node_k.z-node_i.z]]))
        area+=0.5*np.linalg.det(np.array([[1,1,1],
                            [node_l.x-node_i.x,node_l.y-node_i.y,node_l.z-node_i.z],
                            [node_k.x-node_i.x,node_k.y-node_i.y,node_k.z-node_i.z]]))
        area+=0.5*np.linalg.det(np.array([[1,1,1],
                            [node_l.x-node_i.x,node_l.y-node_i.y,node_l.z-node_i.z],
                            [node_j.x-node_i.x,node_j.y-node_i.y,node_j.z-node_i.z]]))
        area+=0.5*np.linalg.det(np.array([[1,1,1],
                            [node_l.x-node_i.x,node_l.y-node_i.y,node_l.z-node_i.z],
                            [node_j.x-node_i.x,node_j.y-node_i.y,node_j.z-node_i.z]]))
        self.__area=area/4

    @property
    def area(self):
        return self.__area