/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup.entry;

import java.beans.Beans;
import java.io.IOException;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.EntryBean;

public class EntryBeans {
    public static EntryBean createBean(Entry ent) throws ClassNotFoundException, IOException {
        String beanClass = ent.getClass().getName() + "Bean";
        Object obj = null;
        try {
            obj = Beans.instantiate(ent.getClass().getClassLoader(), beanClass);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (obj == null) {
            obj = Beans.instantiate(null, beanClass);
        }
        EntryBean entBean = (EntryBean)Beans.getInstanceOf(obj, EntryBean.class);
        entBean.makeLink(ent);
        return entBean;
    }

    public static Class getBeanClass(Class c) throws ClassNotFoundException {
        if (!Entry.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("class does not implement net.jini.core.entry.Entry");
        }
        String beanClassName = c.getName() + "Bean";
        Class<?> beanClass = null;
        try {
            beanClass = c.getClassLoader().loadClass(beanClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (beanClass == null) {
            beanClass = Class.forName(beanClassName);
        }
        if (!EntryBean.class.isAssignableFrom(beanClass)) {
            throw new ClassCastException("JavaBeans component class does not implement EntryBean interface");
        }
        return beanClass;
    }
}

