/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class HttpSettings {
    private static final Object lastNonProxyLock = new Object();
    private static String lastNonProxyHosts = null;
    private static SoftReference lastNonProxyPatterns = null;
    private final boolean ssl;
    private final Properties props;

    public static HttpSettings getHttpSettings(boolean ssl) {
        return new HttpSettings(ssl, System.getProperties());
    }

    private HttpSettings(boolean ssl, Properties props) {
        this.ssl = ssl;
        this.props = props;
    }

    public String getProxyHost(String host) {
        String str = this.props.getProperty(this.ssl ? "https.proxyHost" : "http.proxyHost");
        if (str == null && !this.ssl) {
            str = this.props.getProperty("proxyHost");
        }
        if (str == null || str.length() != 0 && this.nonProxied(host)) {
            str = "";
        }
        return str;
    }

    public int getProxyPort() {
        String str = this.props.getProperty(this.ssl ? "https.proxyPort" : "http.proxyPort");
        int port = -1;
        if (str != null) {
            try {
                port = Integer.parseInt(str);
            }
            catch (Exception ex) {}
        } else if (!this.ssl && (str = this.props.getProperty("proxyPort")) != null) {
            try {
                port = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (port <= 0 || port > 65535) {
            port = this.ssl ? 443 : 80;
        }
        return port;
    }

    public long getResponseAckTimeout() {
        String str = this.props.getProperty(this.ssl ? "com.sun.jini.jeri.https.responseAckTimeout" : "com.sun.jini.jeri.http.responseAckTimeout");
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 15000L;
    }

    public long getConnectionTimeout() {
        String str = this.props.getProperty(this.ssl ? "com.sun.jini.jeri.https.idleConnectionTimeout" : "com.sun.jini.jeri.http.idleConnectionTimeout");
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 15000L;
    }

    public long getServerConnectionTimeout() {
        String str = this.props.getProperty(this.ssl ? "com.sun.jini.jeri.https.idleServerConnectionTimeout" : "com.sun.jini.jeri.http.idleServerConnectionTimeout");
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getConnectionTimeout() + (long)(this.ssl ? 30000 : 10000);
    }

    public boolean getDisableProxyPersistentConnections() {
        return this.ssl ? false : Boolean.valueOf(this.props.getProperty("com.sun.jini.jeri.http.disableProxyPersistentConnections"));
    }

    public boolean getPingProxyConnections() {
        String key = this.ssl ? "com.sun.jini.jeri.https.pingProxyConnections" : "com.sun.jini.jeri.http.pingProxyConnections";
        String prop = this.props.getProperty(key);
        boolean ping = Boolean.valueOf(prop);
        return ping;
    }

    public long getPingProxyConnectionTimeout() {
        String key = this.ssl ? "com.sun.jini.jeri.https.pingProxyConnectionTimeout" : "com.sun.jini.jeri.http.pingProxyConnectionTimeout";
        String prop = this.props.getProperty(key);
        try {
            long timeout = Long.valueOf(prop);
            return timeout;
        }
        catch (Exception exception) {
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nonProxied(String host) {
        Pattern[] patterns;
        String str = this.props.getProperty("http.nonProxyHosts");
        if (str == null) {
            return false;
        }
        Object object = lastNonProxyLock;
        synchronized (object) {
            if (!str.equalsIgnoreCase(lastNonProxyHosts) || (patterns = (Pattern[])lastNonProxyPatterns.get()) == null) {
                StringTokenizer tok = new StringTokenizer(str, "|");
                ArrayList<Pattern> plist = new ArrayList<Pattern>();
                while (tok.hasMoreTokens()) {
                    try {
                        plist.add(Pattern.compile(HttpSettings.convertToRegex(tok.nextToken()), 2));
                    }
                    catch (IllegalArgumentException ex) {}
                }
                patterns = plist.toArray(new Pattern[plist.size()]);
                lastNonProxyPatterns = new SoftReference<Pattern[]>(patterns);
                lastNonProxyHosts = str;
            }
        }
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].matcher(host).matches()) continue;
            return true;
        }
        return false;
    }

    private static String convertToRegex(String hostPattern) {
        int len = hostPattern.length();
        StringBuffer sbuf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = hostPattern.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                sbuf.append(c);
                continue;
            }
            if (c == '.') {
                sbuf.append("\\.");
                continue;
            }
            if (c == '*') {
                sbuf.append(".*");
                continue;
            }
            throw new IllegalArgumentException("illegal char: " + c);
        }
        return sbuf.toString();
    }
}

