/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import java.io.IOException;
import java.util.Arrays;
import net.jini.core.lookup.ServiceID;

public class MulticastRequest {
    protected String host;
    protected int port;
    protected String[] groups;
    protected ServiceID[] serviceIDs;

    public MulticastRequest(String host, int port, String[] groups, ServiceID[] serviceIDs) {
        groups = groups != null ? (String[])groups.clone() : new String[]{};
        ServiceID[] serviceIDArray = serviceIDs = serviceIDs != null ? (ServiceID[])serviceIDs.clone() : new ServiceID[]{};
        if (host == null || Arrays.asList(groups).contains(null) || Arrays.asList(serviceIDs).contains(null)) {
            throw new NullPointerException();
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        this.host = host;
        this.port = port;
        this.groups = groups;
        this.serviceIDs = serviceIDs;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return (String[])this.groups.clone();
    }

    public ServiceID[] getServiceIDs() {
        return (ServiceID[])this.serviceIDs.clone();
    }

    public void checkConstraints() throws IOException {
    }

    public String toString() {
        return "MulticastRequest[" + this.host + ":" + this.port + ", " + Arrays.asList(this.groups) + ", " + Arrays.asList(this.serviceIDs) + "]";
    }
}

