/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplNoCompression
extends OWLObjectImpl
implements OWLLiteral {
    private static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    private static final OWLDatatype RDF_LANG_STRING = new OWL2DatatypeImpl(OWL2Datatype.RDF_LANG_STRING);
    private static final OWLDatatype XSD_STRING = new OWL2DatatypeImpl(OWL2Datatype.XSD_STRING);
    private final String literal;
    private final OWLDatatype datatype;
    private final String language;

    public OWLLiteralImplNoCompression(String literal, @Nullable String lang, @Nullable OWLDatatype datatype) {
        this.literal = literal;
        if (lang == null || lang.isEmpty()) {
            this.language = "";
            this.datatype = datatype == null ? XSD_STRING : datatype;
        } else {
            if (datatype != null && !datatype.equals(RDF_LANG_STRING) && !datatype.equals(RDF_PLAIN_LITERAL)) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.language = lang;
            this.datatype = RDF_LANG_STRING;
        }
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean hasLang() {
        return !this.language.isEmpty();
    }

    public boolean isRDFPlainLiteral() {
        return this.getDatatype().isRDFPlainLiteral();
    }

    public boolean isInteger() {
        return this.getDatatype().isInteger();
    }

    public boolean isBoolean() {
        return this.getDatatype().isBoolean();
    }

    public boolean isDouble() {
        return this.getDatatype().isDouble();
    }

    public boolean isFloat() {
        return this.getDatatype().isFloat();
    }

    public int parseInteger() {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean parseBoolean() {
        return OWLLiteralImpl.asBoolean(this.literal);
    }

    public double parseDouble() {
        return Double.parseDouble(this.literal);
    }

    public float parseFloat() {
        if ("inf".equalsIgnoreCase(this.literal)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(this.literal)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(this.literal);
    }

    public String getLang() {
        return this.language;
    }

    public boolean hasLang(@Nullable String lang) {
        if (lang == null) {
            return this.language.isEmpty();
        }
        return this.language.equalsIgnoreCase(lang.trim());
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    protected int hashCode(OWLObject object) {
        return OWLLiteralImplNoCompression.hash(object.hashIndex(), Stream.of(this.getDatatype(), this.specificHash() * 65536, this.getLang()));
    }

    private int specificHash() {
        try {
            if (this.isInteger()) {
                return this.parseInteger();
            }
            if (this.isDouble()) {
                return (int)this.parseDouble();
            }
            if (this.isFloat()) {
                return (int)this.parseFloat();
            }
            if (this.isBoolean()) {
                return this.parseBoolean() ? 1 : 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getLiteral().hashCode();
    }
}

