/*
 * Decompiled with CFR 0.152.
 */
package cutthecrap.utils.striterators;

import cutthecrap.utils.striterators.Appender;
import cutthecrap.utils.striterators.EnumIterator;
import cutthecrap.utils.striterators.ExclusionFilter;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.ICloseable;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Mapper;
import cutthecrap.utils.striterators.UniquenessFilter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Striterator
implements IStriterator,
IStriterator.ITailOp,
ICloseableIterator {
    private volatile List<IFilter> filters = null;
    private volatile Iterator realSource;
    private volatile Iterator m_src = null;
    private boolean isOpen = true;

    boolean isOpen() {
        return this.isOpen;
    }

    public Striterator() {
        this.realSource = null;
    }

    public Striterator(Iterator src) {
        this.realSource = src;
    }

    public Striterator(Enumeration src) {
        this(new EnumIterator(src));
    }

    public Striterator(Iterator src, List<IFilter> filters) {
        this.realSource = src;
    }

    @Override
    public boolean hasNext() {
        boolean ret;
        if (!this.isOpen) {
            return false;
        }
        if (this.m_src == null) {
            this.compile(this.realSource);
        }
        if (!(ret = this.m_src.hasNext())) {
            this.close();
        }
        return ret;
    }

    @Override
    public Object next() {
        if (this.m_src == null) {
            this.compile(this.realSource);
        }
        Object ret = this.m_src.next();
        if (this.m_src instanceof IStriterator.ITailOp) {
            Iterator old = this.m_src;
            this.m_src = ((IStriterator.ITailOp)((Object)this.m_src)).availableTailOp();
        }
        return ret;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }

    @Override
    public void remove() {
        this.m_src.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStriterator addFilter(IFilter filter) {
        if (this.filters == null) {
            Striterator striterator = this;
            synchronized (striterator) {
                if (this.filters == null) {
                    this.filters = Collections.synchronizedList(new LinkedList());
                }
            }
        }
        this.filters.add(filter);
        return this;
    }

    public void compile(Iterator src) {
        this.compile(src, null);
    }

    public void compile(Iterator src, Object context) {
        if (this.m_src != null) {
            throw new IllegalStateException();
        }
        this.m_src = this.realSource = src;
        if (this.filters != null) {
            for (IFilter filter : this.filters) {
                this.m_src = filter.filter(this.m_src, context);
            }
        }
    }

    @Override
    public IStriterator addTypeFilter(final Class cls) {
        this.addFilter(new Filter(){

            @Override
            public boolean isValid(Object obj) {
                boolean ret = cls.isInstance(obj);
                return ret;
            }
        });
        return this;
    }

    @Override
    public IStriterator addInstanceOfFilter(Class cls) {
        this.addFilter(new Filter(){

            @Override
            public boolean isValid(Object obj) {
                return obj == null ? false : obj.getClass() == obj;
            }
        });
        return this;
    }

    @Override
    public IStriterator exclude(Object object) {
        return this.addFilter(new ExclusionFilter(object));
    }

    @Override
    public IStriterator makeUnique() {
        return this.addFilter(new UniquenessFilter());
    }

    @Override
    public IStriterator append(Iterator iter) {
        return this.addFilter(new Appender(iter));
    }

    @Override
    public IStriterator map(Object client, Method method) {
        return this.addFilter(new Mapper(client, method));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{filterChain=" + this.filters);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Iterator availableTailOp() {
        boolean avail;
        boolean bl = avail = Striterator.class == this.getClass();
        if (avail) {
            return this.m_src instanceof IStriterator.ITailOp ? ((IStriterator.ITailOp)((Object)this.m_src)).availableTailOp() : this.m_src;
        }
        return this;
    }

    @Override
    public void close() {
        if (this.isOpen && this.realSource instanceof ICloseable) {
            ((ICloseable)((Object)this.realSource)).close();
        }
        this.isOpen = false;
    }
}

