/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval.pipeline;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AbstractUnsynchronizedArrayBuffer;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStarJoin;
import com.bigdata.relation.rule.eval.ChunkTrace;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.pipeline.IJoinMaster;
import com.bigdata.relation.rule.eval.pipeline.JoinStats;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class JoinTask
implements Callable<Void> {
    protected static final Logger log = Logger.getLogger(JoinTask.class);
    protected static final boolean WARN = log.isEnabledFor((Priority)Level.WARN);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected final IRule<?> rule;
    protected final int tailCount;
    protected final int partitionId;
    protected final int tailIndex;
    protected final IPredicate<?> predicate;
    protected final IRelation<?> relation;
    protected final int orderIndex;
    protected final boolean lastJoin;
    protected final IJoinMaster masterProxy;
    protected final UUID masterUUID;
    protected final IVariable<?>[][] requiredVars;
    protected IJoinNexus joinNexus;
    protected volatile boolean halt = false;
    protected final AtomicReference<Throwable> firstCause = new AtomicReference<Object>(null);
    final int[] order;
    final JoinStats stats;
    private final ThreadLocalFactory<AbstractUnsynchronizedArrayBuffer<IBindingSet>, IBindingSet> threadLocalBufferFactory = new ThreadLocalFactory<AbstractUnsynchronizedArrayBuffer<IBindingSet>, IBindingSet>(){

        @Override
        protected AbstractUnsynchronizedArrayBuffer<IBindingSet> initialValue() {
            return JoinTask.this.newUnsyncOutputBuffer();
        }
    };
    private boolean didReport = false;

    protected void halt(Throwable cause) {
        this.halt = true;
        boolean isFirstCause = this.firstCause.compareAndSet(null, cause);
        if (WARN) {
            try {
                if (!(InnerCause.isInnerCause((Throwable)cause, InterruptedException.class) || InnerCause.isInnerCause((Throwable)cause, CancellationException.class) || InnerCause.isInnerCause((Throwable)cause, ClosedByInterruptException.class) || InnerCause.isInnerCause((Throwable)cause, RejectedExecutionException.class) || InnerCause.isInnerCause((Throwable)cause, BufferClosedException.class))) {
                    log.warn((Object)("orderIndex=" + this.orderIndex + ", partitionId=" + this.partitionId + ", isFirstCause=" + isFirstCause + " : " + cause.getLocalizedMessage()), cause);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected abstract AbstractUnsynchronizedArrayBuffer<IBindingSet> newUnsyncOutputBuffer();

    protected abstract IBuffer<ISolution[]> getSolutionBuffer();

    protected final int getTailIndex(int orderIndex) {
        assert (this.order != null);
        int tailIndex = this.order[orderIndex];
        assert (orderIndex >= 0 && orderIndex < this.tailCount) : "orderIndex=" + orderIndex + ", rule=" + this.rule;
        return tailIndex;
    }

    public String toString() {
        return this.getClass().getName() + "{ orderIndex=" + this.orderIndex + ", partitionId=" + this.partitionId + ", lastJoin=" + this.lastJoin + ", masterUUID=" + this.masterUUID + "}";
    }

    public JoinTask(IRule rule, IJoinNexus joinNexus, int[] order, int orderIndex, int partitionId, IJoinMaster masterProxy, UUID masterUUID, IVariable[][] requiredVars) {
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        if (joinNexus == null) {
            throw new IllegalArgumentException();
        }
        int tailCount = rule.getTailCount();
        if (order == null) {
            throw new IllegalArgumentException();
        }
        if (order.length != tailCount) {
            throw new IllegalArgumentException();
        }
        if (orderIndex < 0 || orderIndex >= tailCount) {
            throw new IllegalArgumentException();
        }
        if (masterProxy == null) {
            throw new IllegalArgumentException();
        }
        if (masterUUID == null) {
            throw new IllegalArgumentException();
        }
        if (requiredVars == null) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
        this.partitionId = partitionId;
        this.tailCount = tailCount;
        this.orderIndex = orderIndex;
        this.joinNexus = joinNexus;
        this.order = order;
        this.tailIndex = this.getTailIndex(orderIndex);
        this.lastJoin = orderIndex + 1 == tailCount;
        this.predicate = rule.getTail(this.tailIndex);
        this.relation = joinNexus.getTailRelationView(this.predicate);
        this.stats = new JoinStats(partitionId, orderIndex);
        this.masterProxy = masterProxy;
        this.masterUUID = masterUUID;
        this.requiredVars = requiredVars;
        if (DEBUG) {
            log.debug((Object)("orderIndex=" + orderIndex + ", partitionId=" + partitionId));
        }
    }

    @Override
    public Void call() throws Exception {
        if (DEBUG) {
            log.debug((Object)("orderIndex=" + this.orderIndex + ", partitionId=" + this.partitionId));
        }
        try {
            this.consumeSources();
            this.threadLocalBufferFactory.flush();
            this.flushAndCloseBuffersAndAwaitSinks();
            if (DEBUG) {
                log.debug((Object)("JoinTask done: orderIndex=" + this.orderIndex + ", partitionId=" + this.partitionId + ", halt=" + this.halt + "firstCause=" + this.firstCause.get()));
            }
            if (this.halt) {
                throw new RuntimeException(this.firstCause.get());
            }
            Void void_ = null;
            return void_;
        }
        catch (Throwable t) {
            try {
                this.logCallError(t);
            }
            catch (Throwable t2) {
                log.error((Object)t2.getLocalizedMessage(), t2);
            }
            this.halt(t);
            try {
                this.threadLocalBufferFactory.reset();
            }
            catch (Throwable t2) {
                log.error((Object)t2.getLocalizedMessage(), t2);
            }
            try {
                this.cancelSinks();
            }
            catch (Throwable t2) {
                log.error((Object)t2.getLocalizedMessage(), t2);
            }
            try {
                this.reportOnce();
            }
            catch (Throwable t2) {
                log.error((Object)t2.getLocalizedMessage(), t2);
            }
            try {
                this.closeSources();
            }
            catch (Throwable t2) {
                log.error((Object)t2.getLocalizedMessage(), t2);
            }
            throw new RuntimeException(t);
        }
        finally {
            this.reportOnce();
        }
    }

    protected void logCallError(Throwable t) {
    }

    protected void reportOnce() {
        if (!this.didReport) {
            this.didReport = true;
            try {
                this.masterProxy.report(this.stats);
            }
            catch (IOException ex) {
                log.warn((Object)"Could not report statistics to the master", (Throwable)ex);
            }
        }
    }

    protected void consumeSources() throws Exception {
        if (INFO) {
            log.info((Object)this.toString());
        }
        boolean maxParallel = false;
        if (this.orderIndex > 0) {
            // empty if block
        }
        new BindingSetConsumerTask(null).call();
    }

    abstract void closeSources();

    protected abstract void flushAndCloseBuffersAndAwaitSinks() throws InterruptedException, ExecutionException;

    protected abstract void cancelSinks();

    protected abstract IBindingSet[] nextChunk() throws InterruptedException;

    protected class ChunkTask
    implements Callable<Boolean> {
        private final int tailIndex;
        private final IBindingSet[] bindingSets;
        private final AbstractUnsynchronizedArrayBuffer<IBindingSet> unsyncBuffer;
        private final Object[] chunk;

        public ChunkTask(IBindingSet[] bindingSet, AbstractUnsynchronizedArrayBuffer<IBindingSet> unsyncBuffer, Object[] chunk) {
            if (bindingSet == null) {
                throw new IllegalArgumentException();
            }
            if (chunk == null) {
                throw new IllegalArgumentException();
            }
            this.tailIndex = JoinTask.this.getTailIndex(JoinTask.this.orderIndex);
            this.bindingSets = bindingSet;
            this.chunk = chunk;
            this.unsyncBuffer = unsyncBuffer;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                ChunkTrace.chunk(JoinTask.this.orderIndex, this.chunk);
                boolean nothingAccepted = true;
                AbstractUnsynchronizedArrayBuffer unsyncBuffer = this.unsyncBuffer == null ? (AbstractUnsynchronizedArrayBuffer)((ThreadLocalFactory)JoinTask.this.threadLocalBufferFactory).get() : this.unsyncBuffer;
                for (Object e : this.chunk) {
                    if (JoinTask.this.halt) {
                        return nothingAccepted;
                    }
                    int naccepted = 0;
                    ++JoinTask.this.stats.elementCount;
                    for (IBindingSet bset : this.bindingSets) {
                        IVariable<?>[] variablesToKeep = JoinTask.this.requiredVars[this.tailIndex];
                        if (INFO) {
                            log.info((Object)("tailIndex: " + this.tailIndex));
                            log.info((Object)("bset before: " + bset));
                        }
                        bset = bset.clone();
                        if (INFO) {
                            log.info((Object)("tailIndex: " + this.tailIndex));
                            log.info((Object)("bset after: " + bset));
                            log.info((Object)("element: " + e));
                        }
                        if (!JoinTask.this.joinNexus.bind(JoinTask.this.rule, this.tailIndex, e, bset)) continue;
                        bset = bset.copy(variablesToKeep);
                        unsyncBuffer.add(bset);
                        ++naccepted;
                        nothingAccepted = false;
                    }
                    if (!DEBUG) continue;
                    log.debug((Object)("Accepted element for " + naccepted + " of " + this.bindingSets.length + " possible bindingSet combinations: " + e.toString() + ", orderIndex=" + JoinTask.this.orderIndex + ", lastJoin=" + JoinTask.this.lastJoin + ", rule=" + JoinTask.this.rule.getName()));
                }
                return nothingAccepted ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (Throwable t) {
                JoinTask.this.halt(t);
                throw new RuntimeException(t);
            }
        }
    }

    protected class AccessPathTask
    implements Callable<Void>,
    Comparable<AccessPathTask> {
        private final IBindingSet[] bindingSets;
        private final IAccessPath<?> accessPath;

        protected byte[] getFromKey() {
            return ((AccessPath)this.accessPath).getFromKey();
        }

        public boolean equals(AccessPathTask o) {
            return this.accessPath.getPredicate().equals(o.accessPath.getPredicate());
        }

        public AccessPathTask(IPredicate<?> predicate, Collection<IBindingSet> bindingSets) {
            if (predicate == null) {
                throw new IllegalArgumentException();
            }
            if (bindingSets == null) {
                throw new IllegalArgumentException();
            }
            int n = bindingSets.size();
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            this.accessPath = JoinTask.this.joinNexus.getTailAccessPath(JoinTask.this.relation, predicate);
            if (DEBUG) {
                log.debug((Object)("orderIndex=" + JoinTask.this.orderIndex + ", tailIndex=" + JoinTask.this.tailIndex + ", tail=" + JoinTask.this.rule.getTail(JoinTask.this.tailIndex) + ", #bindingSets=" + n + ", accessPath=" + this.accessPath));
            }
            this.bindingSets = bindingSets.toArray(new IBindingSet[n]);
        }

        public String toString() {
            return JoinTask.this.getClass().getSimpleName() + "{ orderIndex=" + JoinTask.this.orderIndex + ", partitionId=" + JoinTask.this.partitionId + ", #bindingSets=" + this.bindingSets.length + "}";
        }

        @Override
        public Void call() throws Exception {
            if (JoinTask.this.halt) {
                throw new RuntimeException(JoinTask.this.firstCause.get());
            }
            ++JoinTask.this.stats.accessPathCount;
            if (this.accessPath.getPredicate() instanceof IStarJoin) {
                this.handleStarJoin();
            } else {
                this.handleJoin();
            }
            return null;
        }

        protected void handleJoin() {
            boolean nothingAccepted = true;
            try (IChunkedOrderedIterator<?> itr = this.accessPath.iterator();){
                AbstractUnsynchronizedArrayBuffer unsyncBuffer = (AbstractUnsynchronizedArrayBuffer)((ThreadLocalFactory)JoinTask.this.threadLocalBufferFactory).get();
                while (itr.hasNext()) {
                    Object[] chunk = itr.nextChunk();
                    ++JoinTask.this.stats.chunkCount;
                    boolean somethingAccepted = new ChunkTask(this.bindingSets, unsyncBuffer, chunk).call();
                    if (!somethingAccepted) continue;
                    nothingAccepted = false;
                }
                if (nothingAccepted && JoinTask.this.predicate.isOptional()) {
                    for (IBindingSet bs : this.bindingSets) {
                        unsyncBuffer.add(bs);
                    }
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void handleStarJoin() {
            IBindingSet[] solutions = this.bindingSets;
            IStarJoin starJoin = (IStarJoin)this.accessPath.getPredicate();
            AbstractUnsynchronizedArrayBuffer unsyncBuffer = (AbstractUnsynchronizedArrayBuffer)((ThreadLocalFactory)JoinTask.this.threadLocalBufferFactory).get();
            int numElements = 0;
            try (IChunkedOrderedIterator<?> itr = this.accessPath.iterator();){
                Object[] elements;
                int nchunks = 0;
                LinkedList<E[]> chunks = new LinkedList<E[]>();
                while (itr.hasNext()) {
                    E[] chunk = itr.nextChunk();
                    chunks.add(chunk);
                    numElements += chunk.length;
                    ++JoinTask.this.stats.chunkCount;
                    ++nchunks;
                }
                if (nchunks == 0) {
                    return;
                }
                if (nchunks == 1) {
                    elements = (Object[])chunks.get(0);
                } else {
                    elements = new Object[numElements];
                    int n = 0;
                    for (Object[] objectArray : chunks) {
                        System.arraycopy(objectArray, 0, elements, n, objectArray.length);
                        n += objectArray.length;
                    }
                }
                JoinTask.this.stats.elementCount += (long)numElements;
                if (numElements > 0) {
                    Iterator it = starJoin.getStarConstraints();
                    boolean constraintFailed = false;
                    while (it.hasNext()) {
                        IStarJoin.IStarConstraint<Object> constraint = it.next();
                        LinkedList<IBindingSet> constraintSolutions = null;
                        int n = constraint.getNumVars();
                        for (int i = 0; i < numElements; ++i) {
                            Object e = elements[i];
                            if (!constraint.isMatch(e)) continue;
                            if (constraintSolutions == null) {
                                constraintSolutions = new LinkedList<IBindingSet>();
                            }
                            for (IBindingSet bs : solutions) {
                                if (n > 0) {
                                    bs = bs.clone();
                                    constraint.bind(bs, e);
                                }
                                constraintSolutions.add(bs);
                            }
                            if (n == 0) break;
                        }
                        if (constraintSolutions == null) {
                            if (constraint.isOptional()) continue;
                            constraintFailed = true;
                            break;
                        }
                        solutions = constraintSolutions.toArray(new IBindingSet[constraintSolutions.size()]);
                    }
                    if (!constraintFailed) {
                        void var11_21;
                        IBindingSet[] arr$ = solutions;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var11_21 < len$) {
                            IBindingSet bs = arr$[var11_21];
                            unsyncBuffer.add(bs);
                            ++var11_21;
                        }
                    }
                }
                return;
            }
        }

        @Override
        public int compareTo(AccessPathTask o) {
            return BytesUtil.compareBytes((byte[])this.getFromKey(), (byte[])o.getFromKey());
        }
    }

    protected class BindingSetConsumerTask
    implements Callable<Void> {
        private final Executor executor;

        public BindingSetConsumerTask(Executor executor) {
            this.executor = executor;
        }

        @Override
        public Void call() throws Exception {
            try {
                IBindingSet[] chunk;
                if (DEBUG) {
                    log.debug((Object)("begin: orderIndex=" + JoinTask.this.orderIndex + ", partitionId=" + JoinTask.this.partitionId));
                }
                while (!JoinTask.this.halt && (chunk = JoinTask.this.nextChunk()) != null) {
                    if (DEBUG) {
                        log.debug((Object)("Read chunk of bindings: chunkSize=" + chunk.length + ", orderIndex=" + JoinTask.this.orderIndex + ", partitionId=" + JoinTask.this.partitionId));
                    }
                    Map<IPredicate<?>, Collection<IBindingSet>> map = this.combineBindingSets(chunk);
                    AccessPathTask[] tasks = this.getAccessPathTasks(map);
                    this.reorderTasks(tasks);
                    this.executeTasks(tasks);
                }
                if (JoinTask.this.halt) {
                    throw new RuntimeException(JoinTask.this.firstCause.get());
                }
                if (DEBUG) {
                    log.debug((Object)("done: orderIndex=" + JoinTask.this.orderIndex + ", partitionId=" + JoinTask.this.partitionId));
                }
                return null;
            }
            catch (Throwable t) {
                JoinTask.this.halt(t);
                throw new RuntimeException(t);
            }
        }

        protected Map<IPredicate<?>, Collection<IBindingSet>> combineBindingSets(IBindingSet[] chunk) {
            if (DEBUG) {
                log.debug((Object)("chunkSize=" + chunk.length));
            }
            int tailIndex = JoinTask.this.getTailIndex(JoinTask.this.orderIndex);
            LinkedHashMap map = new LinkedHashMap(chunk.length);
            for (IBindingSet bindingSet : chunk) {
                LinkedList<IBindingSet> values;
                if (JoinTask.this.halt) {
                    throw new RuntimeException(JoinTask.this.firstCause.get());
                }
                IPredicate predicate = JoinTask.this.rule.getTail(tailIndex).asBound(bindingSet);
                if (JoinTask.this.partitionId != -1) {
                    predicate = predicate.setPartitionId(JoinTask.this.partitionId);
                }
                if ((values = (LinkedList<IBindingSet>)map.get(predicate)) == null) {
                    values = new LinkedList<IBindingSet>();
                    map.put(predicate, values);
                } else {
                    ++JoinTask.this.stats.accessPathDups;
                }
                values.add(bindingSet);
            }
            if (DEBUG) {
                log.debug((Object)("chunkSize=" + chunk.length + ", #distinct predicates=" + map.size()));
            }
            return map;
        }

        protected AccessPathTask[] getAccessPathTasks(Map<IPredicate<?>, Collection<IBindingSet>> map) {
            int n = map.size();
            if (DEBUG) {
                log.debug((Object)("#distinct predicates=" + n));
            }
            AccessPathTask[] tasks = new AccessPathTask[n];
            Iterator<Map.Entry<IPredicate<?>, Collection<IBindingSet>>> itr = map.entrySet().iterator();
            int i = 0;
            while (itr.hasNext()) {
                if (JoinTask.this.halt) {
                    throw new RuntimeException(JoinTask.this.firstCause.get());
                }
                Map.Entry<IPredicate<?>, Collection<IBindingSet>> entry = itr.next();
                tasks[i++] = new AccessPathTask(entry.getKey(), entry.getValue());
            }
            return tasks;
        }

        protected void reorderTasks(AccessPathTask[] tasks) {
            if (tasks[0].accessPath instanceof AccessPath) {
                Arrays.sort(tasks);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        protected void executeTasks(AccessPathTask[] tasks) throws Exception {
            if (this.executor == null) {
                void var4_7;
                AccessPathTask[] arr$ = tasks;
                int len$ = arr$.length;
                boolean bl = false;
                while (var4_7 < len$) {
                    AccessPathTask task = arr$[var4_7];
                    task.call();
                    ++var4_7;
                }
                return;
            }
            LinkedList<FutureTask<Void>> futureTasks = new LinkedList<FutureTask<Void>>();
            for (AccessPathTask task : tasks) {
                FutureTask<Void> ft = new FutureTask<Void>(task);
                futureTasks.add(ft);
            }
            try {
                for (FutureTask futureTask : futureTasks) {
                    if (JoinTask.this.halt) {
                        throw new RuntimeException(JoinTask.this.firstCause.get());
                    }
                    this.executor.execute(futureTask);
                }
                for (FutureTask futureTask : futureTasks) {
                    if (JoinTask.this.halt) continue;
                    futureTask.get();
                }
            }
            finally {
                for (FutureTask futureTask : futureTasks) {
                    futureTask.cancel(true);
                }
            }
        }
    }

    public abstract class ThreadLocalFactory<T extends IBuffer<E>, E> {
        private final ConcurrentHashMap<Thread, T> map;
        private final LinkedList<T> list = new LinkedList();

        protected ThreadLocalFactory() {
            this(16, 0.75f, 16);
        }

        protected ThreadLocalFactory(int initialCapacity, float loadFactor, int concurrencyLevel) {
            this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        }

        public final int size() {
            return this.map.size();
        }

        public void add(E e) {
            this.get().add(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final T get() {
            Thread t = Thread.currentThread();
            IBuffer<Object> tmp = (IBuffer)this.map.get(t);
            if (tmp == null) {
                tmp = this.initialValue();
                if (this.map.put(t, tmp) != null) {
                    throw new AssertionError();
                }
                LinkedList<T> linkedList = this.list;
                synchronized (linkedList) {
                    this.list.add(tmp);
                }
            }
            if (JoinTask.this.halt) {
                throw new RuntimeException(JoinTask.this.firstCause.get());
            }
            return (T)tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            LinkedList<T> linkedList = this.list;
            synchronized (linkedList) {
                int n = 0;
                long m = 0L;
                for (IBuffer b : this.list) {
                    if (JoinTask.this.halt) {
                        throw new RuntimeException(JoinTask.this.firstCause.get());
                    }
                    int size = b.size();
                    long counter = b.flush();
                    m += counter;
                    if (!DEBUG) continue;
                    log.debug((Object)("Flushed buffer: size=" + size + ", counter=" + counter));
                }
                if (INFO) {
                    log.info((Object)("Flushed " + n + " unsynchronized buffers totalling " + m + " elements"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            LinkedList<T> linkedList = this.list;
            synchronized (linkedList) {
                int n = 0;
                for (IBuffer b : this.list) {
                    int size = b.size();
                    b.reset();
                    if (!DEBUG) continue;
                    log.debug((Object)("Reset buffer: size=" + size));
                }
                if (INFO) {
                    log.info((Object)("Reset " + n + " unsynchronized buffers"));
                }
            }
        }

        protected abstract T initialValue();
    }
}

