/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.rdf.sparql.ast.service.SPARQLVersion;
import com.bigdata.rdf.sparql.ast.service.ServiceOptionsBase;

public class RemoteServiceOptions
extends ServiceOptionsBase {
    private static final boolean DEFAULT_IS_GET = false;
    private SPARQLVersion sparqlVersion = SPARQLVersion.SPARQL_11;
    private boolean isGET = false;
    private String acceptStr = null;

    @Override
    public final boolean isBigdataNativeService() {
        return false;
    }

    @Override
    public final boolean isRemoteService() {
        return true;
    }

    @Override
    public boolean isSparql10() {
        return this.getSPARQLVersion().equals((Object)SPARQLVersion.SPARQL_10);
    }

    public boolean isGET() {
        return this.isGET;
    }

    public void setGET(boolean newValue) {
        this.isGET = newValue;
    }

    public String getAcceptHeader() {
        return this.acceptStr;
    }

    public void setAcceptHeader(String newValue) {
        this.acceptStr = newValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{SPARQLVersion=" + (Object)((Object)this.getSPARQLVersion()));
        sb.append(",GET=" + this.isGET());
        sb.append(",Accept=" + this.getAcceptHeader());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public SPARQLVersion getSPARQLVersion() {
        return this.sparqlVersion;
    }

    public void setSPARQLVersion(SPARQLVersion sparqlVersion) {
        if (sparqlVersion == null) {
            throw new IllegalArgumentException("SPARQL version value must not be null");
        }
        this.sparqlVersion = sparqlVersion;
    }
}

