/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class ServiceParams {
    private static final Logger log = Logger.getLogger(AbstractServiceFactory.class);
    private final Map<URI, List<TermNode>> params = new LinkedHashMap<URI, List<TermNode>>();

    public void add(URI param, TermNode value) {
        if (!this.params.containsKey(param)) {
            this.params.put(param, new LinkedList());
        }
        this.params.get(param).add(value);
    }

    public void set(URI param, TermNode value) {
        this.clear(param);
        this.add(param, value);
    }

    public void clear(URI param) {
        this.params.remove(param);
    }

    public boolean contains(URI param) {
        return this.params.containsKey(param);
    }

    public TermNode get(URI param, TermNode defaultValue) {
        if (this.params.containsKey(param)) {
            List<TermNode> values = this.params.get(param);
            if (values.size() > 1) {
                throw new RuntimeException("not a singleton param");
            }
            return values.get(0);
        }
        return defaultValue;
    }

    public Boolean getAsBoolean(URI param) {
        return this.getAsBoolean(param, null);
    }

    public Boolean getAsBoolean(URI param, Boolean defaultValue) {
        Literal term = this.getAsLiteral(param, null);
        if (term != null) {
            return term.booleanValue();
        }
        return defaultValue;
    }

    public Integer getAsInt(URI param) {
        return this.getAsInt(param, null);
    }

    public Integer getAsInt(URI param, Integer defaultValue) {
        Literal term = this.getAsLiteral(param, null);
        if (term != null) {
            return term.intValue();
        }
        return defaultValue;
    }

    public Long getAsLong(URI param) {
        return this.getAsLong(param, null);
    }

    public Long getAsLong(URI param, Long defaultValue) {
        Literal term = this.getAsLiteral(param, null);
        if (term != null) {
            return term.longValue();
        }
        return defaultValue;
    }

    public String getAsString(URI param) {
        return this.getAsString(param, null);
    }

    public String getAsString(URI param, String defaultValue) {
        Literal term = this.getAsLiteral(param, null);
        if (term != null) {
            return term.stringValue();
        }
        return defaultValue;
    }

    public Literal getAsLiteral(URI param) {
        return this.getAsLiteral(param, null);
    }

    public Literal getAsLiteral(URI param, Literal defaultValue) {
        TermNode term = this.get(param, null);
        if (term != null) {
            if (term.isVariable()) {
                throw new IllegalArgumentException("not a constant");
            }
            BigdataValue v = term.getValue();
            if (!(v instanceof Literal)) {
                throw new IllegalArgumentException("not a literal");
            }
            return (Literal)v;
        }
        return defaultValue;
    }

    public URI getAsURI(URI param) {
        return this.getAsURI(param, null);
    }

    public URI getAsURI(URI param, URI defaultValue) {
        TermNode term = this.get(param, null);
        if (term != null) {
            if (term.isVariable()) {
                throw new IllegalArgumentException("not a constant");
            }
            BigdataValue v = term.getValue();
            if (!(v instanceof URI)) {
                throw new IllegalArgumentException("not a uri");
            }
            return (URI)v;
        }
        return defaultValue;
    }

    public IVariable<IV> getAsVar(URI param) {
        return this.getAsVar(param, null);
    }

    public IVariable<IV> getAsVar(URI param, IVariable<IV> defaultValue) {
        TermNode term = this.get(param, null);
        if (term != null) {
            if (!term.isVariable()) {
                throw new IllegalArgumentException("not a var");
            }
            return (IVariable)term.getValueExpression();
        }
        return defaultValue;
    }

    public List<TermNode> get(URI param) {
        if (this.params.containsKey(param)) {
            return this.params.get(param);
        }
        return Collections.emptyList();
    }

    public Iterator<Map.Entry<URI, List<TermNode>>> iterator() {
        return this.params.entrySet().iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<URI, List<TermNode>> e : this.params.entrySet()) {
            URI param = e.getKey();
            List<TermNode> terms = e.getValue();
            sb.append(param).append(": ");
            if (terms.size() == 1) {
                sb.append(terms.get(0));
            } else {
                sb.append("[");
                for (TermNode t : terms) {
                    sb.append(t).append(", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("]");
            }
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("]");
        return sb.toString();
    }

    public static ServiceParams gatherServiceParams(ServiceCallCreateParams createParams) {
        if (createParams == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = createParams.getTripleStore();
        if (store == null) {
            throw new IllegalArgumentException();
        }
        ServiceNode serviceNode = createParams.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        GraphPatternGroup<IGroupMemberNode> group = serviceNode.getGraphPattern();
        if (group == null) {
            throw new IllegalArgumentException();
        }
        ServiceParams serviceParams = new ServiceParams();
        for (IGroupMemberNode node : group) {
            StatementPatternNode sp;
            TermNode s;
            if (!(node instanceof StatementPatternNode) || !(s = (sp = (StatementPatternNode)node).s()).isConstant() || !BD.SERVICE_PARAM.equals((Object)s.getValue())) continue;
            if (sp.p().isVariable()) {
                throw new RuntimeException("not a valid service param triple pattern, predicate must be constant: " + sp);
            }
            URI param = (URI)sp.p().getValue();
            serviceParams.add(param, sp.o());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)serviceParams);
        }
        return serviceParams;
    }
}

