/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.constraint.BooleanValueExpression;
import com.bigdata.bop.constraint.Constraint;
import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlanFactory2;
import com.bigdata.btree.IIndex;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.QueryOptions;
import com.bigdata.relation.rule.Rule;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class OwlSameAsPropertiesExpandingIterator
implements IChunkedOrderedIterator<ISPO> {
    protected static final Logger log = Logger.getLogger(OwlSameAsPropertiesExpandingIterator.class);
    private final IChunkedOrderedIterator<ISPO> src;
    private final IKeyOrder<ISPO> keyOrder;
    private final IV s;
    private final IV p;
    private final IV o;
    private final AbstractTripleStore db;
    private final IV sameAs;
    private IChunkedOrderedIterator<ISolution> solutions;
    private IAccessPathExpander<ISPO> sameAsSelfExpander;
    private ISPO[] chunk;
    private int i;

    public OwlSameAsPropertiesExpandingIterator(IV s, IV p, IV o, AbstractTripleStore db, IV sameAs, IKeyOrder<ISPO> keyOrder) {
        block8: {
            this.i = 0;
            this.db = db;
            this.s = s;
            this.p = p;
            this.o = o;
            this.sameAs = sameAs;
            this.keyOrder = keyOrder;
            this.sameAsSelfExpander = new SameAsSelfExpander();
            if (p == sameAs) {
                this.src = db.getAccessPath(s, p, o).iterator();
            } else {
                this.src = null;
                try {
                    if (s != null && o != null) {
                        this.accessSPO();
                        break block8;
                    }
                    if (s != null && o == null) {
                        this.accessSP();
                        break block8;
                    }
                    if (s == null && o != null) {
                        this.accessPO();
                        break block8;
                    }
                    if (s == null && o == null) {
                        this.accessP();
                        break block8;
                    }
                    throw new AssertionError();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private void accessSPO() throws Exception {
        String SPO2 = this.db.getSPORelation().getNamespace();
        Var _sameS = Var.var("sameS");
        Var _sameO = Var.var("sameO");
        Constant<IV> sameAs = new Constant<IV>(this.sameAs);
        Constant<IV> s = new Constant<IV>(this.s);
        Constant<IV> o = new Constant<IV>(this.o);
        IVariableOrConstant _p = (IVariableOrConstant)(this.p != null ? new Constant<IV>(this.p) : Var.var("p"));
        SPOPredicate head = new SPOPredicate(SPO2, (IVariableOrConstant<IV>)s, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)o);
        Rule rule = new Rule("sameAsSPO", head, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameS, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)s, this.sameAsSelfExpander), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameO, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)o, this.sameAsSelfExpander), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameS, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)_sameO)}, QueryOptions.DISTINCT, new IConstraint[]{Constraint.wrap(new RejectSameAsSelf(head.s(), head.p(), head.o()))});
        this.runQuery(rule);
    }

    private void accessSP() throws Exception {
        String SPO2 = this.db.getSPORelation().getNamespace();
        Var _sameS = Var.var("sameS");
        Var _sameO = Var.var("sameO");
        Constant<IV> sameAs = new Constant<IV>(this.sameAs);
        Constant<IV> s = new Constant<IV>(this.s);
        Var _o = Var.var("o");
        IVariableOrConstant _p = (IVariableOrConstant)(this.p != null ? new Constant<IV>(this.p) : Var.var("p"));
        SPOPredicate head = new SPOPredicate(SPO2, (IVariableOrConstant<IV>)s, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)_sameO);
        Rule rule = new Rule("sameAsSP", head, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameS, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)s, this.sameAsSelfExpander), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameS, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)_o), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_o, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)_sameO, true, this.sameAsSelfExpander)}, QueryOptions.DISTINCT, new IConstraint[]{Constraint.wrap(new RejectSameAsSelf(head.s(), head.p(), head.o()))});
        this.runQuery(rule);
    }

    private void accessPO() throws Exception {
        String SPO2 = this.db.getSPORelation().getNamespace();
        Var _sameS = Var.var("sameS");
        Var _sameO = Var.var("sameO");
        Constant<IV> sameAs = new Constant<IV>(this.sameAs);
        Var _s = Var.var("s");
        Constant<IV> o = new Constant<IV>(this.o);
        IVariableOrConstant _p = (IVariableOrConstant)(this.p != null ? new Constant<IV>(this.p) : Var.var("p"));
        SPOPredicate head = new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameS, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)o);
        Rule rule = new Rule("sameAsPO", head, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameO, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)o, this.sameAsSelfExpander), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_s, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)_sameO), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_s, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)_sameS, true, this.sameAsSelfExpander)}, QueryOptions.DISTINCT, new IConstraint[]{Constraint.wrap(new RejectSameAsSelf(head.s(), head.p(), head.o()))});
        this.runQuery(rule);
    }

    private void accessP() throws Exception {
        String SPO2 = this.db.getSPORelation().getNamespace();
        Var _sameS = Var.var("sameS");
        Var _sameO = Var.var("sameO");
        Constant<IV> sameAs = new Constant<IV>(this.sameAs);
        Var _s = Var.var("s");
        Var _o = Var.var("o");
        IVariableOrConstant _p = (IVariableOrConstant)(this.p != null ? new Constant<IV>(this.p) : Var.var("p"));
        SPOPredicate head = new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameS, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)_sameO);
        Rule rule = new Rule("sameAsP", head, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameS, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)_s, true, this.sameAsSelfExpander), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_sameO, (IVariableOrConstant<IV>)sameAs, (IVariableOrConstant<IV>)_o, true, this.sameAsSelfExpander), new SPOPredicate(SPO2, (IVariableOrConstant<IV>)_s, (IVariableOrConstant<IV>)_p, (IVariableOrConstant<IV>)_o)}, QueryOptions.DISTINCT, new IConstraint[]{Constraint.wrap(new RejectSameAsSelf(head.s(), head.p(), head.o()))});
        this.runQuery(rule);
    }

    private void runQuery(IRule rule) throws Exception {
        DefaultEvaluationPlanFactory2 planFactory = DefaultEvaluationPlanFactory2.INSTANCE;
        IJoinNexusFactory joinNexusFactory = this.db.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 1, null, false, false, planFactory);
        IJoinNexus joinNexus = joinNexusFactory.newInstance(this.db.getIndexManager());
        if (log.isInfoEnabled()) {
            IEvaluationPlan plan = planFactory.newPlan(joinNexus, rule);
            StringBuilder sb = new StringBuilder();
            int[] order = plan.getOrder();
            for (int i = 0; i < order.length; ++i) {
                sb.append(order[i]);
                if (i >= order.length - 1) continue;
                sb.append(",");
            }
            log.info((Object)("order: [" + sb.toString() + "]"));
        }
        this.solutions = joinNexus.runQuery(rule);
    }

    @Override
    public IKeyOrder<ISPO> getKeyOrder() {
        if (this.src != null) {
            return this.src.getKeyOrder();
        }
        return this.keyOrder;
    }

    public ISPO[] nextChunk() {
        if (this.src != null) {
            return (ISPO[])this.src.nextChunk();
        }
        int chunkSize = 10000;
        ISPO[] s = new ISPO[10000];
        int n = 0;
        while (this.hasNext() && n < 10000) {
            ISolution solution = (ISolution)this.solutions.next();
            ISPO spo = (ISPO)solution.get();
            spo = new SPO(spo.s(), spo.p(), spo.o());
            s[n++] = spo;
        }
        ISPO[] stmts = new ISPO[n];
        System.arraycopy(s, 0, stmts, 0, n);
        stmts = this.db.bulkCompleteStatements(stmts);
        Arrays.sort(stmts, 0, n, this.keyOrder.getComparator());
        return stmts;
    }

    public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
        if (this.src != null) {
            return this.src.nextChunk(keyOrder);
        }
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] stmts = this.nextChunk();
        if (this.keyOrder != keyOrder) {
            Arrays.sort(stmts, 0, stmts.length, keyOrder.getComparator());
        }
        return stmts;
    }

    @Override
    public ISPO next() {
        if (this.src != null) {
            return (ISPO)this.src.next();
        }
        if (this.chunk == null || this.i == this.chunk.length) {
            this.chunk = this.nextChunk();
            this.i = 0;
            if (log.isInfoEnabled()) {
                log.info((Object)("got a chunk, length = " + this.chunk.length));
            }
        }
        return this.chunk[this.i++];
    }

    @Override
    public void remove() {
        if (this.src != null) {
            this.src.remove();
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.src != null) {
            this.src.close();
            return;
        }
        if (this.solutions != null) {
            this.solutions.close();
        }
    }

    public boolean hasNext() {
        if (this.src != null) {
            return this.src.hasNext();
        }
        if (this.chunk != null) {
            return this.i < this.chunk.length;
        }
        if (this.solutions != null) {
            return this.solutions.hasNext();
        }
        return false;
    }

    private class RejectSameAsSelf
    extends BOpBase
    implements BooleanValueExpression {
        private static final long serialVersionUID = -7877904606067597254L;

        public RejectSameAsSelf(IVariableOrConstant<IV> _s, IVariableOrConstant<IV> _p, IVariableOrConstant<IV> _o) {
            super(new BOp[]{_s, _p, _o}, null);
        }

        @Override
        public Boolean get(IBindingSet bindings) {
            IV sVal = this.getValue((IVariableOrConstant<IV>)((IVariableOrConstant)this.get(0)), bindings);
            IV pVal = this.getValue((IVariableOrConstant<IV>)((IVariableOrConstant)this.get(1)), bindings);
            IV oVal = this.getValue((IVariableOrConstant<IV>)((IVariableOrConstant)this.get(2)), bindings);
            if (sVal == null || pVal == null || oVal == null) {
                return true;
            }
            if (IVUtility.equals(pVal, OwlSameAsPropertiesExpandingIterator.this.sameAs) && IVUtility.equals(sVal, oVal)) {
                return false;
            }
            return true;
        }

        private IV getValue(IVariableOrConstant<IV> _x, IBindingSet bindings) {
            IConstant bound;
            IV val = _x.isConstant() ? (IV)_x.get() : ((bound = bindings.get((IVariable)_x)) != null ? (IV)bound.get() : null);
            return val;
        }
    }

    private class SameAsSelfAccessPath
    implements IAccessPath<ISPO> {
        private IAccessPath<ISPO> accessPath;
        private SPO spo;

        public SameAsSelfAccessPath(IAccessPath<ISPO> accessPath) {
            this.accessPath = accessPath;
            IVariableOrConstant p = accessPath.getPredicate().get(1);
            if (!p.isConstant() || !IVUtility.equals((IV)p.get(), OwlSameAsPropertiesExpandingIterator.this.sameAs)) {
                throw new UnsupportedOperationException("p must be owl:sameAs");
            }
        }

        private IChunkedOrderedIterator<ISPO> getAppender() {
            IVariableOrConstant s = this.accessPath.getPredicate().get(0);
            IVariableOrConstant o = this.accessPath.getPredicate().get(2);
            if (s.isVar() && o.isVar()) {
                throw new UnsupportedOperationException("s and o cannot both be variables");
            }
            if (s.isConstant() && o.isConstant() && !((IV)s.get()).equals(o.get())) {
                this.spo = null;
            } else {
                IV constant = s.isConstant() ? (IV)s.get() : (IV)o.get();
                SPO sPO = this.spo = s.isConstant() ? new SPO((IV)s.get(), OwlSameAsPropertiesExpandingIterator.this.sameAs, constant) : new SPO(constant, OwlSameAsPropertiesExpandingIterator.this.sameAs, (IV)o.get());
                if (log.isInfoEnabled()) {
                    log.info((Object)("appending SPO: " + this.spo.toString(OwlSameAsPropertiesExpandingIterator.this.db)));
                }
            }
            if (this.spo != null) {
                return new ChunkedArrayIterator<ISPO>(1, new SPO[]{this.spo}, SPOKeyOrder.SPO);
            }
            return null;
        }

        @Override
        public IIndex getIndex() {
            return this.accessPath.getIndex();
        }

        @Override
        public IKeyOrder<ISPO> getKeyOrder() {
            return this.accessPath.getKeyOrder();
        }

        @Override
        public IPredicate<ISPO> getPredicate() {
            return this.accessPath.getPredicate();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public IChunkedOrderedIterator<ISPO> iterator() {
            final IChunkedOrderedIterator<ISPO> appender = this.getAppender();
            final IChunkedOrderedIterator<ISPO> delegate = this.accessPath.iterator();
            if (appender == null) {
                return delegate;
            }
            return new IChunkedOrderedIterator<ISPO>(){

                @Override
                public ISPO next() {
                    if (delegate.hasNext()) {
                        return (ISPO)delegate.next();
                    }
                    return (ISPO)appender.next();
                }

                public ISPO[] nextChunk() {
                    if (delegate.hasNext()) {
                        return (ISPO[])delegate.nextChunk();
                    }
                    return (ISPO[])appender.nextChunk();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return delegate.hasNext() || appender.hasNext();
                }

                @Override
                public IKeyOrder<ISPO> getKeyOrder() {
                    return delegate.getKeyOrder();
                }

                public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
                    if (delegate.hasNext()) {
                        return delegate.nextChunk(keyOrder);
                    }
                    return appender.nextChunk(keyOrder);
                }

                public void close() {
                    delegate.close();
                    appender.close();
                }
            };
        }

        @Override
        public IChunkedOrderedIterator<ISPO> iterator(long offset, long limit, int capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long rangeCount(boolean exact) {
            return this.accessPath.rangeCount(exact) + 1L;
        }

        @Override
        public long removeAll() {
            throw new UnsupportedOperationException();
        }
    }

    private class SameAsSelfExpander
    implements IAccessPathExpander<ISPO> {
        private SameAsSelfExpander() {
        }

        @Override
        public boolean backchain() {
            return false;
        }

        @Override
        public boolean runFirst() {
            return false;
        }

        @Override
        public IAccessPath<ISPO> getAccessPath(IAccessPath<ISPO> accessPath) {
            return new SameAsSelfAccessPath(accessPath);
        }
    }
}

