/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.compression;

import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.LongPacker;
import com.bigdata.io.SliceInputStream;
import com.bigdata.io.compression.IUnicodeCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UnicodeHelper {
    private final IUnicodeCompressor uc;

    public UnicodeHelper(IUnicodeCompressor uc) {
        if (uc == null) {
            throw new IllegalArgumentException();
        }
        this.uc = uc;
    }

    public int encode(String s, OutputStream out, ByteArrayBuffer tmp) throws IOException {
        tmp.reset();
        int nencoded = this.uc.encode(s, tmp);
        int len = tmp.pos();
        out.write(tmp.array(), 0, len);
        return nencoded += LongPacker.packLong(out, (long)len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode1(String s) {
        ByteArrayBuffer tmp = new ByteArrayBuffer(s.length());
        int nwritten = this.uc.encode(s, tmp);
        int npack = LongPacker.getByteLength(nwritten);
        byte[] a = new byte[npack + nwritten];
        DataOutputBuffer dob = new DataOutputBuffer(0, a);
        try {
            dob.packLong(nwritten);
            dob.append(tmp.array(), 0, tmp.pos());
            byte[] byArray = a;
            return byArray;
        }
        finally {
            try {
                dob.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int decode(InputStream in, StringBuilder out) throws IOException {
        long n = LongPacker.unpackLong(in);
        if (n > Integer.MAX_VALUE) {
            throw new IOException();
        }
        int ndecoded = LongPacker.getByteLength(n);
        out.ensureCapacity((int)n + out.length());
        return ndecoded += this.uc.decode(new SliceInputStream(in, (int)n), out);
    }

    public String decode1(DataInputBuffer in, StringBuilder tmp) throws IOException {
        tmp.setLength(0);
        this.decode(in, tmp);
        return tmp.toString();
    }
}

