/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BaseIndexStats;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.IDirtyListener;
import com.bigdata.btree.IIndexLocalCounter;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.ReadOnlyCounter;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.htree.AbstractPage;
import com.bigdata.htree.BucketPage;
import com.bigdata.htree.Counter;
import com.bigdata.htree.DirectoryPage;
import com.bigdata.htree.HTreePageStats;
import com.bigdata.htree.HTreeUtil;
import com.bigdata.htree.MutableDirectoryPageData;
import com.bigdata.htree.NodeFactory;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.SerializerUtil;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.util.BytesUtil;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class HTree
extends AbstractHTree
implements IIndexLocalCounter {
    final int splitBits = 1;
    final boolean versionTimestamps = false;
    final boolean deleteMarkers = false;
    final boolean rawRecords;
    protected long nnodes;
    protected long nleaves;
    protected long nentries;
    protected long recordVersion;
    protected AtomicLong counter;
    private final ByteArrayBuffer recordAddrBuf;
    private Checkpoint checkpoint = null;
    private volatile long lastCommitTime = 0L;
    private IDirtyListener listener;

    @Override
    public final long getNodeCount() {
        return this.nnodes;
    }

    @Override
    public final long getLeafCount() {
        return this.nleaves;
    }

    @Override
    public final long getEntryCount() {
        return this.nentries;
    }

    @Override
    public final Checkpoint getCheckpoint() {
        if (this.checkpoint == null) {
            throw new AssertionError();
        }
        return this.checkpoint;
    }

    @Override
    public final long getRecordVersion() {
        return this.recordVersion;
    }

    @Override
    public final long getMetadataAddr() {
        return this.metadata.getMetadataAddr();
    }

    @Override
    public final long getRootAddr() {
        return this.root == null ? this.getCheckpoint().getRootAddr() : this.root.getIdentity();
    }

    public boolean needsCheckpoint() {
        if (!this.checkpoint.hasCheckpointAddr()) {
            return true;
        }
        if (this.metadata.getMetadataAddr() == 0L) {
            return true;
        }
        if (this.metadata.getMetadataAddr() != this.checkpoint.getMetadataAddr()) {
            return true;
        }
        if (this.checkpoint.getCounter() != this.counter.get()) {
            return true;
        }
        if (this.root != null) {
            if (this.root.isDirty()) {
                return true;
            }
            if (this.checkpoint.getRootAddr() != this.root.getIdentity()) {
                return true;
            }
        }
        return false;
    }

    public final void setIndexMetadata(HTreeIndexMetadata indexMetadata) {
        this.assertNotReadOnly();
        if (indexMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (indexMetadata.getMetadataAddr() != 0L) {
            throw new IllegalArgumentException();
        }
        this.metadata = indexMetadata;
        this.fireDirtyEvent();
    }

    @Override
    public long handleCommit(long commitTime) {
        return this.writeCheckpoint2().getCheckpointAddr();
    }

    @Override
    public void invalidate(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (this.error == null) {
            this.error = t;
        }
    }

    @Override
    public ICounter getCounter() {
        Counter counter = new Counter(this);
        LocalPartitionMetadata pmd = this.metadata.getPartitionMetadata();
        if (pmd != null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            return new ReadOnlyCounter(counter);
        }
        return counter;
    }

    public HTree(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, NodeFactory.INSTANCE, readOnly, (HTreeIndexMetadata)metadata, metadata.getBtreeRecordCompressorFactory());
        if (checkpoint == null) {
            throw new IllegalArgumentException();
        }
        if (store != null && checkpoint.getMetadataAddr() != metadata.getMetadataAddr()) {
            throw new IllegalArgumentException();
        }
        if (metadata.getConflictResolver() != null && !metadata.isIsolatable()) {
            throw new IllegalArgumentException("Conflict resolver may only be used with isolatable indices");
        }
        this.setCheckpoint(checkpoint);
        assert (readOnly || this.writeRetentionQueue.capacity() >= 2);
        this.recordAddrBuf = readOnly ? null : new ByteArrayBuffer(8);
        this.rawRecords = metadata.getRawRecords();
    }

    byte[] encodeRecordAddr(long addr) {
        return AbstractBTree.encodeRecordAddr(this.recordAddrBuf, addr);
    }

    protected void setCheckpoint(Checkpoint checkpoint) {
        this.checkpoint = checkpoint;
        this.nnodes = checkpoint.getNodeCount();
        this.nleaves = checkpoint.getLeafCount();
        this.nentries = checkpoint.getEntryCount();
        this.counter = new AtomicLong(checkpoint.getCounter());
        this.recordVersion = checkpoint.getRecordVersion();
    }

    private final void newRoot() {
        this.nnodes = 0L;
        this.nentries = 0L;
        boolean wasDirty = this.root != null && this.root.isDirty();
        this.nleaves = 0L;
        DirectoryPage r = new DirectoryPage(this, null, this.addressBits);
        ++this.nnodes;
        assert (r.getSlotsPerBuddy() == 1 << this.addressBits) : "slotsPerBuddy=" + r.getSlotsPerBuddy();
        assert (r.getNumBuddies() == 1) : "numBuddies=" + r.getNumBuddies();
        MutableDirectoryPageData rdata = (MutableDirectoryPageData)r.data;
        BucketPage b = new BucketPage(this, 0);
        ++this.nleaves;
        int nslots = r.getSlotsPerBuddy() * r.getNumBuddies();
        for (int i = 0; i < nslots; ++i) {
            b.parent = r.self;
            r.childRefs[i] = b.self;
            rdata.childAddr[i] = 0L;
        }
        this.root = r;
        if (!wasDirty && !this.readOnly) {
            this.fireDirtyEvent();
        }
    }

    @Override
    protected void _reopen() {
        if (this.checkpoint.getRootAddr() == 0L) {
            this.newRoot();
        } else {
            this.root = (DirectoryPage)this.readNodeOrLeaf(this.checkpoint.getRootAddr());
            this.root.globalDepth = this.addressBits;
        }
    }

    @Override
    public final long getLastCommitTime() {
        return this.lastCommitTime;
    }

    public final long getRevisionTimestamp() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Read-only");
        }
        return this.lastCommitTime + 1L;
    }

    @Override
    public final void setLastCommitTime(long lastCommitTime) {
        if (lastCommitTime == 0L) {
            throw new IllegalArgumentException();
        }
        if (this.lastCommitTime == lastCommitTime) {
            return;
        }
        if (INFO) {
            log.info((Object)("old=" + this.lastCommitTime + ", new=" + lastCommitTime));
        }
        this.lastCommitTime = lastCommitTime;
    }

    @Override
    public final IDirtyListener getDirtyListener() {
        return this.listener;
    }

    @Override
    public final void setDirtyListener(IDirtyListener listener) {
        this.assertNotReadOnly();
        this.listener = listener;
    }

    protected final void fireDirtyEvent() {
        this.assertNotReadOnly();
        IDirtyListener l = this.listener;
        if (l == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        l.dirtyEvent(this);
    }

    public final boolean flush() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        if (this.root != null && this.root.isDirty()) {
            this.writeNodeRecursive(this.root);
            if (INFO) {
                log.info((Object)("flushed root: addr=" + this.root.getIdentity()));
            }
            return true;
        }
        return false;
    }

    public HTree asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        if (this.needsCheckpoint()) {
            throw new IllegalStateException();
        }
        return HTree.load(this.store, this.checkpoint.getCheckpointAddr(), true);
    }

    @Override
    public final long writeCheckpoint() {
        return this.writeCheckpoint2().getCheckpointAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Checkpoint writeCheckpoint2() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        Lock lock = this.writeLock();
        lock.lock();
        try {
            if (this.error != null) {
                throw new IllegalStateException("Index is in error state", this.error);
            }
            if (this.needsCheckpoint()) {
                Checkpoint checkpoint = this._writeCheckpoint2();
                return checkpoint;
            }
            Checkpoint checkpoint = this.checkpoint;
            return checkpoint;
        }
        finally {
            lock.unlock();
        }
    }

    private final Checkpoint _writeCheckpoint2() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        this.flush();
        assert (this.root == null || !this.root.isDirty());
        if (this.metadata.getMetadataAddr() == 0L) {
            long addr;
            if (this.checkpoint != null && (addr = this.checkpoint.getMetadataAddr()) != 0L) {
                this.store.delete(addr);
            }
            this.metadata.write(this.store);
        }
        if (this.checkpoint != null && this.getRoot() != null && this.checkpoint.getRootAddr() != this.getRoot().getIdentity()) {
            this.recycle(this.checkpoint.getRootAddr());
        }
        if (this.checkpoint != null) {
            this.recycle(this.checkpoint.getCheckpointAddr());
        }
        this.checkpoint = this.newCheckpoint();
        this.checkpoint.write(this.store);
        if (BigdataStatics.debug || INFO) {
            String msg = "name=" + this.metadata.getName() + ", writeQueue{size=" + this.writeRetentionQueue.size() + ",distinct=" + this.ndistinctOnWriteRetentionQueue + "} : " + this.checkpoint;
            if (BigdataStatics.debug) {
                System.err.println(msg);
            }
            if (INFO) {
                log.info((Object)msg);
            }
        }
        return this.checkpoint;
    }

    private final Checkpoint newCheckpoint() {
        try {
            Class<?> cl = Class.forName(this.metadata.getCheckpointClassName());
            Constructor<?> ctor = cl.getConstructor(HTree.class);
            Checkpoint checkpoint = (Checkpoint)ctor.newInstance(this);
            return checkpoint;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private byte[] i2k(int key) {
        int v = key;
        v = v < 0 ? (v -= Integer.MIN_VALUE) : Integer.MIN_VALUE + v;
        byte[] buf = new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return buf;
    }

    public boolean contains(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(int key) {
        return this.contains(this.i2k(key));
    }

    public boolean contains(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        DirectoryPage current = this.getRoot();
        int prefixLength = 0;
        int buddyOffset = 0;
        int hashBits;
        AbstractPage child;
        while ((child = current.getChildIfPresent(hashBits = current.getLocalHashCode(key, prefixLength))) != null) {
            if (child.isLeaf()) {
                BucketPage bucketPage = (BucketPage)child;
                return bucketPage.contains(key, buddyOffset);
            }
            prefixLength += current.globalDepth;
            buddyOffset = HTreeUtil.getBuddyOffset(hashBits, current.globalDepth, child.globalDepth);
            current = (DirectoryPage)child;
        }
        return false;
    }

    public byte[] lookupFirst(int key) {
        return this.lookupFirst(this.i2k(key));
    }

    public byte[] lookupFirst(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        DirectoryPage current = this.getRoot();
        int prefixLength = 0;
        int buddyOffset = 0;
        int hashBits;
        AbstractPage child;
        while ((child = current.getChildIfPresent(hashBits = current.getLocalHashCode(key, prefixLength))) != null) {
            if (child.isLeaf()) {
                BucketPage bucketPage = (BucketPage)child;
                return bucketPage.lookupFirst(key, buddyOffset);
            }
            prefixLength += current.globalDepth;
            buddyOffset = HTreeUtil.getBuddyOffset(hashBits, current.globalDepth, child.globalDepth);
            current = (DirectoryPage)child;
        }
        return null;
    }

    public ITupleIterator lookupAll(int key) {
        return this.lookupAll(this.i2k(key));
    }

    public ITupleIterator lookupAll(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        DirectoryPage current = this.getRoot();
        int prefixLength = 0;
        int buddyOffset = 0;
        int hashBits;
        AbstractPage child;
        while ((child = current.getChildIfPresent(hashBits = current.getLocalHashCode(key, prefixLength))) != null) {
            if (child.isLeaf()) {
                BucketPage bucketPage = (BucketPage)child;
                return bucketPage.lookupAll(key);
            }
            if (((DirectoryPage)child).isOverflowDirectory()) {
                return ((DirectoryPage)child).getTuples();
            }
            prefixLength += current.globalDepth;
            buddyOffset = HTreeUtil.getBuddyOffset(hashBits, current.globalDepth, child.globalDepth);
            current = (DirectoryPage)child;
        }
        return this.emptyTupleIterator();
    }

    private ITupleIterator emptyTupleIterator() {
        return new ITupleIterator(){

            @Override
            public ITuple next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void insert(Object obj) {
        this.insert(obj.hashCode(), SerializerUtil.serialize(obj));
    }

    public void insert(int key, byte[] val) {
        this.insert(this.i2k(key), val);
    }

    public byte[] insert(byte[] key, byte[] value) {
        if (DEBUG) {
            log.debug((Object)("key=" + BytesUtil.toString((byte[])key) + ", value=" + Arrays.toString(value)));
        }
        if (key == null) {
            throw new IllegalArgumentException();
        }
        DirectoryPage current = this.getRoot();
        int prefixLength = 0;
        int buddyOffset = 0;
        while (true) {
            AbstractPage child;
            assert (prefixLength < key.length * 8 || current.isOverflowDirectory());
            int hashBits = current.getLocalHashCode(key, prefixLength);
            if (current.isOverflowDirectory()) {
                if (!BytesUtil.bytesEqual((byte[])key, (byte[])current.getOverflowKey())) {
                    DirectoryPage pd = current.getParentDirectory();
                    assert (!pd.isOverflowDirectory());
                    assert (!pd.isReadOnly() || current.isReadOnly());
                    current = pd._addLevelForOverflow(current);
                    child = current;
                    prefixLength -= current.globalDepth;
                } else {
                    child = current.lastChild();
                }
            } else {
                child = current.getChild(hashBits, buddyOffset);
            }
            if (child.isLeaf()) {
                BucketPage bucketPage = (BucketPage)child.copyOnWrite();
                if (!bucketPage.insert(key, value)) {
                    if (current.globalDepth == child.globalDepth) {
                        if (child.globalDepth == this.addressBits) {
                            bucketPage.addLevel();
                        } else {
                            current.getParentDirectory().split(buddyOffset, current);
                        }
                    } else {
                        bucketPage.split();
                    }
                    return this.insert(key, value);
                }
                return null;
            }
            prefixLength += current.globalDepth;
            buddyOffset = HTreeUtil.getBuddyOffset(hashBits, current.globalDepth, child.globalDepth);
            current = (DirectoryPage)child;
        }
    }

    protected void insertRawTuple(BucketPage src, int slot) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (slot < 0 || slot >= 1 << this.addressBits) {
            throw new IllegalArgumentException();
        }
        byte[] key = src.getKeys().get(slot);
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (DEBUG) {
            log.debug((Object)("key=" + BytesUtil.toString((byte[])key)));
        }
        DirectoryPage current = this.getRoot();
        int prefixLength = 0;
        int buddyOffset = 0;
        while (true) {
            int hashBits;
            AbstractPage child;
            if ((child = current.getChild(hashBits = current.getLocalHashCode(key, prefixLength), buddyOffset)).isLeaf()) {
                BucketPage bucketPage = (BucketPage)child.copyOnWrite();
                if (!bucketPage.insertRawTuple(src, slot, key)) {
                    if (current.globalDepth == child.globalDepth) {
                        if (child.globalDepth == this.addressBits) {
                            bucketPage.addLevel();
                        } else {
                            current.getParentDirectory().split(buddyOffset, current);
                        }
                    } else {
                        bucketPage.split();
                    }
                    this.insertRawTuple(src, slot);
                    return;
                }
                return;
            }
            prefixLength += current.globalDepth;
            buddyOffset = HTreeUtil.getBuddyOffset(hashBits, current.globalDepth, child.globalDepth);
            current = (DirectoryPage)child;
        }
    }

    public byte[] remove(byte[] key) {
        byte[] ret;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        AbstractPage page = this.locatePageForKey(key);
        byte[] byArray = ret = page == null ? null : page.removeFirst(key);
        if (ret != null) {
            --this.nentries;
        }
        return ret;
    }

    public int removeAll(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        AbstractPage page = this.locatePageForKey(key);
        int removals = page == null ? 0 : page.removeAll(key);
        this.nentries -= (long)removals;
        return removals;
    }

    protected AbstractPage locatePageForKey(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        DirectoryPage current = this.getRoot();
        int prefixLength = 0;
        int hashBits;
        AbstractPage child;
        while ((child = current.getChildIfPresent(hashBits = current.getLocalHashCode(key, prefixLength))) != null && !child.isLeaf() && !((DirectoryPage)child).isOverflowDirectory()) {
            prefixLength += current.globalDepth;
            current = (DirectoryPage)child;
        }
        return child;
    }

    @Override
    public void removeAll() {
        DirectoryPage root = this.getRoot();
        root.removeAll();
        this.newRoot();
    }

    @Override
    public long rangeCount() {
        return this.nentries;
    }

    String PP() {
        return this.PP(true);
    }

    String PP(boolean showBinary) {
        StringBuilder sb = new StringBuilder();
        sb.append("#nodes=" + this.nnodes + ", #leaves=" + this.nleaves + ", #entries=" + this.nentries + "\n");
        this.root.PP(sb, showBinary);
        return sb.toString();
    }

    @Override
    public BaseIndexStats dumpPages(boolean recursive, boolean visitLeaves) {
        if (!recursive) {
            return new BaseIndexStats(this);
        }
        HTreePageStats stats = new HTreePageStats();
        this.getRoot().dumpPages(recursive, visitLeaves, stats);
        return stats;
    }

    public static HTree create(IRawStore store, HTreeIndexMetadata metadata) {
        if (metadata.getIndexType() != IndexTypeEnum.HTree) {
            throw new IllegalStateException("Wrong index type: " + (Object)((Object)metadata.getIndexType()));
        }
        if (store == null) {
            return HTree.createTransient(metadata);
        }
        if (metadata.getMetadataAddr() != 0L) {
            throw new IllegalStateException("Metadata record already in use");
        }
        metadata.write(store);
        Checkpoint firstCheckpoint = metadata.firstCheckpoint();
        firstCheckpoint.write(store);
        return HTree.load(store, firstCheckpoint.getCheckpointAddr(), false);
    }

    public static HTree createTransient(HTreeIndexMetadata metadata) {
        if (metadata.getIndexType() != IndexTypeEnum.HTree) {
            throw new IllegalStateException("Wrong index type: " + (Object)((Object)metadata.getIndexType()));
        }
        Checkpoint firstCheckpoint = metadata.firstCheckpoint();
        try {
            Class<?> cl = Class.forName(metadata.getHTreeClassName());
            Constructor<?> ctor = cl.getConstructor(IRawStore.class, Checkpoint.class, IndexMetadata.class, Boolean.TYPE);
            HTree htree = (HTree)ctor.newInstance(null, firstCheckpoint, metadata, false);
            htree.reopen();
            return htree;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static HTree load(IRawStore store, long addrCheckpoint, boolean readOnly) {
        HTreeIndexMetadata metadata;
        Checkpoint checkpoint;
        if (store == null) {
            throw new IllegalArgumentException();
        }
        try {
            checkpoint = Checkpoint.load(store, addrCheckpoint);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not load Checkpoint: store=" + store + ", addrCheckpoint=" + store.toString(addrCheckpoint), t);
        }
        if (checkpoint.getIndexType() != IndexTypeEnum.HTree) {
            throw new RuntimeException("Not an HTree checkpoint: " + checkpoint);
        }
        try {
            metadata = (HTreeIndexMetadata)IndexMetadata.read(store, checkpoint.getMetadataAddr());
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not read IndexMetadata: store=" + store + ", checkpoint=" + checkpoint, t);
        }
        if (INFO) {
            String name = metadata.getName();
            log.info((Object)((name == null ? "" : "name=" + name + ", ") + "readCheckpoint=" + checkpoint));
        }
        try {
            Class<?> cl = Class.forName(metadata.getHTreeClassName());
            Constructor<?> ctor = cl.getConstructor(IRawStore.class, Checkpoint.class, IndexMetadata.class, Boolean.TYPE);
            HTree htree = (HTree)ctor.newInstance(store, checkpoint, metadata, readOnly);
            htree.reopen();
            return htree;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected int recycle(long addr) {
        if (addr == 0L) {
            return 0;
        }
        int nbytes = this.store.getByteCount(addr);
        this.store.delete(addr);
        return nbytes;
    }
}

