/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.BloomFilter;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.IDirtyListener;
import com.bigdata.btree.ILeafCursor;
import com.bigdata.btree.INodeFactory;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.Node;
import com.bigdata.btree.ReadOnlyCounter;
import com.bigdata.btree.SeekEnum;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.data.INodeData;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.JournalMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rwstore.IRWStrategy;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class BTree
extends AbstractBTree
implements ICheckpointProtocol {
    private Checkpoint checkpoint = null;
    protected int height;
    protected long nnodes;
    protected long nleaves;
    protected long nentries;
    protected long recordVersion;
    protected AtomicLong counter;
    private final ByteArrayBuffer recordAddrBuf;
    private volatile long lastCommitTime = 0L;
    private IDirtyListener listener;

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final long getNodeCount() {
        return this.nnodes;
    }

    @Override
    public final long getLeafCount() {
        return this.nleaves;
    }

    @Override
    public final long getEntryCount() {
        return this.nentries;
    }

    @Override
    public final IRawStore getStore() {
        return this.store;
    }

    @Override
    public ICounter getCounter() {
        ICounter counter = new Counter(this);
        LocalPartitionMetadata pmd = this.metadata.getPartitionMetadata();
        if (pmd != null) {
            counter = new PartitionedCounter(pmd.getPartitionId(), counter);
        }
        if (this.isReadOnly()) {
            return new ReadOnlyCounter(counter);
        }
        return counter;
    }

    public BTree(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, NodeFactory.INSTANCE, readOnly, metadata, metadata.getBtreeRecordCompressorFactory());
        if (checkpoint == null) {
            throw new IllegalArgumentException();
        }
        if (store != null && checkpoint.getMetadataAddr() != metadata.getMetadataAddr()) {
            throw new IllegalArgumentException();
        }
        if (metadata.getConflictResolver() != null && !metadata.isIsolatable()) {
            throw new IllegalArgumentException("Conflict resolver may only be used with isolatable indices");
        }
        this.setCheckpoint(checkpoint);
        assert (readOnly || this.writeRetentionQueue.capacity() >= 2);
        this.recordAddrBuf = readOnly ? null : new ByteArrayBuffer(8);
    }

    byte[] encodeRecordAddr(long addr) {
        return AbstractBTree.encodeRecordAddr(this.recordAddrBuf, addr);
    }

    private void setCheckpoint(Checkpoint checkpoint) {
        this.checkpoint = checkpoint;
        this.height = checkpoint.getHeight();
        this.nnodes = checkpoint.getNodeCount();
        this.nleaves = checkpoint.getLeafCount();
        this.nentries = checkpoint.getEntryCount();
        this.counter = new AtomicLong(checkpoint.getCounter());
        this.recordVersion = checkpoint.getRecordVersion();
    }

    private final void newRootLeaf() {
        this.height = 0;
        this.nnodes = 0L;
        this.nentries = 0L;
        boolean wasDirty = this.root != null && this.root.dirty;
        this.root = new Leaf(this);
        this.nleaves = 1L;
        if (this.metadata.getBloomFilterFactory() != null) {
            this.bloomFilter = this.metadata.getBloomFilterFactory().newBloomFilter();
        }
        if (!wasDirty && !this.readOnly) {
            this.fireDirtyEvent();
        }
    }

    @Override
    protected void _reopen() {
        if (this.checkpoint.getRootAddr() == 0L) {
            this.newRootLeaf();
        } else {
            this.root = this.readNodeOrLeaf(this.checkpoint.getRootAddr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BloomFilter getBloomFilter() {
        this.reopen();
        if (this.bloomFilter == null) {
            if (this.checkpoint.getBloomFilterAddr() == 0L) {
                return null;
            }
            BTree bTree = this;
            synchronized (bTree) {
                if (this.bloomFilter == null) {
                    this.bloomFilter = this.readBloomFilter();
                }
            }
        }
        if (this.bloomFilter != null && !this.bloomFilter.isEnabled()) {
            return null;
        }
        return this.bloomFilter;
    }

    protected final BloomFilter readBloomFilter() {
        long bloomFilterAddr = this.checkpoint.getBloomFilterAddr();
        if (bloomFilterAddr == 0L) {
            throw new IllegalStateException();
        }
        return BloomFilter.read(this.store, bloomFilterAddr);
    }

    @Override
    public final long getLastCommitTime() {
        return this.lastCommitTime;
    }

    @Override
    public final long getRevisionTimestamp() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Read-only");
        }
        return this.lastCommitTime + 1L;
    }

    @Override
    public final void setLastCommitTime(long lastCommitTime) {
        if (lastCommitTime == 0L) {
            throw new IllegalArgumentException();
        }
        if (this.lastCommitTime == lastCommitTime) {
            return;
        }
        if (INFO) {
            log.info((Object)("old=" + this.lastCommitTime + ", new=" + lastCommitTime));
        }
        this.lastCommitTime = lastCommitTime;
    }

    @Override
    public final IDirtyListener getDirtyListener() {
        return this.listener;
    }

    @Override
    public final void setDirtyListener(IDirtyListener listener) {
        this.assertNotReadOnly();
        this.listener = listener;
    }

    protected final void fireDirtyEvent() {
        this.assertNotReadOnly();
        IDirtyListener l = this.listener;
        if (l == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        l.dirtyEvent(this);
    }

    private final boolean flush() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        if (this.root != null && this.root.dirty) {
            this.writeNodeRecursive(this.root);
            if (INFO) {
                log.info((Object)("flushed root: addr=" + this.root.identity));
            }
            return true;
        }
        return false;
    }

    public BTree asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        if (this.needsCheckpoint()) {
            throw new IllegalStateException();
        }
        return BTree.load(this.store, this.checkpoint.addrCheckpoint, true);
    }

    @Override
    public final long writeCheckpoint() {
        return this.writeCheckpoint2().getCheckpointAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Checkpoint writeCheckpoint2() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        Lock lock = this.writeLock();
        lock.lock();
        try {
            if (this.error != null) {
                throw new IllegalStateException("Index is in error state", this.error);
            }
            if (this.needsCheckpoint()) {
                Checkpoint checkpoint = this._writeCheckpoint2();
                return checkpoint;
            }
            Checkpoint checkpoint = this.checkpoint;
            return checkpoint;
        }
        finally {
            lock.unlock();
        }
    }

    private final Checkpoint _writeCheckpoint2() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        this.flush();
        assert (this.root == null || !this.root.dirty);
        BloomFilter filter = this.bloomFilter;
        if (filter != null && filter.isDirty() && filter.isEnabled()) {
            this.recycle(filter.getAddr());
            filter.write(this.store);
        }
        if (this.metadata.getMetadataAddr() == 0L) {
            if (this.checkpoint != null) {
                this.recycle(this.checkpoint.getMetadataAddr());
            }
            this.metadata.write(this.store);
        }
        this.recycle(this.checkpoint != null ? this.checkpoint.addrCheckpoint : 0L);
        if (this.checkpoint != null && this.getRoot() != null && this.checkpoint.getRootAddr() != this.getRoot().identity) {
            this.recycle(this.checkpoint != null ? this.checkpoint.getRootAddr() : 0L);
        }
        this.checkpoint = this.newCheckpoint();
        this.checkpoint.write(this.store);
        if (BigdataStatics.debug || INFO) {
            String msg = "name=" + this.metadata.getName() + ", writeQueue{size=" + this.writeRetentionQueue.size() + ",distinct=" + this.ndistinctOnWriteRetentionQueue + "} : " + this.checkpoint;
            if (BigdataStatics.debug) {
                System.err.println(msg);
            }
            if (INFO) {
                log.info((Object)msg);
            }
        }
        return this.checkpoint;
    }

    private final Checkpoint newCheckpoint() {
        try {
            Class<?> cl = Class.forName(this.metadata.getCheckpointClassName());
            Constructor<?> ctor = cl.getConstructor(BTree.class);
            Checkpoint checkpoint = (Checkpoint)ctor.newInstance(this);
            return checkpoint;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final Checkpoint getCheckpoint() {
        if (this.checkpoint == null) {
            throw new AssertionError();
        }
        return this.checkpoint;
    }

    @Override
    public final long getRecordVersion() {
        return this.recordVersion;
    }

    @Override
    public final long getMetadataAddr() {
        return this.metadata.getMetadataAddr();
    }

    @Override
    public final long getRootAddr() {
        return this.root == null ? this.getCheckpoint().getRootAddr() : this.root.getIdentity();
    }

    public boolean needsCheckpoint() {
        if (this.checkpoint.addrCheckpoint == 0L) {
            return true;
        }
        if (this.metadata.getMetadataAddr() == 0L) {
            return true;
        }
        if (this.metadata.getMetadataAddr() != this.checkpoint.getMetadataAddr()) {
            return true;
        }
        if (this.checkpoint.getCounter() != this.counter.get()) {
            return true;
        }
        if (this.root != null) {
            if (this.root.isDirty()) {
                return true;
            }
            if (this.checkpoint.getRootAddr() != this.root.identity) {
                return true;
            }
        }
        return false;
    }

    public final void setIndexMetadata(IndexMetadata indexMetadata) {
        this.assertNotReadOnly();
        if (indexMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (indexMetadata.getMetadataAddr() != 0L) {
            throw new IllegalArgumentException();
        }
        this.metadata = indexMetadata;
        this.fireDirtyEvent();
    }

    @Override
    public long handleCommit(long commitTime) {
        return this.writeCheckpoint2().getCheckpointAddr();
    }

    @Override
    public void invalidate(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (this.error == null) {
            this.error = t;
        }
    }

    @Override
    public final void removeAll() {
        this.assertNotReadOnly();
        if (!this.getIndexMetadata().getDeleteMarkers() && this.getStore() instanceof IRWStrategy) {
            Iterator<AbstractNode> itr = this.getRoot().postOrderNodeIterator(false, true);
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                int nchildren = node.getChildCount();
                for (int i = 0; i < nchildren; ++i) {
                    long childAddr = node.getChildAddr(i);
                    if (childAddr == 0L) continue;
                    this.deleteNodeOrLeaf(childAddr);
                }
            }
            long raddr = this.getRoot().getIdentity();
            if (raddr != 0L) {
                this.deleteNodeOrLeaf(raddr);
            }
            this.replaceRootWithEmptyLeaf();
        } else if (this.getIndexMetadata().getDeleteMarkers() || this.getStore() instanceof IRWStrategy || this.metadata.getRawRecords()) {
            ITupleIterator itr = this.rangeIterator(null, null, 0, 16, null);
            while (itr.hasNext()) {
                itr.next();
            }
        } else {
            this.replaceRootWithEmptyLeaf();
        }
    }

    private void replaceRootWithEmptyLeaf() {
        this.writeRetentionQueue.clear(true);
        this.ndistinctOnWriteRetentionQueue = 0;
        this.newRootLeaf();
    }

    public long createViewCheckpoint() {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (this.needsCheckpoint()) {
            throw new IllegalStateException();
        }
        long priorCommitTime = this.getLastCommitTime();
        if (priorCommitTime == 0L) {
            throw new IllegalStateException();
        }
        IndexMetadata indexMetadata = this.getIndexMetadata().clone();
        LocalPartitionMetadata oldPmd = indexMetadata.getPartitionMetadata();
        IResourceMetadata[] oldResources = oldPmd.getResources();
        IResourceMetadata[] newResources = new IResourceMetadata[oldResources.length + 1];
        newResources[0] = oldResources[0];
        newResources[1] = new JournalMetadata((AbstractJournal)this.getStore(), priorCommitTime);
        for (int i = 1; i < oldResources.length; ++i) {
            newResources[i + 1] = oldResources[i];
        }
        LocalPartitionMetadata newPmd = new LocalPartitionMetadata(oldPmd.getPartitionId(), -1, oldPmd.getLeftSeparatorKey(), oldPmd.getRightSeparatorKey(), newResources, oldPmd.getIndexPartitionCause());
        indexMetadata.setPartitionMetadata(newPmd);
        this.setIndexMetadata(indexMetadata);
        assert (this.needsCheckpoint());
        this.replaceRootWithEmptyLeaf();
        return priorCommitTime;
    }

    public static BTree create(IRawStore store, IndexMetadata metadata) {
        if (metadata.getMetadataAddr() != 0L) {
            throw new IllegalStateException("Metadata record already in use");
        }
        if (metadata.getIndexType() != IndexTypeEnum.BTree) {
            throw new IllegalStateException("Wrong index type: " + (Object)((Object)metadata.getIndexType()));
        }
        metadata.write(store);
        Checkpoint firstCheckpoint = metadata.firstCheckpoint();
        firstCheckpoint.write(store);
        return BTree.load(store, firstCheckpoint.getCheckpointAddr(), false);
    }

    public static BTree createTransient(IndexMetadata metadata) {
        Checkpoint firstCheckpoint = metadata.firstCheckpoint();
        try {
            Class<?> cl = Class.forName(metadata.getBTreeClassName());
            Constructor<?> ctor = cl.getConstructor(IRawStore.class, Checkpoint.class, IndexMetadata.class, Boolean.TYPE);
            BTree btree = (BTree)ctor.newInstance(null, firstCheckpoint, metadata, false);
            btree.reopen();
            return btree;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static BTree load(IRawStore store, long addrCheckpoint, boolean readOnly) {
        IndexMetadata metadata;
        Checkpoint checkpoint;
        if (store == null) {
            throw new IllegalArgumentException();
        }
        try {
            checkpoint = Checkpoint.load(store, addrCheckpoint);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not load Checkpoint: store=" + store + ", addrCheckpoint=" + store.toString(addrCheckpoint), t);
        }
        if (checkpoint.getIndexType() != IndexTypeEnum.BTree) {
            throw new RuntimeException("Not a BTree checkpoint: " + checkpoint);
        }
        try {
            metadata = IndexMetadata.read(store, checkpoint.getMetadataAddr());
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not read IndexMetadata: store=" + store + ", checkpoint=" + checkpoint, t);
        }
        if (INFO) {
            String name = metadata.getName();
            log.info((Object)((name == null ? "" : "name=" + name + ", ") + "readCheckpoint=" + checkpoint));
        }
        try {
            Class<?> cl = Class.forName(metadata.getBTreeClassName());
            Constructor<?> ctor = cl.getConstructor(IRawStore.class, Checkpoint.class, IndexMetadata.class, Boolean.TYPE);
            BTree btree = (BTree)ctor.newInstance(store, checkpoint, metadata, readOnly);
            btree.reopen();
            return btree;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final int getSourceCount() {
        return 1;
    }

    @Override
    public final AbstractBTree[] getSources() {
        return new AbstractBTree[]{this};
    }

    @Override
    public final BTree getMutableBTree() {
        return this;
    }

    @Override
    public LeafCursor newLeafCursor(SeekEnum where) {
        return new LeafCursor(where);
    }

    @Override
    public LeafCursor newLeafCursor(byte[] key) {
        return new LeafCursor(key);
    }

    public class LeafCursor
    implements ILeafCursor<Leaf> {
        private Stack stack = new Stack();
        private Stack backup = null;
        private Leaf leaf;

        private void backup() {
            assert (this.stack != null);
            if (this.backup == null) {
                this.backup = new Stack(this.stack.capacity());
            }
            this.backup.copyFrom(this.stack);
        }

        private void restore() {
            assert (this.backup != null);
            this.stack = this.backup;
            this.backup = null;
        }

        @Override
        public Leaf leaf() {
            return this.leaf;
        }

        @Override
        public BTree getBTree() {
            return BTree.this;
        }

        public LeafCursor clone() {
            return new LeafCursor(this);
        }

        private LeafCursor(LeafCursor src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.stack = new Stack(src.stack.capacity());
            this.stack.copyFrom(src.stack);
            this.leaf = src.leaf();
        }

        public LeafCursor(SeekEnum where) {
            switch (where) {
                case First: {
                    this.first();
                    break;
                }
                case Last: {
                    this.last();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown seek directive: " + (Object)((Object)where)));
                }
            }
        }

        public LeafCursor(byte[] key) {
            this.seek(key);
        }

        @Override
        public Leaf first() {
            this.stack.clear();
            AbstractNode node = BTree.this.getRoot();
            while (!node.isLeaf()) {
                Node n = (Node)node;
                this.stack.push(n);
                node = n.getChild(0);
            }
            this.leaf = (Leaf)node;
            return this.leaf;
        }

        @Override
        public Leaf last() {
            this.stack.clear();
            AbstractNode node = BTree.this.getRoot();
            while (!node.isLeaf()) {
                Node n = (Node)node;
                this.stack.push(n);
                node = n.getChild(n.getKeyCount());
            }
            this.leaf = (Leaf)node;
            return this.leaf;
        }

        @Override
        public Leaf seek(byte[] key) {
            this.stack.clear();
            AbstractNode node = BTree.this.getRoot();
            while (!node.isLeaf()) {
                Node n = (Node)node;
                int index = n.findChild(key);
                this.stack.push(n);
                node = n.getChild(index);
            }
            this.leaf = (Leaf)node;
            return this.leaf;
        }

        @Override
        public Leaf seek(ILeafCursor<Leaf> src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            if (src == this) {
                return this.leaf;
            }
            if (src.getBTree() != BTree.this) {
                throw new IllegalArgumentException();
            }
            this.stack.copyFrom(((LeafCursor)src).stack);
            this.leaf = src.leaf();
            return this.leaf;
        }

        @Override
        public Leaf next() {
            if (this.leaf.isDeleted()) {
                throw new IllegalStateException("deleted");
            }
            this.backup();
            AbstractNode sibling = null;
            AbstractNode child = this.leaf;
            Node p = child.getParent();
            while (true) {
                if (p == null) {
                    this.restore();
                    return null;
                }
                sibling = p.getRightSibling(child, true);
                if (sibling != null) break;
                if (p != this.stack.pop()) {
                    throw new AssertionError();
                }
                child = p;
                p = p.getParent();
            }
            while (!sibling.isLeaf()) {
                this.stack.push((Node)sibling);
                sibling = ((Node)sibling).getChild(0);
            }
            this.leaf = (Leaf)sibling;
            return this.leaf;
        }

        @Override
        public Leaf prior() {
            if (this.leaf.isDeleted()) {
                throw new IllegalStateException("deleted");
            }
            this.backup();
            AbstractNode sibling = null;
            AbstractNode child = this.leaf;
            Node p = child.getParent();
            while (true) {
                if (p == null) {
                    this.restore();
                    return null;
                }
                sibling = p.getLeftSibling(child, true);
                if (sibling != null) break;
                if (p != this.stack.pop()) {
                    throw new AssertionError();
                }
                child = p;
                p = p.getParent();
            }
            while (!sibling.isLeaf()) {
                this.stack.push((Node)sibling);
                sibling = ((Node)sibling).getChild(sibling.getKeyCount());
            }
            this.leaf = (Leaf)sibling;
            return this.leaf;
        }
    }

    protected static class Stack {
        private Node[] a;
        private int n = 0;

        public Stack() {
            this(10);
        }

        public Stack(int capacity) {
            this.a = new Node[capacity];
        }

        public final int capacity() {
            return this.a.length;
        }

        public final int size() {
            return this.n;
        }

        public void push(Node item) {
            assert (item != null);
            if (this.n == this.a.length) {
                Node[] t = new Node[this.a.length * 2];
                System.arraycopy(this.a, 0, t, 0, this.n);
                this.a = t;
            }
            this.a[this.n++] = item;
        }

        public Node pop() {
            if (this.n == 0) {
                throw new IllegalStateException();
            }
            Node item = this.a[--this.n];
            this.a[this.n] = null;
            return item;
        }

        public Node peek() {
            if (this.n == 0) {
                throw new IllegalStateException();
            }
            return this.a[this.n - 1];
        }

        public void copyFrom(Stack src) {
            assert (src != null);
            if (src.n > this.a.length) {
                this.a = new Node[src.a.length];
            } else {
                this.clear();
            }
            System.arraycopy(src.a, 0, this.a, 0, src.n);
            this.n = src.n;
        }

        public void clear() {
            while (this.n > 0) {
                this.a[--this.n] = null;
            }
        }
    }

    public static class PartitionedCounter
    implements ICounter {
        private final int partitionId;
        private final ICounter src;
        private static final long MAX_LOCAL_COUNTER = 0x100000000L;

        public PartitionedCounter(int partitionId, ICounter src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.partitionId = partitionId;
            this.src = src;
        }

        private long wrap(long tmp) {
            if (tmp >= 0x100000000L) {
                throw new RuntimeException("Counter overflow: counter=" + tmp + ", pid=" + PartitionedCounter.getPartitionId(tmp) + ", ctr=" + PartitionedCounter.getLocalCounter(tmp));
            }
            return PartitionedCounter.combine(this.partitionId, (int)tmp);
        }

        @Override
        public long get() {
            return this.wrap(this.src.get());
        }

        @Override
        public long incrementAndGet() {
            return this.wrap(this.src.incrementAndGet());
        }

        public static int getPartitionId(long v) {
            return (int)(v >>> 32);
        }

        public static int getLocalCounter(long v) {
            return (int)v;
        }

        public static long combine(int pid, int ctr) {
            return (long)pid << 32 | 0xFFFFFFFFL & (long)ctr;
        }
    }

    public static class Counter
    implements ICounter {
        private final BTree btree;

        public Counter(BTree btree) {
            if (btree == null) {
                throw new IllegalArgumentException();
            }
            this.btree = btree;
        }

        @Override
        public long get() {
            return this.btree.counter.get();
        }

        @Override
        public long incrementAndGet() {
            long counter = this.btree.counter.incrementAndGet();
            if (counter == this.btree.checkpoint.getCounter() + 1L) {
                this.btree.fireDirtyEvent();
            }
            if (counter == 0L) {
                throw new RuntimeException("Counter overflow");
            }
            return counter;
        }
    }

    protected static class NodeFactory
    implements INodeFactory {
        public static final INodeFactory INSTANCE = new NodeFactory();

        private NodeFactory() {
        }

        @Override
        public Leaf allocLeaf(AbstractBTree btree, long addr, ILeafData data) {
            return new Leaf(btree, addr, data);
        }

        @Override
        public Node allocNode(AbstractBTree btree, long addr, INodeData data) {
            return new Node(btree, addr, data);
        }
    }
}

