/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.ILeafCursor;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleCursor;
import com.bigdata.btree.ITupleCursor2;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.KeyOutOfRangeException;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.SeekEnum;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.util.BytesUtil;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public abstract class AbstractBTreeTupleCursor<I extends AbstractBTree, L extends Leaf, E>
implements ITupleCursor2<E> {
    protected static final Logger log = Logger.getLogger(AbstractBTreeTupleCursor.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private static final transient String LOG_NO_CURSOR_POSITION = "No cursor position";
    private static final transient String LOG_NO_SUCCESSOR = "No successor";
    private static final transient String LOG_NO_PREDECESSOR = "No predecessor";
    private static final transient String LOG_CURSOR_POSITION_NOT_VISITABLE = "Cursor position is not visitable";
    protected final I btree;
    protected final Tuple<E> tuple;
    protected final byte[] fromKey;
    protected final byte[] toKey;
    protected final boolean visitDeleted;
    protected AbstractCursorPosition<L, E> currentPosition;

    public final I getIndex() {
        return this.btree;
    }

    @Override
    public final byte[] getFromKey() {
        return this.fromKey;
    }

    @Override
    public final byte[] getToKey() {
        return this.toKey;
    }

    @Override
    public final boolean isDeletedTupleVisitor() {
        return this.visitDeleted;
    }

    @Override
    public final boolean isCursorPositionDefined() {
        return this.currentPosition != null;
    }

    protected final void assertCursorPositionDefined() {
        if (!this.isCursorPositionDefined()) {
            throw new IllegalStateException();
        }
    }

    public AbstractBTreeTupleCursor(I btree, Tuple<E> tuple, byte[] fromKey, byte[] toKey) {
        if (btree == null) {
            throw new IllegalArgumentException();
        }
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        if (fromKey != null) assert (((AbstractBTree)btree).rangeCheck(fromKey, false));
        if (toKey != null) assert (((AbstractBTree)btree).rangeCheck(toKey, true));
        if (fromKey != null && toKey != null && BytesUtil.compareBytes((byte[])fromKey, (byte[])toKey) > 0) {
            throw new IllegalArgumentException("toKey LT fromKey: fromKey=" + BytesUtil.toString((byte[])fromKey) + ", toKey=" + BytesUtil.toString((byte[])toKey));
        }
        this.btree = btree;
        this.tuple = tuple;
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.visitDeleted = (tuple.flags() & 4) != 0;
        this.currentPosition = null;
    }

    public String toString() {
        return "Cursor{fromKey=" + BytesUtil.toString((byte[])this.fromKey) + ", toKey=" + BytesUtil.toString((byte[])this.toKey) + ", currentKey=" + BytesUtil.toString((byte[])this.currentKey()) + ", visitDeleted=" + this.visitDeleted + "}";
    }

    protected final boolean rangeCheck(byte[] key) {
        return BytesUtil.rangeCheck((byte[])key, (byte[])this.fromKey, (byte[])this.toKey);
    }

    protected final byte[] getInclusiveLowerBound() {
        IndexMetadata md;
        LocalPartitionMetadata pmd;
        Object fromKey = this.fromKey != null ? this.fromKey : (Object)((pmd = (md = ((AbstractBTree)this.getIndex()).getIndexMetadata()).getPartitionMetadata()) != null ? pmd.getLeftSeparatorKey() : null);
        return fromKey;
    }

    protected final byte[] getExclusiveUpperBound() {
        IndexMetadata md;
        LocalPartitionMetadata pmd;
        Object toKey = this.toKey != null ? this.toKey : (Object)((pmd = (md = ((AbstractBTree)this.getIndex()).getIndexMetadata()).getPartitionMetadata()) != null ? pmd.getRightSeparatorKey() : null);
        return toKey;
    }

    protected abstract AbstractCursorPosition<L, E> newPosition(ILeafCursor<L> var1, int var2, byte[] var3);

    protected abstract AbstractCursorPosition<L, E> newTemporaryPosition(ICursorPosition<L, E> var1);

    protected final AbstractCursorPosition<L, E> firstPosition() {
        byte[] key = this.getInclusiveLowerBound();
        if (key == null) {
            key = BytesUtil.EMPTY;
        }
        ILeafCursor leafCursor = ((AbstractBTree)this.btree).newLeafCursor(key);
        int index = ((Leaf)leafCursor.leaf()).getKeys().search(key);
        return this.newPosition(leafCursor, index, key);
    }

    protected final AbstractCursorPosition<L, E> newPosition(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.rangeCheck(key)) {
            throw new KeyOutOfRangeException("key=" + BytesUtil.toString((byte[])key) + ", fromKey=" + BytesUtil.toString((byte[])this.fromKey) + ", toKey=" + BytesUtil.toString((byte[])this.toKey));
        }
        ILeafCursor leafCursor = ((AbstractBTree)this.btree).newLeafCursor(key);
        int index = ((Leaf)leafCursor.leaf()).getKeys().search(key);
        return this.newPosition(leafCursor, index, key);
    }

    protected final AbstractCursorPosition<L, E> lastPosition() {
        int index;
        ILeafCursor leafCursor;
        byte[] key = this.getExclusiveUpperBound();
        if (key == null) {
            leafCursor = ((AbstractBTree)this.btree).newLeafCursor(SeekEnum.Last);
            Object leaf = leafCursor.leaf();
            index = ((Leaf)leaf).getKeyCount() - 1;
            key = index < 0 ? BytesUtil.EMPTY : ((Leaf)leaf).getKeys().get(index);
        } else {
            leafCursor = ((AbstractBTree)this.btree).newLeafCursor(key);
            Object leaf = leafCursor.leaf();
            index = ((Leaf)leaf).getKeys().search(key);
            index = index == 0 || index == -1 ? ((leaf = leafCursor.prior()) == null ? 0 : ((Leaf)leaf).getKeyCount() - 1) : (index > 0 ? --index : ++index);
        }
        return this.newPosition(leafCursor, index, key);
    }

    @Override
    public byte[] currentKey() {
        if (!this.isCursorPositionDefined()) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_CURSOR_POSITION);
            }
            return null;
        }
        return this.currentPosition.getKey();
    }

    @Override
    public ITuple<E> tuple() {
        if (!this.isCursorPositionDefined()) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_CURSOR_POSITION);
            }
            return null;
        }
        return this.currentPosition.get(this.tuple);
    }

    @Override
    public ITuple<E> first() {
        this.currentPosition = this.firstPosition();
        if (!this.currentPosition.forwardScan(false, false)) {
            this.currentPosition = null;
            if (DEBUG) {
                log.debug((Object)LOG_NO_CURSOR_POSITION);
            }
            return null;
        }
        return this.currentPosition.get(this.tuple);
    }

    @Override
    public ITuple<E> last() {
        this.currentPosition = this.lastPosition();
        if (!this.currentPosition.reverseScan(false, false)) {
            this.currentPosition = null;
            if (DEBUG) {
                log.debug((Object)LOG_NO_CURSOR_POSITION);
            }
            return null;
        }
        return this.currentPosition.get(this.tuple);
    }

    @Override
    public final ITuple<E> seek(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.seek(((AbstractBTree)this.getIndex()).getIndexMetadata().getTupleSerializer().serializeKey(key));
    }

    @Override
    public ITuple<E> seek(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (DEBUG) {
            log.debug((Object)("key=" + BytesUtil.toString((byte[])key)));
        }
        this.currentPosition = this.newPosition(key);
        return this.currentPosition.get(this.tuple);
    }

    @Override
    public ITuple<E> nextTuple() {
        if (!this.isCursorPositionDefined()) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_CURSOR_POSITION);
            }
            return null;
        }
        if (!this.currentPosition.forwardScan(true, false)) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_SUCCESSOR);
            }
            return null;
        }
        return this.currentPosition.get(this.tuple);
    }

    @Override
    public ITuple<E> next() {
        ITuple<E> t = !this.isCursorPositionDefined() ? this.first() : this.nextTuple();
        if (t == null) {
            throw new NoSuchElementException();
        }
        return t;
    }

    @Override
    public boolean hasNext() {
        boolean skipCurrent;
        AbstractCursorPosition<L, E> pos;
        if (!this.isCursorPositionDefined()) {
            pos = this.firstPosition();
            skipCurrent = false;
        } else {
            skipCurrent = true;
            pos = this.currentPosition;
        }
        if (!pos.forwardScan(skipCurrent, true)) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_SUCCESSOR);
            }
            return false;
        }
        if (DEBUG) {
            log.debug((Object)pos.toString());
        }
        return true;
    }

    @Override
    public ITuple<E> priorTuple() {
        if (!this.isCursorPositionDefined()) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_CURSOR_POSITION);
            }
            return null;
        }
        if (!this.currentPosition.reverseScan(true, false)) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_PREDECESSOR);
            }
            return null;
        }
        return this.currentPosition.get(this.tuple);
    }

    @Override
    public ITuple<E> prior() {
        ITuple<E> t = !this.isCursorPositionDefined() ? this.last() : this.priorTuple();
        if (t == null) {
            throw new NoSuchElementException();
        }
        return t;
    }

    @Override
    public boolean hasPrior() {
        boolean skipCurrent;
        AbstractCursorPosition<L, E> pos;
        if (!this.isCursorPositionDefined()) {
            pos = this.lastPosition();
            skipCurrent = false;
        } else {
            skipCurrent = true;
            pos = this.currentPosition;
        }
        if (!pos.reverseScan(skipCurrent, true)) {
            if (DEBUG) {
                log.debug((Object)LOG_NO_PREDECESSOR);
            }
            return false;
        }
        if (DEBUG) {
            log.debug((Object)pos.toString());
        }
        return true;
    }

    @Override
    public void remove() {
        if (((AbstractBTree)this.btree).isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        if (!this.isCursorPositionDefined()) {
            throw new IllegalStateException(LOG_NO_CURSOR_POSITION);
        }
        if (!this.currentPosition.isVisitableTuple()) {
            throw new IllegalStateException(LOG_CURSOR_POSITION_NOT_VISITABLE);
        }
        byte[] key = this.currentKey();
        if (DEBUG) {
            log.debug((Object)("key=" + BytesUtil.toString((byte[])key)));
        }
        if (((AbstractBTree)this.btree).getIndexMetadata().getDeleteMarkers()) {
            ((AbstractBTree)this.btree).insert(key, null, true, false, ((AbstractBTree)this.btree).getRevisionTimestamp(), this.tuple);
        } else {
            ((AbstractBTree)this.btree).remove(key, this.tuple);
        }
    }

    public static class MutableBTreeTupleCursor<E>
    extends ReadOnlyBTreeTupleCursor<E> {
        public MutableBTreeTupleCursor(BTree btree, Tuple<E> tuple, byte[] fromKey, byte[] toKey) {
            super(btree, tuple, fromKey, toKey);
        }

        @Override
        protected MutableCursorPosition<E> newPosition(ILeafCursor<Leaf> leafCursor, int index, byte[] key) {
            return new MutableCursorPosition(this, leafCursor, index, key);
        }

        @Override
        protected ReadOnlyCursorPosition<E> newTemporaryPosition(ICursorPosition<Leaf, E> p) {
            return new ReadOnlyCursorPosition((ReadOnlyCursorPosition)p);
        }
    }

    public static class ReadOnlyBTreeTupleCursor<E>
    extends AbstractBTreeTupleCursor<BTree, Leaf, E> {
        public ReadOnlyBTreeTupleCursor(BTree btree, Tuple<E> tuple, byte[] fromKey, byte[] toKey) {
            super(btree, tuple, fromKey, toKey);
        }

        protected ReadOnlyCursorPosition<E> newPosition(ILeafCursor<Leaf> leafCursor, int index, byte[] key) {
            return new ReadOnlyCursorPosition(this, leafCursor, index, key);
        }

        protected ReadOnlyCursorPosition<E> newTemporaryPosition(ICursorPosition<Leaf, E> p) {
            return new ReadOnlyCursorPosition((ReadOnlyCursorPosition)p);
        }
    }

    private static class MutableCursorPosition<E>
    extends ReadOnlyCursorPosition<E>
    implements Leaf.ILeafListener {
        protected MutableCursorPosition(ITupleCursor2<E> cursor, ILeafCursor<Leaf> leafCursor, int index, byte[] key) {
            super(cursor, leafCursor, index, key);
            leafCursor.leaf().addLeafListener(this);
        }

        public MutableCursorPosition(MutableCursorPosition<E> p) {
            super(p);
            ((Leaf)this.leafCursor.leaf()).addLeafListener(this);
        }

        @Override
        public void invalidateLeaf() {
            this.leafValid = false;
        }

        @Override
        public final boolean isLeafListener() {
            return true;
        }

        @Override
        protected boolean priorLeaf(ILeafCursor<Leaf> leafCursor) {
            if (super.priorLeaf(leafCursor)) {
                leafCursor.leaf().addLeafListener(this);
                return true;
            }
            return false;
        }

        @Override
        protected boolean nextLeaf(ILeafCursor<Leaf> leafCursor) {
            if (super.nextLeaf(leafCursor)) {
                leafCursor.leaf().addLeafListener(this);
                return true;
            }
            return false;
        }

        @Override
        protected boolean relocateLeaf() {
            if (this.leafValid) {
                return true;
            }
            byte[] key = this.getKey();
            if (INFO) {
                log.info((Object)("Relocating leaf: key=" + BytesUtil.toString((byte[])key)));
            }
            ((Leaf)this.leafCursor.seek(key)).addLeafListener(this);
            this.index = ((Leaf)this.leafCursor.leaf()).getKeys().search(key);
            boolean tupleDeleted = this.index < 0;
            this.leafValid = true;
            return tupleDeleted;
        }
    }

    private static class ReadOnlyCursorPosition<E>
    extends AbstractCursorPosition<Leaf, E> {
        public ReadOnlyCursorPosition(ITupleCursor2<E> cursor, ILeafCursor<Leaf> leafCursor, int index, byte[] key) {
            super(cursor, leafCursor, index, key);
        }

        public ReadOnlyCursorPosition(ReadOnlyCursorPosition<E> p) {
            super(p);
        }
    }

    static abstract class AbstractCursorPosition<L extends Leaf, E>
    implements ICursorPosition<L, E> {
        protected final ITupleCursor2<E> cursor;
        protected final ILeafCursor<L> leafCursor;
        protected int index;
        private final DataOutputBuffer kbuf;
        protected boolean leafValid;
        private DataOutputBuffer tbuf;

        @Override
        public ITupleCursor<E> getCursor() {
            return this.cursor;
        }

        @Override
        public ILeafCursor<L> getLeafCursor() {
            this.relocateLeaf();
            return this.leafCursor;
        }

        @Override
        public int getIndex() {
            this.relocateLeaf();
            return this.index;
        }

        public boolean isLeafListener() {
            return false;
        }

        protected AbstractCursorPosition(ITupleCursor2<E> cursor, ILeafCursor<L> leafCursor, int index, byte[] key) {
            if (cursor == null) {
                throw new IllegalArgumentException();
            }
            if (leafCursor == null) {
                throw new IllegalArgumentException();
            }
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.leafValid = true;
            this.cursor = cursor;
            this.leafCursor = leafCursor;
            this.index = index;
            this.kbuf = new DataOutputBuffer(key.length);
            this.kbuf.put(key);
        }

        public AbstractCursorPosition(AbstractCursorPosition<L, E> p) {
            if (p == null) {
                throw new IllegalArgumentException();
            }
            p.relocateLeaf();
            this.leafValid = true;
            this.cursor = p.cursor;
            this.index = p.index;
            this.kbuf = new DataOutputBuffer(p.kbuf.capacity());
            this.kbuf.copyAll(p.kbuf);
            this.leafCursor = p.leafCursor.clone();
        }

        public String toString() {
            return "CursorPosition{" + this.cursor + ", leafCursor=" + this.leafCursor + ", index=" + this.index + ", leafValid=" + this.leafValid + ", key=" + BytesUtil.toString((byte[])this.kbuf.toByteArray()) + "}";
        }

        public void seek(AbstractCursorPosition<L, E> src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            if (this.cursor != src.cursor) {
                throw new IllegalArgumentException();
            }
            src.relocateLeaf();
            this.leafValid = true;
            this.index = src.index;
            this.leafCursor.seek(src.leafCursor);
            this.kbuf.reset().copyAll(src.kbuf);
        }

        @Override
        public final byte[] getKey() {
            return this.kbuf.toByteArray();
        }

        protected boolean isOnTuple() {
            return this.index >= 0 && this.index < ((Leaf)this.leafCursor.leaf()).getKeyCount();
        }

        @Override
        public boolean isVisitableTuple() {
            this.relocateLeaf();
            if (!this.isOnTuple()) {
                return false;
            }
            L leaf = this.leafCursor.leaf();
            return !((Leaf)leaf).hasDeleteMarkers() || this.cursor.isDeletedTupleVisitor() || !((Leaf)leaf).getDeleteMarker(this.index);
        }

        @Override
        public Tuple<E> get(Tuple<E> tuple) {
            this.relocateLeaf();
            if (!this.isVisitableTuple()) {
                if (DEBUG) {
                    log.debug((Object)AbstractBTreeTupleCursor.LOG_CURSOR_POSITION_NOT_VISITABLE);
                }
                return null;
            }
            tuple.copy(this.index, (ILeafData)this.leafCursor.leaf());
            if (DEBUG) {
                log.debug((Object)tuple.toString());
            }
            return tuple;
        }

        protected boolean relocateLeaf() {
            if (this.leafValid) {
                return true;
            }
            throw new UnsupportedOperationException();
        }

        protected boolean nextLeaf(ILeafCursor<L> leafCursor) {
            if (leafCursor.next() == null) {
                log.info((Object)"No right sibling.");
                return false;
            }
            return true;
        }

        protected boolean priorLeaf(ILeafCursor<L> leafCursor) {
            if (leafCursor.prior() == null) {
                log.info((Object)"No left sibling.");
                return false;
            }
            return true;
        }

        private boolean rangeCheck(L leaf, int index) {
            byte[] fromKey = this.cursor.getFromKey();
            byte[] toKey = this.cursor.getToKey();
            if (fromKey == null && toKey == null) {
                return true;
            }
            byte[] key = ((Leaf)leaf).getKeys().get(index);
            if (fromKey != null && BytesUtil.compareBytes((byte[])key, (byte[])fromKey) < 0) {
                return false;
            }
            return toKey == null || BytesUtil.compareBytes((byte[])key, (byte[])toKey) < 0;
        }

        private void updatePosition(ILeafCursor<L> leafCursor, int index) {
            this.index = index;
            assert (this.leafCursor == leafCursor);
            this.kbuf.reset();
            ((Leaf)leafCursor.leaf()).getKeys().copy(index, this.kbuf);
        }

        @Override
        public final boolean forwardScan(boolean skipCurrent, boolean testOnly) {
            this.relocateLeaf();
            int index = this.index;
            ILeafCursor<L> leafCursor = this.leafCursor;
            if (index < 0) {
                index = -index - 1;
            } else if (skipCurrent) {
                ++index;
            }
            boolean done = false;
            while (!done) {
                L leaf = leafCursor.leaf();
                int nkeys = ((Leaf)leaf).getKeyCount();
                while (index < nkeys) {
                    if (!this.rangeCheck(leaf, index)) {
                        done = true;
                        break;
                    }
                    if (!((Leaf)leaf).hasDeleteMarkers() || this.cursor.isDeletedTupleVisitor() || !((Leaf)leaf).getDeleteMarker(index)) {
                        if (!testOnly) {
                            this.updatePosition(leafCursor, index);
                        }
                        return true;
                    }
                    ++index;
                }
                if (testOnly) {
                    leafCursor = leafCursor.clone();
                }
                if (!this.nextLeaf(leafCursor)) break;
                index = 0;
            }
            if (INFO) {
                log.info((Object)AbstractBTreeTupleCursor.LOG_NO_SUCCESSOR);
            }
            return false;
        }

        @Override
        public final boolean reverseScan(boolean skipCurrent, boolean testOnly) {
            this.relocateLeaf();
            int nkeys = ((Leaf)this.leafCursor.leaf()).getKeyCount();
            if (nkeys == 0) {
                return false;
            }
            int index = this.index;
            ILeafCursor<L> leafCursor = this.leafCursor;
            if (index < 0) {
                index = -index - 1;
            }
            if (skipCurrent) {
                --index;
            }
            boolean done = false;
            while (!done) {
                L leaf = leafCursor.leaf();
                while (index >= 0) {
                    if (index != nkeys) {
                        if (!this.rangeCheck(leaf, index)) {
                            done = true;
                            break;
                        }
                        if (!((Leaf)leaf).hasDeleteMarkers() || this.cursor.isDeletedTupleVisitor() || !((Leaf)leaf).getDeleteMarker(index)) {
                            if (!testOnly) {
                                this.updatePosition(leafCursor, index);
                            }
                            return true;
                        }
                    }
                    --index;
                }
                if (testOnly) {
                    leafCursor = leafCursor.clone();
                }
                if (!this.priorLeaf(leafCursor)) break;
                nkeys = ((Leaf)leafCursor.leaf()).getKeyCount();
                index = nkeys - 1;
            }
            if (INFO) {
                log.info((Object)AbstractBTreeTupleCursor.LOG_NO_PREDECESSOR);
            }
            return false;
        }
    }

    static interface ICursorPosition<L extends Leaf, E> {
        public ITupleCursor<E> getCursor();

        public ILeafCursor<L> getLeafCursor();

        public int getIndex();

        public byte[] getKey();

        public Tuple<E> get(Tuple<E> var1);

        public boolean isVisitableTuple();

        public boolean forwardScan(boolean var1, boolean var2);

        public boolean reverseScan(boolean var1, boolean var2);
    }
}

