/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.bindingSet;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class HashBindingSet
implements IBindingSet {
    private static final long serialVersionUID = -2989802566387532422L;
    private final LinkedHashMap<IVariable, IConstant> current;
    private int hash;

    private LinkedHashMap<IVariable, IConstant> current() {
        return this.current;
    }

    public HashBindingSet() {
        this.current = new LinkedHashMap();
    }

    protected HashBindingSet(HashBindingSet src, IVariable[] variablesToKeep) {
        this.current = this.copy(src.current, variablesToKeep);
    }

    private HashBindingSet(LinkedHashMap<IVariable, IConstant> contents) {
        this.current = contents;
    }

    private LinkedHashMap<IVariable, IConstant> copy(LinkedHashMap<IVariable, IConstant> src, IVariable[] variablesToKeep) {
        LinkedHashMap<IVariable, IConstant> dst = new LinkedHashMap<IVariable, IConstant>(variablesToKeep != null ? variablesToKeep.length : src.size());
        for (Map.Entry<IVariable, IConstant> e : src.entrySet()) {
            boolean keep = true;
            if (variablesToKeep != null) {
                keep = false;
                for (IVariable x : variablesToKeep) {
                    if (x != e.getKey()) continue;
                    keep = true;
                    break;
                }
            }
            if (!keep) continue;
            dst.put(e.getKey(), e.getValue());
        }
        return dst;
    }

    private LinkedHashMap<IVariable, IConstant> copyMinusErrors(LinkedHashMap<IVariable, IConstant> src, IVariable[] variablesToKeep) {
        LinkedHashMap<IVariable, IConstant> dst = new LinkedHashMap<IVariable, IConstant>(variablesToKeep != null ? variablesToKeep.length : src.size());
        for (Map.Entry<IVariable, IConstant> e : src.entrySet()) {
            if (e.getValue() == Constant.errorValue()) continue;
            boolean keep = true;
            if (variablesToKeep != null) {
                keep = false;
                for (IVariable x : variablesToKeep) {
                    if (x != e.getKey()) continue;
                    keep = true;
                    break;
                }
            }
            if (!keep) continue;
            dst.put(e.getKey(), e.getValue());
        }
        return dst;
    }

    HashBindingSet(IBindingSet src) {
        this();
        for (Map.Entry e : src) {
            this.set((IVariable)e.getKey(), (IConstant)e.getValue());
        }
    }

    HashBindingSet(IVariable[] vars, IConstant[] vals) {
        this();
        if (vars == null) {
            throw new IllegalArgumentException();
        }
        if (vals == null) {
            throw new IllegalArgumentException();
        }
        if (vars.length != vals.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < vars.length; ++i) {
            this.set(vars[i], vals[i]);
        }
    }

    public HashBindingSet clone() {
        return new HashBindingSet(this, null);
    }

    public HashBindingSet copy(IVariable[] variablesToKeep) {
        return new HashBindingSet(this, variablesToKeep);
    }

    public IBindingSet copyMinusErrors(IVariable[] variablesToKeep) {
        return new HashBindingSet(this.copyMinusErrors(this.current, variablesToKeep));
    }

    public final boolean containsErrorValues() {
        for (IConstant val : this.current.values()) {
            if (val != Constant.errorValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isBound(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        return this.current().containsKey(var);
    }

    public IConstant get(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        return this.current().get(var);
    }

    public void set(IVariable var, IConstant val) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        if (val == null) {
            throw new IllegalArgumentException();
        }
        this.current().put(var, val);
        this.hash = 0;
    }

    public void clear(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        this.current().remove(var);
        this.hash = 0;
    }

    public void clearAll() {
        this.current().clear();
        this.hash = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int i = 0;
        Iterator<Map.Entry<IVariable, IConstant>> itr = this.current().entrySet().iterator();
        while (itr.hasNext()) {
            if (i > 0) {
                sb.append(", ");
            }
            Map.Entry<IVariable, IConstant> entry = itr.next();
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }

    public Iterator<Map.Entry<IVariable, IConstant>> iterator() {
        return this.current().entrySet().iterator();
    }

    public Iterator<IVariable> vars() {
        return Collections.unmodifiableSet(this.current().keySet()).iterator();
    }

    public boolean isEmpty() {
        return this.current().isEmpty();
    }

    public int size() {
        return this.current().size();
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (!(t instanceof IBindingSet)) {
            return false;
        }
        IBindingSet o = (IBindingSet)t;
        if (this.size() != o.size()) {
            return false;
        }
        for (Map.Entry<IVariable, IConstant> entry : this.current().entrySet()) {
            IVariable var = entry.getKey();
            IConstant val = entry.getValue();
            IConstant o_val = o.get(var);
            if (null != o_val && val.equals(o_val)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = 0;
            for (IConstant c : this.current().values()) {
                if (c == null) continue;
                result ^= c.hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }
}

