/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.graph.Node;
import org.apache.jena.irix.IRIx;
import org.apache.jena.query.Query;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Var;

public class PrologHandler
implements Handler {
    private final Query query;

    public PrologHandler(Query query) {
        this.query = query;
    }

    private static String canonicalPfx(String x) {
        if (x.endsWith(":")) {
            return x.substring(0, x.length() - 1);
        }
        return x;
    }

    public void setBase(IRIx base) {
        this.query.setBase(base);
    }

    public void setBase(String base) {
        this.query.setBaseURI(base);
    }

    public void addPrefix(String pfx, String uri) {
        this.query.setPrefix(PrologHandler.canonicalPfx(pfx), uri);
    }

    public void clearPrefixes() {
        this.query.setPrefixMapping((PrefixMapping)new PrefixMappingImpl());
    }

    public void addPrefixes(Map<String, String> prefixes) {
        for (Map.Entry<String, String> e : prefixes.entrySet()) {
            this.addPrefix(e.getKey(), e.getValue());
        }
    }

    public PrefixMapping getPrefixes() {
        return this.query.getPrefixMapping();
    }

    public ExprFactory getExprFactory() {
        return new ExprFactory(this.query.getPrefixMapping());
    }

    public void addPrefixes(PrefixMapping prefixes) {
        this.query.getPrefixMapping().setNsPrefixes(prefixes);
    }

    public void addAll(PrologHandler pfxHandler) {
        String val = (String)StringUtils.defaultIfEmpty((CharSequence)pfxHandler.query.getBaseURI(), (CharSequence)this.query.getBaseURI());
        if (val != null) {
            this.setBase(val);
        }
        this.addPrefixes(pfxHandler.query.getPrefixMapping());
    }

    @Override
    public void setVars(Map<Var, Node> values) {
    }

    @Override
    public void build() {
    }
}

