/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.net.URI;
import java.net.http.HttpRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.auth.AuthCredentials;
import org.apache.jena.http.auth.AuthDomain;
import org.apache.jena.http.auth.AuthLib;
import org.apache.jena.http.auth.AuthRequestModifier;
import org.apache.jena.http.auth.PasswordRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthEnv {
    public static Logger LOG = LoggerFactory.getLogger(AuthEnv.class);
    private AuthCredentials passwordRegistry = new AuthCredentials();
    private Map<String, AuthRequestModifier> authModifiers = new ConcurrentHashMap<String, AuthRequestModifier>();
    private static AuthEnv singleton = new AuthEnv();

    public static AuthEnv get() {
        return singleton;
    }

    private AuthEnv() {
    }

    public void registerUsernamePassword(URI uri, String user, String password) {
        AuthDomain domain = new AuthDomain(uri, null);
        this.passwordRegistry.put(domain, new PasswordRecord(user, password));
    }

    public boolean hasRegistation(URI uri) {
        AuthDomain location = new AuthDomain(uri, null);
        return this.passwordRegistry.contains(location);
    }

    public void unregisterUsernamePassword(URI uri) {
        AuthDomain location = new AuthDomain(uri, null);
        this.passwordRegistry.remove(location);
        this.authModifiers.remove(uri.toString());
    }

    public PasswordRecord getUsernamePassword(URI uri) {
        AuthDomain domain = new AuthDomain(uri, null);
        return this.passwordRegistry.get(domain);
    }

    public void clearActiveAuthentication() {
        this.authModifiers.clear();
    }

    public void clearAuthEnv() {
        this.passwordRegistry.clearAll();
        this.authModifiers.clear();
    }

    public HttpRequest.Builder addAuth(HttpRequest.Builder requestBuilder, String uri) {
        if (this.authModifiers.isEmpty()) {
            return requestBuilder;
        }
        String endpointURL = HttpLib.endpoint(uri);
        AuthRequestModifier mod = this.authModifiers.get(endpointURL);
        if (mod == null) {
            return requestBuilder;
        }
        return mod.addAuth(requestBuilder);
    }

    public void registerBasicAuthModifier(String url, String user, String password) {
        AuthRequestModifier basicAuthModifier = AuthLib.basicAuthModifier(user, password);
        String serviceEndpoint = HttpLib.endpoint(url);
        this.authModifiers.put(serviceEndpoint, basicAuthModifier);
    }

    void registerAuthModifier(String requestTarget, AuthRequestModifier authModifier) {
        String serviceEndpoint = HttpLib.endpoint(requestTarget);
        this.authModifiers.put(serviceEndpoint, authModifier);
    }
}

