/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.debugging.AbstractOWLDebugger;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.SimpleIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackBoxOWLDebugger
extends AbstractOWLDebugger {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackBoxOWLDebugger.class);
    private static final int DEFAULT_INITIAL_EXPANSION_LIMIT = 50;
    private static final int DEFAULT_FAST_PRUNING_WINDOW_SIZE = 10;
    private final Set<OWLAxiom> debuggingAxioms = new LinkedHashSet<OWLAxiom>();
    private final Set<OWLEntity> objectsExpandedWithDefiningAxioms = new HashSet<OWLEntity>();
    private final Set<OWLEntity> objectsExpandedWithReferencingAxioms = new HashSet<OWLEntity>();
    private final Set<OWLAxiom> expandedWithDefiningAxioms = new HashSet<OWLAxiom>();
    private final Set<OWLAxiom> expandedWithReferencingAxioms = new HashSet<OWLAxiom>();
    private final OWLReasonerFactory reasonerFactory;
    private final Set<OWLAxiom> temporaryAxioms = new HashSet<OWLAxiom>();
    @Nullable
    private OWLClass currentClass;
    @Nullable
    private OWLOntology debuggingOntology;
    private int expansionLimit = 50;
    private int fastPruningWindowSize = 0;
    private int satTestCount = 0;

    public BlackBoxOWLDebugger(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLReasonerFactory reasonerFactory) {
        super(owlOntologyManager, ontology);
        this.reasonerFactory = (OWLReasonerFactory)OWLAPIPreconditions.checkNotNull((Object)reasonerFactory, (String)"reasonerFactory cannot be null");
    }

    private static <N extends OWLAxiom> int addMax(Set<N> source, Set<N> dest, int limit) {
        int count = 0;
        for (OWLAxiom obj : source) {
            if (count == limit) break;
            if (obj instanceof OWLAnnotationAxiom || !dest.add(obj)) continue;
            ++count;
        }
        return count;
    }

    private static IRI createIRI() {
        return IRI.getNextDocumentIRI((String)"http://debugging.blackbox#A");
    }

    @Override
    public void dispose() {
        this.reset();
    }

    private void reset() {
        this.currentClass = null;
        this.debuggingOntology = null;
        this.debuggingAxioms.clear();
        this.objectsExpandedWithDefiningAxioms.clear();
        this.objectsExpandedWithReferencingAxioms.clear();
        this.expandedWithDefiningAxioms.clear();
        this.expandedWithReferencingAxioms.clear();
        this.temporaryAxioms.clear();
        this.expansionLimit = 50;
    }

    @Override
    protected OWLClassExpression getCurrentClass() {
        return (OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.currentClass, (String)"currentClass is null; it is not possible to use it at this point.");
    }

    private OWLClass setupDebuggingClass(OWLClassExpression cls) {
        if (!cls.isAnonymous()) {
            return (OWLClass)cls;
        }
        OWLClass curCls = this.df.getOWLClass(BlackBoxOWLDebugger.createIRI());
        this.temporaryAxioms.add((OWLAxiom)this.df.getOWLEquivalentClassesAxiom((Collection)CollectionFactory.createSet((Object[])new OWLClassExpression[]{curCls, cls})));
        this.temporaryAxioms.forEach(ax -> this.man.addAxiom(this.getOWLOntology(), ax));
        return curCls;
    }

    @Override
    public Set<OWLAxiom> getSOSForInconsistentClass(OWLClassExpression cls) {
        this.reset();
        this.currentClass = this.setupDebuggingClass(cls);
        this.generateSOSAxioms();
        this.getOWLOntology().remove(this.temporaryAxioms);
        this.debuggingAxioms.removeAll(this.temporaryAxioms);
        return new HashSet<OWLAxiom>(this.debuggingAxioms);
    }

    private int expandAxioms() {
        int added;
        int axiomsAdded = 0;
        int remainingSpace = this.expansionLimit;
        double expansionFactor = 1.25;
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithDefiningAxioms.contains(ax)) continue;
            for (OWLEntity curObj : OWLAPIStreamUtils.asList((Stream)ax.signature())) {
                if (this.objectsExpandedWithDefiningAxioms.contains(curObj)) continue;
                added = this.expandWithDefiningAxioms(curObj, remainingSpace);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithDefiningAxioms.add(curObj);
            }
            this.expandedWithDefiningAxioms.add(ax);
        }
        if (axiomsAdded > 0) {
            return axiomsAdded;
        }
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithReferencingAxioms.contains(ax)) continue;
            for (OWLEntity curObj : OWLAPIStreamUtils.asList((Stream)ax.signature())) {
                if (this.objectsExpandedWithReferencingAxioms.contains(curObj)) continue;
                added = this.expandWithReferencingAxioms(curObj, this.expansionLimit);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithReferencingAxioms.add(curObj);
            }
            this.expandedWithReferencingAxioms.add(ax);
        }
        return axiomsAdded;
    }

    private int expandWithDefiningAxioms(OWLEntity obj, int limit) {
        HashSet expansionAxioms = new HashSet();
        if (obj instanceof OWLClass) {
            OWLAPIStreamUtils.add(expansionAxioms, (Stream)this.getOWLOntology().axioms((OWLClass)obj, Imports.INCLUDED));
        } else if (obj.isOWLObjectProperty()) {
            OWLAPIStreamUtils.add(expansionAxioms, (Stream)this.getOWLOntology().axioms((OWLObjectPropertyExpression)obj.asOWLObjectProperty(), Imports.INCLUDED));
        } else if (obj.isOWLDataProperty()) {
            OWLAPIStreamUtils.add(expansionAxioms, (Stream)this.getOWLOntology().axioms(obj.asOWLDataProperty(), Imports.INCLUDED));
        } else if (obj instanceof OWLIndividual) {
            OWLAPIStreamUtils.add(expansionAxioms, (Stream)this.getOWLOntology().axioms((OWLIndividual)obj, Imports.INCLUDED));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private int expandWithReferencingAxioms(OWLEntity obj, int limit) {
        Set expansionAxioms = OWLAPIStreamUtils.asUnorderedSet((Stream)this.getOWLOntology().referencingAxioms((OWLPrimitive)obj, Imports.INCLUDED));
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private void performFastPruning() {
        HashSet<OWLAxiom> axiomWindow = new HashSet<OWLAxiom>();
        Object[] axioms = this.debuggingAxioms.toArray();
        LOGGER.info("Fast pruning: ");
        LOGGER.info("     - Window size: {}", (Object)this.fastPruningWindowSize);
        int windowCount = this.debuggingAxioms.size() / this.fastPruningWindowSize;
        for (int currentWindow = 0; currentWindow < windowCount; ++currentWindow) {
            axiomWindow.clear();
            int startIndex = currentWindow * this.fastPruningWindowSize;
            int endIndex = startIndex + this.fastPruningWindowSize;
            for (int axiomIndex = startIndex; axiomIndex < endIndex; ++axiomIndex) {
                OWLAxiom currentAxiom = (OWLAxiom)axioms[axiomIndex];
                axiomWindow.add(currentAxiom);
                this.debuggingAxioms.remove(currentAxiom);
            }
            if (!this.isSatisfiable()) continue;
            this.debuggingAxioms.addAll(axiomWindow);
        }
        axiomWindow.clear();
        int remainingAxiomsCount = this.debuggingAxioms.size() % this.fastPruningWindowSize;
        if (remainingAxiomsCount > 0) {
            for (int fragmentIndex = windowCount * this.fastPruningWindowSize; fragmentIndex < axioms.length; ++fragmentIndex) {
                OWLAxiom curAxiom = (OWLAxiom)axioms[fragmentIndex];
                axiomWindow.add(curAxiom);
                this.debuggingAxioms.remove(curAxiom);
            }
            if (this.isSatisfiable()) {
                this.debuggingAxioms.addAll(axiomWindow);
            }
        }
        LOGGER.info("    - End of fast pruning");
    }

    private void performSlowPruning() {
        new ArrayList<OWLAxiom>(this.debuggingAxioms).forEach(this::removeAndTest);
    }

    protected void removeAndTest(OWLAxiom ax) {
        this.debuggingAxioms.remove(ax);
        if (this.isSatisfiable()) {
            this.debuggingAxioms.add(ax);
        }
    }

    protected OWLOntology getDebuggingOntology() {
        return (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.debuggingOntology);
    }

    private boolean isSatisfiable() {
        this.createDebuggingOntology();
        OWLReasoner reasoner = this.reasonerFactory.createNonBufferingReasoner(this.getDebuggingOntology());
        ++this.satTestCount;
        boolean sat = reasoner.isSatisfiable((OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.currentClass));
        reasoner.dispose();
        return sat;
    }

    private void createDebuggingOntology() {
        if (this.debuggingOntology != null) {
            this.man.removeOntology((OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.debuggingOntology));
        }
        IRI iri = BlackBoxOWLDebugger.createIRI();
        SimpleIRIMapper mapper = new SimpleIRIMapper(iri, iri);
        this.man.getIRIMappers().add((Serializable)mapper);
        try {
            this.debuggingOntology = this.man.createOntology(iri);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        this.man.getIRIMappers().remove((Serializable)mapper);
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        this.debuggingAxioms.forEach(ax -> changes.add(new AddAxiom(this.getDebuggingOntology(), ax)));
        this.temporaryAxioms.forEach(ax -> changes.add(new AddAxiom(this.getDebuggingOntology(), ax)));
        OWLSubClassOfAxiom ax2 = this.df.getOWLSubClassOfAxiom((OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.currentClass), (OWLClassExpression)this.df.getOWLThing());
        changes.add(new AddAxiom(this.getDebuggingOntology(), (OWLAxiom)ax2));
        this.man.applyChanges(changes);
    }

    private void resetSatisfiabilityTestCounter() {
        this.satTestCount = 0;
    }

    private void generateSOSAxioms() {
        this.resetSatisfiabilityTestCounter();
        this.expandWithDefiningAxioms((OWLEntity)((OWLClass)this.getCurrentClass()), this.expansionLimit);
        LOGGER.info("Initial axiom count: {}", (Object)this.debuggingAxioms.size());
        int totalAdded = 0;
        int expansionCount = 0;
        while (this.isSatisfiable()) {
            LOGGER.info("Expanding axioms (expansion {})", (Object)expansionCount);
            ++expansionCount;
            int numberAdded = this.expandAxioms();
            totalAdded += numberAdded;
            LOGGER.info("    ... expanded by {}", (Object)numberAdded);
            if (numberAdded != 0) continue;
            LOGGER.info("ERROR! Cannot find SOS axioms!");
            this.debuggingAxioms.clear();
            return;
        }
        LOGGER.info("Total number of axioms added: {}", (Object)totalAdded);
        LOGGER.info("FOUND CLASH! Pruning {} axioms...", (Object)this.debuggingAxioms.size());
        this.resetSatisfiabilityTestCounter();
        LOGGER.info("Fast pruning...");
        this.fastPruningWindowSize = 10;
        this.performFastPruning();
        LOGGER.info("... end of fast pruning. Axioms remaining: {}", (Object)this.debuggingAxioms.size());
        LOGGER.info("Performed {} satisfiability tests during fast pruning", (Object)this.satTestCount);
        int totalSatTests = this.satTestCount;
        this.resetSatisfiabilityTestCounter();
        LOGGER.info("Slow pruning...");
        this.performSlowPruning();
        LOGGER.info("... end of slow pruning");
        LOGGER.info("Performed {} satisfiability tests during slow pruning", (Object)this.satTestCount);
        LOGGER.info("Total number of satisfiability tests performed: {}", (Object)(totalSatTests += this.satTestCount));
    }
}

