import pymysql
import sqlalchemy as sqlalchemy
from sqlalchemy.engine.url import URL
import pandas as pd


class DBProperty:
    __user = None
    __password = None
    __host = None

    @property
    def user(self):
        return self.__user

    @user.setter
    def user(self, user):
        self.__user = user

    @property
    def password(self):
        return self.__password

    @password.setter
    def password(self, password):
        self.__password = password

    @property
    def host(self):
        return self.__host

    @host.setter
    def host(self, host):
        self.__host = host


class DB(DBProperty):
    database_name = None
    sqlalchemy_connector = None

    def __init__(self, database_name):
        self.database_name = database_name
        self.sqlalchemy_connector = self._get_sqlalchemy_connector()
        self.pymysql_connector = self._get_pymysql_connector()
        self.pymysql_cursor = self.pymysql_connector.cursor()

    def _get_sqlalchemy_connector(self):
        pymysql.install_as_MySQLdb()
        conn = sqlalchemy.create_engine(URL(
            drivername='mysql',
            username=self.__user,
            password=self.__password,
            host=self.__host,
            database=self.database_name
        ))
        return conn

    def _get_pymysql_connector(self):
        return pymysql.connect(host=self.__host, user=self.__user, password=self.__password,
                               db=self.database_name, charset='utf8')

    def con_close(self):
        self.pymysql_connector.close()
        self.sqlalchemy_connector.dispose()

    def get_sqlalchemy_connector(self):
        return self.sqlalchemy_connector

    def get_pymysql_connector(self):
        return self.pymysql_connector

    def get_tables(self) -> list:
        sql = "show tables"
        table_df = pd.read_sql(sql=sql, con=self.sqlalchemy_connector)
        return table_df[table_df.columns[0]].to_list()

    def drop_table(self, table_name):
        sql = f"drop table {table_name}"
        self.pymysql_cursor.execute(sql)

    def drop_all_table(self):
        list(map(self.drop_table, self.get_tables()))
