/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import org.jd.gui.api.API;
import org.jd.gui.service.fileloader.AbstractFileLoaderProvider;

public class ZipFileLoaderProvider
extends AbstractFileLoaderProvider {
    private static String[] a = new String[]{"zip"};

    @Override
    public String[] getExtensions() {
        return a;
    }

    @Override
    public String getDescription() {
        return "Zip files (*.zip)";
    }

    @Override
    public boolean accept(API aPI, File file) {
        return file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(".zip");
    }

    @Override
    public boolean load(API object, File file) {
        block5: {
            try {
                FileSystem fileSystem;
                Object object2 = file.toURI();
                object2 = new URI("jar:" + ((URI)object2).getScheme(), ((URI)object2).getHost(), ((URI)object2).getPath() + "!/", null);
                try {
                    fileSystem = FileSystems.getFileSystem((URI)object2);
                }
                catch (FileSystemNotFoundException fileSystemNotFoundException) {
                    fileSystem = FileSystems.newFileSystem((URI)object2, Collections.emptyMap());
                }
                if (fileSystem != null && (object2 = fileSystem.getRootDirectories().iterator()).hasNext()) {
                    return ZipFileLoaderProvider.a((API)object, file, (Path)object2.next()) != null;
                }
            }
            catch (IOException | URISyntaxException exception) {
                if (b) break block5;
                object = exception;
                ((Throwable)object).printStackTrace();
            }
        }
        return false;
    }
}

