/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class TypeIdItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "type_id_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int stringIndex = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, StringIdItem.getReferenceAnnotation(this.dexFile, stringIndex), new Object[0]);
            }
        };
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int typeIndex) {
        try {
            String typeString = (String)dexFile.getTypeSection().get(typeIndex);
            return String.format("type_id_item[%d]: %s", typeIndex, typeString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("type_id_item[%d]", typeIndex);
        }
    }

    public static String getOptionalReferenceAnnotation(DexBackedDexFile dexFile, int typeIndex) {
        if (typeIndex == -1) {
            return "type_id_item[NO_INDEX]";
        }
        return TypeIdItem.getReferenceAnnotation(dexFile, typeIndex);
    }
}

