/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Debug;

import java.io.IOException;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.Adaptors.Debug.DebugMethodItem;
import org.jf.baksmali.Adaptors.Debug.LocalFormatter;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.formatter.BaksmaliWriter;
import org.jf.dexlib2.iface.debug.RestartLocal;

public class RestartLocalMethodItem
extends DebugMethodItem {
    private final ClassDefinition classDef;
    private final RestartLocal restartLocal;
    private final RegisterFormatter registerFormatter;

    public RestartLocalMethodItem(ClassDefinition classDef, int codeAddress, int sortOrder, RegisterFormatter registerFormatter, RestartLocal restartLocal) {
        super(codeAddress, sortOrder);
        this.classDef = classDef;
        this.restartLocal = restartLocal;
        this.registerFormatter = registerFormatter;
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        writer.write(".restart local ");
        this.registerFormatter.writeTo(writer, this.restartLocal.getRegister());
        String name = this.restartLocal.getName();
        String type = this.restartLocal.getType();
        String signature = this.restartLocal.getSignature();
        if (name != null || type != null || signature != null) {
            writer.write("    # ");
            LocalFormatter.writeLocal(writer, name, type, signature);
        }
        return true;
    }
}

