/**
* @author ٺط
* @company ӹɷ޹˾
* @file HSStruct.h
* @brief ˽ӿʹõҵݽṹ
* @date    20170927
*/
#ifndef _HS_API_STRUCT_H_
#define _HS_API_STRUCT_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "./HSDataType.h"
#pragma pack(push,4)
struct CHSRspInfoField
{
    /// 
    HSErrorID                     ErrorID;
    /// ʾ
    HSErrorMsg                    ErrorMsg;
};


///֤
struct CHSReqAuthenticateField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSPassword                    Password;
    /// ͻid
    HSAppID                       AppID;
    /// ֤
    HSAuthCode                    AuthCode;
};

///֤Ӧ
struct CHSRspAuthenticateField
{
    /// ˺
    HSAccountID                   AccountID;
    /// ͻID
    HSAppID                       AppID;
    /// ֤
    HSAuthCode                    AuthCode;
    /// ͻID
    HSAppIDType                   AppIDType;
};


///ûϢϱ
struct CHSReqUserSystemInfoField
{
    /// ͻ˵½ʱ
    HSStrTime                    AppLoginTime;
    /// ͻ˹ַ
    HSIPAddress                  AppPublicAdrr;
    /// ͻϵͳϢ
    HSAppSysInfo                 AppSysInfo;
    /// ͻϵͳϢɼ
    HSAppSysInfoIntegrity        AppSysInfoIntegrity;
    /// ͻϵͳϢɼ쳣ʶ
    HSAppAbnormalType            AppAbnormalType;
};

///ûϢϱӦ
struct CHSRspUserSystemInfoField
{
};

///ͻ¼
struct CHSReqUserLoginField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSPassword                    Password;
    /// Ͷ߶Ӧ
    HSUserApplicationType         UserApplicationType;
    /// Ͷ߶ӦϢ
    HSUserApplicationInfo         UserApplicationInfo;
    /// ͶMacַ
    HSMacAddress                  MacAddress;
    /// ͶIPַ
    HSIPAddress                   IPAddress;
    /// ͶվϢ
    HSUserStationInfo             UserStationInfo;
};
///ͻ¼Ӧ
struct CHSRspUserLoginField
{
    /// Ӫҵ
    HSNum                         BranchID;
    /// ˺
    HSAccountID                   AccountID;
    /// Ͷ
    HSUserName                    UserName;
    /// 
    HSDate                        TradingDay;
    /// ϸ
    HSDate                        PreTradingDay;
    /// ˵ȷϱ־
    HSBillConfirmFlag             BillConfirmFlag;
    /// Ự
    HSSessionID                   SessionID;
    /// Ͷ߶Ӧ
    HSUserApplicationType         UserApplicationType;
    /// Ͷ߶ӦϢ
    HSUserApplicationInfo         UserApplicationInfo;
    /// յȼ
    HSRiskLevel                   RiskLevel;
    /// Ͷϴε½Macַ
    HSMacAddress                  LastMacAddress;
    /// Ͷϴε½IPַ
    HSIPAddress                   LastIPAddress;
    /// ϴε¼ɹʱ
    HSTime                        LastLoginTime;
    /// ֣ǰʱ
    HSTime                        CZCETime;
    /// ǰʱ
    HSTime                        DCETime;
    /// ǰʱ
    HSTime                        SHFETime;
    /// нǰʱ
    HSTime                        CFFEXTime;
    /// Դĵǰʱ
    HSTime                        INETime;
    /// 󱨵(ػỰϴ󱨵)
    HSRef                         MaxOrderRef;
    /// ͻ
    HSUserID                      UserID;
};

///
struct CHSReqUserPasswordUpdateField
{
    /// 
    HSPasswordType                PasswordType;
    /// 
    HSPassword                    Password;
    /// 
    HSPassword                    NewPassword;
};
///Ӧ
struct CHSRspUserPasswordUpdateField
{
};

///¼
struct CHSReqOrderInsertField
{
    /// 
    HSRef                         OrderRef;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSDirection                   Direction;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ۸
    HSPrice                       OrderPrice;
    /// 
    HSVolume                      OrderVolume;
    /// ָ
    HSOrderCommand                OrderCommand;
    /// Сɽ
    HSVolume                      MinVolume;
    /// ֹֹӯ
    HSPrice                       SpringPrice;
    /// ־
    HSSwapOrderFlag               SwapOrderFlag;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
};
///¼Ӧ
struct CHSRspOrderInsertField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSOrderSysID                  OrderSysID;
    /// ͹˾
    HSBrokerOrderID               BrokerOrderID;
    /// Ự
    HSSessionID                   SessionID;
    /// 
    HSRef                         OrderRef;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSExchangeID                  ExchangeID;
    /// 
    HSDirection                   Direction;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ۸
    HSPrice                       OrderPrice;
    /// 
    HSVolume                      OrderVolume;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// ָ
    HSOrderCommand                OrderCommand;
    /// ʱ
    HSTime                        InsertTime;
    /// Сɽ
    HSVolume                      MinVolume;
    /// ֹֹӯ
    HSPrice                       SpringPrice;
    /// ־
    HSSwapOrderFlag               SwapOrderFlag;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
};

///
struct CHSReqOrderActionField
{
    /// 
    HSOrderSysID                  OrderSysID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Ự
    HSSessionID                   SessionID;
    /// 
    HSRef                         OrderRef;
    /// 
    HSRef                         OrderActionRef;
};
///Ӧ
struct CHSRspOrderActionField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSOrderSysID                  OrderSysID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Ự
    HSSessionID                   SessionID;
    /// 
    HSRef                         OrderRef;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// ʱ
    HSTime                        InsertTime;
    /// 
    HSRef                         OrderActionRef;
};

///Ȩ¼
struct CHSReqExerciseOrderInsertField
{
    /// Ȩ
    HSRef                         ExerciseRef;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSVolume                      OrderVolume;
    /// Ȩʽ
    HSExerciseType                ExerciseType;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// ȨȨɵͷǷԶƽ
    HSCloseFlag                   CloseFlag;
};
///Ȩ¼Ӧ
struct CHSRspExerciseOrderInsertField
{
    /// ˺
    HSAccountID                   AccountID;
    /// Ự
    HSSessionID                   SessionID;
    /// Ȩ
    HSOrderSysID                  ExerciseOrderSysID;
    /// Ȩ
    HSRef                         ExerciseRef;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSVolume                      OrderVolume;
    /// Ȩʽ
    HSExerciseType                ExerciseType;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// ʱ
    HSTime                        InsertTime;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// ȨȨɵͷǷԶƽ
    HSCloseFlag                   CloseFlag;
};

///Ȩ
struct CHSReqExerciseOrderActionField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Ȩ
    HSOrderSysID                  ExerciseOrderSysID;
    /// Ȩ
    HSRef                         ExerciseRef;
    /// Ự
    HSSessionID                   SessionID;
    /// Ȩ
    HSRef                         ExecOrderActionRef;
};
///ȨӦ
struct CHSRspExerciseOrderActionField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Ȩ
    HSOrderSysID                  ExerciseOrderSysID;
    /// Ȩ
    HSRef                         ExerciseRef;
    /// Ự
    HSSessionID                   SessionID;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// Ȩ
    HSRef                         ExecOrderActionRef;
};

///¼
struct CHSReqLockInsertField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSLockType                    LockType;
    /// 
    HSVolume                      OrderVolume;
};
///¼Ӧ
struct CHSRspLockInsertField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSOrderSysID                  LockOrderSysID;
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSLockType                    LockType;
    /// 
    HSVolume                      OrderVolume;
    /// ｻ˺
    HSAccountID                   UnderlyingAccountID;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// ʱ
    HSTime                        InsertTime;
};

///ѯ¼
struct CHSReqForQuoteInsertField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};
///ѯ¼Ӧ
struct CHSRspForQuoteInsertField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ״̬
    HSOrderStatus                 OrderStatus;
};

///¼
struct CHSReqCombActionInsertField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ϲԱ
    HSCombStrategyID              CombStrategyID;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
    /// ָ
    HSCombDirection               CombDirection;
    /// 
    HSVolume                      OrderVolume;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// 
    HSDirection                   Direction;
};
///¼Ӧ
struct CHSRspCombActionInsertField
{
    /// ˺
    HSAccountID                   AccountID;
    /// ϱ
    HSOrderSysID                  CombOrderSysID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ϲԱ
    HSCombStrategyID              CombStrategyID;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
    /// ָ
    HSCombDirection               CombDirection;
    /// 
    HSVolume                      OrderVolume;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// ʱ
    HSTime                        InsertTime;
    /// 
    HSDirection                   Direction;
};

///󱨵ȡ
struct CHSReqQueryMaxOrderVolumeField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ָ
    HSOrderCommand                OrderCommand;
    /// 
    HSDirection                   Direction;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ۸
    HSPrice                       OrderPrice;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
};
///󱨵ȡӦ
struct CHSRspQueryMaxOrderVolumeField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 󱨵
    HSVolume                      MaxOrderVolume;
    /// 󱨵
    HSVolume                      MaxOrderVolumeUnit;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ָ
    HSOrderCommand                OrderCommand;
    /// 
    HSDirection                   Direction;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ۸
    HSPrice                       OrderPrice;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
};

///ȡ
struct CHSReqQryLockVolumeField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSLockType                    LockType;
};
///ȡӦ
struct CHSRspQryLockVolumeField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSLockType                    LockType;
    /// óֲ
    HSVolume                      AvailablePositionVolume;
};

///Ȩȡ
struct CHSReqQueryExerciseVolumeField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};
///ȨȡӦ
struct CHSRspQueryExerciseVolumeField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 󱨵
    HSVolume                      MaxOrderVolumeUnit;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};

///ȡ
struct CHSReqQryCombVolumeField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ϲԱ
    HSCombStrategyID              CombStrategyID;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
    /// ָ
    HSCombDirection               CombDirection;
};
///ȡӦ
struct CHSRspQryCombVolumeField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ϲԱ
    HSCombStrategyID              CombStrategyID;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
    /// ָ
    HSCombDirection               CombDirection;
    /// 󱨵
    HSVolume                      MaxOrderVolumeUnit;
};

///ֲֻܲѯ
struct CHSReqQryPositionField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};
///ֲֻܲѯӦ
struct CHSRspQryPositionField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSDirection                   Direction;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ճֲ
    HSVolume                      YdPositionVolume;
    /// ֲ
    HSVolume                      PositionVolume;
    /// ճֲ
    HSVolume                      TodayPositionVolume;
    /// óֲ
    HSVolume                      AvailablePositionVolume;
    /// տóֲ
    HSVolume                      TodayAvailablePositionVolume;
    /// ֱֲ֤
    HSBalance                     PositionMargin;
    /// Ȩ
    HSBalance                     Premium;
    /// 
    HSBalance                     Commission;
    /// ֶ
    HSVolume                      OpenFrozenVolume;
    /// ƽֶ
    HSVolume                      CloseFrozenVolume;
    /// 
    HSVolume                      CombVolume;
    /// Ȩ
    HSVolume                      ExerciseFrozenVolume;
    /// ᱣ֤
    HSBalance                     FrozenMargin;
    /// Ȩᱣ֤
    HSBalance                     ExerciseFrozenMargin;
    /// Ȩ
    HSBalance                     FrozenPremium;
    /// 
    HSBalance                     FrozenCommission;
    /// 
    HSVolume                      OpenVolume;
    /// ƽ
    HSVolume                      CloseVolume;
    /// ֽ
    HSBalance                     OpenBalance;
    /// ƽֽ
    HSBalance                     CloseBalance;
    /// ֳɱ
    HSBalance                     OpenCost;
    /// ֲֳɱ
    HSBalance                     PositionCost;
    /// ֲӯ
    HSBalance                     PositionProfit;
    /// ƽӯ
    HSBalance                     CloseProfit;
    /// Ȩֵ
    HSBalance                     OptionsMarketValue;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
};

///ʽ˻ѯ
struct CHSReqQryTradingAccountField
{
};
///ʽ˻ѯӦ
struct CHSRspQryTradingAccountField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSBalance                     YdBalance;
    /// ճֱֲ֤
    HSBalance                     YdPositionMargin;
    /// ʽȨ
    HSBalance                     YdFundEquity;
    /// ʽȨ
    HSBalance                     FundEquity;
    /// Ȩֵ
    HSBalance                     OptionsMarketValue;
    /// Ȩ
    HSBalance                     Equity;
    /// ʽ
    HSBalance                     AvailableBalance;
    /// ȡʽ
    HSBalance                     WithdrawBalance;
    /// ֤
    HSBalance                     Margin;
    /// ᱣ֤
    HSBalance                     FrozenMargin;
    /// Ȩᱣ֤
    HSBalance                     ExerciseFrozenMargin;
    /// ն
    HSRiskDegree                  RiskDegree;
    /// Ȩ
    HSBalance                     Premium;
    /// Ȩ
    HSBalance                     FrozenPremium;
    /// 
    HSBalance                     Commission;
    /// 
    HSBalance                     FrozenCommission;
    /// ƽӯ
    HSBalance                     CloseProfit;
    /// ֲӯ
    HSBalance                     PositionProfit;
    /// ƽֶӯ
    HSBalance                     CloseProfitByDate;
    /// ֲֶӯ
    HSBalance                     PositionProfitByDate;
    /// ת
    HSBalance                     Deposit;
    /// ת
    HSBalance                     Withdraw;
    /// Ѻ
    HSBalance                     FundMortgage;
    /// ֵѺ
    HSBalance                     WarrantMortgage;
    /// ʽ
    HSBalance                     FrozenBalance;
    /// ⶳʽ
    HSBalance                     UnFrozenBalance;
    /// 
    HSCurrencyID                  CurrencyID;
    /// Գն
    HSRiskDegree                  HedgeRiskDegree;
};

///ѯ
struct CHSReqQryOrderField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSOrderSysID                  OrderSysID;
};

///ʷѯ
struct CHSReqQryHistOrderField
{
    /// 
    HSExchangeID                   ExchangeID;
    /// Լ
    HSInstrumentID                 InstrumentID;
    /// 
    HSOrderSysID                   OrderSysID;
    /// ʼ
    HSDate                         BeginDate;
    /// 
    HSDate                         EndDate;
};

///Ϣ
struct CHSOrderField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSOrderSysID                  OrderSysID;
    /// ͹˾
    HSBrokerOrderID               BrokerOrderID;
    /// Ự
    HSSessionID                   SessionID;
    /// 
    HSRef                         OrderRef;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSDirection                   Direction;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ۸
    HSPrice                       OrderPrice;
    /// 
    HSVolume                      OrderVolume;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// ɽ
    HSVolume                      TradeVolume;
    /// 
    HSVolume                      CancelVolume;
    /// ɽ۸
    HSPrice                       TradePrice;
    /// 
    HSDate                        TradingDay;
    /// 
    HSDate                        InsertDate;
    /// ʱ
    HSTime                        InsertTime;
    /// 걨ʱ
    HSTime                        ReportTime;
    /// ָ
    HSOrderCommand                OrderCommand;
    /// Сɽ
    HSVolume                      MinVolume;
    /// ֹֹӯ
    HSPrice                       SpringPrice;
    /// ־
    HSSwapOrderFlag               SwapOrderFlag;
    /// ǿƽԭ
    HSForceCloseReason            ForceCloseReason;
    /// Ϣ
    HSErrorMsg                    ErrorMsg;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSOrderSource                 OrderSource;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
};

///ɽѯ
struct CHSReqQryTradeField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};

///ʷɽѯ
struct CHSReqQryHistTradeField
{
    /// 
    HSExchangeID                   ExchangeID;
    /// Լ
    HSInstrumentID                 InstrumentID;
    /// ʼ
    HSDate                         BeginDate;
    /// 
    HSDate                         EndDate;
};

///ɽϢ
struct CHSTradeField
{
    /// ˺
    HSAccountID                   AccountID;
    /// ɽ
    HSTradeID                     TradeID;
    /// 
    HSOrderSysID                  OrderSysID;
    /// ͹˾
    HSBrokerOrderID               BrokerOrderID;
    /// Ự
    HSSessionID                   SessionID;
    /// 
    HSRef                         OrderRef;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSDirection                   Direction;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ɽ
    HSVolume                      TradeVolume;
    /// ɽ۸
    HSPrice                       TradePrice;
    /// 
    HSDate                        TradingDay;
    /// ɽʱ
    HSTime                        TradeTime;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
    /// ɽ
    HSBalance                     TradeCommission;
};

///Ȩѯ
struct CHSReqQryExerciseField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// Ȩ
    HSOrderSysID                  ExerciseOrderSysID;
};

///ʷȨѯ
struct CHSReqQryHistExerciseField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// Ȩ
    HSOrderSysID                  ExerciseOrderSysID;
    /// ʼ
    HSDate                        BeginDate;
    /// 
    HSDate                        EndDate;
};

///ȨϢ
struct CHSExerciseField
{
    /// ˺
    HSAccountID                   AccountID;
    /// Ȩ
    HSOrderSysID                  ExerciseOrderSysID;
    /// Ự
    HSSessionID                   SessionID;
    /// Ȩ
    HSRef                         ExerciseRef;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// Ȩʽ
    HSExerciseType                ExerciseType;
    /// Ȩ
    HSVolume                      OrderVolume;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// 
    HSDate                        InsertDate;
    /// ʱ
    HSTime                        InsertTime;
    /// Ϣ
    HSErrorMsg                    ErrorMsg;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSOrderSource                 OrderSource;
    /// ȨȨɵͷǷԶƽ
    HSCloseFlag                   CloseFlag;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// ȨԤ
    HSBalance                     ExercisePreFrozenCommission;
    /// ȨԤᱣ֤
    HSBalance                     ExercisePreFrozenMargin;
};

///ѯ
struct CHSReqQryLockField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSOrderSysID                  LockOrderSysID;
};

///ʷѯ
struct CHSReqQryHistLockField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSOrderSysID                  LockOrderSysID;
    /// ʼ
    HSDate                        BeginDate;
    /// 
    HSDate                        EndDate;
};

///Ϣ
struct CHSLockField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSOrderSysID                  LockOrderSysID;
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSLockType                    LockType;
    /// 
    HSVolume                      OrderVolume;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// 
    HSDate                        TradingDay;
    /// ʱ
    HSTime                        InsertTime;
    /// Ϣ
    HSErrorMsg                    ErrorMsg;
    /// 
    HSOrderSource                 OrderSource;
};

///ϲѯ
struct CHSReqQryCombActionField
{
    /// ϱ
    HSOrderSysID                  CombOrderSysID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};

///ʷϲѯ
struct CHSReqQryHistCombActionField
{
    /// ϱ
    HSOrderSysID                  CombOrderSysID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ʼ
    HSDate                        BeginDate;
    /// 
    HSDate                        EndDate;
};

///Ϣ
struct CHSCombActionField
{
    /// ˺
    HSAccountID                   AccountID;
    /// ϱ
    HSOrderSysID                  CombOrderSysID;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ϲԱ
    HSCombStrategyID              CombStrategyID;
    /// 
    HSDirection                   Direction;
    /// ָ
    HSCombDirection               CombDirection;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// 
    HSVolume                      OrderVolume;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// 
    HSDate                        TradingDay;
    /// 
    HSDate                        InsertDate;
    /// ʱ
    HSTime                        InsertTime;
    /// Ϣ
    HSErrorMsg                    ErrorMsg;
    /// 
    HSOrderSource                 OrderSource;
};

///ϳֲϸѯ
struct CHSReqQryPositionCombineDetailField
{
};
///ϳֲϸѯӦ
struct CHSRspQryPositionCombineDetailField
{
    /// ˺
    HSAccountID                   AccountID;
    /// ϳֱֲ
    HSCombPositionID              CombPositionID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ϲԱ
    HSCombStrategyID              CombStrategyID;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// 
    HSDirection                   Direction;
    /// ճֲ
    HSVolume                      YdPositionVolume;
    /// óֲ
    HSVolume                      AvailablePositionVolume;
    /// ϻ
    HSVolume                      TotalCombVolume;
    /// ֻ
    HSVolume                      TotalSplitVolume;
    /// ֱֲ֤
    HSBalance                     PositionMargin;
    /// 
    HSDate                        OpenDate;
};

///ԼϢѯ
struct CHSReqQryInstrumentField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};
///ԼϢѯӦ
struct CHSRspQryInstrumentField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// Լ
    HSInstrumentName              InstrumentName;
    /// ԼӢ
    HSInstrumentEngName           InstrumentEngName;
    /// ԼƷֱ
    HSProductID                   ProductID;
    /// Ʒ
    HSProductType                 ProductType;
    /// м۵󱨵
    HSVolume                      MaxMarketOrderVolume;
    /// м۵С
    HSVolume                      MinMarketOrderVolume;
    /// ޼۵󱨵
    HSVolume                      MaxLimitOrderVolume;
    /// ޼۵С
    HSVolume                      MinLimitOrderVolume;
    /// Լ
    HSVolume                      VolumeMultiple;
    /// С䶯λ
    HSPrice                       PriceTick;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// Ȩ
    HSPrice                       ExercisePrice;
    /// Ȩ
    HSOptionsType                 OptionsType;
    /// ױ־
    HSTradingFlag                 TradingFlag;
    /// 
    HSDate                        MarketDate;
    /// 
    HSDate                        ExpireDate;
    /// Ȩʼ
    HSDate                        BeginExerciseDate;
    /// Ȩ
    HSDate                        EndExerciseDate;
    /// ʼ
    HSDate                        BeginDeliveryDate;
    /// 
    HSDate                        EndDeliveryDate;
    /// 
    HSCurrencyID                  CurrencyID;
    /// 
    HSCombType                    CombType;
};

///ȱڲѯ
struct CHSReqQryCoveredShortField
{
    /// 
    HSExchangeID                  ExchangeID;
};
///ȱڲѯӦ
struct CHSRspQryCoveredShortField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSVolume                      CoveredLockVolume;
    /// ȱ
    HSVolume                      CoveredShortVolume;
    /// Ԥȱ
    HSVolume                      CoveredEstimateShortVolume;
    /// Ϣ
    HSMsgContent                  MsgContent;
};

///Ȩָɲѯ
struct CHSReqQryExerciseAssignField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ֲ
    HSPositionType                PositionType;
};
///ȨָɲѯӦ
struct CHSRspQryExerciseAssignField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ֲ
    HSPositionType                PositionType;
    /// Ȩ
    HSOptionsType                 OptionsType;
    /// Ȩ
    HSPrice                       ExercisePrice;
    /// Ȩ
    HSVolume                      ExerciseVolume;
    /// 
    HSVolume                      DeliveryVolume;
    /// Ȩʽ
    HSBalance                     ExerciseFrozenBalance;
    /// 
    HSBalance                     SettlementBalance;
};

///ת
struct CHSReqTransferField
{
    /// д
    HSBankID                      BankID;
    /// ת
    HSTransferType                TransferType;
    /// 
    HSBalance                     OccurBalance;
    /// ʽ
    HSPassword                    FundPassword;
    /// 
    HSPassword                    BankPassword;
    /// 
    HSCurrencyID                  CurrencyID;
    /// ת˳
    HSOccasion                    TransferOccasion;
};
///תӦ
struct CHSRspTransferField
{
    /// תˮ
    HSNum                         TransferSerialID;
    /// д
    HSBankID                      BankID;
    /// ת
    HSTransferType                TransferType;
    /// 
    HSBalance                     OccurBalance;
    /// 
    HSCurrencyID                  CurrencyID;
    /// ת˳
    HSOccasion                    TransferOccasion;
};

///ת˲ѯ
struct CHSReqQryTransferField
{
    /// д
    HSBankID                      BankID;
    /// תˮ
    HSNum                         TransferSerialID;
};
///ת˲ѯӦ
struct CHSRspQryTransferField
{
    /// תˮ
    HSNum                         TransferSerialID;
    /// д
    HSBankID                      BankID;
    /// 
    HSBankName                    BankName;
    /// ҵ
    HSBusinessName                BusinessName;
    /// 
    HSBalance                     OccurBalance;
    /// ʽ
    HSBalance                     PostBalance;
    /// תʱ
    HSTime                        TransferTime;
    /// ת״̬
    HSTransferStatus              TransferStatus;
    /// ת˷
    HSTransferSource              TransferSource;
    /// ע
    HSRemarks                     Remarks;
    /// 
    HSCurrencyID                  CurrencyID;
    /// ׷
    HSDate                        OrderSourceDate;
    /// 
    HSDate                        TradingDay;
    /// ת˳
    HSOccasion                    TransferOccasion;
};

///ѯ
struct CHSReqQueryBankBalanceField
{
    /// д
    HSBankID                      BankID;
    /// ʽ
    HSPassword                    FundPassword;
    /// 
    HSPassword                    BankPassword;
    /// 
    HSCurrencyID                  CurrencyID;
};
///ѯӦ
struct CHSRspQueryBankBalanceField
{
    /// תˮ
    HSNum                         TransferSerialID;
};

///˻ѯ
struct CHSReqQueryBankAccountField
{
    /// д
    HSBankID                      BankID;
    /// 
    HSCurrencyID                  CurrencyID;
};
///˻ѯӦ
struct CHSRspQueryBankAccountField
{
    /// д
    HSBankID                      BankID;
    /// 
    HSBankName                    BankName;
    /// ˺
    HSBankAccountID               BankAccountID;
    /// 
    HSCurrencyID                  CurrencyID;
};

///ʽ
struct CHSReqMultiCentreFundTransField
{
    /// 
    HSCurrencyID                  CurrencyID;
    /// 
    HSBalance                     OccurBalance;
    /// 
    HSTransDirection              TransDirection;
};
///ʽӦ
struct CHSRspMultiCentreFundTransField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSCurrencyID                  CurrencyID;
    /// 
    HSBalance                     OccurBalance;
    /// 
    HSTransDirection              TransDirection;
    /// ʽˮ
    HSNum                         LocalTransferSerialID;
    /// Զʽˮ
    HSNum                         OppositeTransferSerialID;
};

///ͻ˵ѯ
struct CHSReqQueryBillContentField
{
    /// ʼ
    HSDate                        BeginDate;
    /// 
    HSDate                        EndDate;
};
///ͻ˵ѯӦ
struct CHSRspQueryBillContentField
{
    /// ˵
    HSBillContent                 BillContent;
};

///ͻ˵ȷ
struct CHSReqBillConfirmField
{
};
///ͻ˵ȷӦ
struct CHSRspBillConfirmField
{
    /// ˺
    HSAccountID                   AccountID;
    /// ˵ȷ״̬
    HSBillConfirmStatus           BillConfirmStatus;
    /// ȷ
    HSDate                        ConfirmDate;
    /// ȷʱ
    HSTime                        ConfirmTime;
};

///֤ѯ
struct CHSReqQryMarginField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
};
///֤ѯӦ
struct CHSRspQryMarginField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ͷ֤
    HSRate                        LongMarginRatio;
    /// ͷ֤
    HSBalance                     LongMargin;
    /// ͷ֤
    HSRate                        ShortMarginRatio;
    /// ͷ֤
    HSBalance                     ShortMargin;
};

///Ѳѯ
struct CHSReqQryCommissionField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Ʒ
    HSProductType                 ProductType;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
};
///ѲѯӦ
struct CHSRspQryCommissionField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSExchangeID                  ExchangeID;
    /// Ʒ
    HSProductType                 ProductType;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// ͷ
    HSRate                        LongOpenCommissionRatio;
    /// ͷ
    HSBalance                     LongOpenCommission;
    /// ͷƽ
    HSRate                        LongCloseCommissionRatio;
    /// ͷƽ
    HSBalance                     LongCloseCommission;
    /// ͷƽ
    HSRate                        LongCloseTodayCommissionRatio;
    /// ͷƽ
    HSBalance                     LongCloseTodayCommission;
    /// ͷ
    HSRate                        ShortOpenCommissionRatio;
    /// ͷ
    HSBalance                     ShortOpenCommission;
    /// ͷƽ
    HSRate                        ShortCloseCommissionRatio;
    /// ͷƽ
    HSBalance                     ShortCloseCommission;
    /// ͷƽ
    HSRate                        ShortCloseTodayCommissionRatio;
    /// ͷƽ
    HSBalance                     ShortCloseTodayCommission;
    /// Ȩ
    HSRate                        ExerciseCommissionRatio;
    /// Ȩ
    HSBalance                     ExerciseCommission;
    /// ɽֵ
    HSRate                        TradeValueRatio;
    /// Ʊֵ
    HSBalance                     StockValue;
};

///ʲѯ
struct CHSReqQryExchangeRateField
{
    /// ԭ
    HSCurrencyID                  FromCurrencyID;
    /// Ŀ
    HSCurrencyID                  ToCurrencyID;
};
///ʲѯӦ
struct CHSRspQryExchangeRateField
{
    /// ԭ
    HSCurrencyID                  FromCurrencyID;
    /// Ŀ
    HSCurrencyID                  ToCurrencyID;
    /// 
    HSExchangeRate                ExchangeRate;
    /// ԭλ
    HSVolume                      FromCurrencyUnit;
};

///ֲϸѯ
struct CHSReqQryPositionDetailField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};
///ֲϸѯӦ
struct CHSRspQryPositionDetailField
{
    /// ˺
    HSAccountID                   AccountID;
    /// ɽ
    HSTradeID                     TradeID;
    /// 
    HSDate                        OpenDate;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSDirection                   Direction;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ɽ
    HSVolume                      TradeVolume;
    /// ֲּ۸
    HSPrice                       PositionPrice;
    /// ƽ
    HSVolume                      TodayCloseVolume;
    /// ֲֺ
    HSArbitPositionID             ArbitragePositionID;
    /// Ⱥ
    HSLegID                       LegID;
    /// ɽ
    HSTradeType                   TradeType;
    /// ֱֲ֤
    HSBalance                     PositionMargin;
    /// ϺԼ
    HSInstrumentID                CombInstrumentID;
};

///͹˾òѯ
struct CHSReqQrySysConfigField
{
};
///͹˾òѯӦ
struct CHSRspQrySysConfigField
{
    /// ñ
    HSConfigNo                    ConfigNo;
    /// ÿ״̬
    HSConfigValue                 ConfigValue;
};

/// 鶩ģȡ
struct CHSReqDepthMarketDataField
{
    HSExchangeID                  ExchangeID;
    HSInstrumentID                InstrumentID;
};

///ѯ
struct CHSReqQryDepthMarketDataField
{
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
};

///Ϣ
struct CHSDepthMarketDataField
{
    /// 
    HSDate                        TradingDay;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSExchangeID                  ExchangeID;
    /// ¼
    HSPrice                       LastPrice;
    /// 
    HSPrice                       PreSettlementPrice;
    /// ̼
    HSPrice                       PreClosePrice;
    /// ̼
    HSPrice                       OpenPrice;
    /// ߼
    HSPrice                       HighestPrice;
    /// ͼ
    HSPrice                       LowestPrice;
    /// ɽ
    HSVolume                      TradeVolume;
    /// ɽ
    HSBalance                     TradeBalance;
    /// ܳ
    HSVolume                      OpenInterest;
    /// ̼
    HSPrice                       ClosePrice;
    /// 
    HSPrice                       SettlementPrice;
    /// ͣ
    HSPrice                       UpperLimitPrice;
    /// ͣ
    HSPrice                       LowerLimitPrice;
    /// ʵ
    HSDelta                       PreDelta;
    /// ʵ
    HSDelta                       CurrDelta;
    /// ʱ
    HSTime                        UpdateTime;
    /// һ
    HSPrice                       BidPrice1;
    /// һ
    HSVolume                      BidVolume1;
    /// һ
    HSPrice                       AskPrice1;
    /// һ
    HSVolume                      AskVolume1;
    /// ۶
    HSPrice                       BidPrice2;
    /// 
    HSVolume                      BidVolume2;
    /// ۶
    HSPrice                       AskPrice2;
    /// 
    HSVolume                      AskVolume2;
    /// 
    HSPrice                       BidPrice3;
    /// 
    HSVolume                      BidVolume3;
    /// 
    HSPrice                       AskPrice3;
    /// 
    HSVolume                      AskVolume3;
    /// 
    HSPrice                       BidPrice4;
    /// 
    HSVolume                      BidVolume4;
    /// 
    HSPrice                       AskPrice4;
    /// 
    HSVolume                      AskVolume4;
    /// 
    HSPrice                       BidPrice5;
    /// 
    HSVolume                      BidVolume5;
    /// 
    HSPrice                       AskPrice5;
    /// 
    HSVolume                      AskVolume5;
    /// ƽ۸
    HSPrice                       AveragePrice;
    /// ֲ
    HSVolume                      PreOpenInterest;
    /// Լ״̬
    HSInstrumentTradeStatus       InstrumentTradeStatus;
    /// Լʵʱ
    HSOpenRestriction             OpenRestriction;
};

///Ϣ
struct CHSOrderActionField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSOrderSysID                  OrderSysID;
    /// ͹˾
    HSBrokerOrderID               BrokerOrderID;
    /// Ự
    HSSessionID                   SessionID;
    /// 
    HSRef                         OrderRef;
    /// 
    HSRef                         OrderActionRef;
    /// 
    HSExchangeID                  ExchangeID;
    /// Լ
    HSInstrumentID                InstrumentID;
    /// 
    HSDirection                   Direction;
    /// ƽ־
    HSOffsetFlag                  OffsetFlag;
    /// Ͷ/ױ/
    HSHedgeType                   HedgeType;
    /// ۸
    HSPrice                       OrderPrice;
    /// 
    HSVolume                      OrderVolume;
    /// ״̬
    HSOrderStatus                 OrderActionStatus;
    /// ״̬
    HSOrderStatus                 OrderStatus;
    /// 
    HSDate                        TradingDay;
    /// 
    HSDate                        ActionDate;
    /// ʱ
    HSTime                        ActionTime;
    /// Ϣ
    HSErrorMsg                    ErrorMsg;
    /// ȨӦıĺԼ
    HSInstrumentID                UnderlyingInstrID;
    /// 
    HSOrderSource                 OrderSource;
};

///ٽ뼯н֮ʽ
struct CHSReqFundTransField
{
    /// 
    HSTransDirection              TransDirection;
    /// 
    HSCurrencyID                  CurrencyID;
    /// 
    HSBalance                     OccurBalance;
};

///ٽ뼯н֮ʽӦ
struct CHSRspFundTransField
{
    /// ʽˮ
    HSNum                         FundTransSerialID;
};

///ʽˮѯ
struct CHSReqQryFundTransField
{

};

///ʽˮѯӦ
struct CHSRspQryFundTransField
{
    /// ˺
    HSAccountID                   AccountID;
    /// 
    HSDate                        TradingDay;
    /// 
    HSDate                        OccurDate;
    /// ʱ
    HSTime                        OccurTime;
    /// תˮ
    HSNum                         TransferSerialID;
    /// 
    HSCurrencyID                  CurrencyID;
    /// 
    HSBalance                     OccurBalance;
    /// ʽ
    HSBalance                     PostBalance;
};

///ͻ֪ͨѯ
struct CHSReqQryClientNoticeField
{

};

///ͻ֪ͨϢ
struct CHSClientNoticeField
{
    /// ˺
    HSAccountID                   AccountID;
    /// Ϣ
    HSMsgBody                     MsgContent;
    /// Ϣ
    HSMsgTitle                    MsgTitle;
    /// Ϣ
    HSMsgType                     MsgType;
    /// Ϣ
    HSDate                        MsgDate;
    /// Ϣʱ
    HSTime                        MsgTime;
};

///ȨϢѯ
struct CHSReqQryOptUnderlyField
{
    /// 
    HSExchangeID                   ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                 UnderlyingInstrID;
};

///ȨϢѯӦ
struct CHSRspQryOptUnderlyField
{
    /// 
    HSExchangeID                   ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                 UnderlyingInstrID;
    /// ȨӦ
    HSStockType                    UnderlyingType;
    /// 
    HSCurrencyID                   CurrencyID;
    /// ȨӦ״̬
    HSStatus                       UnderlyingStatus;
    /// ͣ
    HSPrice                        UpperLimitPrice;
    /// ͣ
    HSPrice                        LowerLimitPrice;
    /// ȨӦĽ
    HSVolume                       UnderlyingHighAmount;
    /// ȨӦĽ
    HSVolume                       UnderlyingLowAmount;
    /// Լ
    HSVolume                       VolumeMultiple;
    /// 뵥λ
    HSNum                          BuyUnit;
    /// λ
    HSNum                          SellUnit;
    /// С۲()
    HSNum                          PriceStep;
    /// 
    HSDate                         MarketDate;
    /// 
    HSDate                         DelistDate;
    /// ȨӦм۽
    HSVolume                       UnderlyingMarketHighAmount;
    /// ȨӦм۽
    HSVolume                       UnderlyingMarketLowAmount;
    /// 
    HSInstrumentName               UnderlyingName;
    /// м뵥λ
    HSNum                          MarketBuyUnit;
    /// мλ
    HSNum                          MarketSellUnit;
    /// ȨӦЧ
    HSDate                         UnderlyingValidDate;
    /// 
    HSNum                          UpdateType;
};

///֤ȯѯ
struct CHSReqQrySecuDepthMarketField
{
    /// 
    HSExchangeID                   ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                 UnderlyingInstrID;
};

///֤ȯѯӦ
struct CHSRspQrySecuDepthMarketField
{
    /// 
    HSExchangeID                   ExchangeID;
    /// ȨӦıĺԼ
    HSInstrumentID                 UnderlyingInstrID;
    /// 
    HSInstrumentName               UnderlyingName;
    /// ¼
    HSPrice                        LastPrice;
    /// ̼
    HSPrice                        OpenPrice;
    /// ̼
    HSPrice                        UnderlyingPreClosePrice;
    /// ߼
    HSPrice                        HighestPrice;
    /// ͼ
    HSPrice                        LowestPrice;
    /// ɽ
    HSBalance                      TradeBalance;
    /// ɽ
    HSVolume                       TradeVolume;
    /// һ
    HSPrice                        BidPrice1;
    /// һ
    HSVolume                       BidVolume1;
    /// һ
    HSPrice                        AskPrice1;
    /// һ
    HSVolume                       AskVolume1;
    /// ۶
    HSPrice                        BidPrice2;
    /// 
    HSVolume                       BidVolume2;
    /// ۶
    HSPrice                        AskPrice2;
    /// 
    HSVolume                       AskVolume2;
    /// 
    HSPrice                        BidPrice3;
    /// 
    HSVolume                       BidVolume3;
    /// 
    HSPrice                        AskPrice3;
    /// 
    HSVolume                       AskVolume3;
    /// 
    HSPrice                        BidPrice4;
    /// 
    HSVolume                       BidVolume4;
    /// 
    HSPrice                        AskPrice4;
    /// 
    HSVolume                       AskVolume4;
    /// 
    HSPrice                        BidPrice5;
    /// 
    HSVolume                       BidVolume5;
    /// 
    HSPrice                        AskPrice5;
    /// 
    HSVolume                       AskVolume5;
};

#pragma pack(pop)
#endif
