from old_code.serializer import Serializer


class DiskList:

    def __init__(self, list_=[]):
        self.main_list = []

        for item in list_:
            self.append(item)

    def append(self, item):
        Serializer.dump(item)
        if not any(item.id == saved_item['id'] for saved_item in self.main_list):
            self.main_list.append({'id': item.id,
                                   'type': type(item),
                                   'item_repr': item.__repr__()})

    def __delitem__(self, index):
        item_to_delete = self.main_list[index]
        Serializer.delete(item_to_delete['type'], item_to_delete['id'])
        del self.main_list[index]

    def __getitem__(self, index):
        if isinstance(index, slice):
            items_to_return = self.main_list[index]
            return [Serializer.load(item['type'],
                                    item['id'])
                    for item in items_to_return]
        elif isinstance(index, int):
            item_to_get = self.main_list[index]
            item = Serializer.load(item_to_get['type'], item_to_get['id'])
        return item

    def __repr__(self):
        list_to_display = [item['item_repr'] for item in self.main_list]
        return f"[{', '.join(list_to_display)}]"

    def pop(self, index):
        item_to_return = self[index]
        del self[index]
        return item_to_return

    def len(self):
        return len(self.main_list)

    def __add__(self, disklist_to_add):
        temp_list = self.main_list + disklist_to_add.main_list
        disklist_to_return = DiskList()
        disklist_to_return.main_list = [item for n, item in enumerate(temp_list)
                                        if item not in temp_list[n + 1:]]
        return disklist_to_return

#   def __lt__(self, other: object) -> bool: ...
#   def __le__(self, other: object) -> bool: ...
#   def __gt__(self, other: object) -> bool: ...
#   def __ge__(self, other: object) -> bool: ...
#   def __contains__(self, item: object) -> bool: ...
#   def __len__(self) -> int: ...
#   @overload
#   def __getitem__(self, i: int) -> _T: ...
#   @overload
#   def __getitem__(self, i: slice) -> MutableSequence[_T]: ...
#   @overload
#   def __setitem__(self, i: int, o: _T) -> None: ...
#   @overload
#   def __setitem__(self, i: slice, o: Iterable[_T]) -> None: ...
#   def __delitem__(self, i: Union[int, slice]) -> None: ...
#   def __add__(self: _UserListT, other: Iterable[_T]) -> _UserListT: ...
#   def __iadd__(self: _UserListT, other: Iterable[_T]) -> _UserListT: ...
#   def __mul__(self: _UserListT, n: int) -> _UserListT: ...
#   def __imul__(self: _UserListT, n: int) -> _UserListT: ...
#   def append(self, item: _T) -> None: ...
#   def insert(self, i: int, item: _T) -> None: ...
#   def pop(self, i: int = ...) -> _T: ...
#   def remove(self, item: _T) -> None: ...
#   def clear(self) -> None: ...
#   def copy(self: _UserListT) -> _UserListT: ...
#   def count(self, item: _T) -> int: ...
#   def index(self, item: _T, *args: Any) -> int: ...
#   def reverse(self) -> None: ...
#   def sort(self, *args: Any, **kwds: Any) -> None: ...
#   def extend(self, other: Iterable[_T]) -> None: ...
