# Copyright (c) 2020 Dimitrios-Georgios Akestoridis
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

"""
Metadata for the mcdm package
"""

__title__ = "mcdm"
__version__ = "1.0"
__author__ = "Dimitrios-Georgios Akestoridis"
__author_email__ = "akestoridis@gmail.com"
__description__ = (
    "Python implementation of Multiple-Criteria Decision-Making algorithms"
)
__license__ = "MIT"
__copyright__ = "Copyright (c) 2020 Dimitrios-Georgios Akestoridis"
__url__ = "https://github.com/akestoridis/mcdm"
__keywords__ = [
    "multiple-criteria decision-making",
    "evaluation",
    "ranking",
    "scoring",
    "weighting",
    "correlation",
    "normalization"
]
__classifiers__ = [
    "Intended Audience :: Science/Research",
    "License :: OSI Approved :: MIT License",
    "Operating System :: POSIX :: Linux",
    "Programming Language :: Python :: 3"
]
__install_requires__ = [
    "numpy>=1.18.3"
]
__python_requires__ = ">=3.5.3"
__all__ = [
    "__title__",
    "__version__",
    "__author__",
    "__author_email__",
    "__description__",
    "__license__",
    "__copyright__",
    "__url__",
    "__keywords__",
    "__classifiers__",
    "__install_requires__",
    "__python_requires__"
]
