import sys
import typing
import bpy.types

GenericType = typing.TypeVar("GenericType")


def background_image_add(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None,
        *,
        name: typing.Union[str, typing.Any] = "",
        session_uuid: typing.Optional[typing.Any] = 0,
        filepath: typing.Union[str, typing.Any] = "",
        hide_props_region: typing.Union[bool, typing.Any] = True,
        check_existing: typing.Union[bool, typing.Any] = False,
        filter_blender: typing.Union[bool, typing.Any] = False,
        filter_backup: typing.Union[bool, typing.Any] = False,
        filter_image: typing.Union[bool, typing.Any] = True,
        filter_movie: typing.Union[bool, typing.Any] = True,
        filter_python: typing.Union[bool, typing.Any] = False,
        filter_font: typing.Union[bool, typing.Any] = False,
        filter_sound: typing.Union[bool, typing.Any] = False,
        filter_text: typing.Union[bool, typing.Any] = False,
        filter_archive: typing.Union[bool, typing.Any] = False,
        filter_btx: typing.Union[bool, typing.Any] = False,
        filter_collada: typing.Union[bool, typing.Any] = False,
        filter_alembic: typing.Union[bool, typing.Any] = False,
        filter_usd: typing.Union[bool, typing.Any] = False,
        filter_obj: typing.Union[bool, typing.Any] = False,
        filter_volume: typing.Union[bool, typing.Any] = False,
        filter_folder: typing.Union[bool, typing.Any] = True,
        filter_blenlib: typing.Union[bool, typing.Any] = False,
        filemode: typing.Optional[typing.Any] = 9,
        relative_path: typing.Union[bool, typing.Any] = True,
        show_multiview: typing.Union[bool, typing.Any] = False,
        use_multiview: typing.Union[bool, typing.Any] = False,
        display_type: typing.Optional[typing.Any] = 'DEFAULT',
        sort_method: typing.Union[str, int, typing.Any] = ''):
    ''' Add a new background image

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param name: Name, Name of the data-block to use by the operator
    :type name: typing.Union[str, typing.Any]
    :param session_uuid: Session UUID, Session UUID of the data-block to use by the operator
    :type session_uuid: typing.Optional[typing.Any]
    :param filepath: File Path, Path to file
    :type filepath: typing.Union[str, typing.Any]
    :param hide_props_region: Hide Operator Properties, Collapse the region displaying the operator settings
    :type hide_props_region: typing.Union[bool, typing.Any]
    :param check_existing: Check Existing, Check and warn on overwriting existing files
    :type check_existing: typing.Union[bool, typing.Any]
    :param filter_blender: Filter .blend files
    :type filter_blender: typing.Union[bool, typing.Any]
    :param filter_backup: Filter .blend files
    :type filter_backup: typing.Union[bool, typing.Any]
    :param filter_image: Filter image files
    :type filter_image: typing.Union[bool, typing.Any]
    :param filter_movie: Filter movie files
    :type filter_movie: typing.Union[bool, typing.Any]
    :param filter_python: Filter python files
    :type filter_python: typing.Union[bool, typing.Any]
    :param filter_font: Filter font files
    :type filter_font: typing.Union[bool, typing.Any]
    :param filter_sound: Filter sound files
    :type filter_sound: typing.Union[bool, typing.Any]
    :param filter_text: Filter text files
    :type filter_text: typing.Union[bool, typing.Any]
    :param filter_archive: Filter archive files
    :type filter_archive: typing.Union[bool, typing.Any]
    :param filter_btx: Filter btx files
    :type filter_btx: typing.Union[bool, typing.Any]
    :param filter_collada: Filter COLLADA files
    :type filter_collada: typing.Union[bool, typing.Any]
    :param filter_alembic: Filter Alembic files
    :type filter_alembic: typing.Union[bool, typing.Any]
    :param filter_usd: Filter USD files
    :type filter_usd: typing.Union[bool, typing.Any]
    :param filter_obj: Filter OBJ files
    :type filter_obj: typing.Union[bool, typing.Any]
    :param filter_volume: Filter OpenVDB volume files
    :type filter_volume: typing.Union[bool, typing.Any]
    :param filter_folder: Filter folders
    :type filter_folder: typing.Union[bool, typing.Any]
    :param filter_blenlib: Filter Blender IDs
    :type filter_blenlib: typing.Union[bool, typing.Any]
    :param filemode: File Browser Mode, The setting for the file browser mode to load a .blend file, a library or a special file
    :type filemode: typing.Optional[typing.Any]
    :param relative_path: Relative Path, Select the file relative to the blend file
    :type relative_path: typing.Union[bool, typing.Any]
    :param show_multiview: Enable Multi-View
    :type show_multiview: typing.Union[bool, typing.Any]
    :param use_multiview: Use Multi-View
    :type use_multiview: typing.Union[bool, typing.Any]
    :param display_type: Display Type * ``DEFAULT`` Default -- Automatically determine display type for files. * ``LIST_VERTICAL`` Short List -- Display files as short list. * ``LIST_HORIZONTAL`` Long List -- Display files as a detailed list. * ``THUMBNAIL`` Thumbnails -- Display files as thumbnails.
    :type display_type: typing.Optional[typing.Any]
    :param sort_method: File sorting mode
    :type sort_method: typing.Union[str, int, typing.Any]
    '''

    pass


def background_image_remove(override_context: typing.
                            Union[typing.Dict, 'bpy.types.Context'] = None,
                            execution_context: typing.Union[str, int] = None,
                            undo: typing.Optional[bool] = None,
                            *,
                            index: typing.Optional[typing.Any] = 0):
    ''' Remove a background image from the 3D view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param index: Index, Background image index to remove
    :type index: typing.Optional[typing.Any]
    '''

    pass


def bone_select_menu(override_context: typing.
                     Union[typing.Dict, 'bpy.types.Context'] = None,
                     execution_context: typing.Union[str, int] = None,
                     undo: typing.Optional[bool] = None,
                     *,
                     name: typing.Union[str, int, typing.Any] = '',
                     extend: typing.Union[bool, typing.Any] = False,
                     deselect: typing.Union[bool, typing.Any] = False,
                     toggle: typing.Union[bool, typing.Any] = False):
    ''' Menu bone selection

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param name: Bone Name
    :type name: typing.Union[str, int, typing.Any]
    :param extend: Extend
    :type extend: typing.Union[bool, typing.Any]
    :param deselect: Deselect
    :type deselect: typing.Union[bool, typing.Any]
    :param toggle: Toggle
    :type toggle: typing.Union[bool, typing.Any]
    '''

    pass


def camera_to_view(override_context: typing.
                   Union[typing.Dict, 'bpy.types.Context'] = None,
                   execution_context: typing.Union[str, int] = None,
                   undo: typing.Optional[bool] = None):
    ''' Set camera view to active view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def camera_to_view_selected(override_context: typing.
                            Union[typing.Dict, 'bpy.types.Context'] = None,
                            execution_context: typing.Union[str, int] = None,
                            undo: typing.Optional[bool] = None):
    ''' Move the camera so selected objects are framed

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def clear_render_border(override_context: typing.
                        Union[typing.Dict, 'bpy.types.Context'] = None,
                        execution_context: typing.Union[str, int] = None,
                        undo: typing.Optional[bool] = None):
    ''' Clear the boundaries of the border render and disable border render

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def clip_border(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None,
                *,
                xmin: typing.Optional[typing.Any] = 0,
                xmax: typing.Optional[typing.Any] = 0,
                ymin: typing.Optional[typing.Any] = 0,
                ymax: typing.Optional[typing.Any] = 0,
                wait_for_input: typing.Union[bool, typing.Any] = True):
    ''' Set the view clipping region

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Union[bool, typing.Any]
    '''

    pass


def copybuffer(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None):
    ''' Selected objects are copied to the clipboard

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def cursor3d(override_context: typing.Union[typing.
                                            Dict, 'bpy.types.Context'] = None,
             execution_context: typing.Union[str, int] = None,
             undo: typing.Optional[bool] = None,
             *,
             use_depth: typing.Union[bool, typing.Any] = True,
             orientation: typing.Optional[typing.Any] = 'VIEW'):
    ''' Set the location of the 3D cursor

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param use_depth: Surface Project, Project onto the surface
    :type use_depth: typing.Union[bool, typing.Any]
    :param orientation: Orientation, Preset viewpoint to use * ``NONE`` None -- Leave orientation unchanged. * ``VIEW`` View -- Orient to the viewport. * ``XFORM`` Transform -- Orient to the current transform setting. * ``GEOM`` Geometry -- Match the surface normal.
    :type orientation: typing.Optional[typing.Any]
    '''

    pass


def dolly(override_context: typing.Union[typing.
                                         Dict, 'bpy.types.Context'] = None,
          execution_context: typing.Union[str, int] = None,
          undo: typing.Optional[bool] = None,
          *,
          mx: typing.Optional[typing.Any] = 0,
          my: typing.Optional[typing.Any] = 0,
          delta: typing.Optional[typing.Any] = 0,
          use_cursor_init: typing.Union[bool, typing.Any] = True):
    ''' Dolly in/out in the view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mx: Region Position X
    :type mx: typing.Optional[typing.Any]
    :param my: Region Position Y
    :type my: typing.Optional[typing.Any]
    :param delta: Delta
    :type delta: typing.Optional[typing.Any]
    :param use_cursor_init: Use Mouse Position, Allow the initial mouse position to be used
    :type use_cursor_init: typing.Union[bool, typing.Any]
    '''

    pass


def drop_world(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None,
               *,
               name: typing.Union[str, typing.Any] = "",
               session_uuid: typing.Optional[typing.Any] = 0):
    ''' Drop a world into the scene

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param name: Name, Name of the data-block to use by the operator
    :type name: typing.Union[str, typing.Any]
    :param session_uuid: Session UUID, Session UUID of the data-block to use by the operator
    :type session_uuid: typing.Optional[typing.Any]
    '''

    pass


def edit_mesh_extrude_individual_move(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None):
    ''' Extrude each individual face separately along local normals :file: `startup/bl_operators/view3d.py\:21 <https://developer.blender.org/diffusion/B/browse/master/release/scripts/startup/bl_operators/view3d.py$21>`_

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def edit_mesh_extrude_manifold_normal(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None):
    ''' Extrude manifold region along normals :file: `startup/bl_operators/view3d.py\:154 <https://developer.blender.org/diffusion/B/browse/master/release/scripts/startup/bl_operators/view3d.py$154>`_

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def edit_mesh_extrude_move_normal(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None,
        *,
        dissolve_and_intersect: typing.Union[bool, typing.Any] = False):
    ''' Extrude region together along the average normal

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param dissolve_and_intersect: dissolve_and_intersect, Dissolves adjacent faces and intersects new geometry
    :type dissolve_and_intersect: typing.Union[bool, typing.Any]
    '''

    pass


def edit_mesh_extrude_move_shrink_fatten(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None):
    ''' Extrude region together along local normals :file: `startup/bl_operators/view3d.py\:137 <https://developer.blender.org/diffusion/B/browse/master/release/scripts/startup/bl_operators/view3d.py$137>`_

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def fly(override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None):
    ''' Interactively fly around the scene

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def interactive_add(override_context: typing.
                    Union[typing.Dict, 'bpy.types.Context'] = None,
                    execution_context: typing.Union[str, int] = None,
                    undo: typing.Optional[bool] = None,
                    *,
                    primitive_type: typing.Optional[typing.Any] = 'CUBE',
                    plane_axis: typing.Union[str, int] = 'Z',
                    plane_axis_auto: typing.Union[bool, typing.Any] = False,
                    plane_depth: typing.Optional[typing.Any] = 'SURFACE',
                    plane_orientation: typing.Optional[typing.Any] = 'SURFACE',
                    snap_target: typing.Optional[typing.Any] = 'GEOMETRY',
                    plane_origin_base: typing.Optional[typing.Any] = 'EDGE',
                    plane_origin_depth: typing.Optional[typing.Any] = 'EDGE',
                    plane_aspect_base: typing.Optional[typing.Any] = 'FREE',
                    plane_aspect_depth: typing.Optional[typing.Any] = 'FREE',
                    wait_for_input: typing.Union[bool, typing.Any] = True):
    ''' Interactively add an object

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param primitive_type: Primitive
    :type primitive_type: typing.Optional[typing.Any]
    :param plane_axis: Plane Axis, The axis used for placing the base region
    :type plane_axis: typing.Union[str, int]
    :param plane_axis_auto: Auto Axis, Select the closest axis when placing objects (surface overrides)
    :type plane_axis_auto: typing.Union[bool, typing.Any]
    :param plane_depth: Position, The initial depth used when placing the cursor * ``SURFACE`` Surface -- Start placing on the surface, using the 3D cursor position as a fallback. * ``CURSOR_PLANE`` Cursor Plane -- Start placement using a point projected onto the orientation axis at the 3D cursor position. * ``CURSOR_VIEW`` Cursor View -- Start placement using a point projected onto the view plane at the 3D cursor position.
    :type plane_depth: typing.Optional[typing.Any]
    :param plane_orientation: Orientation, The initial depth used when placing the cursor * ``SURFACE`` Surface -- Use the surface normal (using the transform orientation as a fallback). * ``DEFAULT`` Default -- Use the current transform orientation.
    :type plane_orientation: typing.Optional[typing.Any]
    :param snap_target: Snap to, The target to use while snapping * ``GEOMETRY`` Geometry -- Snap to all geometry. * ``DEFAULT`` Default -- Use the current snap settings.
    :type snap_target: typing.Optional[typing.Any]
    :param plane_origin_base: Origin, The initial position for placement * ``EDGE`` Edge -- Start placing the edge position. * ``CENTER`` Center -- Start placing the center position.
    :type plane_origin_base: typing.Optional[typing.Any]
    :param plane_origin_depth: Origin, The initial position for placement * ``EDGE`` Edge -- Start placing the edge position. * ``CENTER`` Center -- Start placing the center position.
    :type plane_origin_depth: typing.Optional[typing.Any]
    :param plane_aspect_base: Aspect, The initial aspect setting * ``FREE`` Free -- Use an unconstrained aspect. * ``FIXED`` Fixed -- Use a fixed 1:1 aspect.
    :type plane_aspect_base: typing.Optional[typing.Any]
    :param plane_aspect_depth: Aspect, The initial aspect setting * ``FREE`` Free -- Use an unconstrained aspect. * ``FIXED`` Fixed -- Use a fixed 1:1 aspect.
    :type plane_aspect_depth: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Union[bool, typing.Any]
    '''

    pass


def localview(override_context: typing.Union[typing.
                                             Dict, 'bpy.types.Context'] = None,
              execution_context: typing.Union[str, int] = None,
              undo: typing.Optional[bool] = None,
              *,
              frame_selected: typing.Union[bool, typing.Any] = True):
    ''' Toggle display of selected object(s) separately and centered in view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param frame_selected: Frame Selected, Move the view to frame the selected objects
    :type frame_selected: typing.Union[bool, typing.Any]
    '''

    pass


def localview_remove_from(override_context: typing.
                          Union[typing.Dict, 'bpy.types.Context'] = None,
                          execution_context: typing.Union[str, int] = None,
                          undo: typing.Optional[bool] = None):
    ''' Move selected objects out of local view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def move(override_context: typing.Union[typing.
                                        Dict, 'bpy.types.Context'] = None,
         execution_context: typing.Union[str, int] = None,
         undo: typing.Optional[bool] = None,
         *,
         use_cursor_init: typing.Union[bool, typing.Any] = True):
    ''' Move the view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param use_cursor_init: Use Mouse Position, Allow the initial mouse position to be used
    :type use_cursor_init: typing.Union[bool, typing.Any]
    '''

    pass


def navigate(override_context: typing.Union[typing.
                                            Dict, 'bpy.types.Context'] = None,
             execution_context: typing.Union[str, int] = None,
             undo: typing.Optional[bool] = None):
    ''' Interactively navigate around the scene (uses the mode (walk/fly) preference)

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def ndof_all(override_context: typing.Union[typing.
                                            Dict, 'bpy.types.Context'] = None,
             execution_context: typing.Union[str, int] = None,
             undo: typing.Optional[bool] = None):
    ''' Pan and rotate the view with the 3D mouse

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def ndof_orbit(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None):
    ''' Orbit the view using the 3D mouse

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def ndof_orbit_zoom(override_context: typing.
                    Union[typing.Dict, 'bpy.types.Context'] = None,
                    execution_context: typing.Union[str, int] = None,
                    undo: typing.Optional[bool] = None):
    ''' Orbit and zoom the view using the 3D mouse

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def ndof_pan(override_context: typing.Union[typing.
                                            Dict, 'bpy.types.Context'] = None,
             execution_context: typing.Union[str, int] = None,
             undo: typing.Optional[bool] = None):
    ''' Pan the view with the 3D mouse

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def object_as_camera(override_context: typing.
                     Union[typing.Dict, 'bpy.types.Context'] = None,
                     execution_context: typing.Union[str, int] = None,
                     undo: typing.Optional[bool] = None):
    ''' Set the active object as the active camera for this view or scene

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def object_mode_pie_or_toggle(override_context: typing.
                              Union[typing.Dict, 'bpy.types.Context'] = None,
                              execution_context: typing.Union[str, int] = None,
                              undo: typing.Optional[bool] = None):
    ''' Undocumented, consider `contributing <https://developer.blender.org/T51061>`__.

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def pastebuffer(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None,
                *,
                autoselect: typing.Union[bool, typing.Any] = True,
                active_collection: typing.Union[bool, typing.Any] = True):
    ''' Objects from the clipboard are pasted

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param autoselect: Select, Select pasted objects
    :type autoselect: typing.Union[bool, typing.Any]
    :param active_collection: Active Collection, Put pasted objects in the active collection
    :type active_collection: typing.Union[bool, typing.Any]
    '''

    pass


def render_border(override_context: typing.
                  Union[typing.Dict, 'bpy.types.Context'] = None,
                  execution_context: typing.Union[str, int] = None,
                  undo: typing.Optional[bool] = None,
                  *,
                  xmin: typing.Optional[typing.Any] = 0,
                  xmax: typing.Optional[typing.Any] = 0,
                  ymin: typing.Optional[typing.Any] = 0,
                  ymax: typing.Optional[typing.Any] = 0,
                  wait_for_input: typing.Union[bool, typing.Any] = True):
    ''' Set the boundaries of the border render and enable border render

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Union[bool, typing.Any]
    '''

    pass


def rotate(override_context: typing.Union[typing.
                                          Dict, 'bpy.types.Context'] = None,
           execution_context: typing.Union[str, int] = None,
           undo: typing.Optional[bool] = None,
           *,
           use_cursor_init: typing.Union[bool, typing.Any] = True):
    ''' Rotate the view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param use_cursor_init: Use Mouse Position, Allow the initial mouse position to be used
    :type use_cursor_init: typing.Union[bool, typing.Any]
    '''

    pass


def ruler_add(override_context: typing.Union[typing.
                                             Dict, 'bpy.types.Context'] = None,
              execution_context: typing.Union[str, int] = None,
              undo: typing.Optional[bool] = None):
    ''' Add ruler

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def ruler_remove(override_context: typing.
                 Union[typing.Dict, 'bpy.types.Context'] = None,
                 execution_context: typing.Union[str, int] = None,
                 undo: typing.Optional[bool] = None):
    ''' Undocumented, consider `contributing <https://developer.blender.org/T51061>`__.

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def select(override_context: typing.Union[typing.
                                          Dict, 'bpy.types.Context'] = None,
           execution_context: typing.Union[str, int] = None,
           undo: typing.Optional[bool] = None,
           *,
           extend: typing.Union[bool, typing.Any] = False,
           deselect: typing.Union[bool, typing.Any] = False,
           toggle: typing.Union[bool, typing.Any] = False,
           deselect_all: typing.Union[bool, typing.Any] = False,
           select_passthrough: typing.Union[bool, typing.Any] = False,
           center: typing.Union[bool, typing.Any] = False,
           enumerate: typing.Union[bool, typing.Any] = False,
           object: typing.Union[bool, typing.Any] = False,
           vert_without_handles: typing.Union[bool, typing.Any] = False,
           location: typing.Optional[typing.Any] = (0, 0)):
    ''' Select and activate item(s)

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param extend: Extend, Extend selection instead of deselecting everything first
    :type extend: typing.Union[bool, typing.Any]
    :param deselect: Deselect, Remove from selection
    :type deselect: typing.Union[bool, typing.Any]
    :param toggle: Toggle Selection, Toggle the selection
    :type toggle: typing.Union[bool, typing.Any]
    :param deselect_all: Deselect On Nothing, Deselect all when nothing under the cursor
    :type deselect_all: typing.Union[bool, typing.Any]
    :param select_passthrough: Only Select Unselected, Ignore the select action when the element is already selected
    :type select_passthrough: typing.Union[bool, typing.Any]
    :param center: Center, Use the object center when selecting, in edit mode used to extend object selection
    :type center: typing.Union[bool, typing.Any]
    :param enumerate: Enumerate, List objects under the mouse (object mode only)
    :type enumerate: typing.Union[bool, typing.Any]
    :param object: Object, Use object selection (edit mode only)
    :type object: typing.Union[bool, typing.Any]
    :param vert_without_handles: Control Point Without Handles, Only select the curve control point, not it's handles
    :type vert_without_handles: typing.Union[bool, typing.Any]
    :param location: Location, Mouse location
    :type location: typing.Optional[typing.Any]
    '''

    pass


def select_box(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None,
               *,
               xmin: typing.Optional[typing.Any] = 0,
               xmax: typing.Optional[typing.Any] = 0,
               ymin: typing.Optional[typing.Any] = 0,
               ymax: typing.Optional[typing.Any] = 0,
               wait_for_input: typing.Union[bool, typing.Any] = True,
               mode: typing.Optional[typing.Any] = 'SET'):
    ''' Select items using box selection

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Union[bool, typing.Any]
    :param mode: Mode * ``SET`` Set -- Set a new selection. * ``ADD`` Extend -- Extend existing selection. * ``SUB`` Subtract -- Subtract existing selection. * ``XOR`` Difference -- Invert existing selection. * ``AND`` Intersect -- Intersect existing selection.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def select_circle(override_context: typing.
                  Union[typing.Dict, 'bpy.types.Context'] = None,
                  execution_context: typing.Union[str, int] = None,
                  undo: typing.Optional[bool] = None,
                  *,
                  x: typing.Optional[typing.Any] = 0,
                  y: typing.Optional[typing.Any] = 0,
                  radius: typing.Optional[typing.Any] = 25,
                  wait_for_input: typing.Union[bool, typing.Any] = True,
                  mode: typing.Optional[typing.Any] = 'SET'):
    ''' Select items using circle selection

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param x: X
    :type x: typing.Optional[typing.Any]
    :param y: Y
    :type y: typing.Optional[typing.Any]
    :param radius: Radius
    :type radius: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Union[bool, typing.Any]
    :param mode: Mode * ``SET`` Set -- Set a new selection. * ``ADD`` Extend -- Extend existing selection. * ``SUB`` Subtract -- Subtract existing selection.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def select_lasso(override_context: typing.
                 Union[typing.Dict, 'bpy.types.Context'] = None,
                 execution_context: typing.Union[str, int] = None,
                 undo: typing.Optional[bool] = None,
                 *,
                 path: typing.Optional[bpy.types.bpy_prop_collection[
                     'bpy.types.OperatorMousePath']] = None,
                 mode: typing.Optional[typing.Any] = 'SET'):
    ''' Select items using lasso selection

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param path: Path
    :type path: typing.Optional[bpy.types.bpy_prop_collection['bpy.types.OperatorMousePath']]
    :param mode: Mode * ``SET`` Set -- Set a new selection. * ``ADD`` Extend -- Extend existing selection. * ``SUB`` Subtract -- Subtract existing selection. * ``XOR`` Difference -- Invert existing selection. * ``AND`` Intersect -- Intersect existing selection.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def select_menu(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None,
                *,
                name: typing.Union[str, int, typing.Any] = '',
                extend: typing.Union[bool, typing.Any] = False,
                deselect: typing.Union[bool, typing.Any] = False,
                toggle: typing.Union[bool, typing.Any] = False):
    ''' Menu object selection

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param name: Object Name
    :type name: typing.Union[str, int, typing.Any]
    :param extend: Extend
    :type extend: typing.Union[bool, typing.Any]
    :param deselect: Deselect
    :type deselect: typing.Union[bool, typing.Any]
    :param toggle: Toggle
    :type toggle: typing.Union[bool, typing.Any]
    '''

    pass


def smoothview(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None):
    ''' Undocumented, consider `contributing <https://developer.blender.org/T51061>`__.

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def snap_cursor_to_active(override_context: typing.
                          Union[typing.Dict, 'bpy.types.Context'] = None,
                          execution_context: typing.Union[str, int] = None,
                          undo: typing.Optional[bool] = None):
    ''' Snap 3D cursor to the active item

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def snap_cursor_to_center(override_context: typing.
                          Union[typing.Dict, 'bpy.types.Context'] = None,
                          execution_context: typing.Union[str, int] = None,
                          undo: typing.Optional[bool] = None):
    ''' Snap 3D cursor to the world origin

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def snap_cursor_to_grid(override_context: typing.
                        Union[typing.Dict, 'bpy.types.Context'] = None,
                        execution_context: typing.Union[str, int] = None,
                        undo: typing.Optional[bool] = None):
    ''' Snap 3D cursor to the nearest grid division

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def snap_cursor_to_selected(override_context: typing.
                            Union[typing.Dict, 'bpy.types.Context'] = None,
                            execution_context: typing.Union[str, int] = None,
                            undo: typing.Optional[bool] = None):
    ''' Snap 3D cursor to the middle of the selected item(s)

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def snap_selected_to_active(override_context: typing.
                            Union[typing.Dict, 'bpy.types.Context'] = None,
                            execution_context: typing.Union[str, int] = None,
                            undo: typing.Optional[bool] = None):
    ''' Snap selected item(s) to the active item

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def snap_selected_to_cursor(override_context: typing.
                            Union[typing.Dict, 'bpy.types.Context'] = None,
                            execution_context: typing.Union[str, int] = None,
                            undo: typing.Optional[bool] = None,
                            *,
                            use_offset: typing.Union[bool, typing.Any] = True):
    ''' Snap selected item(s) to the 3D cursor

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param use_offset: Offset, If the selection should be snapped as a whole or by each object center
    :type use_offset: typing.Union[bool, typing.Any]
    '''

    pass


def snap_selected_to_grid(override_context: typing.
                          Union[typing.Dict, 'bpy.types.Context'] = None,
                          execution_context: typing.Union[str, int] = None,
                          undo: typing.Optional[bool] = None):
    ''' Snap selected item(s) to their nearest grid division

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def toggle_matcap_flip(override_context: typing.
                       Union[typing.Dict, 'bpy.types.Context'] = None,
                       execution_context: typing.Union[str, int] = None,
                       undo: typing.Optional[bool] = None):
    ''' Flip MatCap

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def toggle_shading(override_context: typing.
                   Union[typing.Dict, 'bpy.types.Context'] = None,
                   execution_context: typing.Union[str, int] = None,
                   undo: typing.Optional[bool] = None,
                   *,
                   type: typing.Optional[typing.Any] = 'WIREFRAME'):
    ''' Toggle shading type in 3D viewport

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param type: Type, Shading type to toggle * ``WIREFRAME`` Wireframe -- Toggle wireframe shading. * ``SOLID`` Solid -- Toggle solid shading. * ``MATERIAL`` Material Preview -- Toggle material preview shading. * ``RENDERED`` Rendered -- Toggle rendered shading.
    :type type: typing.Optional[typing.Any]
    '''

    pass


def toggle_xray(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None):
    ''' Transparent scene display. Allow selecting through items

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def transform_gizmo_set(override_context: typing.
                        Union[typing.Dict, 'bpy.types.Context'] = None,
                        execution_context: typing.Union[str, int] = None,
                        undo: typing.Optional[bool] = None,
                        *,
                        extend: typing.Union[bool, typing.Any] = False,
                        type: typing.Optional[typing.Any] = {}):
    ''' Set the current transform gizmo

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param extend: Extend
    :type extend: typing.Union[bool, typing.Any]
    :param type: Type
    :type type: typing.Optional[typing.Any]
    '''

    pass


def view_all(override_context: typing.Union[typing.
                                            Dict, 'bpy.types.Context'] = None,
             execution_context: typing.Union[str, int] = None,
             undo: typing.Optional[bool] = None,
             *,
             use_all_regions: typing.Union[bool, typing.Any] = False,
             center: typing.Union[bool, typing.Any] = False):
    ''' View all objects in scene

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param use_all_regions: All Regions, View selected for all regions
    :type use_all_regions: typing.Union[bool, typing.Any]
    :param center: Center
    :type center: typing.Union[bool, typing.Any]
    '''

    pass


def view_axis(override_context: typing.Union[typing.
                                             Dict, 'bpy.types.Context'] = None,
              execution_context: typing.Union[str, int] = None,
              undo: typing.Optional[bool] = None,
              *,
              type: typing.Optional[typing.Any] = 'LEFT',
              align_active: typing.Union[bool, typing.Any] = False,
              relative: typing.Union[bool, typing.Any] = False):
    ''' Use a preset viewpoint

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param type: View, Preset viewpoint to use * ``LEFT`` Left -- View from the left. * ``RIGHT`` Right -- View from the right. * ``BOTTOM`` Bottom -- View from the bottom. * ``TOP`` Top -- View from the top. * ``FRONT`` Front -- View from the front. * ``BACK`` Back -- View from the back.
    :type type: typing.Optional[typing.Any]
    :param align_active: Align Active, Align to the active object's axis
    :type align_active: typing.Union[bool, typing.Any]
    :param relative: Relative, Rotate relative to the current orientation
    :type relative: typing.Union[bool, typing.Any]
    '''

    pass


def view_camera(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None):
    ''' Toggle the camera view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_center_camera(override_context: typing.
                       Union[typing.Dict, 'bpy.types.Context'] = None,
                       execution_context: typing.Union[str, int] = None,
                       undo: typing.Optional[bool] = None):
    ''' Center the camera view, resizing the view to fit its bounds

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_center_cursor(override_context: typing.
                       Union[typing.Dict, 'bpy.types.Context'] = None,
                       execution_context: typing.Union[str, int] = None,
                       undo: typing.Optional[bool] = None):
    ''' Center the view so that the cursor is in the middle of the view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_center_lock(override_context: typing.
                     Union[typing.Dict, 'bpy.types.Context'] = None,
                     execution_context: typing.Union[str, int] = None,
                     undo: typing.Optional[bool] = None):
    ''' Center the view lock offset

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_center_pick(override_context: typing.
                     Union[typing.Dict, 'bpy.types.Context'] = None,
                     execution_context: typing.Union[str, int] = None,
                     undo: typing.Optional[bool] = None):
    ''' Center the view to the Z-depth position under the mouse cursor

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_lock_clear(override_context: typing.
                    Union[typing.Dict, 'bpy.types.Context'] = None,
                    execution_context: typing.Union[str, int] = None,
                    undo: typing.Optional[bool] = None):
    ''' Clear all view locking

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_lock_to_active(override_context: typing.
                        Union[typing.Dict, 'bpy.types.Context'] = None,
                        execution_context: typing.Union[str, int] = None,
                        undo: typing.Optional[bool] = None):
    ''' Lock the view to the active object/bone

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_orbit(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None,
               *,
               angle: typing.Optional[typing.Any] = 0.0,
               type: typing.Optional[typing.Any] = 'ORBITLEFT'):
    ''' Orbit the view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param angle: Roll
    :type angle: typing.Optional[typing.Any]
    :param type: Orbit, Direction of View Orbit * ``ORBITLEFT`` Orbit Left -- Orbit the view around to the left. * ``ORBITRIGHT`` Orbit Right -- Orbit the view around to the right. * ``ORBITUP`` Orbit Up -- Orbit the view up. * ``ORBITDOWN`` Orbit Down -- Orbit the view down.
    :type type: typing.Optional[typing.Any]
    '''

    pass


def view_pan(override_context: typing.Union[typing.
                                            Dict, 'bpy.types.Context'] = None,
             execution_context: typing.Union[str, int] = None,
             undo: typing.Optional[bool] = None,
             *,
             type: typing.Optional[typing.Any] = 'PANLEFT'):
    ''' Pan the view in a given direction

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param type: Pan, Direction of View Pan * ``PANLEFT`` Pan Left -- Pan the view to the left. * ``PANRIGHT`` Pan Right -- Pan the view to the right. * ``PANUP`` Pan Up -- Pan the view up. * ``PANDOWN`` Pan Down -- Pan the view down.
    :type type: typing.Optional[typing.Any]
    '''

    pass


def view_persportho(override_context: typing.
                    Union[typing.Dict, 'bpy.types.Context'] = None,
                    execution_context: typing.Union[str, int] = None,
                    undo: typing.Optional[bool] = None):
    ''' Switch the current view from perspective/orthographic projection

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def view_roll(override_context: typing.Union[typing.
                                             Dict, 'bpy.types.Context'] = None,
              execution_context: typing.Union[str, int] = None,
              undo: typing.Optional[bool] = None,
              *,
              angle: typing.Optional[typing.Any] = 0.0,
              type: typing.Optional[typing.Any] = 'ANGLE'):
    ''' Roll the view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param angle: Roll
    :type angle: typing.Optional[typing.Any]
    :param type: Roll Angle Source, How roll angle is calculated * ``ANGLE`` Roll Angle -- Roll the view using an angle value. * ``LEFT`` Roll Left -- Roll the view around to the left. * ``RIGHT`` Roll Right -- Roll the view around to the right.
    :type type: typing.Optional[typing.Any]
    '''

    pass


def view_selected(override_context: typing.
                  Union[typing.Dict, 'bpy.types.Context'] = None,
                  execution_context: typing.Union[str, int] = None,
                  undo: typing.Optional[bool] = None,
                  *,
                  use_all_regions: typing.Union[bool, typing.Any] = False):
    ''' Move the view to the selection center

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param use_all_regions: All Regions, View selected for all regions
    :type use_all_regions: typing.Union[bool, typing.Any]
    '''

    pass


def walk(override_context: typing.Union[typing.
                                        Dict, 'bpy.types.Context'] = None,
         execution_context: typing.Union[str, int] = None,
         undo: typing.Optional[bool] = None):
    ''' Interactively walk around the scene

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def zoom(override_context: typing.Union[typing.
                                        Dict, 'bpy.types.Context'] = None,
         execution_context: typing.Union[str, int] = None,
         undo: typing.Optional[bool] = None,
         *,
         mx: typing.Optional[typing.Any] = 0,
         my: typing.Optional[typing.Any] = 0,
         delta: typing.Optional[typing.Any] = 0,
         use_cursor_init: typing.Union[bool, typing.Any] = True):
    ''' Zoom in/out in the view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mx: Region Position X
    :type mx: typing.Optional[typing.Any]
    :param my: Region Position Y
    :type my: typing.Optional[typing.Any]
    :param delta: Delta
    :type delta: typing.Optional[typing.Any]
    :param use_cursor_init: Use Mouse Position, Allow the initial mouse position to be used
    :type use_cursor_init: typing.Union[bool, typing.Any]
    '''

    pass


def zoom_border(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None,
                *,
                xmin: typing.Optional[typing.Any] = 0,
                xmax: typing.Optional[typing.Any] = 0,
                ymin: typing.Optional[typing.Any] = 0,
                ymax: typing.Optional[typing.Any] = 0,
                wait_for_input: typing.Union[bool, typing.Any] = True,
                zoom_out: typing.Union[bool, typing.Any] = False):
    ''' Zoom in the view to the nearest object contained in the border

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Union[bool, typing.Any]
    :param zoom_out: Zoom Out
    :type zoom_out: typing.Union[bool, typing.Any]
    '''

    pass


def zoom_camera_1_to_1(override_context: typing.
                       Union[typing.Dict, 'bpy.types.Context'] = None,
                       execution_context: typing.Union[str, int] = None,
                       undo: typing.Optional[bool] = None):
    ''' Match the camera to 1:1 to the render output

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass
