import numpy as np

range_axys_limits = {
    "swvht": [0.1, 19.9],
    "mxwvht": [0.1, 19.9],
    "tp": [1.7, 30],
    "wvdir": [0, 360],
    "wspd1": [0.1, 59],
    "wdir1": [0, 360],
    "gust1": [0.1, 59],
    "wspd2": [0.1, 59],
    "wdir2": [0, 360],
    "gust2": [0.1, 59],
    "atmp": [-39, 59],
    "pres": [501, 1099],
    "dewpt": [-29, 39],
    "sst": [-3, 39],
    "rh": [25, 102],
    "cspd1": [-4990, 4990],
    "cdir1": [0, 360],
    "cspd2": [-4990, 4990],
    "cdir2": [0, 360],
    "cspd3": [-4990, 4990],
    "cdir3": [0, 360],
    "tp": [1.7, 30],
    }

sigma_axys_limits = {
    "swvht": 6,
    "rh": 20,
    "pres": 21,
    "atmp": 11,
    "wspd": 25,
    "wspd1": 25,
    "wspd2": 25,
    "sst": 8.6,
    }

mis_value_axys_limits = {
    "rh": [11, -9999, np.nan],
    "cspd1": [409.5, -9999, np.nan],
    "cdir1": [511, -9999, np.nan],
    "cspd2": [409.5, -9999, np.nan],
    "cdir2": [511, -9999, np.nan],
    "cspd3": [409.5, -9999, np.nan],
    "cdir3": [511, -9999, np.nan],
    "dewpt": [-10, -9999, np.nan],
    "atmp": [-10, -9999, np.nan],
    "sst": [40.955, -9999, np.nan],
    "swvht": [20.47, -9999, np.nan],
    "mxwvht": [20.47, -9999, np.nan],
    "tp": [25.5, -9999, np.nan],
    "wvdir": [381, -9999, np.nan],
    "spred": [381, -9999, np.nan]
    }

fine_axys_limits = {
    "swvht": [0, 15],
    "mxwvht": [0, 19],
    "tp": [1.7, 20],
    "wspd1": [0, 59],
    "gust1": [0, 59],
    "wspd2": [0, 59],
    "gust2": [0, 59],
    "atmp": [-8, 42],
    "atmp": [8, 48],
    "atmp": [15, 48],
    "pres": [950, 1050],
    "dewpt": [-29, 39],
    "sst": [-3, 39],
    "tp": [1.7, 20],
    "cspd1": [-2500, 2500],
    "cspd2": [-2500, 2500],
    "cspd3": [-2500, 2500],
    }


std_mean_values = {
    "wwht": [0, 15],
    "mxwvht": [0, 19],
    "tp": [1.7, 20],
    "wspd": [0, 59],
    "gust": [0, 59],
    "wspd2": [0, 59],
    "gust2": [0, 59],
    "atmp": [-8, 42],
    "atmp": [8, 48],
    "atmp": [15, 48],
    "pres": [950, 1050],
    "dewpt": [-29, 39],
    "sst": [-3, 39],
    "apd": [1.7, 20],
    "cspd1": [-2500, 2500],
    "cspd2": [-2500, 2500],
    "cspd3": [-2500, 2500],
    }

height = {
    'wspd1': 4.4,
    'wspd2': 3.7
}

stuck_axys_limits = 7

continuity_axys_limits = 3


anemometer_ascat = {
    "riogrande":
        [{"start_date": "2009-04-28 00:00:00", "end_date": "2009-08-01 00:00:00", "choice": 3},
        {"start_date": "2009-08-01 00:00:00", "end_date": "2009-09-21 00:00:00", "choice": 0},
        {"start_date": "2009-09-21 00:00:00", "end_date": "2010-01-08 00:00:00", "choice": 3},
        {"start_date": "2010-01-08 00:00:00", "end_date": "2011-02-26 00:00:00", "choice": 0},
        {"start_date": "2011-02-26 00:00:00", "end_date": "2011-03-21 00:00:00", "choice": 2},
        {"start_date": "2011-03-21 00:00:00", "end_date": "2011-07-03 00:00:00", "choice": 0},
        {"start_date": "2011-07-03 00:00:00", "end_date": "2012-01-19 00:00:00", "choice": 0},
        {"start_date": "2012-01-19 00:00:00", "end_date": "2012-09-03 00:00:00", "choice": 3},
        {"start_date": "2012-09-03 00:00:00", "end_date": "2012-11-12 00:00:00", "choice": 1},
        {"start_date": "2012-11-12 00:00:00", "end_date": "2013-06-01 00:00:00", "choice": 0},
        {"start_date": "2013-06-01 00:00:00", "end_date": "2013-11-11 00:00:00", "choice": 2},
        {"start_date": "2013-11-11 00:00:00", "end_date": "2014-04-19 00:00:00", "choice": 0},
        {"start_date": "2014-04-19 00:00:00", "end_date": "2014-11-14 00:00:00", "choice": 2},
        {"start_date": "2014-11-14 00:00:00", "end_date": "2016-11-19 00:00:00", "choice": 3},
        {"start_date": "2016-11-19 00:00:00", "end_date": "2017-01-10 00:00:00", "choice": 1},
        {"start_date": "2017-01-10 00:00:00", "end_date": "2017-01-31 00:00:00", "choice": 3},
        {"start_date": "2017-01-31 00:00:00", "end_date": "2286-11-20 17:46:39", "choice": 1}],
    "portoseguro":
        [{"start_date": "2012-07-05 00:00:00", "end_date": "2013-06-23 00:00:00", "choice": 3},
        {"start_date": "2013-06-23 00:00:00", "end_date": "2013-06-26 00:00:00", "choice": 2},
        {"start_date": "2013-06-26 00:00:00", "end_date": "2013-07-01 00:00:00", "choice": 0},
        {"start_date": "2013-07-01 00:00:00", "end_date": "2014-12-04 00:00:00", "choice": 0},
        {"start_date": "2014-12-04 00:00:00", "end_date": "2015-05-16 00:00:00", "choice": 2},
        {"start_date": "2015-05-16 00:00:00", "end_date": "2015-07-01 00:00:00", "choice": 1},
        {"start_date": "2015-07-01 00:00:00", "end_date": "2016-02-13 00:00:00", "choice": 0},
        {"start_date": "2016-02-13 00:00:00", "end_date": "2016-07-18 00:00:00", "choice": 2},
        {"start_date": "2016-07-18 00:00:00", "end_date": "2016-09-12 00:00:00", "choice": 0},
        {"start_date": "2016-09-12 00:00:00", "end_date": "2026-11-20 17:46:39", "choice": 2}],
    "cabofrio2":
        [{"start_date": "2016-07-20 00:00:00", "end_date": "2017-04-10 00:00:00", "choice": 3},
        {"start_date": "2017-04-10 00:00:00", "end_date": "2017-10-02 00:00:00", "choice": 2},
        {"start_date": "2017-10-02 00:00:00", "end_date": "2018-09-18 00:00:00", "choice": 0},
        {"start_date": "2018-09-18 00:00:00", "end_date": "2286-11-20 17:46:39", "choice": 3}],
    "santos":
        [{"start_date": "2011-04-11 00:00:00", "end_date": "2011-08-15 00:00:00", "choice": 3},
        {"start_date": "2011-08-15 00:00:00", "end_date": "2013-05-01 00:00:00", "choice": 2},
        {"start_date": "2013-05-01 00:00:00", "end_date": "2013-06-10 00:00:00", "choice": 3},
        {"start_date": "2013-06-10 00:00:00", "end_date": "2013-06-13 00:00:00", "choice": 1},
        {"start_date": "2013-06-13 00:00:00", "end_date": "2013-09-18 00:00:00", "choice": 3},
        {"start_date": "2013-09-18 00:00:00", "end_date": "2014-01-02 00:00:00", "choice": 2},
        {"start_date": "2014-01-02 00:00:00", "end_date": "2014-05-06 00:00:00", "choice": 2},
        {"start_date": "2014-05-06 00:00:00", "end_date": "2014-06-11 00:00:00", "choice": 0},
        {"start_date": "2014-06-11 00:00:00", "end_date": "2014-10-07 00:00:00", "choice": 2},
        {"start_date": "2014-10-07 00:00:00", "end_date": "2014-11-16 00:00:00", "choice": 0},
        {"start_date": "2014-11-16 00:00:00", "end_date": "2016-06-16 00:00:00", "choice": 2},
        {"start_date": "2016-06-16 00:00:00", "end_date": "2017-04-08 00:00:00", "choice": 3},
        {"start_date": "2017-04-08 00:00:00", "end_date": "2017-06-08 00:00:00", "choice": 0},
        {"start_date": "2017-06-08 00:00:00", "end_date": "2017-07-11 00:00:00", "choice": 0},
        {"start_date": "2017-07-11 00:00:00", "end_date": "2017-08-14 00:00:00", "choice": 1},
        {"start_date": "2017-08-14 00:00:00", "end_date": "2017-11-10 00:00:00", "choice": 0},
        {"start_date": "2017-11-10 00:00:00", "end_date": "2018-06-19 00:00:00", "choice": 1},
        {"start_date": "2018-06-19 00:00:00", "end_date": "2018-08-07 00:00:00", "choice": 0},
        {"start_date": "2018-08-07 00:00:00", "end_date": "2018-10-18 00:00:00", "choice": 3}],
    "itajai":
        [{"start_date": "2009-04-28 00:00:00", "end_date": "2009-12-10 00:00:00", "choice": 3},
        {"start_date": "2009-12-10 00:00:00", "end_date": "2011-02-16 00:00:00", "choice": 0},
        {"start_date": "2011-02-16 00:00:00", "end_date": "2012-01-25 00:00:00", "choice": 3},
        {"start_date": "2012-01-25 00:00:00", "end_date": "2012-10-04 00:00:00", "choice": 4},
        {"start_date": "2012-10-04 00:00:00", "end_date": "2013-01-31 00:00:00", "choice": 0},
        {"start_date": "2013-01-31 00:00:00", "end_date": "2013-09-26 00:00:00", "choice": 3},
        {"start_date": "2013-09-26 00:00:00", "end_date": "2014-11-14 00:00:00", "choice": 0},
        {"start_date": "2014-11-14 00:00:00", "end_date": "2015-10-30 00:00:00", "choice": 2},
        {"start_date": "2015-10-30 00:00:00", "end_date": "2016-04-09 00:00:00", "choice": 0},
        {"start_date": "2016-04-09 00:00:00", "end_date": "2016-07-22 00:00:00", "choice": 3},
        {"start_date": "2016-07-22 00:00:00", "end_date": "2017-02-02 00:00:00", "choice": 2},
        {"start_date": "2017-02-02 00:00:00", "end_date": "2018-04-15 00:00:00", "choice": 2},
        {"start_date": "2018-04-15 00:00:00", "end_date": "2018-04-30 00:00:00", "choice": 1},
        {"start_date": "2018-04-30 00:00:00", "end_date": "2286-11-20 17:46:39", "choice": 2}]
}
