# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gridplayer',
 'gridplayer.dialogs',
 'gridplayer.main',
 'gridplayer.models',
 'gridplayer.multiprocess',
 'gridplayer.params',
 'gridplayer.player',
 'gridplayer.player.managers',
 'gridplayer.utils',
 'gridplayer.utils.stream_proxy',
 'gridplayer.utils.url_resolve',
 'gridplayer.vlc_player',
 'gridplayer.widgets']

package_data = \
{'': ['*']}

install_requires = \
['PyQt5==5.15.7',
 'pydantic>=1.8.2,<2.0.0',
 'python-vlc==3.0.11115',
 'streamlink==4.2.0',
 'yt-dlp==2022.07.18']

extras_require = \
{':sys_platform == "darwin"': ['pyobjc-core', 'pyobjc-framework-Cocoa']}

entry_points = \
{'console_scripts': ['gridplayer = gridplayer.__main__:main']}

setup_kwargs = {
    'name': 'gridplayer',
    'version': '0.4.3',
    'description': 'Play videos side-by-side',
    'long_description': '![GridPlayer](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/logo.png)\n\n[![PyPI version](https://img.shields.io/pypi/v/gridplayer)](https://pypi.python.org/pypi/gridplayer)\n[![Github All Releases](https://img.shields.io/github/downloads/vzhd1701/gridplayer/total.svg)](https://github.com/vzhd1701/gridplayer/releases/latest)\n[![Crowdin](https://badges.crowdin.net/gridplayer/localized.svg)](https://crowdin.com/project/gridplayer)\n\n## Screenshots\n\n[![Screenshot 1](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-001-thumb.png)](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-001.png)\n[![Screenshot 2](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-002-thumb.png)](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-002.png)\n[![Screenshot 3](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-003-thumb.png)](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-003.png)\n[![Screenshot 4](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-004-thumb.png)](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/screenshot-004.png)\n\n## About\n\nSimple VLC-based media player that can play multiple videos at the same time. You can\nplay as many videos as you like, the only limit is your hardware. It supports all video\nformats that VLC supports (which is all of them). You can save your playlist retaining\ninformation about the position, sound volume, loops, aspect ratio, etc.\n\n## Features\n\n- Cross-platform (Linux, Mac, and Windows)\n- Support for any video and audio format (VLC)\n- Support for (almost) any streaming URLs ([streamlink](https://streamlink.github.io/plugins.html) + [yt-dlp](https://github.com/yt-dlp/yt-dlp/blob/master/supportedsites.md))\n- Hardware & software video decoding\n- Control video aspect, playback speed, zoom\n- Set loop fragments with frame percision\n- Configurable grid layout\n- Easy swap videos with drag-n-drop\n- Playlist retains settings for each video\n\n## Translation\n\nGridPlayer now supports internationalization! Anyone with a handful of free time and\ndesire to support this project is [welcome to contribute](https://crowdin.com/project/gridplayer).\nNo coding skills or special software required, all dialogs are well documented and\nthere are not many strings to translate. Every contributor will be given proper credit.\n\n## Installation\n\n### Windows\n\n[![Download Windows Installer](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/dl_windows_installer.png)](https://github.com/vzhd1701/gridplayer/releases/download/v0.4.3/GridPlayer-0.4.3-win64-install.exe)\n[![Download Windows Portable](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/dl_windows_portable.png)](https://github.com/vzhd1701/gridplayer/releases/download/v0.4.3/GridPlayer-0.4.3-win64-portable.zip)\n\n**Compatible with Windows 7, 8, 10, 11.**\n\n### Linux\n\n[![Get it from the Flathub](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/dl_flathub.png)](https://flathub.org/apps/details/com.vzhd1701.gridplayer)\n[![Get it from the Snap Store](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/dl_snap.png)](https://snapcraft.io/gridplayer)\n[![Download AppImage](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/dl_appimage.png)](https://github.com/vzhd1701/gridplayer/releases/download/v0.4.3/GridPlayer-0.4.3-x86_64.AppImage)\n\n**For better system integration install via Flathub.**\n\n#### Note on AppImage\n\nThe AppImage was built using Ubuntu Focal Fossa libraries, so compatibility is Ubuntu 20+.\n\nYou may need to set execute permissions on AppImage file in order to run it:\n\n```shell\n$ chmod +x GridPlayer-0.4.3-x86_64.AppImage\n```\n\n### MacOS\n\n[![Download DMG](https://raw.githubusercontent.com/vzhd1701/gridplayer/master/resources/public/dl_dmg.png)](https://github.com/vzhd1701/gridplayer/releases/download/v0.4.3/GridPlayer.0.4.3.dmg)\n\n**DMG image is not signed.** You will have to add an exception to run this app.\n\n- [How to open an app that hasn’t been notarized or is from an unidentified developer](https://support.apple.com/en-euro/HT202491)\n- [Open a Mac app from an unidentified developer](https://support.apple.com/guide/mac-help/open-a-mac-app-from-an-unidentified-developer-mh40616/mac)\n\nIf you get "GridPlayer is damaged and can\'t be opened" error, run this command in the Terminal app:\n\n```shell\n$ sudo xattr -rd com.apple.quarantine /Applications/GridPlayer.app\n```\n\n### PIP\n\n```shell\n$ pip install -U gridplayer\n```\n\n**Python 3.8 or later required.**\n\nThis type of installation will also require a `vlc` package present in your system.\nPlease refer to [VLC official page](https://www.videolan.org/vlc/) for instructions on how to install it.\n\nSome distros (e.g. Ubuntu) might also require `libxcb-xinerama0` package.\n\n### From source\n\nThis project uses [poetry](https://python-poetry.org/) for dependency management and packaging. You will have to install it first. See [poetry official documentation](https://python-poetry.org/docs/) for instructions.\n\n```shell\n$ git clone https://github.com/vzhd1701/gridplayer.git\n$ cd gridplayer/\n$ poetry install --no-dev\n$ poetry run gridplayer\n```\n\nThe same notes about the Python version and external packages from **PIP** installation apply here.\n\n## Video Decoder settings\n\nGridPlayer supports two video output modes:\n\n- Hardware (default) mode uses available GPU to render video. This mode offers high performance and is a recommended mode.\n- Software mode is entirely independent of GPU and only uses the CPU to render video. This mode may cause a high CPU load with high-resolution videos.\n\nDue to libvlc software library limitations, video decoding is split into parallel processes. You can control how many videos are handled by a single decoder process using the "Videos per process" setting. Setting this option too high may cause a high CPU load and application freeze. The optimal value is 4 videos per process.\n\nThere is also "Hardware SP" mode. It handles video decoding within the same process in which GridPlayer runs. It is not recommended to use with many videos (>4-6) because it may cause high CPU load and application freeze.\n\nDue to OS inter-process restrictions, "Hardware SP" is the only available hardware mode in macOS.\n\n## Known issues\n\n#### Linux (Snap): Error when opening a file from the mounted disk\n\nYou need to allow GridPlayer snap to access removable storage devices via Snap Store or by running:\n\n```shell\n$ sudo snap connect gridplayer:removable-media\n```\n\n#### Linux (Snap): mounted drives are not visible in file selection dialog\n\nYou will also see following error if you run GridPlayer from terminal:\n\n```shell\nGLib-GIO-WARNING **: Error creating IO channel for /proc/self/mountinfo: Permission denied (g-file-error-quark, 2)\n```\n\nTo fix this, you need to allow GridPlayer snap to access system mount information and disk quotas via Snap Store or by running:\n\n```shell\n$ sudo snap connect gridplayer:mount-observe\n```\n\n#### Linux (KDE): black screen issue when using hardware decoder\n\nSwitch on "Opaque overlay (fix black screen)" checkbox in settings.\n\nOverlay might be a bit glitchy in KDE with hardware decoder.\n\n## Geting help\n\nIf you found a bug or have a feature request, please [open a new issue](https://github.com/vzhd1701/gridplayer/issues/new/choose).\n\nIf you have a question about the program or have difficulty using it, you are welcome to [the discussions page](https://github.com/vzhd1701/gridplayer/discussions). You can also mail me directly, I\'m always happy to help.\n\n## Attributions\n\nThis software was build using\n\n- **Python** by [Python Software Foundation](https://www.python.org/)\n  - Licensed under *Python Software Foundation License*\n- **Qt** by [Qt Project](https://www.qt.io/)\n  - Licensed under *GPL 2.0, GPL 3.0, and LGPL 3.0*\n- **VLC** by [VideoLAN](https://www.videolan.org/)\n  - Licensed under *GPL 2.0 or later*\n\n### Python packages\n\n- **PyQt** by [Riverbank Computing](https://riverbankcomputing.com/)\n  - Licensed under *Riverbank Commercial License and GPL v3*\n- **python-vlc** by [Olivier Aubert](https://github.com/oaubert/python-vlc)\n  - Licensed under *GPL 2.0 and LGPL 2.1*\n- **pydantic** by [Samuel Colvin](https://github.com/samuelcolvin/pydantic)\n  - Licensed under *MIT License*\n- **streamlink** by [Christopher Rosell, Streamlink Team](https://github.com/streamlink/streamlink)\n  - Licensed under *BSD-2-Clause License*\n- **yt-dlp** by [Contributors](https://github.com/yt-dlp/yt-dlp)\n  - Licensed under *Unlicense License*\n\n### Graphics\n\n- **Hack Font** by [Source Foundry](http://sourcefoundry.org/hack/)\n  - Licensed under *MIT License*\n- **Basic Icons** by [Icongeek26](https://www.flaticon.com/authors/icongeek26)\n  - Licensed under *Flaticon License*\n- **Suru Icons** by [Sam Hewitt](https://snwh.org/)\n  - Licensed under *Creative Commons Attribution-Share Alike 4.0*\n- **Clean App Download Buttons** by [Tony Thomas](https://medialoot.com/item/clean-app-download-buttons/)\n  - Licensed under *MediaLoot License*\n- **Flag Icons** by [Panayiotis Lipiridis](https://github.com/lipis/flag-icons)\n  - Licensed under *MIT License*\n\n### Translations\n\n- **Hungarian** by [samu112](https://crowdin.com/profile/samu112)\n\n## License\n\nThis software is licensed under the terms of the GNU General Public License version 3 (GPLv3). Full text of the license is available in the [LICENSE](https://github.com/vzhd1701/gridplayer/blob/master/LICENSE) file and [online](https://www.gnu.org/licenses/gpl-3.0.html).\n',
    'author': 'vzhd1701',
    'author_email': 'vzhd1701@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vzhd1701/gridplayer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
