# Generated by Django 2.1.8 on 2019-05-06 09:01

import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models

import vng_api_common.fields


class Migration(migrations.Migration):

    dependencies = [("authorizations", "0005_auto_20190506_0842")]

    operations = [
        migrations.AlterField(
            model_name="applicatie",
            name="client_ids",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=50),
                help_text="Komma-gescheiden lijst van consumer identifiers (hun client_id).",
                size=None,
                verbose_name="client IDs",
            ),
        ),
        migrations.AlterField(
            model_name="applicatie",
            name="heeft_alle_autorisaties",
            field=models.BooleanField(
                default=False,
                help_text="Indien alle autorisaties gegeven zijn, dan hoeven deze niet individueel opgegeven te worden. Gebruik dit alleen als je de consumer helemaal vertrouwt.",
                verbose_name="heeft alle autorisaties",
            ),
        ),
        migrations.AlterField(
            model_name="applicatie",
            name="label",
            field=models.CharField(
                help_text="Een leesbare representatie van de applicatie, voor eindgebruikers.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="autorisatie",
            name="applicatie",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="autorisaties",
                to="authorizations.Applicatie",
                verbose_name="applicatie",
            ),
        ),
        migrations.AlterField(
            model_name="autorisatie",
            name="component",
            field=models.CharField(
                choices=[
                    ("AC", "Autorisatiecomponent"),
                    ("NRC", "Notificatierouteringcomponent"),
                    ("ZRC", "Zaakregistratiecomponent"),
                    ("ZTC", "Zaaktypecatalogus"),
                    ("DRC", "Documentregistratiecomponent"),
                    ("BRC", "Besluitregistratiecomponent"),
                ],
                help_text="Component waarop autorisatie van toepassing is.",
                max_length=50,
                verbose_name="component",
            ),
        ),
        migrations.AlterField(
            model_name="autorisatie",
            name="max_vertrouwelijkheidaanduiding",
            field=vng_api_common.fields.VertrouwelijkheidsAanduidingField(
                blank=True,
                choices=[
                    ("openbaar", "OPENBAAR"),
                    ("beperkt openbaar", "BEPERKT OPENBAAR"),
                    ("intern", "INTERN"),
                    ("zaakvertrouwelijk", "ZAAKVERTROUWELIJK"),
                    ("vertrouwelijk", "VERTROUWELIJK"),
                    ("confidentieel", "CONFIDENTIEEL"),
                    ("geheim", "GEHEIM"),
                    ("zeer geheim", "ZEER GEHEIM"),
                ],
                help_text="Maximaal toegelaten vertrouwelijkheidaanduiding (inclusief).",
                max_length=20,
            ),
        ),
        migrations.AlterField(
            model_name="autorisatie",
            name="scopes",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=100),
                help_text="Komma-gescheiden lijst van scope labels.",
                size=None,
                verbose_name="scopes",
            ),
        ),
        migrations.AlterField(
            model_name="autorisatie",
            name="zaaktype",
            field=models.URLField(
                blank=True,
                help_text="URL naar het zaaktype waarop de autorisatie van toepassing is.",
                max_length=1000,
                verbose_name="zaaktype",
            ),
        ),
    ]
