import socket

def is_valid_ipv4(ip_str: str) -> bool:
    parts = ip_str.split('.')
    if len(parts) != 4:
        return False
    for part in parts:
        if not part.isdigit():
            return False
        num = int(part)
        if num < 0 or num > 255 or part != str(num):
            return False
    return True

def parse_ports(range_str: str) -> list[int]:
    ports = []
    parts = range_str.split(',')
    for part in parts:
        if "-" in part:
            try:
                start, end = map(int, part.split('-'))
                ports.extend(range(start, end + 1))
            except ValueError:
                raise ValueError(f"Invalid range format: {part}")
        elif part.isdigit():
            ports.append(int(part))
        else:
            raise ValueError(f"Invalid port format: {part}")
    return list(set(ports))

def load_default_ports(path='assets/common_1k_ports.txt') -> list[int]:
    try:
        with open(path, 'r') as f:
            return [int(p) for p in f.read().split(',') if p.strip().isdigit()]
    except (FileNotFoundError, ValueError):
        return [80, 443, 8080]  # Fallback

def scan_port(ip: str, port: int, timeout: float = 0.5) -> bool:
    try:
        with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as sock:
            sock.settimeout(timeout)
            return sock.connect_ex((ip, port)) == 0
    except Exception:
        return False
