# pentest_tls
Develop multiple pentest tools by python

### Installation
#### Create virtual environment (Recommended)
- 1. Create a virtual environment named `venv` and the folder named `venv`
```
python3 -m venv venv
```
- 2. Activate the venv
```
source venv/bin/activate
```
- 3. install dependencies
```
pip3 install -r requirements.txt
```
- 4. (Optional) After developing, deactivate/check the environment
```
deactivate
which python
```

#### How to use
- Simple usage
```
python3 port_scanner.py 127.0.0.1
python3 port_scanner.py 127.0.0.1 -p 80,443
python3 port_scanner.py 127.0.0.1 -p 8000-8080
python3 port_scanner.py 127.0.0.1 -p 80,443,8000-8080
```
- Check the help page to see more detailed description
```
python3 port_scanner.py --help
python3 port_scanner.py -h
```

#### Deploy to PyPI
source venv/bin/activate
# replace python3 setup.py sdist bdist_wheel
python3 -m build
twine upload dist/*