"""Initial schema

Revision ID: 44402069e137
Revises: None
Create Date: 2014-05-04 17:10:23.127702

"""

# revision identifiers, used by Alembic.
revision = '44402069e137'
down_revision = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('project',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('subscribed', sa.Boolean(), nullable=True),
    sa.Column('description', sa.Text(), nullable=False),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_project_name'), 'project', ['name'], unique=True)
    op.create_index(op.f('ix_project_subscribed'), 'project', ['subscribed'], unique=False)
    op.create_table('change',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('project_key', sa.Integer(), nullable=True),
    sa.Column('id', sa.String(length=255), nullable=False),
    sa.Column('number', sa.Integer(), nullable=False),
    sa.Column('branch', sa.String(length=255), nullable=False),
    sa.Column('change_id', sa.String(length=255), nullable=False),
    sa.Column('topic', sa.String(length=255), nullable=True),
    sa.Column('owner', sa.String(length=255), nullable=True),
    sa.Column('subject', sa.Text(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('updated', sa.DateTime(), nullable=False),
    sa.Column('status', sa.String(length=8), nullable=False),
    sa.Column('hidden', sa.Boolean(), nullable=False),
    sa.Column('reviewed', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['project_key'], ['project.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_change_branch'), 'change', ['branch'], unique=False)
    op.create_index(op.f('ix_change_change_id'), 'change', ['change_id'], unique=False)
    op.create_index(op.f('ix_change_created'), 'change', ['created'], unique=False)
    op.create_index(op.f('ix_change_hidden'), 'change', ['hidden'], unique=False)
    op.create_index(op.f('ix_change_id'), 'change', ['id'], unique=True)
    op.create_index(op.f('ix_change_owner'), 'change', ['owner'], unique=False)
    op.create_index(op.f('ix_change_project_key'), 'change', ['project_key'], unique=False)
    op.create_index(op.f('ix_change_reviewed'), 'change', ['reviewed'], unique=False)
    op.create_index(op.f('ix_change_status'), 'change', ['status'], unique=False)
    op.create_index(op.f('ix_change_topic'), 'change', ['topic'], unique=False)
    op.create_index(op.f('ix_change_updated'), 'change', ['updated'], unique=False)
    op.create_table('approval',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('change_key', sa.Integer(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('category', sa.String(length=255), nullable=False),
    sa.Column('value', sa.Integer(), nullable=False),
    sa.Column('pending', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['change_key'], ['change.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_approval_change_key'), 'approval', ['change_key'], unique=False)
    op.create_index(op.f('ix_approval_pending'), 'approval', ['pending'], unique=False)
    op.create_table('revision',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('change_key', sa.Integer(), nullable=True),
    sa.Column('number', sa.Integer(), nullable=False),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('commit', sa.String(length=255), nullable=False),
    sa.Column('parent', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['change_key'], ['change.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_revision_change_key'), 'revision', ['change_key'], unique=False)
    op.create_index(op.f('ix_revision_number'), 'revision', ['number'], unique=False)
    op.create_table('label',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('change_key', sa.Integer(), nullable=True),
    sa.Column('category', sa.String(length=255), nullable=False),
    sa.Column('value', sa.Integer(), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['change_key'], ['change.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_label_change_key'), 'label', ['change_key'], unique=False)
    op.create_table('permitted_label',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('change_key', sa.Integer(), nullable=True),
    sa.Column('category', sa.String(length=255), nullable=False),
    sa.Column('value', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['change_key'], ['change.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_permitted_label_change_key'), 'permitted_label', ['change_key'], unique=False)
    op.create_table('comment',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('revision_key', sa.Integer(), nullable=True),
    sa.Column('id', sa.String(length=255), nullable=True),
    sa.Column('in_reply_to', sa.String(length=255), nullable=True),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('file', sa.Text(), nullable=False),
    sa.Column('parent', sa.Boolean(), nullable=False),
    sa.Column('line', sa.Integer(), nullable=True),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('pending', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['revision_key'], ['revision.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_comment_created'), 'comment', ['created'], unique=False)
    op.create_index(op.f('ix_comment_id'), 'comment', ['id'], unique=False)
    op.create_index(op.f('ix_comment_pending'), 'comment', ['pending'], unique=False)
    op.create_index(op.f('ix_comment_revision_key'), 'comment', ['revision_key'], unique=False)
    op.create_table('message',
    sa.Column('key', sa.Integer(), nullable=False, quote=True),
    sa.Column('revision_key', sa.Integer(), nullable=True),
    sa.Column('id', sa.String(length=255), nullable=True),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('pending', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['revision_key'], ['revision.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_message_created'), 'message', ['created'], unique=False)
    op.create_index(op.f('ix_message_id'), 'message', ['id'], unique=False)
    op.create_index(op.f('ix_message_pending'), 'message', ['pending'], unique=False)
    op.create_index(op.f('ix_message_revision_key'), 'message', ['revision_key'], unique=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_message_revision_key'), table_name='message')
    op.drop_index(op.f('ix_message_pending'), table_name='message')
    op.drop_index(op.f('ix_message_id'), table_name='message')
    op.drop_index(op.f('ix_message_created'), table_name='message')
    op.drop_table('message')
    op.drop_index(op.f('ix_comment_revision_key'), table_name='comment')
    op.drop_index(op.f('ix_comment_pending'), table_name='comment')
    op.drop_index(op.f('ix_comment_id'), table_name='comment')
    op.drop_index(op.f('ix_comment_created'), table_name='comment')
    op.drop_table('comment')
    op.drop_index(op.f('ix_permitted_label_change_key'), table_name='permitted_label')
    op.drop_table('permitted_label')
    op.drop_index(op.f('ix_label_change_key'), table_name='label')
    op.drop_table('label')
    op.drop_index(op.f('ix_revision_number'), table_name='revision')
    op.drop_index(op.f('ix_revision_change_key'), table_name='revision')
    op.drop_table('revision')
    op.drop_index(op.f('ix_approval_pending'), table_name='approval')
    op.drop_index(op.f('ix_approval_change_key'), table_name='approval')
    op.drop_table('approval')
    op.drop_index(op.f('ix_change_updated'), table_name='change')
    op.drop_index(op.f('ix_change_topic'), table_name='change')
    op.drop_index(op.f('ix_change_status'), table_name='change')
    op.drop_index(op.f('ix_change_reviewed'), table_name='change')
    op.drop_index(op.f('ix_change_project_key'), table_name='change')
    op.drop_index(op.f('ix_change_owner'), table_name='change')
    op.drop_index(op.f('ix_change_id'), table_name='change')
    op.drop_index(op.f('ix_change_hidden'), table_name='change')
    op.drop_index(op.f('ix_change_created'), table_name='change')
    op.drop_index(op.f('ix_change_change_id'), table_name='change')
    op.drop_index(op.f('ix_change_branch'), table_name='change')
    op.drop_table('change')
    op.drop_index(op.f('ix_project_subscribed'), table_name='project')
    op.drop_index(op.f('ix_project_name'), table_name='project')
    op.drop_table('project')
    ### end Alembic commands ###
