supported_aminoacids = ["ALA", "ARG", "ASH", "ASN", "ASP", "CYS", "CYT", "GLH",
                        "GLN", "GLU", "GLY", "HID", "HIE", "HIS", "HIP", "ILE",
                        "LEU", "LYS", "LYN", "MET", "PHE", "PRO", "SER", "TRP",
                        "THR", "TYR", "VAL", "ACE", "NMA"]
aminoacids_3letter = ['ALA', 'ARG', 'ASH', 'ASN', 'ASP', 'CYS', 'GLH', 'GLN',
                      'GLU', 'GLY', 'HID', 'HIE', 'HIS', 'HIP', 'ILE', 'LEU',
                      'LYS', 'LYN', 'MET', 'PHE', 'PRO', 'SER', 'TRP', 'THR',
                      'TYR', 'VAL']

aminoacids_1letter = ["A",  "R", "D", "N", "D", "C", "E", "Q", "E", "G", "H", "H",
                            "H",  "H", "I", "L", "K", "K", "M", "F", "P", "S", "W", "T",
                            "Y", "V"]

protein_atomnames_dictionary = {
    "END": [["H1", "1H", "HN1", "HN1", "HT1"], ["H2", "2H", "HN2", "HN2", "HT2"],
            ["H3", "3H", "HN3", "H", "HN3", "HT3"], ["OXT", "O1", "OT2", "OXT", "OXT"]],
    "ALA": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB1', '1HB', '2HB', 'HB1', 'HB1', 'HB1', 'HB1'], ['HB2', '2HB', 'HB2', 'HB2', 'HB2', 'HB2', 'HB2'],
            ['HB3', '3HB', 'HB3', 'HB3', 'HB3', 'HB3', 'HB3'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "ARG": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG2', '1HG', 'HG1', 'HG1', 'HG2', '2HG', 'HG2'], ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'],
            ['HD2', '1HD', 'HD1', 'HD1', 'HD2', 'HD2', '2HD'], ['HD3', '2HD', 'HD2', 'HD2', 'HD1', 'HD1', 'HD3'],
            ['HE', 'HE', 'HNE', 'HE', 'HE', 'HE', 'HE'], ['HH11', '1HH1', 'HN11', 'HH11', 'HH11', 'HH11', 'HH11'],
            ['HH12', '2HH1', 'HN12', 'HH12', 'HH12', 'HH12', 'HH12'],
            ['HH21', '1HH2', 'HN21', 'HH22', 'HH21', 'HH21', 'HH21'],
            ['HH22', '2HH2', 'HN22', 'HH21', 'HH22', 'HH22', 'HH22'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD', 'CD', 'CD', 'CD', 'CD', 'CD', 'CD'],
            ['CZ', 'CZ', 'CZ', 'CZ', 'CZ', 'CZ', 'CZ'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['NE', 'NE', 'NE', 'NE', 'NE', 'NE', 'NE'], ['NH1', 'NH1', 'NH1', 'NH1', 'NH1', 'NH1', 'NH1'],
            ['NH2', 'NH2', 'NH2', 'NH2', 'NH2', 'NH2', 'NH2'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "ASH": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD2', 'HD2', 'HD2'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O'],
            ['OD1', 'OD1', 'OD1', 'OD1', 'OD1', 'OD1', 'OD1'], ['OD2', 'OD2', 'OD2', 'OD2', 'OD2', 'OD2', 'OD2']],
    "ASN": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD21', '1HD2', 'HN21', 'HD21', 'HD1', 'HD21', 'HD21'],
            ['HD22', '2HD2', 'HN22', 'HD22', 'HD2', 'HD22', 'HD22'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['ND2', 'ND2', 'ND2', 'ND2', 'ND2', 'ND2', 'ND2'], ['O', 'O', 'O', 'O', 'O', 'O', 'O'],
            ['OD1', 'OD1', 'OD1', 'OD1', 'OD1', 'OD1', 'OD1']],
    "ASP": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O'],
            ['OD1', 'OD1', 'OD1', 'OD1', 'OD1', 'OD1', 'OD1'], ['OD2', 'OD2', 'OD2', 'OD2', 'OD2', 'OD2', 'OD2']],
    "CYS": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG', 'HG', 'HSG', 'HG', 'HG', 'HG', 'HG'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O'],
            ['SG', 'SG', 'SG', 'SG', 'SG', 'SG', 'SG']],
    "CYT": [['H', 'H', 'HN', 'HN', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O'], ['SG', 'SG', 'SG', 'SG', 'SG', 'SG', 'SG']],
    "GLN": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', 'HB1', '2HB', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG2', '1HG', 'HG1', 'HG1', '2HG', 'HG2', 'HG2'], ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'],
            ['HE21', '1HE2', 'HN21', 'HE1', 'HE21', 'HE21', 'HE21'],
            ['HE22', '2HE2', 'HN22', 'HE2', 'HE22', 'HE22', 'HE22'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD', 'CD', 'CD', 'CD', 'CD', 'CD', 'CD'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O'], ['OE1', 'OE1', 'OE1', 'OE1', 'OE1', 'OE1', 'OE1']],
    "GLY": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA2', '1HA', '2HA', 'HA1', 'HA2', 'HA2', 'HA1'],
            ['HA3', '2HA', 'HA2', 'HA2', 'HA1', 'HA1', 'HA2'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "GLU": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG2', '1HG', 'HG1', 'HG1', 'HG2', '2HG', 'HG2'], ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'],
            ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'],
            ['CD', 'CD', 'CD', 'CD', 'CD', 'CD', 'CD'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O'], ['OE1', 'OE1', 'OE1', 'OE1', 'OE1', 'OE1', 'OE1'],
            ['OE2', 'OE2', 'OE2', 'OE2', 'OE2', 'OE2', 'OE2']],
    "GLH": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG2', '1HG', 'HG1', '2HG', 'HG2', 'HG2', 'HG2'], ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'],
            ['HE2', 'HE2', 'HE2'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'],
            ['CD', 'CD', 'CD', 'CD', 'CD', 'CD', 'CD'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O'], ['OE1', 'OE1', 'OE1', 'OE1', 'OE1', 'OE1', 'OE1'],
            ['OE2', 'OE2', 'OE2', 'OE2', 'OE2', 'OE2', 'OE2']],
    "HIE": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN1'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2'], ['HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1'],
            ['HE2', 'HNE2', 'HE2', 'HE2'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2'],
            ['CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['ND1', 'ND1', 'ND1', 'ND1', 'ND1', 'ND1', 'ND1'], ['NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "HID": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN1'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD1', 'HD1', 'HND1', 'HD1', 'HD1', 'HD1', 'HD1'], ['HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2'],
            ['HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2'],
            ['CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['ND1', 'ND1', 'ND1', 'ND1', 'ND1', 'ND1', 'ND1'], ['NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "HIP": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN1'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD1', 'HD1', 'HND1', 'HD1', 'HD1', 'HD1', 'HD1'], ['HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2'],
            ['HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1'], ['HE2', 'HNE2', 'HE2', 'HE2'],
            ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'],
            ['CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2'], ['CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['ND1', 'ND1', 'ND1', 'ND1', 'ND1', 'ND1', 'ND1'],
            ['NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2', 'NE2'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "ILE": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB', 'HB', 'HB', 'HB', 'HB3', 'HB', 'HB'], ['HG12', '1HG1', '2HG1', 'HG11', 'HG12', 'HG12', 'HG12'],
            ['HG13', '2HG1', 'HG12', 'HG12', 'HG11', 'HG11', 'HG13'],
            ['HG21', '1HG2', 'HG21', 'HG21', 'HG21', 'HG21', 'HG21'],
            ['HG22', '2HG2', 'HG22', 'HG22', 'HG22', 'HG22', 'HG22'],
            ['HG23', '3HG2', 'HG23', 'HG23', 'HG23', 'HG23', 'HG23'],
            ['HD11', '1HD1', 'HD11', 'HD11', 'HD11', 'HD11', 'HD11'],
            ['HD12', '2HD1', 'HD12', 'HD12', 'HD12', 'HD12', 'HD12'],
            ['HD13', '3HD1', 'HD13', 'HD13', 'HD13', 'HD13', 'HD13'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG1', 'CG1', 'CG1', 'CG1', 'CG1', 'CG1', 'CG1'], ['CG2', 'CG2', 'CG2', 'CG2', 'CG2', 'CG2', 'CG2'],
            ['CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "LYN": [['H', 'H', 'HN', 'H2', 'HN', 'H1', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG2', '1HG', 'HG1', 'HG1', 'HG2', 'HG2', 'HG2'], ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'],
            ['HD2', '1HD', 'HD1', 'HD1', 'HD2', 'HD2', 'HD2'], ['HD3', '2HD', 'HD2', 'HD2', 'HD1', 'HD1', 'HD3'],
            ['HE2', '1HE', 'HE1', 'HE1', 'HE2', 'HE2', 'HE2'], ['HE3', '2HE', 'HE2', 'HE2', 'HE1', 'HE1', 'HE3'],
            ['HZ1', '1HZ', 'HNZ1', 'HZ1', 'HZ1', 'HZ1', 'H11'], ['HZ2', '2HZ', 'HNZ2', 'HZ2', 'HZ2', 'HZ2', 'H12'],
            ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'],
            ['CD', 'CD', 'CD', 'CD', 'CD', 'CD', 'CD'], ['CE', 'CE', 'CE', 'CE', 'CE', 'CE', 'CE'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['NZ', 'NZ', 'N1', 'NZ', 'NZ', 'NZ', 'NZ'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "LYS": [['H', 'H', 'HN', 'H2', 'HN', 'H1', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG2', '1HG', 'HG1', 'HG1', '2HG', 'HG2', 'HG2'], ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'],
            ['HD2', '1HD', 'HD1', 'HD2', '2HD'], ['HD3', '2HD', 'HD2', 'HD2', 'HD1', 'HD1', 'HD3'],
            ['HE2', '1HE', 'HE1', '2HE', 'HE2'], ['HE3', '2HE', 'HE2', 'HE2', 'HE1', 'HE1', 'HE3'],
            ['HZ1', '1HZ', 'HNZ1', 'HZ1', 'HZ1', 'HZ1', 'H11'], ['HZ2', '2HZ', 'HNZ2', 'HZ2', 'HZ2', 'HZ2', 'H12'],
            ['HZ3', '3HZ', 'HNZ3', 'HZ', 'HZ3', 'HZ3', 'HZ3'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD', 'CD', 'CD', 'CD', 'CD', 'CD', 'CD'],
            ['CE', 'CE', 'CE', 'CE', 'CE', 'CE', 'CE'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['NZ', 'NZ', 'N1', 'NZ', 'NZ', 'NZ', 'NZ'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "LEU": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG', 'HG', 'HG', 'HG', 'HG', 'HG', 'HG'], ['HD11', '1HD1', 'HD11', 'HD11', 'HD11', 'HD11', 'HD11'],
            ['HD12', '2HD1', 'HD12', 'HD12', 'HD12', 'HD12', 'HD12'],
            ['HD13', '3HD1', 'HD13', 'HD13', 'HD13', 'HD13', 'HD13'],
            ['HD21', '1HD2', 'HD21', 'HD21', 'HD21', 'HD21', 'HD21'],
            ['HD22', '2HD2', 'HD22', 'HD22', 'HD22', 'HD22', 'HD22'],
            ['HD23', '3HD2', 'HD23', 'HD23', 'HD23', 'HD23', 'HD23'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1'],
            ['CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "MET": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG2', '1HG', 'HG1', 'HG1', '2HG', 'HG2', 'HG2'], ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'],
            ['HE1', '1HE', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1'], ['HE2', '2HE', 'HE2', 'HE2', 'HE2', 'HE2', 'HE2'],
            ['HE3', '3HE', 'HE3', 'HE3', 'HE3', 'HE3', 'HE3'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CE', 'CE', 'CE', 'CE', 'CE', 'CE', 'CE'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O'],
            ['SD', 'SD', 'SD', 'SD', 'SD', 'SD', 'SD']],
    "PHE": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD1', 'HD1', 'HD1', 'HD1', 'HD1', 'HD1', 'HD1'], ['HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2'],
            ['HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1'], ['HE2', 'HE2', 'HE2', 'HE2', 'HE2', 'HE2', 'HE2'],
            ['HZ', 'HZ', 'HZ', 'HZ', 'HZ', 'HZ', 'HZ'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1'],
            ['CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2'], ['CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1'],
            ['CE2', 'CE2', 'CE2', 'CE2', 'CE2', 'CE2', 'CE2'], ['CZ', 'CZ', 'CZ', 'CZ', 'CZ', 'CZ', 'CZ'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "PRO": [['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'], ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'],
            ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'], ['HG2', '1HG', '2HG', 'HG1', 'HG2', 'HG2', 'HG2'],
            ['HG3', '2HG', 'HG2', 'HG2', 'HG1', 'HG1', 'HG3'], ['HD2', '1HD', '2HD', 'HD1', 'HD2', 'HD2', 'HD2'],
            ['HD3', '2HD', 'HD1', 'HD2', 'HD1', 'HD1', 'HD3'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD', 'CD', 'CD', 'CD', 'CD', 'CD', 'CD'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "SER": [['H', 'H', 'HN', 'HN', 'H2', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HG', 'HG', 'HOG', 'HG', 'HG', 'HG', 'HG'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O'],
            ['OG', 'OG', 'OG', 'OG', 'OG', 'OG', 'OG']],
    "THR": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB', 'HB', 'HB', 'HB', 'HB1', 'HB3', 'HB'], ['HG1', 'HG1', 'HOG1', 'HG1', 'HG1', 'HG1', 'HG1'],
            ['HG21', '1HG2', 'HG21', 'HG21', 'HG21', 'HG21', 'HG21'],
            ['HG22', '2HG2', 'HG22', 'HG22', 'HG22', 'HG22', 'HG22'],
            ['HG23', '3HG2', 'HG23', 'HG23', 'HG23', 'HG23', 'HG23'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG2', 'CG2', 'CG2', 'CG2', 'CG2', 'CG2', 'CG2'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['O', 'O', 'O', 'O', 'O', 'O', 'O'], ['OG1', 'OG1', 'OG1', 'OG1', 'OG1', 'OG1', 'OG1']],
    "TRP": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD1', 'HD1', 'HD1', 'HD1', 'HD1', 'HD1', 'HD1'], ['HE1', 'HE1', 'HNE1', 'HE1', 'HE1', 'HE1', 'HE1'],
            ['HE3', 'HE3', 'HE3', 'HE3', 'HE3', 'HE3', 'HE3'], ['HZ2', 'HZ2', 'HZ2', 'HZ2', 'HZ2', 'HZ2', 'HZ2'],
            ['HZ3', 'HZ3', 'HZ3', 'HZ3', 'HZ3', 'HZ3', 'HZ3'], ['HH2', 'HH2', 'HH2', 'HH2', 'HH2', 'HH2', 'HH2'],
            ['C', 'C', 'C', 'C', 'C', 'C', 'C'], ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'],
            ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'], ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'],
            ['CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1'], ['CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2'],
            ['CE2', 'CE2', 'CE2', 'CE2', 'CE2', 'CE2', 'CE2'], ['CE3', 'CE3', 'CE3', 'CE3', 'CE3', 'CE3', 'CE3'],
            ['CZ2', 'CZ2', 'CZ2', 'CZ2', 'CZ2', 'CZ2', 'CZ2'], ['CZ3', 'CZ3', 'CZ3', 'CZ3', 'CZ3', 'CZ3', 'CZ3'],
            ['CH2', 'CH2', 'CH2', 'CH2', 'CH2', 'CH2', 'CH2'], ['N', 'N', 'N', 'N', 'N', 'N', 'N'],
            ['NE1', 'NE1', 'NE1', 'NE1', 'NE1', 'NE1', 'NE1'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "TYR": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB2', '1HB', '2HB', 'HB1', 'HB2', 'HB2', 'HB2'], ['HB3', '2HB', 'HB2', 'HB2', 'HB1', 'HB1', 'HB3'],
            ['HD1', 'HD1', 'HD1', 'HD1', 'HD1', 'HD1', 'HD1'], ['HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2', 'HD2'],
            ['HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1', 'HE1'], ['HE2', 'HE2', 'HE2', 'HE2', 'HE2', 'HE2', 'HE2'],
            ['HH', 'HH', 'HOH', 'HH', 'HH', 'HH', 'HH'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG', 'CG', 'CG', 'CG', 'CG', 'CG', 'CG'], ['CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1', 'CD1'],
            ['CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2', 'CD2'], ['CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1', 'CE1'],
            ['CE2', 'CE2', 'CE2', 'CE2', 'CE2', 'CE2', 'CE2'], ['CZ', 'CZ', 'CZ', 'CZ', 'CZ', 'CZ', 'CZ'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O'],
            ['OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH']],
    "VAL": [['H', 'H', 'HN', 'H2', 'HN', 'H', 'HN'], ['HA', 'HA', 'HA', 'HA', 'HA', 'HA', 'HA'],
            ['HB', 'HB', 'HB', 'HB', 'HB', 'HB3', 'HB'], ['HG11', '1HG1', 'HG11', 'HG11', 'HG11', 'HG11', 'HG11'],
            ['HG12', '2HG1', 'HG12', 'HG12', 'HG12', 'HG12', 'HG12'],
            ['HG13', '3HG1', 'HG13', 'HG13', 'HG13', 'HG13', 'HG13'],
            ['HG21', '1HG2', 'HG21', 'HG21', 'HG21', 'HG21', 'HG21'],
            ['HG22', '2HG2', 'HG22', 'HG22', 'HG22', 'HG22', 'HG22'],
            ['HG23', '3HG2', 'HG23', 'HG23', 'HG23', 'HG23', 'HG23'], ['C', 'C', 'C', 'C', 'C', 'C', 'C'],
            ['CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA'], ['CB', 'CB', 'CB', 'CB', 'CB', 'CB', 'CB'],
            ['CG1', 'CG1', 'CG1', 'CG1', 'CG1', 'CG1', 'CG1'], ['CG2', 'CG2', 'CG2', 'CG2', 'CG2', 'CG2', 'CG2'],
            ['N', 'N', 'N', 'N', 'N', 'N', 'N'], ['O', 'O', 'O', 'O', 'O', 'O', 'O']],
    "HOH": [['1HW', 'H1', 'H1 1'], ['2HW', 'H2', 'H1 2'], ['OW', 'O', 'O1']],
    "ACE": [['CA', 'CH3'], ['HH31', 'HA1', 'H', '1H', 'H1'], ['HH32', 'HA2', '2H', 'H2'], ['HH33', 'HA3', '3H', 'H3'],
            ['C', 'C'], ['O', 'O']],
    "NMA": [['HH31', '1HA', 'HA1'], ['HH32', '2HA', 'HA2'], ['HH33', '3HA', 'HA3'], ['CA', 'C'], ['H', 'H'], ['N']],
}

supported_metals = ["MN", "MG", "ZN", "CA", "CU", "FE", "NI", "CO", "PB"]

coordination_geometries = {
    'octahedric': [[90, 180], 6],
    'tetrahedric': [[109.5], 4]
}

default_mutations_maps = {
    'ALA-ARG': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG2', 'HG3', 'CD', 'HD2', 'HD3', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-ALA': ['disappear', 1, 0], 'ALA-ARG': ['appear', 0, 1]},
    ],
    'ALA-ASH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['OD1', 'OD2', 'HD2'],
        {'ALA-ASH': ['appear', 0, 1], 'ASH-ALA': ['disappear', 1, 0]},
    ],
    'ALA-ASN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['OD1', 'ND2', 'HD21', 'HD22'],
        {'ASN-ALA': ['disappear', 1, 0], 'ALA-ASN': ['appear', 0, 1]},
    ],
    'ALA-ASP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['OD1', 'OD2'],
        {'ALA-ASP': ['appear', 0, 1], 'ASP-ALA': ['disappear', 1, 0]},
    ],
    'ALA-CYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'SG']],
        ['HG'],
        {'CYS-ALA': ['disappear', 1, 0], 'ALA-CYS': ['appear', 0, 1]},
    ],
    'ALA-GLH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG2', 'HG3', 'CD', 'OE1', 'OE2', 'HE2'],
        {'GLH-ALA': ['disappear', 1, 0], 'ALA-GLH': ['appear', 0, 1]},
    ],
    'ALA-GLN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG2', 'HG3', 'CD', 'OE1', 'NE2', 'HE21', 'HE22'],
        {'ALA-GLN': ['appear', 0, 1], 'GLN-ALA': ['disappear', 1, 0]},
    ],
    'ALA-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG2', 'HG3', 'CD', 'OE1', 'OE2'],
        {'ALA-GLU': ['appear', 0, 1], 'GLU-ALA': ['disappear', 1, 0]},
    ],
    'ALA-GLY': [
        ['N', 'H', 'CA', 'O', 'C'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB1', 'HB2', 'HB3'),
        {'GLY-ALA': ['appear', 1, 0], 'ALA-GLY': ['disappear', 0, 1]},
    ],
    'ALA-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['ND1', 'CD2', 'HD1', 'CE1', 'HD2', 'NE2', 'HE1'],
        {'HID-ALA': ['disappear', 1, 0], 'ALA-HID': ['appear', 0, 1]},
    ],
    'ALA-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['ND1', 'CD2', 'CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'ALA-HIE': ['appear', 0, 1], 'HIE-ALA': ['disappear', 1, 0]},
    ],
    'ALA-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['ND1', 'CD2', 'HD1', 'CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'HIP-ALA': ['disappear', 1, 0], 'ALA-HIP': ['appear', 0, 1]},
    ],
    'ALA-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB1', 'HB'], ['HB2', 'CG1'], ['HB3', 'CG2']],
        ['HG12', 'HG13', 'CD1', 'HG21', 'HG22', 'HG23', 'HD11', 'HD12', 'HD13'],
        {'ILE-ALA': ['disappear', 1, 0], 'ALA-ILE': ['appear', 0, 1]},
    ],
    'ALA-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG', 'CD1', 'CD2', 'HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'],
        {'ALA-LEU': ['appear', 0, 1], 'LEU-ALA': ['disappear', 1, 0]},
    ],
    'ALA-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG2', 'HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-ALA': ['disappear', 1, 0], 'ALA-LYN': ['appear', 0, 1]},
    ],
    'ALA-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG2', 'HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'ALA-LYS': ['appear', 0, 1], 'LYS-ALA': ['disappear', 1, 0]},
    ],
    'ALA-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['HG2', 'HG3', 'SD', 'CE', 'HE1', 'HE2', 'HE3'],
        {'MET-ALA': ['disappear', 1, 0], 'ALA-MET': ['appear', 0, 1]},
    ],
    'ALA-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['CD1', 'CD2', 'HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'ALA-PHE': ['appear', 0, 1], 'PHE-ALA': ['disappear', 1, 0]},
    ],
    'ALA-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG'], ['H', 'CD']],
        ['HG2', 'HG3', 'HD2', 'HD3'],
        {'ALA-PRO': ['appear', 0, 1], 'PRO-ALA': ['disappear', 1, 0]},
    ],
    'ALA-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'OG']],
        ['HG'],
        {'ALA-SER': ['appear', 0, 1], 'SER-ALA': ['disappear', 1, 0]},
    ],
    'ALA-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB1', 'HB'], ['HB2', 'OG1'], ['HB3', 'CG2']],
        ['HG1', 'HG21', 'HG22', 'HG23'],
        {'ALA-THR': ['appear', 0, 1], 'THR-ALA': ['disappear', 1, 0]},
    ],
    'ALA-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['CD1', 'CD2', 'HD1', 'NE1', 'CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'ALA-TRP': ['appear', 0, 1], 'TRP-ALA': ['disappear', 1, 0]},
    ],
    'ALA-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['HB1', 'CG']],
        ['CD1', 'CD2', 'HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'ALA-TYR': ['appear', 0, 1], 'TYR-ALA': ['disappear', 1, 0]},
    ],
    'ALA-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB1', 'HB'], ['HB2', 'CG1'], ['HB3', 'CG2']],
        ['HG11', 'HG12', 'HG13', 'HG21', 'HG22', 'HG23'],
        {'ALA-VAL': ['appear', 0, 1], 'VAL-ALA': ['disappear', 1, 0]},
    ],
    'ARG-ASH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HG2', 'OD1'], ['HG3', 'OD2']],
        ['CD', 'HD3', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-ASH': ['disappear', 0, 1], 'ASH-ARG': ['appear', 1, 0]},
    ],
    'ARG-ASN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'OD1'], ['HG3', 'ND2'], ['CD', 'HD21'], ['HD2', 'HD22']],
        ['HD3', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ASN-ARG': ['appear', 1, 0], 'ARG-ASN': ['disappear', 0, 1]},
    ],
    'ARG-ASP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'OD1'], ['HG3', 'OD2']],
        ['CD', 'HD2', 'HD3', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-ASP': ['disappear', 0, 1], 'ASP-ARG': ['appear', 1, 0]},
    ],
    'ARG-CYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'SG'], ['HG2', 'HG']],
        ['HG3', 'CD', 'HD2', 'HD3', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'CYS-ARG': ['appear', 1, 0], 'ARG-CYS': ['disappear', 0, 1]},
    ],
    'ARG-GLH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['HD2', 'OE1'], ['HD3', 'OE2'], ['NE', 'HE2']],
        ['HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'GLH-ARG': ['appear', 1, 0], 'ARG-GLH': ['disappear', 0, 1]},
    ],
    'ARG-GLN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['HD2', 'OE1'], ['HD3', 'NE2'], ['NE', 'HE21'], ['HE', 'HE22']],
        ['CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-GLN': ['disappear', 0, 1], 'GLN-ARG': ['appear', 1, 0]},
    ],
    'ARG-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['HD2', 'OE1'], ['HD3', 'OE2']],
        ['NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-GLU': ['disappear', 0, 1], 'GLU-ARG': ['appear', 1, 0]},
    ],
    'ARG-GLY': [
        ['N', 'H', 'CA', 'O', 'C'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'HD2', 'HD3', 'NE', 'HE', 'CZ', 'NH1', 'HH11', 'HH12', 'NH2', 'HH21',
         'HH22'),
        {'GLY-ARG': ['appear', 1, 0], 'ARG-GLY': ['disappear', 0, 1]},
    ],
    'ARG-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD3', 'CE1'], ['NE', 'NE2'], ['HE', 'HE1']],
        ['CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-HID': ['disappear', 0, 1], 'HID-ARG': ['appear', 1, 0]},
    ],
    'ARG-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'CE1'], ['HD3', 'NE2'], ['NE', 'HE1'], ['HE', 'HE2']],
        ['CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-HIE': ['disappear', 0, 1], 'HIE-ARG': ['appear', 1, 0]},
    ],
    'ARG-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD3', 'CE1'], ['NE', 'NE2'], ['HE', 'HE1'],
         ['CZ', 'HE2']],
        ['NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'HIP-ARG': ['appear', 1, 0], 'ARG-HIP': ['disappear', 0, 1]},
    ],
    'ARG-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG12'], ['HG3', 'HG13'], ['CD', 'CD1'], ['HD2', 'HG21'],
         ['HD3', 'HG22'], ['NE', 'HG23'], ['HE', 'HD11'], ['CZ', 'HD12'], ['NH1', 'HD13']],
        ['NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ILE-ARG': ['appear', 1, 0], 'ARG-ILE': ['disappear', 0, 1]},
    ],
    'ARG-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG'], ['HG3', 'CD1'], ['CD', 'CD2'], ['HD2', 'HD11'], ['HD3', 'HD12'], ['NE', 'HD13'], ['HE', 'HD21'],
         ['CZ', 'HD22'], ['NH1', 'HD23']],
        ['NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-LEU': ['disappear', 0, 1], 'LEU-ARG': ['appear', 1, 0]},
    ],
    'ARG-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['HD3', 'HD3'], ['HD2', 'HD2'], ['NE', 'CE'], ['HE', 'HE2'], ['CZ', 'HE3'], ['NH1', 'NZ'], ['NH2', 'HZ1'],
         ['HH11', 'HZ2']],
        ['HH12', 'HH21', 'HH22'],
        {'LYN-ARG': ['appear', 1, 0], 'ARG-LYN': ['disappear', 0, 1]},
    ],
    'ARG-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['HD3', 'HD3'], ['HD2', 'HD2'], ['NE', 'CE'], ['HE', 'HE2'], ['CZ', 'HE3'], ['NH1', 'NZ'], ['NH2', 'HZ1'],
         ['HH11', 'HZ2'], ['HH12', 'HZ3']],
        ['HH21', 'HH22'],
        {'ARG-LYS': ['disappear', 0, 1], 'LYS-ARG': ['appear', 1, 0]},
    ],
    'ARG-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'SD'], ['HD2', 'CE'], ['HD3', 'HE1'], ['NE', 'HE2'], ['HE', 'HE3']],
        ['CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'MET-ARG': ['appear', 1, 0], 'ARG-MET': ['disappear', 0, 1]},
    ],
    'ARG-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD2', 'HD2'], ['HD3', 'CE1'], ['NE', 'CE2'], ['HE', 'HE1'],
         ['CZ', 'CZ'], ['NH1', 'HE2'], ['NH2', 'HZ']],
        ['HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-PHE': ['disappear', 0, 1], 'PHE-ARG': ['appear', 1, 0]},
    ],
    'ARG-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'CD'], ['HD3', 'HD3'],
         ['HD2', 'HD2']],
        ['H', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-PRO': ['disappear', 0, 1], 'PRO-ARG': ['appear', 1, 0]},
    ],
    'ARG-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG2', 'HG']],
        ['HG3', 'CD', 'HD2', 'HD3', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-SER': ['disappear', 0, 1], 'SER-ARG': ['appear', 1, 0]},
    ],
    'ARG-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['CD', 'HG22'],
         ['HD2', 'HG23']],
        ['HD3', 'NE', 'HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-THR': ['disappear', 0, 1], 'THR-ARG': ['appear', 1, 0]},
    ],
    'ARG-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD2', 'NE1'], ['HD3', 'CE3'], ['NE', 'CE2'], ['HE', 'HE1'],
         ['CZ', 'HE3'], ['NH1', 'CZ3'], ['NH2', 'CZ2'], ['HH11', 'HZ3'], ['HH12', 'HZ2'], ['HH21', 'CH2'],
         ['HH22', 'HH2']],
        [],
        {'ARG-TRP': ['', 0, 1], 'TRP-ARG': ['', 1, 0]},
    ],
    'ARG-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CZ', 'CZ'], ['HD2', 'HD2'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD3', 'CE1'], ['NE', 'CE2'],
         ['HE', 'HE1'], ['NH1', 'HE2'], ['NH2', 'OH'], ['HH11', 'HH']],
        ['HH12', 'HH21', 'HH22'],
        {'ARG-TYR': ['disappear', 0, 1], 'TYR-ARG': ['appear', 1, 0]},
    ],
    'ARG-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['CD', 'HG13'],
         ['HD2', 'HG21'], ['HD3', 'HG22'], ['NE', 'HG23']],
        ['HE', 'CZ', 'NH1', 'NH2', 'HH11', 'HH12', 'HH21', 'HH22'],
        {'ARG-VAL': ['disappear', 0, 1], 'VAL-ARG': ['appear', 1, 0]},
    ],
    'ASH-ASN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'OD1'], ['OD2', 'ND2'], ['HD2', 'HD21']],
        ['HD22'],
        {'ASH-ASN': ['appear', 0, 1], 'ASN-ASH': ['disappear', 1, 0]},
    ],
    'ASH-ASP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'OD1', 'OD2'],
        [],
        ['HD2'],
        {'ASP-ASH': ['appear', 1, 0], 'ASH-ASP': ['disappear', 0, 1]},
    ],
    'ASH-CYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'SG'], ['OD1', 'HG']],
        ['OD2', 'HD2'],
        {'ASH-CYS': ['disappear', 0, 1], 'CYS-ASH': ['appear', 1, 0]},
    ],
    'ASH-GLH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3'], ['HD2', 'CD']],
        ['OE1', 'OE2', 'HE2'],
        {'ASH-GLH': ['appear', 0, 1], 'GLH-ASH': ['disappear', 1, 0]},
    ],
    'ASH-GLN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3'], ['HD2', 'CD']],
        ['OE1', 'NE2', 'HE21', 'HE22'],
        {'ASH-GLN': ['appear', 0, 1], 'GLN-ASH': ['disappear', 1, 0]},
    ],
    'ASH-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3'], ['HD2', 'CD']],
        ['OE1', 'OE2'],
        {'GLU-ASH': ['disappear', 1, 0], 'ASH-GLU': ['appear', 0, 1]},
    ],
    'ASH-GLY': [
        ['N', 'H', 'CA', 'O', 'C'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB2', 'HB3', 'CG', 'OD1', 'OD2', 'HD2'),
        {'ASH-GLY': ['disappear', 0, 1], 'GLY-ASH': ['appear', 1, 0]},
    ],
    'ASH-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['OD1', 'ND1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'NE2', 'HE1'],
        {'HID-ASH': ['disappear', 1, 0], 'ASH-HID': ['appear', 0, 1]},
    ],
    'ASH-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['OD1', 'ND1'], ['OD2', 'CD2']],
        ['CE1', 'NE2', 'HE1', 'HE2'],
        {'HIE-ASH': ['disappear', 1, 0], 'ASH-HIE': ['appear', 0, 1]},
    ],
    'ASH-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['OD1', 'ND1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'NE2', 'HE1', 'HE2'],
        {'ASH-HIP': ['appear', 0, 1], 'HIP-ASH': ['disappear', 1, 0]},
    ],
    'ASH-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['OD1', 'HG12'], ['OD2', 'HG13'], ['HD2', 'CD1']],
        ['HG21', 'HG22', 'HG23', 'HD11', 'HD12', 'HD13'],
        {'ASH-ILE': ['appear', 0, 1], 'ILE-ASH': ['disappear', 1, 0]},
    ],
    'ASH-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG'], ['OD2', 'CD1'], ['HD2', 'CD2']],
        ['HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'],
        {'LEU-ASH': ['disappear', 1, 0], 'ASH-LEU': ['appear', 0, 1]},
    ],
    'ASH-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['OD1', 'HG2'], ['OD2', 'HG3']],
        ['CD', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'ASH-LYN': ['appear', 0, 1], 'LYN-ASH': ['disappear', 1, 0]},
    ],
    'ASH-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['OD1', 'HG2'], ['OD2', 'HG3']],
        ['CD', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-ASH': ['disappear', 1, 0], 'ASH-LYS': ['appear', 0, 1]},
    ],
    'ASH-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3'], ['HD2', 'SD']],
        ['CE', 'HE1', 'HE2', 'HE3'],
        {'ASH-MET': ['appear', 0, 1], 'MET-ASH': ['disappear', 1, 0]},
    ],
    'ASH-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['OD1', 'CD1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'ASH-PHE': ['appear', 0, 1], 'PHE-ASH': ['disappear', 1, 0]},
    ],
    'ASH-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['OD1', 'HG2'], ['OD2', 'HG3'], ['H', 'CD'], ['HD2', 'HD2']],
        ['HD3'],
        {'PRO-ASH': ['disappear', 1, 0], 'ASH-PRO': ['appear', 0, 1]},
    ],
    'ASH-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['OD1', 'HG']],
        ['OD2', 'HD2'],
        {'SER-ASH': ['appear', 1, 0], 'ASH-SER': ['disappear', 0, 1]},
    ],
    'ASH-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['OD1', 'HG1'], ['OD2', 'HG21'], ['HD2', 'HG22']],
        ['HG23'],
        {'THR-ASH': ['disappear', 1, 0], 'ASH-THR': ['appear', 0, 1]},
    ],
    'ASH-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'CD1'], ['OD2', 'CD2'], ['HD2', 'HD1']],
        ['NE1', 'CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-ASH': ['disappear', 1, 0], 'ASH-TRP': ['appear', 0, 1]},
    ],
    'ASH-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['OD1', 'CD1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'ASH-TYR': ['appear', 0, 1], 'TYR-ASH': ['disappear', 1, 0]},
    ],
    'ASH-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['OD1', 'HG11'], ['OD2', 'HG12'], ['HD2', 'HG13']],
        ['HG21', 'HG22', 'HG23'],
        {'ASH-VAL': ['appear', 0, 1], 'VAL-ASH': ['disappear', 1, 0]},
    ],
    'ASN-ASP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'OD1'], ['ND2', 'OD2']],
        ['HD21', 'HD22'],
        {'ASN-ASP': ['disappear', 0, 1], 'ASP-ASN': ['appear', 1, 0]},
    ],
    'ASN-CYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'SG'], ['OD1', 'HG']],
        ['ND2', 'HD21', 'HD22'],
        {'ASN-CYS': ['disappear', 0, 1], 'CYS-ASN': ['appear', 1, 0]},
    ],
    'ASN-GLH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['ND2', 'HG3'], ['HD21', 'CD'], ['HD22', 'OE1']],
        ['OE2', 'HE2'],
        {'ASN-GLH': ['appear', 0, 1], 'GLH-ASN': ['disappear', 1, 0]},
    ],
    'ASN-GLN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['ND2', 'HG3'], ['HD21', 'CD'], ['HD22', 'OE1']],
        ['NE2', 'HE21', 'HE22'],
        {'GLN-ASN': ['disappear', 1, 0], 'ASN-GLN': ['appear', 0, 1]},
    ],
    'ASN-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['ND2', 'HG3'], ['HD21', 'CD'], ['HD22', 'OE1']],
        ['OE2'],
        {'GLU-ASN': ['disappear', 1, 0], 'ASN-GLU': ['appear', 0, 1]},
    ],
    'ASN-GLY': [
        ['N', 'H', 'CA', 'O', 'C'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB2', 'HB3', 'CG', 'OD1', 'ND2', 'HD21', 'HD22'),
        {'ASN-GLY': ['disappear', 0, 1], 'GLY-ASN': ['appear', 1, 0]},
    ],
    'ASN-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'ND1'], ['ND2', 'CD2'], ['HD21', 'HD1'], ['HD22', 'CE1']],
        ['HD2', 'NE2', 'HE1'],
        {'ASN-HID': ['appear', 0, 1], 'HID-ASN': ['disappear', 1, 0]},
    ],
    'ASN-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'ND1'], ['ND2', 'CD2'], ['HD21', 'CE1'], ['HD22', 'HD2']],
        ['NE2', 'HE1', 'HE2'],
        {'ASN-HIE': ['appear', 0, 1], 'HIE-ASN': ['disappear', 1, 0]},
    ],
    'ASN-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'ND1'], ['ND2', 'CD2'], ['HD21', 'HD1'], ['HD22', 'CE1']],
        ['HD2', 'NE2', 'HE1', 'HE2'],
        {'ASN-HIP': ['appear', 0, 1], 'HIP-ASN': ['disappear', 1, 0]},
    ],
    'ASN-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['OD1', 'HG12'], ['ND2', 'HG13'], ['HD21', 'CD1'],
         ['HD22', 'HG21']],
        ['HG22', 'HG23', 'HD11', 'HD12', 'HD13'],
        {'ASN-ILE': ['appear', 0, 1], 'ILE-ASN': ['disappear', 1, 0]},
    ],
    'ASN-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD22', 'HD22'], ['HD21', 'HD21'], ['OD1', 'HG'], ['ND2', 'CD1']],
        ['CD2', 'HD11', 'HD12', 'HD13', 'HD23'],
        {'ASN-LEU': ['appear', 0, 1], 'LEU-ASN': ['disappear', 1, 0]},
    ],
    'ASN-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['ND2', 'HG3'], ['HD21', 'CD'], ['HD22', 'HD2']],
        ['HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-ASN': ['disappear', 1, 0], 'ASN-LYN': ['appear', 0, 1]},
    ],
    'ASN-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['ND2', 'HG3'], ['HD21', 'CD'], ['HD22', 'HD2']],
        ['HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'ASN-LYS': ['appear', 0, 1], 'LYS-ASN': ['disappear', 1, 0]},
    ],
    'ASN-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['ND2', 'HG3'], ['HD21', 'SD'], ['HD22', 'CE']],
        ['HE1', 'HE2', 'HE3'],
        {'MET-ASN': ['disappear', 1, 0], 'ASN-MET': ['appear', 0, 1]},
    ],
    'ASN-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'CD1'], ['ND2', 'CD2'], ['HD21', 'HD1'], ['HD22', 'CE1']],
        ['HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'PHE-ASN': ['disappear', 1, 0], 'ASN-PHE': ['appear', 0, 1]},
    ],
    'ASN-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['OD1', 'HG2'], ['ND2', 'HG3'], ['H', 'CD'], ['HD21', 'HD2'],
         ['HD22', 'HD3']],
        [],
        {'PRO-ASN': ['', 1, 0], 'ASN-PRO': ['', 0, 1]},
    ],
    'ASN-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['OD1', 'HG']],
        ['ND2', 'HD21', 'HD22'],
        {'ASN-SER': ['disappear', 0, 1], 'SER-ASN': ['appear', 1, 0]},
    ],
    'ASN-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['OD1', 'HG1'], ['ND2', 'HG21'], ['HD21', 'HG22'],
         ['HD22', 'HG23']],
        [],
        {'THR-ASN': ['', 1, 0], 'ASN-THR': ['', 0, 1]},
    ],
    'ASN-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'CD1'], ['ND2', 'CD2'], ['HD21', 'HD1'], ['HD22', 'NE1']],
        ['CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-ASN': ['disappear', 1, 0], 'ASN-TRP': ['appear', 0, 1]},
    ],
    'ASN-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'CD1'], ['ND2', 'CD2'], ['HD21', 'HD1'], ['HD22', 'CE1']],
        ['HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'ASN-TYR': ['appear', 0, 1], 'TYR-ASN': ['disappear', 1, 0]},
    ],
    'ASN-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['OD1', 'HG11'], ['ND2', 'HG12'], ['HD21', 'HG13'],
         ['HD22', 'HG21']],
        ['HG22', 'HG23'],
        {'ASN-VAL': ['appear', 0, 1], 'VAL-ASN': ['disappear', 1, 0]},
    ],
    'ASP-CYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'SG'], ['OD1', 'HG']],
        ['OD2'],
        {'ASP-CYS': ['disappear', 0, 1], 'CYS-ASP': ['appear', 1, 0]},
    ],
    'ASP-GLH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3']],
        ['CD', 'OE1', 'OE2', 'HE2'],
        {'ASP-GLH': ['appear', 0, 1], 'GLH-ASP': ['disappear', 1, 0]},
    ],
    'ASP-GLN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3']],
        ['CD', 'OE1', 'NE2', 'HE21', 'HE22'],
        {'ASP-GLN': ['appear', 0, 1], 'GLN-ASP': ['disappear', 1, 0]},
    ],
    'ASP-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3']],
        ['CD', 'OE1', 'OE2'],
        {'GLU-ASP': ['disappear', 1, 0], 'ASP-GLU': ['appear', 0, 1]},
    ],
    'ASP-GLY': [
        ['N', 'H', 'CA', 'O', 'C'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB2', 'HB3', 'CG', 'OD1', 'OD2'),
        {'ASP-GLY': ['disappear', 0, 1], 'GLY-ASP': ['appear', 1, 0]},
    ],
    'ASP-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'ND1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'HD2', 'NE2', 'HE1'],
        {'HID-ASP': ['disappear', 1, 0], 'ASP-HID': ['appear', 0, 1]},
    ],
    'ASP-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'ND1'], ['OD2', 'CD2']],
        ['CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'HIE-ASP': ['disappear', 1, 0], 'ASP-HIE': ['appear', 0, 1]},
    ],
    'ASP-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'ND1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'ASP-HIP': ['appear', 0, 1], 'HIP-ASP': ['disappear', 1, 0]},
    ],
    'ASP-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['OD1', 'HG12'], ['OD2', 'HG13']],
        ['CD1', 'HG21', 'HG22', 'HG23', 'HD11', 'HD12', 'HD13'],
        {'ASP-ILE': ['appear', 0, 1], 'ILE-ASP': ['disappear', 1, 0]},
    ],
    'ASP-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG'], ['OD2', 'CD1']],
        ['CD2', 'HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'],
        {'LEU-ASP': ['disappear', 1, 0], 'ASP-LEU': ['appear', 0, 1]},
    ],
    'ASP-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3']],
        ['CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'ASP-LYN': ['appear', 0, 1], 'LYN-ASP': ['disappear', 1, 0]},
    ],
    'ASP-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3']],
        ['CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-ASP': ['disappear', 1, 0], 'ASP-LYS': ['appear', 0, 1]},
    ],
    'ASP-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'HG2'], ['OD2', 'HG3']],
        ['SD', 'CE', 'HE1', 'HE2', 'HE3'],
        {'ASP-MET': ['appear', 0, 1], 'MET-ASP': ['disappear', 1, 0]},
    ],
    'ASP-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'CD1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'ASP-PHE': ['appear', 0, 1], 'PHE-ASP': ['disappear', 1, 0]},
    ],
    'ASP-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['OD1', 'HG2'], ['OD2', 'HG3'], ['H', 'CD']],
        ['HD2', 'HD3'],
        {'PRO-ASP': ['disappear', 1, 0], 'ASP-PRO': ['appear', 0, 1]},
    ],
    'ASP-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['OD1', 'HG']],
        ['OD2'],
        {'SER-ASP': ['appear', 1, 0], 'ASP-SER': ['disappear', 0, 1]},
    ],
    'ASP-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['OD1', 'HG1'], ['OD2', 'HG21']],
        ['HG22', 'HG23'],
        {'THR-ASP': ['disappear', 1, 0], 'ASP-THR': ['appear', 0, 1]},
    ],
    'ASP-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'CD1'], ['OD2', 'CD2']],
        ['HD1', 'NE1', 'CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-ASP': ['disappear', 1, 0], 'ASP-TRP': ['appear', 0, 1]},
    ],
    'ASP-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['OD1', 'CD1'], ['OD2', 'CD2']],
        ['HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'ASP-TYR': ['appear', 0, 1], 'TYR-ASP': ['disappear', 1, 0]},
    ],
    'ASP-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['OD1', 'HG11'], ['OD2', 'HG12']],
        ['HG13', 'HG21', 'HG22', 'HG23'],
        {'ASP-VAL': ['appear', 0, 1], 'VAL-ASP': ['disappear', 1, 0]},
    ],
    'CYS-GLH': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'HG2']],
        ['HG3', 'CD', 'OE1', 'OE2', 'HE2'],
        {'CYS-GLH': ['appear', 0, 1], 'GLH-CYS': ['disappear', 1, 0]},
    ],
    'CYS-GLN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'HG2']],
        ['HG3', 'CD', 'OE1', 'NE2', 'HE21', 'HE22'],
        {'GLN-CYS': ['disappear', 1, 0], 'CYS-GLN': ['appear', 0, 1]},
    ],
    'CYS-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'HG2']],
        ['HG3', 'CD', 'OE1', 'OE2'],
        {'CYS-GLU': ['appear', 0, 1], 'GLU-CYS': ['disappear', 1, 0]},
    ],
    'CYS-GLY': [
        ['N', 'H', 'CA', 'O', 'C'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB2', 'HB3', 'SG', 'HG'),
        {'CYS-GLY': ['disappear', 0, 1], 'GLY-CYS': ['appear', 1, 0]},
    ],
    'CYS-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'ND1']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'NE2', 'HE1'],
        {'HID-CYS': ['disappear', 1, 0], 'CYS-HID': ['appear', 0, 1]},
    ],
    'CYS-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'ND1']],
        ['CD2', 'CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'CYS-HIE': ['appear', 0, 1], 'HIE-CYS': ['disappear', 1, 0]},
    ],
    'CYS-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'ND1']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'CYS-HIP': ['appear', 0, 1], 'HIP-CYS': ['disappear', 1, 0]},
    ],
    'CYS-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['SG', 'CG2'], ['HG', 'HG12']],
        ['HG13', 'CD1', 'HG21', 'HG22', 'HG23', 'HD11', 'HD12', 'HD13'],
        {'CYS-ILE': ['appear', 0, 1], 'ILE-CYS': ['disappear', 1, 0]},
    ],
    'CYS-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HG', 'HG'], ['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG']],
        ['CD1', 'CD2', 'HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'],
        {'CYS-LEU': ['appear', 0, 1], 'LEU-CYS': ['disappear', 1, 0]},
    ],
    'CYS-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'HG2']],
        ['HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'CYS-LYN': ['appear', 0, 1], 'LYN-CYS': ['disappear', 1, 0]},
    ],
    'CYS-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'HG2']],
        ['HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-CYS': ['disappear', 1, 0], 'CYS-LYS': ['appear', 0, 1]},
    ],
    'CYS-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'HG2']],
        ['HG3', 'SD', 'CE', 'HE1', 'HE2', 'HE3'],
        {'CYS-MET': ['appear', 0, 1], 'MET-CYS': ['disappear', 1, 0]},
    ],
    'CYS-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'CD1']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'PHE-CYS': ['disappear', 1, 0], 'CYS-PHE': ['appear', 0, 1]},
    ],
    'CYS-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'HG2'], ['H', 'CD']],
        ['HG3', 'HD2', 'HD3'],
        {'CYS-PRO': ['appear', 0, 1], 'PRO-CYS': ['disappear', 1, 0]},
    ],
    'CYS-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HG', 'HG'], ['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'OG']],
        [],
        {'CYS-SER': ['', 0, 1], 'SER-CYS': ['', 1, 0]},
    ],
    'CYS-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['SG', 'CG2'], ['HG', 'HG1']],
        ['HG21', 'HG22', 'HG23'],
        {'CYS-THR': ['appear', 0, 1], 'THR-CYS': ['disappear', 1, 0]},
    ],
    'CYS-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'CD1']],
        ['CD2', 'HD1', 'NE1', 'CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'CYS-TRP': ['appear', 0, 1], 'TRP-CYS': ['disappear', 1, 0]},
    ],
    'CYS-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['SG', 'CG'], ['HG', 'CD1']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'TYR-CYS': ['disappear', 1, 0], 'CYS-TYR': ['appear', 0, 1]},
    ],
    'CYS-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['SG', 'CG2'], ['HG', 'HG11']],
        ['HG12', 'HG13', 'HG21', 'HG22', 'HG23'],
        {'VAL-CYS': ['disappear', 1, 0], 'CYS-VAL': ['appear', 0, 1]},
    ],
    'GLH-GLN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['OE1', 'OE1'], ['OE2', 'NE2'], ['HE2', 'HE21']],
        ['HE22'],
        {'GLN-GLH': ['disappear', 1, 0], 'GLH-GLN': ['appear', 0, 1]},
    ],
    'GLH-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'OE1', 'OE2'],
        [],
        ['HE2'],
        {'GLU-GLH': ['appear', 1, 0], 'GLH-GLU': ['disappear', 0, 1]},
    ],
    'GLH-GLY': [
        ['N', 'H', 'CA', 'C', 'O'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'OE1', 'OE2', 'HE2'),
        {'GLH-GLY': ['disappear', 0, 1], 'GLY-GLH': ['appear', 1, 0]},
    ],
    'GLH-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2'], ['HE2', 'NE2']],
        ['HE1'],
        {'HID-GLH': ['disappear', 1, 0], 'GLH-HID': ['appear', 0, 1]},
    ],
    'GLH-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HE2', 'HE2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'CE1'], ['OE1', 'HD2'], ['OE2', 'NE2']],
        ['HE1'],
        {'HIE-GLH': ['disappear', 1, 0], 'GLH-HIE': ['appear', 0, 1]},
    ],
    'GLH-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HE2', 'HE2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2']],
        ['NE2', 'HE1'],
        {'GLH-HIP': ['appear', 0, 1], 'HIP-GLH': ['disappear', 1, 0]},
    ],
    'GLH-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG12'], ['HG3', 'HG13'], ['CD', 'CD1'], ['OE1', 'HG21'],
         ['OE2', 'HG22'], ['HE2', 'HG23']],
        ['HD11', 'HD12', 'HD13'],
        {'ILE-GLH': ['disappear', 1, 0], 'GLH-ILE': ['appear', 0, 1]},
    ],
    'GLH-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG'], ['HG3', 'CD1'], ['CD', 'CD2'], ['OE1', 'HD11'], ['OE2', 'HD12'], ['HE2', 'HD13']],
        ['HD21', 'HD22', 'HD23'],
        {'LEU-GLH': ['disappear', 1, 0], 'GLH-LEU': ['appear', 0, 1]},
    ],
    'GLH-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['HE2', 'HE2'], ['OE1', 'HD2'], ['OE2', 'HD3']],
        ['CE', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'GLH-LYN': ['appear', 0, 1], 'LYN-GLH': ['disappear', 1, 0]},
    ],
    'GLH-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['HE2', 'HE2'], ['OE1', 'HD2'], ['OE2', 'HD3']],
        ['CE', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-GLH': ['disappear', 1, 0], 'GLH-LYS': ['appear', 0, 1]},
    ],
    'GLH-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG2'], ['HG3', 'HG3'], ['HE2', 'HE2'], ['CD', 'SD'], ['OE1', 'CE'], ['OE2', 'HE1']],
        ['HE3'],
        {'GLH-MET': ['appear', 0, 1], 'MET-GLH': ['disappear', 1, 0]},
    ],
    'GLH-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HE2', 'HE2'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2']],
        ['CE2', 'HE1', 'CZ', 'HZ'],
        {'PHE-GLH': ['disappear', 1, 0], 'GLH-PHE': ['appear', 0, 1]},
    ],
    'GLH-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'CD'], ['OE1', 'HD2'],
         ['OE2', 'HD3']],
        ['H', 'HE2'],
        {'GLH-PRO': ['disappear', 0, 1], 'PRO-GLH': ['appear', 1, 0]},
    ],
    'GLH-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG2', 'HG']],
        ['HG3', 'CD', 'OE1', 'OE2', 'HE2'],
        {'SER-GLH': ['appear', 1, 0], 'GLH-SER': ['disappear', 0, 1]},
    ],
    'GLH-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['CD', 'HG22'],
         ['OE1', 'HG23']],
        ['OE2', 'HE2'],
        {'THR-GLH': ['appear', 1, 0], 'GLH-THR': ['disappear', 0, 1]},
    ],
    'GLH-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'NE1'], ['OE2', 'CE3'], ['HE2', 'CE2']],
        ['HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'GLH-TRP': ['appear', 0, 1], 'TRP-GLH': ['disappear', 1, 0]},
    ],
    'GLH-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HE2', 'HE2'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2']],
        ['CE2', 'HE1', 'CZ', 'OH', 'HH'],
        {'TYR-GLH': ['disappear', 1, 0], 'GLH-TYR': ['appear', 0, 1]},
    ],
    'GLH-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['CD', 'HG13'],
         ['OE1', 'HG21'], ['OE2', 'HG22'], ['HE2', 'HG23']],
        [],
        {'VAL-GLH': ['', 1, 0], 'GLH-VAL': ['', 0, 1]},
    ],
    'GLN-GLU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['OE1', 'OE1'], ['NE2', 'OE2']],
        ['HE21', 'HE22'],
        {'GLU-GLN': ['appear', 1, 0], 'GLN-GLU': ['disappear', 0, 1]},
    ],
    'GLN-GLY': [
        ['N', 'H', 'CA', 'C', 'O'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ['HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'OE1', 'NE2', 'HE21', 'HE22'],
        {'GLY-GLN': ['appear', 1, 0], 'GLN-GLY': ['disappear', 0, 1]},
    ],
    'GLN-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['NE2', 'NE2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['HE21', 'HD2'],
         ['HE22', 'HE1']],
        [],
        {'GLN-HID': ['', 0, 1], 'HID-GLN': ['', 1, 0]},
    ],
    'GLN-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['NE2', 'NE2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'CE1'], ['OE1', 'HD2'], ['HE21', 'HE1'],
         ['HE22', 'HE2']],
        [],
        {'GLN-HIE': ['', 0, 1], 'HIE-GLN': ['', 1, 0]},
    ],
    'GLN-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['NE2', 'NE2'], ['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['HE21', 'HD2'],
         ['HE22', 'HE1']],
        ['HE2'],
        {'HIP-GLN': ['disappear', 1, 0], 'GLN-HIP': ['appear', 0, 1]},
    ],
    'GLN-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG12'], ['HG3', 'HG13'], ['CD', 'CD1'], ['OE1', 'HG21'],
         ['NE2', 'HG22'], ['HE21', 'HG23'], ['HE22', 'HD11']],
        ['HD12', 'HD13'],
        {'GLN-ILE': ['appear', 0, 1], 'ILE-GLN': ['disappear', 1, 0]},
    ],
    'GLN-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG'], ['HG3', 'CD1'], ['CD', 'CD2'], ['OE1', 'HD11'], ['NE2', 'HD12'], ['HE21', 'HD13'],
         ['HE22', 'HD21']],
        ['HD22', 'HD23'],
        {'GLN-LEU': ['appear', 0, 1], 'LEU-GLN': ['disappear', 1, 0]},
    ],
    'GLN-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['OE1', 'HD2'], ['NE2', 'HD3'], ['HE21', 'CE'], ['HE22', 'HE2']],
        ['HE3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-GLN': ['disappear', 1, 0], 'GLN-LYN': ['appear', 0, 1]},
    ],
    'GLN-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['OE1', 'HD2'], ['NE2', 'HD3'], ['HE21', 'CE'], ['HE22', 'HE2']],
        ['HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'GLN-LYS': ['appear', 0, 1], 'LYS-GLN': ['disappear', 1, 0]},
    ],
    'GLN-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'SD'], ['OE1', 'CE'], ['NE2', 'HE1'], ['HE21', 'HE2'], ['HE22', 'HE3']],
        [],
        {'MET-GLN': ['', 1, 0], 'GLN-MET': ['', 0, 1]},
    ],
    'GLN-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['NE2', 'HD2'], ['HE21', 'CE2'],
         ['HE22', 'HE1']],
        ['CZ', 'HE2', 'HZ'],
        {'PHE-GLN': ['disappear', 1, 0], 'GLN-PHE': ['appear', 0, 1]},
    ],
    'GLN-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'CD'], ['OE1', 'HD2'],
         ['NE2', 'HD3']],
        ['H', 'HE21', 'HE22'],
        {'GLN-PRO': ['disappear', 0, 1], 'PRO-GLN': ['appear', 1, 0]},
    ],
    'GLN-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG2', 'HG']],
        ['HG3', 'CD', 'OE1', 'NE2', 'HE21', 'HE22'],
        {'GLN-SER': ['disappear', 0, 1], 'SER-GLN': ['appear', 1, 0]},
    ],
    'GLN-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['CD', 'HG22'],
         ['OE1', 'HG23']],
        ['NE2', 'HE21', 'HE22'],
        {'THR-GLN': ['appear', 1, 0], 'GLN-THR': ['disappear', 0, 1]},
    ],
    'GLN-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'NE1'], ['NE2', 'CE3'], ['HE21', 'CE2'],
         ['HE22', 'HE1']],
        ['HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-GLN': ['disappear', 1, 0], 'GLN-TRP': ['appear', 0, 1]},
    ],
    'GLN-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['NE2', 'HD2'], ['HE21', 'CE2'],
         ['HE22', 'HE1']],
        ['CZ', 'HE2', 'OH', 'HH'],
        {'GLN-TYR': ['appear', 0, 1], 'TYR-GLN': ['disappear', 1, 0]},
    ],
    'GLN-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['CD', 'HG13'],
         ['OE1', 'HG21'], ['NE2', 'HG22'], ['HE21', 'HG23']],
        ['HE22'],
        {'GLN-VAL': ['disappear', 0, 1], 'VAL-GLN': ['appear', 1, 0]},
    ],
    'GLU-GLY': [
        ['N', 'H', 'CA', 'O', 'C'],
        [['HA', 'HA2'], ['CB', 'HA3']],
        ('HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'OE1', 'OE2'),
        {'GLU-GLY': ['disappear', 0, 1], 'GLY-GLU': ['appear', 1, 0]},
    ],
    'GLU-HID': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2']],
        ['NE2', 'HE1'],
        {'GLU-HID': ['appear', 0, 1], 'HID-GLU': ['disappear', 1, 0]},
    ],
    'GLU-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'CE1'], ['OE1', 'HD2'], ['OE2', 'NE2']],
        ['HE1', 'HE2'],
        {'GLU-HIE': ['appear', 0, 1], 'HIE-GLU': ['disappear', 1, 0]},
    ],
    'GLU-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'ND1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2']],
        ['NE2', 'HE1', 'HE2'],
        {'GLU-HIP': ['appear', 0, 1], 'HIP-GLU': ['disappear', 1, 0]},
    ],
    'GLU-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG12'], ['HG3', 'HG13'], ['CD', 'CD1'], ['OE1', 'HG21'],
         ['OE2', 'HG22']],
        ['HG23', 'HD11', 'HD12', 'HD13'],
        {'GLU-ILE': ['appear', 0, 1], 'ILE-GLU': ['disappear', 1, 0]},
    ],
    'GLU-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG'], ['HG3', 'CD1'], ['CD', 'CD2'], ['OE1', 'HD11'], ['OE2', 'HD12']],
        ['HD13', 'HD21', 'HD22', 'HD23'],
        {'GLU-LEU': ['appear', 0, 1], 'LEU-GLU': ['disappear', 1, 0]},
    ],
    'GLU-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['OE1', 'HD2'], ['OE2', 'HD3']],
        ['CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-GLU': ['disappear', 1, 0], 'GLU-LYN': ['appear', 0, 1]},
    ],
    'GLU-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD'],
        [['OE1', 'HD2'], ['OE2', 'HD3']],
        ['CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'GLU-LYS': ['appear', 0, 1], 'LYS-GLU': ['disappear', 1, 0]},
    ],
    'GLU-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'SD'], ['OE1', 'CE'], ['OE2', 'HE1']],
        ['HE2', 'HE3'],
        {'MET-GLU': ['disappear', 1, 0], 'GLU-MET': ['appear', 0, 1]},
    ],
    'GLU-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2']],
        ['CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'PHE-GLU': ['disappear', 1, 0], 'GLU-PHE': ['appear', 0, 1]},
    ],
    'GLU-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'CD'], ['OE1', 'HD2'],
         ['OE2', 'HD3']],
        ['H'],
        {'PRO-GLU': ['appear', 1, 0], 'GLU-PRO': ['disappear', 0, 1]},
    ],
    'GLU-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG2', 'HG']],
        ['HG3', 'CD', 'OE1', 'OE2'],
        {'GLU-SER': ['disappear', 0, 1], 'SER-GLU': ['appear', 1, 0]},
    ],
    'GLU-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['CD', 'HG22'],
         ['OE1', 'HG23']],
        ['OE2'],
        {'THR-GLU': ['appear', 1, 0], 'GLU-THR': ['disappear', 0, 1]},
    ],
    'GLU-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'NE1'], ['OE2', 'CE3']],
        ['CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-GLU': ['disappear', 1, 0], 'GLU-TRP': ['appear', 0, 1]},
    ],
    'GLU-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['OE1', 'CE1'], ['OE2', 'HD2']],
        ['CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'GLU-TYR': ['appear', 0, 1], 'TYR-GLU': ['disappear', 1, 0]},
    ],
    'GLU-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['CD', 'HG13'],
         ['OE1', 'HG21'], ['OE2', 'HG22']],
        ['HG23'],
        {'GLU-VAL': ['appear', 0, 1], 'VAL-GLU': ['disappear', 1, 0]},
    ],
    'GLY-HID': [
        ['N', 'H', 'CA', 'C', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'ND1', 'HD1', 'CD2', 'HD2', 'CE1', 'HE1', 'NE2'),
        {'GLY-HID': ['appear', 0, 1], 'HID-GLY': ['disappear', 1, 0]},
    ],
    'GLY-HIE': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'ND1', 'CD2', 'HD2', 'CE1', 'HE1', 'NE2', 'HE2'),
        {'HIE-GLY': ['disappear', 1, 0], 'GLY-HIE': ['appear', 0, 1]},
    ],
    'GLY-HIP': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'ND1', 'HD1', 'CD2', 'HD2', 'CE1', 'HE1', 'NE2', 'HE2'),
        {'GLY-HIP': ['appear', 0, 1], 'HIP-GLY': ['disappear', 1, 0]},
    ],
    'GLY-ILE': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB', 'CG1', 'HG12', 'HG13', 'CG2', 'HG21', 'HG22', 'HG23', 'CD1', 'HD11', 'HD12', 'HD13'),
        {'ILE-GLY': ['disappear', 1, 0], 'GLY-ILE': ['appear', 0, 1]},
    ],
    'GLY-LEU': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'HG', 'CD1', 'HD11', 'HD12', 'HD13', 'CD2', 'HD21', 'HD22', 'HD23'),
        {'LEU-GLY': ['disappear', 1, 0], 'GLY-LEU': ['appear', 0, 1]},
    ],
    'GLY-LYN': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'),
        {'GLY-LYN': ['appear', 0, 1], 'LYN-GLY': ['disappear', 1, 0]},
    ],
    'GLY-LYS': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'),
        {'LYS-GLY': ['disappear', 1, 0], 'GLY-LYS': ['appear', 0, 1]},
    ],
    'GLY-MET': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'HG2', 'HG3', 'SD', 'CE', 'HE1', 'HE2', 'HE3'),
        {'GLY-MET': ['appear', 0, 1], 'MET-GLY': ['disappear', 1, 0]},
    ],
    'GLY-PHE': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'CD1', 'HD1', 'CD2', 'HD2', 'CE1', 'HE1', 'CE2', 'HE2', 'CZ', 'HZ'),
        {'GLY-PHE': ['appear', 0, 1], 'PHE-GLY': ['disappear', 1, 0]},
    ],
    'GLY-PRO': [
        ['C', 'N', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB'], ['H', 'CD']],
        ['HB2', 'HB3', 'CG', 'HG2', 'HG3', 'HD2', 'HD3'],
        {'GLY-PRO': ['appear', 0, 1], 'PRO-GLY': ['disappear', 1, 0]}
    ],
    'GLY-SER': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'OG', 'HG'),
        {'SER-GLY': ['disappear', 1, 0], 'GLY-SER': ['appear', 0, 1]},
    ],
    'GLY-THR': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB', 'OG1', 'HG1', 'CG2', 'HG21', 'HG22', 'HG23'),
        {'GLY-THR': ['appear', 0, 1], 'THR-GLY': ['disappear', 1, 0]},
    ],
    'GLY-TRP': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'CD1', 'HD1', 'CD2', 'NE1', 'HE1', 'CE3', 'HE3', 'CE2', 'CZ3', 'HZ3', 'CZ2', 'HZ2', 'CH2',
         'HH2'),
        {'GLY-TRP': ['appear', 0, 1], 'TRP-GLY': ['disappear', 1, 0]},
    ],
    'GLY-TYR': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB2', 'HB3', 'CG', 'CD1', 'HD1', 'CD2', 'HD2', 'CE1', 'HE1', 'CE2', 'HE2', 'CZ', 'OH', 'HH'),
        {'TYR-GLY': ['disappear', 1, 0], 'GLY-TYR': ['appear', 0, 1]},
    ],
    'GLY-VAL': [
        ['C', 'N', 'H', 'CA', 'O'],
        [['HA2', 'HA'], ['HA3', 'CB']],
        ('HB', 'CG1', 'HG11', 'HG12', 'HG13', 'CG2', 'HG21', 'HG22', 'HG23'),
        {'VAL-GLY': ['disappear', 1, 0], 'GLY-VAL': ['appear', 0, 1]},
    ],
    'HID-HIE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'ND1', 'CD2', 'HD2', 'CE1', 'HE1', 'NE2'],
        [['HD1', 'HE2']],
        [],
        {'HID-HIE': ['', 0, 1], 'HIE-HID': ['', 1, 0]},
    ],
    'HID-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'ND1', 'CD2', 'HD2', 'CE1', 'HE1', 'NE2', 'HD1'],
        [],
        ['HE2'],
        {'HID-HIP': ['appear', 1, 0], 'HIP-HID': ['disappear', 0, 1]},
    ],
    'HID-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['ND1', 'HG12'], ['CD2', 'HG13'], ['HD1', 'CD1'],
         ['CE1', 'HG21'], ['HD2', 'HG22'], ['NE2', 'HG23'], ['HE1', 'HD11']],
        ['HD12', 'HD13'],
        {'ILE-HID': ['disappear', 1, 0], 'HID-ILE': ['appear', 0, 1]},
    ],
    'HID-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD2', 'CD2'], ['ND1', 'HG'], ['HD1', 'CD1'], ['CE1', 'HD11'], ['HD2', 'HD12'], ['NE2', 'HD13'],
         ['HE1', 'HD21']],
        ['HD22', 'HD23'],
        {'HID-LEU': ['appear', 0, 1], 'LEU-HID': ['disappear', 1, 0]},
    ],
    'HID-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['HD1', 'CD'], ['CE1', 'HD3'], ['NE2', 'CE'], ['HE1', 'HE2']],
        ['HE3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-HID': ['disappear', 1, 0], 'HID-LYN': ['appear', 0, 1]},
    ],
    'HID-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['HD1', 'CD'], ['CE1', 'HD3'], ['NE2', 'CE'], ['HE1', 'HE2']],
        ['HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'HID-LYS': ['appear', 0, 1], 'LYS-HID': ['disappear', 1, 0]},
    ],
    'HID-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HE1', 'HE1'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['HD1', 'SD'], ['CE1', 'CE'], ['HD2', 'HE2'], ['NE2', 'HE3']],
        [],
        {'HID-MET': ['', 0, 1], 'MET-HID': ['', 1, 0]},
    ],
    'HID-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['HD2', 'HD2'], ['CE1', 'CE1'], ['HE1', 'HE1'],
         ['NE2', 'CE2']],
        ['HE2', 'CZ', 'HZ'],
        {'HID-PHE': ['appear', 0, 1], 'PHE-HID': ['disappear', 1, 0]},
    ],
    'HID-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['CE1', 'CD'], ['HD2', 'HD2'],
         ['HE1', 'HD3']],
        ['H', 'HD1', 'NE2'],
        {'HID-PRO': ['disappear', 0, 1], 'PRO-HID': ['appear', 1, 0]},
    ],
    'HID-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['ND1', 'HG']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'NE2', 'HE1'],
        {'HID-SER': ['disappear', 0, 1], 'SER-HID': ['appear', 1, 0]},
    ],
    'HID-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['ND1', 'HG1'], ['CD2', 'HG21'], ['HD1', 'HG22'],
         ['CE1', 'HG23']],
        ['HD2', 'NE2', 'HE1'],
        {'HID-THR': ['disappear', 0, 1], 'THR-HID': ['appear', 1, 0]},
    ],
    'HID-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['CE1', 'NE1'], ['NE2', 'CE3'], ['HD2', 'CE2'],
         ['HE1', 'HE1']],
        ['CZ3', 'HZ3', 'CZ2', 'HZ2', 'CH2', 'HH2', 'HE3'],
        {'HID-TRP': ['appear', 0, 1], 'TRP-HID': ['disappear', 1, 0]},
    ],
    'HID-TYR': [
        ['N', 'CA', 'HA', 'C', 'H', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['HD2', 'HD2'], ['CE1', 'CE1'], ['HE1', 'HE1'],
         ['NE2', 'CE2']],
        ['HE2', 'CZ', 'OH', 'HH'],
        {'HID-TYR': ['appear', 0, 1], 'PHE-TYR': ['disappear', 1, 0]},
    ],
    'HID-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['ND1', 'HG11'], ['CD2', 'HG12'], ['HD1', 'HG13'],
         ['CE1', 'HG21'], ['HD2', 'HG22'], ['NE2', 'HG23']],
        ['HE1'],
        {'HID-VAL': ['disappear', 0, 1], 'VAL-HID': ['appear', 1, 0]},
    ],
    'HIE-HIP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'HB2', 'HB3', 'CG', 'CB', 'ND1', 'CD2', 'HD2', 'CE1', 'HE1', 'NE2', 'HE2'],
        [],
        ['HD1'],
        {'HIE-HIP': ['appear', 1, 0], 'HIP-HIE': ['disappear', 0, 1]},
    ],
    'HIE-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['ND1', 'HG12'], ['CD2', 'HG13'], ['CE1', 'CD1'],
         ['HD2', 'HG21'], ['NE2', 'HG22'], ['HE1', 'HG23'], ['HE2', 'HD11']],
        ['HD12', 'HD13'],
        {'HIE-ILE': ['appear', 0, 1], 'ILE-HIE': ['disappear', 1, 0]},
    ],
    'HIE-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD2', 'CD2'], ['ND1', 'HG'], ['CE1', 'CD1'], ['HD2', 'HD11'], ['NE2', 'HD12'], ['HE1', 'HD13'],
         ['HE2', 'HD21']],
        ['HD22', 'HD23'],
        {'HIE-LEU': ['appear', 0, 1], 'LEU-HIE': ['disappear', 1, 0]},
    ],
    'HIE-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['CE1', 'CD'], ['NE2', 'HD3'], ['HE1', 'CE']],
        ['HE3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-HIE': ['disappear', 1, 0], 'HIE-LYN': ['appear', 0, 1]},
    ],
    'HIE-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['CE1', 'CD'], ['NE2', 'HD3'], ['HE1', 'CE']],
        ['HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'HIE-LYS': ['appear', 0, 1], 'LYS-HIE': ['disappear', 1, 0]},
    ],
    'HIE-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HE1', 'HE1'], ['HE2', 'HE2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['CE1', 'SD'], ['HD2', 'CE'], ['NE2', 'HE3']],
        [],
        {'MET-HIE': ['', 1, 0], 'HIE-MET': ['', 0, 1]},
    ],
    'HIE-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HE2', 'HE2'], ['CD2', 'CD2'], ['HD2', 'HD2'], ['CE1', 'CE1'], ['HE1', 'HE1'],
         ['NE2', 'CE2']],
        ['HD1', 'CZ', 'HZ'],
        {'HIE-PHE': ['appear', 0, 1], 'PHE-HIE': ['disappear', 1, 0]},
    ],
    'HIE-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['CE1', 'CD'], ['HD2', 'HD2'],
         ['HE1', 'HD3']],
        ['H', 'NE2', 'HE2'],
        {'HIE-PRO': ['disappear', 0, 1], 'PRO-HIE': ['appear', 1, 0]},
    ],
    'HIE-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['ND1', 'HG']],
        ['CD2', 'CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'HIE-SER': ['disappear', 0, 1], 'SER-HIE': ['appear', 1, 0]},
    ],
    'HIE-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['ND1', 'HG1'], ['CD2', 'HG21'], ['CE1', 'HG22'],
         ['HD2', 'HG23']],
        ['NE2', 'HE1', 'HE2'],
        {'THR-HIE': ['appear', 1, 0], 'HIE-THR': ['disappear', 0, 1]},
    ],
    'HIE-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['CD2', 'CD2'], ['CE1', 'NE1'], ['NE2', 'CE3'], ['HE2', 'HE3'], ['HD2', 'CE2'],
         ['HE1', 'HE1']],
        ['CZ3', 'HZ3', 'HD1', 'CZ2', 'HZ2', 'CH2', 'HH2'],
        {'HIE-TRP': ['appear', 0, 1], 'TRP-HIE': ['disappear', 1, 0]},
    ],
    'HIE-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HE2', 'HE2'], ['CD2', 'CD2'], ['HD2', 'HD2'], ['CE1', 'CE1'], ['HE1', 'HE1'],
         ['NE2', 'CE2']],
        ['HD1', 'CZ', 'OH', 'HH'],
        {'HIE-TYR': ['appear', 0, 1], 'TYR-HIE': ['disappear', 1, 0]},
    ],
    'HIE-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['ND1', 'HG11'], ['CD2', 'HG12'], ['CE1', 'HG13'],
         ['HD2', 'HG21'], ['NE2', 'HG22'], ['HE1', 'HG23']],
        ['HE2'],
        {'VAL-HIE': ['appear', 1, 0], 'HIE-VAL': ['disappear', 0, 1]},
    ],
    'HIP-ILE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['ND1', 'HG12'], ['CD2', 'HG13'], ['HD1', 'CD1'],
         ['CE1', 'HG21'], ['HD2', 'HG22'], ['NE2', 'HG23'], ['HE1', 'HD11'], ['HE2', 'HD12']],
        ['HD13'],
        {'ILE-HIP': ['disappear', 1, 0], 'HIP-ILE': ['appear', 0, 1]},
    ],
    'HIP-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD2', 'CD2'], ['ND1', 'HG'], ['HD1', 'CD1'], ['CE1', 'HD11'], ['HD2', 'HD12'], ['NE2', 'HD13'],
         ['HE1', 'HD21'], ['HE2', 'HD22']],
        ['HD23'],
        {'HIP-LEU': ['appear', 0, 1], 'LEU-HIP': ['disappear', 1, 0]},
    ],
    'HIP-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['HD1', 'CD'], ['CE1', 'HD3'], ['NE2', 'CE'],
         ['HE1', 'HE3']],
        ['NZ', 'HZ1', 'HZ2'],
        {'HIP-LYN': ['appear', 0, 1], 'LYN-HIP': ['disappear', 1, 0]},
    ],
    'HIP-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['HD1', 'CD'], ['CE1', 'HD3'], ['NE2', 'CE'],
         ['HE1', 'HE3']],
        ['NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-HIP': ['disappear', 1, 0], 'HIP-LYS': ['appear', 0, 1]},
    ],
    'HIP-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HE1', 'HE1'], ['HE2', 'HE2'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['HD1', 'SD'], ['CE1', 'CE'], ['HD2', 'HE3']],
        ['NE2'],
        {'HIP-MET': ['disappear', 0, 1], 'MET-HIP': ['appear', 1, 0]},
    ],
    'HIP-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['HD2', 'HD2'], ['CE1', 'CE1'], ['HE1', 'HE1'], ['HE2', 'HE2'],
         ['NE2', 'CE2']],
        ['CZ', 'HZ'],
        {'HIP-PHE': ['appear', 0, 1], 'PHE-HIP': ['disappear', 1, 0]},
    ],
    'HIP-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['ND1', 'HG2'], ['CD2', 'HG3'], ['CE1', 'CD'], ['HD2', 'HD2'],
         ['HE1', 'HD3']],
        ['H', 'NE2', 'HD1', 'HE2'],
        {'HIP-PRO': ['disappear', 0, 1], 'PRO-HIP': ['appear', 1, 0]},
    ],
    'HIP-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['ND1', 'HG']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'NE2', 'HE1', 'HE2'],
        {'HIP-SER': ['disappear', 0, 1], 'SER-HIP': ['appear', 1, 0]},
    ],
    'HIP-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['ND1', 'HG1'], ['CD2', 'HG21'], ['HD1', 'HG22'],
         ['CE1', 'HG23']],
        ['HD2', 'NE2', 'HE1', 'HE2'],
        {'HIP-THR': ['disappear', 0, 1], 'THR-HIP': ['appear', 1, 0]},
    ],
    'HIP-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['CE1', 'NE1'], ['NE2', 'CE3'], ['HE2', 'HE3'], ['HD2', 'CE2'],
         ['HE1', 'HE1']],
        ['CZ3', 'HZ3', 'CZ2', 'HZ2', 'CH2', 'HH2'],
        {'HIP-TRP': ['appear', 0, 1], 'TRP-HIP': ['disappear', 1, 0]},
    ],
    'HIP-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['ND1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['HD2', 'HD2'], ['CE1', 'CE1'], ['HE1', 'HE1'], ['NE2', 'CE2'],
         ['HE2', 'HE2']],
        ['CZ', 'OH', 'HH'],
        {'HIP-TYR': ['appear', 0, 1], 'TYR-HIP': ['disappear', 1, 0]},
    ],
    'HIP-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['ND1', 'HG11'], ['CD2', 'HG12'], ['HD1', 'HG13'],
         ['CE1', 'HG21'], ['HD2', 'HG22'], ['NE2', 'HG23']],
        ['HE1', 'HE2'],
        {'VAL-HIP': ['appear', 1, 0], 'HIP-VAL': ['disappear', 0, 1]},
    ],
    'ILE-LEU': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['CD1', 'CD1'], ['HG13', 'CD2'], ['HG12', 'HG'],
         ['HG21', 'HD21'], ['HG22', 'HD22'], ['HD11', 'HD11'], ['HD12', 'HD12'], ['HD13', 'HD13'], ['HG23', 'HD23']],
        [],
        {'LEU-ILE': ['', 1, 0], 'ILE-LEU': ['', 0, 1]},
    ],
    'ILE-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['HG12', 'HG2'], ['HG13', 'HG3'], ['CD1', 'CD'], ['HG21', 'HD2'],
         ['HG22', 'HD3'], ['HG23', 'CE'], ['HD11', 'HE2'], ['HD12', 'HE3'], ['HD13', 'NZ']],
        ['HZ1', 'HZ2'],
        {'ILE-LYN': ['appear', 0, 1], 'LYN-ILE': ['disappear', 1, 0]},
    ],
    'ILE-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['HG12', 'HG2'], ['HG13', 'HG3'], ['CD1', 'CD'], ['HG21', 'HD2'],
         ['HG22', 'HD3'], ['HG23', 'CE'], ['HD11', 'HE2'], ['HD12', 'HE3'], ['HD13', 'NZ']],
        ['HZ1', 'HZ2', 'HZ3'],
        {'LYS-ILE': ['disappear', 1, 0], 'ILE-LYS': ['appear', 0, 1]},
    ],
    'ILE-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['HG12', 'HG2'], ['HG13', 'HG3'], ['CD1', 'SD'], ['HG21', 'CE'],
         ['HG22', 'HE1'], ['HG23', 'HE2'], ['HD11', 'HE3']],
        ['HD12', 'HD13'],
        {'ILE-MET': ['disappear', 0, 1], 'MET-ILE': ['appear', 1, 0]},
    ],
    'ILE-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['CD1', 'CD1'], ['HG12', 'CD2'], ['HG23', 'CE2'],
         ['HG13', 'HD1'], ['HG21', 'CE1'], ['HG22', 'HD2'], ['HD11', 'HE1'], ['HD12', 'CZ'], ['HD13', 'HE2']],
        ['HZ'],
        {'PHE-ILE': ['disappear', 1, 0], 'ILE-PHE': ['appear', 0, 1]},
    ],
    'ILE-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['HG12', 'HG2'], ['HG13', 'HG3'], ['CD1', 'CD'], ['HG21', 'HD2'],
         ['HG22', 'HD3']],
        ['H', 'HG23', 'HD11', 'HD12', 'HD13'],
        {'ILE-PRO': ['disappear', 0, 1], 'PRO-ILE': ['appear', 1, 0]},
    ],
    'ILE-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'OG'], ['HG12', 'HG']],
        ['HG13', 'CD1', 'HG21', 'HG22', 'HG23', 'HD11', 'HD12', 'HD13'],
        {'SER-ILE': ['appear', 1, 0], 'ILE-SER': ['disappear', 0, 1]},
    ],
    'ILE-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HG21', 'HG21'], ['HB', 'HB'], ['HG23', 'HG23'], ['CG2', 'CG2'], ['HG22', 'HG22'], ['CG1', 'OG1'],
         ['HG12', 'HG1']],
        ['HG13', 'CD1', 'HD11', 'HD12', 'HD13'],
        {'THR-ILE': ['appear', 1, 0], 'ILE-THR': ['disappear', 0, 1]},
    ],
    'ILE-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['CD1', 'CD1'], ['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['HG12', 'CD2'], ['HG13', 'HD1'],
         ['HG21', 'NE1'], ['HG22', 'CE3'], ['HG23', 'CE2'], ['HD11', 'HE1'], ['HD12', 'HE3'], ['HD13', 'CZ3']],
        ['CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-ILE': ['disappear', 1, 0], 'ILE-TRP': ['appear', 0, 1]},
    ],
    'ILE-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['CG1', 'HB3'], ['CG2', 'CG'], ['CD1', 'CD1'], ['HG12', 'CD2'], ['HG13', 'HD1'],
         ['HG21', 'CE1'], ['HG22', 'HD2'], ['HG23', 'CE2'], ['HD11', 'HE1'], ['HD12', 'CZ'], ['HD13', 'HE2']],
        ['OH', 'HH'],
        {'TYR-ILE': ['disappear', 1, 0], 'ILE-TYR': ['appear', 0, 1]},
    ],
    'ILE-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['CG2', 'CG2'], ['HB', 'HB'], ['CG1', 'CG1'], ['HG12', 'HG12'], ['HG13', 'HG13'], ['HG21', 'HG21'],
         ['HG23', 'HG23'], ['HG22', 'HG22'], ['CD1', 'HG11']],
        ['HD11', 'HD12', 'HD13'],
        {'VAL-ILE': ['appear', 1, 0], 'ILE-VAL': ['disappear', 0, 1]},
    ],
    'LEU-LYN': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG', 'HG2'], ['CD1', 'HG3'], ['CD2', 'CD'], ['HD11', 'HD2'], ['HD12', 'HD3'], ['HD13', 'CE'],
         ['HD21', 'HE2'], ['HD22', 'HE3'], ['HD23', 'NZ']],
        ['HZ1', 'HZ2'],
        {'LYN-LEU': ['disappear', 1, 0], 'LEU-LYN': ['appear', 0, 1]},
    ],
    'LEU-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG', 'HG2'], ['CD1', 'HG3'], ['CD2', 'CD'], ['HD11', 'HD2'], ['HD12', 'HD3'], ['HD13', 'CE'],
         ['HD21', 'HE2'], ['HD22', 'HE3'], ['HD23', 'NZ']],
        ['HZ1', 'HZ2', 'HZ3'],
        {'LEU-LYS': ['appear', 0, 1], 'LYS-LEU': ['disappear', 1, 0]},
    ],
    'LEU-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG', 'HG2'], ['CD1', 'HG3'], ['CD2', 'SD'], ['HD11', 'CE'], ['HD12', 'HE1'], ['HD13', 'HE2'],
         ['HD21', 'HE3']],
        ['HD22', 'HD23'],
        {'MET-LEU': ['appear', 1, 0], 'LEU-MET': ['disappear', 0, 1]},
    ],
    'LEU-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD1', 'CD1'], ['CD2', 'CD2'], ['HG', 'HD1'], ['HD11', 'CE1'], ['HD12', 'HD2'], ['HD13', 'CE2'],
         ['HD21', 'HE1'], ['HD22', 'CZ'], ['HD23', 'HE2']],
        ['HZ'],
        {'PHE-LEU': ['disappear', 1, 0], 'LEU-PHE': ['appear', 0, 1]},
    ],
    'LEU-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG', 'HG2'], ['CD1', 'HG3'], ['HD11', 'HD2'], ['HD12', 'HD3'],
         ['HD13', 'CD']],
        ['H', 'CD2', 'HD21', 'HD22', 'HD23'],
        {'PRO-LEU': ['appear', 1, 0], 'LEU-PRO': ['disappear', 0, 1]},
    ],
    'LEU-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG', 'HG']],
        ['CD1', 'CD2', 'HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'],
        {'LEU-SER': ['disappear', 0, 1], 'SER-LEU': ['appear', 1, 0]},
    ],
    'LEU-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG', 'HG1'], ['CD1', 'HG21'], ['CD2', 'HG22'],
         ['HD11', 'HG23']],
        ['HD12', 'HD13', 'HD21', 'HD22', 'HD23'],
        {'THR-LEU': ['appear', 1, 0], 'LEU-THR': ['disappear', 0, 1]},
    ],
    'LEU-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD1', 'CD1'], ['CD2', 'CD2'], ['HG', 'HD1'], ['HD11', 'NE1'], ['HD12', 'CE3'], ['HD13', 'CE2'],
         ['HD21', 'HE1'], ['HD22', 'HE3'], ['HD23', 'CZ3']],
        ['CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-LEU': ['disappear', 1, 0], 'LEU-TRP': ['appear', 0, 1]},
    ],
    'LEU-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD1', 'CD1'], ['CD2', 'CD2'], ['HG', 'HD1'], ['HD11', 'CE1'], ['HD12', 'HD2'], ['HD13', 'CE2'],
         ['HD21', 'HE1'], ['HD22', 'CZ'], ['HD23', 'HE2']],
        ['OH', 'HH'],
        {'TYR-LEU': ['disappear', 1, 0], 'LEU-TYR': ['appear', 0, 1]},
    ],
    'LEU-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG', 'HG11'], ['CD1', 'HG12'], ['CD2', 'HG13'],
         ['HD11', 'HG21'], ['HD12', 'HG22'], ['HD13', 'HG23']],
        ['HD21', 'HD22', 'HD23'],
        {'VAL-LEU': ['appear', 1, 0], 'LEU-VAL': ['disappear', 0, 1]},
    ],
    'LYN-LYS': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3',
         'NZ', 'HZ1', 'HZ2'],
        [],
        ['HZ3'],
        {'LYN-LYS': ['appear', 0, 1], 'LYS-LYN': ['disappear', 1, 0]},
    ],
    'LYN-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CE', 'CE'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['HE2', 'HE2'], ['HE3', 'HE3'], ['CD', 'SD'], ['HD2', 'HE1']],
        ['HD3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-MET': ['disappear', 0, 1], 'MET-LYN': ['appear', 1, 0]},
    ],
    'LYN-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD3', 'CE1'], ['CE', 'CE2'],
         ['HE3', 'HE1'], ['NZ', 'CZ'], ['HZ1', 'HZ']],
        ['HZ2'],
        {'LYN-PHE': ['disappear', 0, 1], 'PHE-LYN': ['appear', 1, 0]},
    ],
    'LYN-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'CD'], ['HD3', 'HD3'],
         ['HD2', 'HD2']],
        ['H', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'PRO-LYN': ['appear', 1, 0], 'LYN-PRO': ['disappear', 0, 1]},
    ],
    'LYN-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG2', 'HG']],
        ['HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'SER-LYN': ['appear', 1, 0], 'LYN-SER': ['disappear', 0, 1]},
    ],
    'LYN-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['CD', 'HG22'],
         ['HD2', 'HG23']],
        ['HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'LYN-THR': ['disappear', 0, 1], 'THR-LYN': ['appear', 1, 0]},
    ],
    'LYN-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HZ2', 'HZ2'], ['HE3', 'HE3'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD2', 'NE1'], ['HD3', 'CE3'],
         ['CE', 'CE2'], ['HE2', 'HE1'], ['NZ', 'CZ3'], ['HZ1', 'CZ2']],
        ['HZ3', 'CH2', 'HH2'],
        {'TRP-LYN': ['disappear', 1, 0], 'LYN-TRP': ['appear', 0, 1]},
    ],
    'LYN-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD3', 'CE1'], ['CE', 'CE2'],
         ['HE3', 'HE1'], ['NZ', 'CZ'], ['HZ1', 'OH'], ['HZ2', 'HH']],
        [],
        {'TYR-LYN': ['', 1, 0], 'LYN-TYR': ['', 0, 1]},
    ],
    'LYN-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['CD', 'HG13'],
         ['HD2', 'HG21'], ['HD3', 'HG22'], ['CE', 'HG23']],
        ['HE2', 'HE3', 'NZ', 'HZ1', 'HZ2'],
        {'VAL-LYN': ['appear', 1, 0], 'LYN-VAL': ['disappear', 0, 1]},
    ],
    'LYS-MET': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD', 'SD'], ['CE', 'CE'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['HE2', 'HE2'], ['HE3', 'HE3'], ['HD2', 'HE1']],
        ['HD3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'MET-LYS': ['appear', 1, 0], 'LYS-MET': ['disappear', 0, 1]},
    ],
    'LYS-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD3', 'CE1'], ['CE', 'CE2'],
         ['HE3', 'HE1'], ['NZ', 'CZ'], ['HZ1', 'HZ']],
        ['HZ2', 'HZ3'],
        {'LYS-PHE': ['disappear', 0, 1], 'PHE-LYS': ['appear', 1, 0]},
    ],
    'LYS-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['CD', 'CD'], ['HD3', 'HD3'],
         ['HD2', 'HD2']],
        ['H', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-PRO': ['disappear', 0, 1], 'PRO-LYS': ['appear', 1, 0]},
    ],
    'LYS-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG2', 'HG']],
        ['HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-SER': ['disappear', 0, 1], 'SER-LYS': ['appear', 1, 0]},
    ],
    'LYS-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['CD', 'HG22'],
         ['HD2', 'HG23']],
        ['HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-THR': ['disappear', 0, 1], 'THR-LYS': ['appear', 1, 0]},
    ],
    'LYS-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HZ2', 'HZ2'], ['HZ3', 'HZ3'], ['HE3', 'HE3'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD2', 'NE1'],
         ['HD3', 'CE3'], ['CE', 'CE2'], ['HE2', 'HE1'], ['NZ', 'CZ3'], ['HZ1', 'CZ2']],
        ['CH2', 'HH2'],
        {'LYS-TRP': ['appear', 0, 1], 'TRP-LYS': ['disappear', 1, 0]},
    ],
    'LYS-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HD2', 'HD2'], ['HE2', 'HE2'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'HD1'], ['HD3', 'CE1'], ['CE', 'CE2'],
         ['HE3', 'HE1'], ['NZ', 'CZ'], ['HZ1', 'OH'], ['HZ2', 'HH']],
        ['HZ3'],
        {'LYS-TYR': ['disappear', 0, 1], 'TYR-LYS': ['appear', 1, 0]},
    ],
    'LYS-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['CD', 'HG13'],
         ['HD2', 'HG21'], ['HD3', 'HG22'], ['CE', 'HG23']],
        ['HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3'],
        {'LYS-VAL': ['disappear', 0, 1], 'VAL-LYS': ['appear', 1, 0]},
    ],
    'MET-PHE': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['SD', 'HD1'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CE', 'CE1'], ['HE1', 'HE1'], ['HE2', 'HE2'], ['HE3', 'HD2']],
        ['CE2', 'CZ', 'HZ'],
        {'MET-PHE': ['appear', 0, 1], 'PHE-MET': ['disappear', 1, 0]},
    ],
    'MET-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'HG2'], ['HG3', 'HG3'], ['SD', 'CD'], ['CE', 'HD3'],
         ['HE1', 'HD2']],
        ['H', 'HE2', 'HE3'],
        {'MET-PRO': ['disappear', 0, 1], 'PRO-MET': ['appear', 1, 0]},
    ],
    'MET-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['HG2', 'HG']],
        ['HG3', 'SD', 'CE', 'HE1', 'HE2', 'HE3'],
        {'SER-MET': ['appear', 1, 0], 'MET-SER': ['disappear', 0, 1]},
    ],
    'MET-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['SD', 'HG22'], ['CE', 'HG23']],
        ['HE1', 'HE2', 'HE3'],
        {'MET-THR': ['disappear', 0, 1], 'THR-MET': ['appear', 1, 0]},
    ],
    'MET-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['SD', 'HD1'], ['CE', 'NE1'], ['HE2', 'CE3'], ['HE1', 'HE1'], ['HE3', 'HE3']],
        ['CE2', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'MET-TRP': ['appear', 0, 1], 'TRP-MET': ['disappear', 1, 0]},
    ],
    'MET-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['HG2', 'CD1'], ['HG3', 'CD2'], ['SD', 'HD1'], ['CE', 'CE1'], ['HE3', 'HD2'], ['HE1', 'HE1'], ['HE2', 'CE2']],
        ['HE2', 'CZ', 'OH', 'HH'],
        {'TYR-MET': ['disappear', 1, 0], 'MET-TYR': ['appear', 0, 1]},
    ],
    'MET-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'CG1'], ['HB3', 'CG2'], ['CG', 'HB'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['SD', 'HG13'], ['CE', 'HG21'],
         ['HE1', 'HG22'], ['HE2', 'HG23']],
        ['HE3'],
        {'VAL-MET': ['appear', 1, 0], 'MET-VAL': ['disappear', 0, 1]},
    ],
    'PHE-PRO': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['CD1', 'HG2'], ['CD2', 'HG3'], ['CE1', 'CD'], ['HD2', 'HD2'],
         ['HD1', 'HD3']],
        ['H', 'HE1', 'CE2', 'HE2', 'CZ', 'HZ'],
        {'PHE-PRO': ['disappear', 0, 1], 'PRO-PHE': ['appear', 1, 0]}
    ],
    'PHE-SER': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['CG', 'OG'], ['CD1', 'HG']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'PHE-SER': ['disappear', 0, 1], 'SER-PHE': ['appear', 1, 0]},
    ],
    'PHE-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['CD1', 'HG1'], ['CD2', 'HG21'], ['HD1', 'HG22'],
         ['CE1', 'HG23']],
        ['HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'HZ'],
        {'THR-PHE': ['appear', 1, 0], 'PHE-THR': ['disappear', 0, 1]},
    ],
    'PHE-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['HD2', 'NE1'], ['CE1', 'CE3'], ['HE1', 'HE3'], ['CE2', 'CE2'],
         ['HE2', 'HE1'], ['CZ', 'CZ3'], ['HZ', 'HZ3']],
        ['CZ2', 'HZ2', 'CH2', 'HH2'],
        {'PHE-TRP': ['appear', 0, 1], 'TRP-PHE': ['disappear', 1, 0]}
    ],
    'PHE-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG', 'CD1', 'HD1', 'CD2', 'HD2', 'CE1', 'HE1', 'CE2',
         'HE2', 'CZ'],
        [['HZ', 'OH']],
        ['HH'],
        {'PHE-TYR': ['appear', 0, 1], 'TYR-PHE': ['disappear', 1, 0]}
    ],
    'PHE-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['CD1', 'HG11'], ['CD2', 'HG12'], ['HD1', 'HG13'],
         ['CE1', 'HG21'], ['HD2', 'HG22'], ['CE2', 'HG23']],
        ['HE1', 'CZ', 'HE2', 'HZ'],
        {'PHE-VAL': ['disappear', 0, 1], 'VAL-PHE': ['appear', 1, 0]},
    ],
    'PRO-SER': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'OG'], ['HG2', 'HG'], ['CD', 'H']],
        ['HG3', 'HD2', 'HD3'],
        {'PRO-SER': ['disappear', 0, 1], 'SER-PRO': ['appear', 1, 0]}
    ],
    'PRO-THR': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['CG', 'CG2'], ['HG2', 'HG1'], ['HG3', 'HG21'], ['CD', 'H'], ['HD2', 'HG22'],
         ['HD3', 'HG23']],
        [],
        {'PRO-THR': ['', 0, 1], 'THR-PRO': ['', 1, 0]}
    ],
    'PRO-TRP': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'H'], ['HD2', 'HD1'],
         ['HD3', 'NE1']],
        ['CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'PRO-TRP': ['appear', 0, 1], 'THR-PRO': ['disappear', 1, 0]}
    ],
    'PRO-TYR': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB2'], ['HB3', 'HB3'], ['CG', 'CG'], ['HG2', 'CD1'], ['HG3', 'CD2'], ['CD', 'H'], ['HD2', 'HD1'],
         ['HD3', 'HD2']],
        ['CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'PRO-TYR': ['appear', 0, 1], 'TYR-PRO': ['disappear', 1, 0]}
    ],
    'PRO-VAL': [
        ['N', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['CG', 'CG1'], ['HB3', 'CG2'], ['HG2', 'HG11'], ['HG3', 'HG12'], ['CD', 'H'], ['HD2', 'HG13'],
         ['HD3', 'HG21']],
        ['HG22', 'HG23'],
        {'PRO-VAL': ['appear', 0, 1], 'VAL-PRO': ['disappear', 1, 0]}
    ],
    'SER-THR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'OG1'], ['OG', 'CG2'], ['HG', 'HG1']],
        ['HG21', 'HG22', 'HG23'],
        {'THR-SER': ['disappear', 1, 0], 'SER-THR': ['appear', 0, 1]},
    ],
    'SER-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['OG', 'CG'], ['HG', 'CD1']],
        ['CD2', 'HD1', 'NE1', 'CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-SER': ['disappear', 1, 0], 'SER-TRP': ['appear', 0, 1]},
    ],
    'SER-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB3', 'HB3'], ['HB2', 'HB2'], ['OG', 'CG'], ['HG', 'CD1']],
        ['CD2', 'HD1', 'CE1', 'HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'SER-TYR': ['appear', 0, 1], 'TYR-SER': ['disappear', 1, 0]},
    ],
    'SER-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['OG', 'CG2'], ['HG', 'HG11']],
        ['HG12', 'HG13', 'HG21', 'HG22', 'HG23'],
        {'SER-VAL': ['appear', 0, 1], 'VAL-SER': ['disappear', 1, 0]},
    ],
    'THR-TRP': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['OG1', 'HB3'], ['CG2', 'CG'], ['HG1', 'CD1'], ['HG21', 'CD2'], ['HG22', 'HD1'],
         ['HG23', 'NE1']],
        ['CE3', 'CE2', 'HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'TRP-THR': ['disappear', 1, 0], 'THR-TRP': ['appear', 0, 1]},
    ],
    'THR-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB', 'HB2'], ['OG1', 'HB3'], ['CG2', 'CG'], ['HG1', 'CD1'], ['HG21', 'CD2'], ['HG22', 'HD1'],
         ['HG23', 'CE1']],
        ['HD2', 'CE2', 'HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'THR-TYR': ['appear', 0, 1], 'TYR-THR': ['disappear', 1, 0]},
    ],
    'THR-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HG21', 'HG21'], ['HB', 'HB'], ['HG23', 'HG23'], ['CG2', 'CG2'], ['HG22', 'HG22'], ['OG1', 'CG1'],
         ['HG1', 'HG11']],
        ['HG12', 'HG13'],
        {'THR-VAL': ['appear', 0, 1], 'VAL-THR': ['disappear', 1, 0]},
    ],
    'TRP-TYR': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB', 'HB2', 'HB3', 'CG'],
        [['CD1', 'CD1'], ['HD1', 'HD1'], ['CD2', 'CD2'], ['NE1', 'HD2'], ['CE3', 'CE1'], ['HE1', 'HE1'], ['CE2', 'CE2'],
         ['HE3', 'HE2'], ['CZ3', 'CZ'], ['HZ3', 'OH'], ['CZ2', 'HH']],
        ['HZ2', 'CH2', 'HH2'],
        {'TRP-TYR': ['disappear', 0, 1], 'TYR-TRP': ['appear', 1, 0]}
    ],
    'TRP-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['CD1', 'HG11'], ['CD2', 'HG12'], ['HD1', 'HG13'],
         ['NE1', 'HG21'], ['CE3', 'HG22'], ['CE2', 'HG23']],
        ['HE1', 'HE3', 'CZ3', 'CZ2', 'HZ3', 'HZ2', 'CH2', 'HH2'],
        {'VAL-TRP': ['appear', 1, 0], 'TRP-VAL': ['disappear', 0, 1]},
    ],
    'TYR-VAL': [
        ['N', 'H', 'CA', 'HA', 'C', 'O', 'CB'],
        [['HB2', 'HB'], ['HB3', 'CG1'], ['CG', 'CG2'], ['CD1', 'HG11'], ['CD2', 'HG12'], ['HD1', 'HG13'],
         ['CE1', 'HG21'], ['HD2', 'HG22'], ['CE2', 'HG23']],
        ['HE1', 'CZ', 'HE2', 'OH', 'HH'],
        {'TYR-VAL': ['disappear', 0, 1], 'VAL-TYR': ['appear', 1, 0]},
    ],
}

input_keywords = {
    "all": ["ARG", "HIE", "HID", "HIP", "LYS", "ASP", "GLU", "SER", "THR",
            "ASN", "GLN", "CYS", "GLY", "PRO", "ALA", "VAL", "ILE", "LEU",
            "MET", "PHE", "TYR", "TRP"],
    "all_protonated": ["ARG", "HIE", "HID", "HIP", "LYS", "LYN", "ASP", "ASH", "GLU", "GLH",
                       "SER", "THR", "ASN", "GLN", "CYS", "CYT", "GLY", "PRO", "ALA", "VAL",
                       "ILE", "LEU", "MET", "PHE", "TYR", "TRP"],
    "positive": ["ARG", "HIE", "HID", "HIP", "LYS"],
    "positive_protonated": ["ARG", "HIE", "HID", "HIP", "LYS", "LYN"],
    "negative": ["ASP", "GLU"],
    "negative_protonated": ["ASP", "ASH", "GLU", "GLH"],
    "polar": ["SER", "THR", "ASN", "GLN"],
    "special": ["CYS", "CYT", "GLY", "PRO"],
    "hydrophobic": ["ALA", "VAL", "ILE", "LEU", "MET", "PHE", "TYR", "TRP"]
}
