![python-version](https://img.shields.io/badge/python-3.7+-blue.svg)
[![publish](https://github.com/mnogomed/pm-attacher/actions/workflows/publish.yml/badge.svg)](https://github.com/mnogomed/pm-attacher/actions/workflows/publish.yml)
![PyPI](https://img.shields.io/pypi/v/pm-attacher)

# Прикрепление файлов к МКАБ

Утилита предназначена для поиска и прикрепления файлов к медицинским картам амбулаторных больных (МКАБ), основываясь на имени файла, в котором должен быть номер МКАБ.

## Установка

```bash
pip install pm-attacher
```

## Настройка

Управление параметрами утилиты производится либо через переменные окружения, либо через ключи запуска, причём приоритет имеют последние.

| Ключ запуска         | Переменная окружения | Обязательно? | Значение по умолчанию | Описание                                       |
|----------------------|----------------------|:------------:|-----------------------|------------------------------------------------|
| `--file-type-code`   |                      |      Да      |                       | Код типа файла                                 | 
| `--file-type-name`   |                      |      Да      |                       | Наименование типа файла                        | 
| `--file-info-name`   |                      |     Нет      | `Протокол осмотра`    | Наименование файла                             | 
| `--create-user-id`   |                      |     Нет      | `1`                   | Идентификатор пользователя, прикрепившего файл | 
| `--create-user-name` |                      |     Нет      | `Администратор`       | ФИО пользователя, прикрепившего файл           | 
| `--prefix`           |                      |     Нет      |                       | Префикс имени файла                            |         
| `--suffix`           |                      |     Нет      |                       | Суффикс имени файла                            |         
| `--recursive`        |                      |     Нет      | `False`               | Рекурсивный поиск                              |      
| `--dry-run`          |                      |     Нет      | `False`               | Тестовый запуск, изменения не сохраняются      |        
| `--mis-db-server`    | `MIS_DB_SERVER`      |      Да      |                       | Адрес сервера МИС                              |  
| `--mis-db-port`      | `MIS_DB_PORT`        |     Нет      | `1433`                | Порт сервера МИС                               |    
| `--mis-db-name`      | `MIS_DB_NAME`        |      Да      |                       | Наименование базы данных                       |    
| `--mis-db-username`  | `MIS_DB_USERNAME`    |     Нет      | `sa`                  | Имя пользователя для подключения к БД МИС      |
| `--mis-db-password`  | `MIS_DB_PASSWORD`    |      Да      |                       | Пароль пользователя для подключения к БД МИС   |
| `--mis-file-path`    | `MIS_FILE_PATH`      |      Да      |                       | Путь до хранилища прикреплённых файлов МИС     |  
| `--log-path`         | `PMA_LOG_PATH`       |     Нет      |                       | Путь для хранения журнала приложения           |         

Ключи `--create-user-id` и `--create-user-name` должны соответствовать полям `UserID` и `FIO` таблицы `x_User`.

Ключи `--file-type-code` и `--file-type-name` должны соответствовать полям `Code` и `Name` таблицы `atf_FileType`. Если совпадение по коду не будет найдено, то программа создаст тип прикрепляемого файла с указанными параметрами. **Внимание!** Поиск типа производится по полю `Code` и используется первое найденное вхождение.

Ключи `--recursive` и `--dry-run` являются флагами и им **не передаются** значения.

При использовании ключа `--log-path` в указанной директории будет формироваться журнал `debug.log` с ротацией каждые 1 Мб и очисткой данных через 3 месяца.

Получить справку по описанным выше параметрам из командной строки можно запустив утилиту с ключом `--help`:

```bash
pm-attacher --help
```

## Запуск

При запуске необходимо определить обязательные параметры (таблица выше) и указать путь, по которому будет производиться обработка файлов:

```bash
pm-attacher [OPTIONS] WATCH_DIR
```
