# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class SolutionControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_solution_template_using_delete(self, solution_template_id, **kwargs):  # noqa: E501
        """deleteSolutionTemplate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_solution_template_using_delete(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_solution_template_using_delete_with_http_info(solution_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_solution_template_using_delete_with_http_info(solution_template_id, **kwargs)  # noqa: E501
            return data

    def delete_solution_template_using_delete_with_http_info(self, solution_template_id, **kwargs):  # noqa: E501
        """deleteSolutionTemplate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_solution_template_using_delete_with_http_info(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['solution_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_solution_template_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'solution_template_id' is set
        if ('solution_template_id' not in params or
                params['solution_template_id'] is None):
            raise ValueError("Missing the required parameter `solution_template_id` when calling `delete_solution_template_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'solution_template_id' in params:
            path_params['solutionTemplateId'] = params['solution_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/solutions/templates/{solutionTemplateId}/delete', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_solution_template_details_using_get(self, solution_template_id, **kwargs):  # noqa: E501
        """getSolutionTemplateDetails  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_solution_template_details_using_get(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: TenantSolutionTemplateDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_solution_template_details_using_get_with_http_info(solution_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_solution_template_details_using_get_with_http_info(solution_template_id, **kwargs)  # noqa: E501
            return data

    def get_solution_template_details_using_get_with_http_info(self, solution_template_id, **kwargs):  # noqa: E501
        """getSolutionTemplateDetails  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_solution_template_details_using_get_with_http_info(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: TenantSolutionTemplateDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['solution_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_solution_template_details_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'solution_template_id' is set
        if ('solution_template_id' not in params or
                params['solution_template_id'] is None):
            raise ValueError("Missing the required parameter `solution_template_id` when calling `get_solution_template_details_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'solution_template_id' in params:
            path_params['solutionTemplateId'] = params['solution_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/solutions/templates/details/{solutionTemplateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantSolutionTemplateDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_solution_template_infos_using_get(self, **kwargs):  # noqa: E501
        """getSolutionTemplateInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_solution_template_infos_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TenantSolutionTemplateInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_solution_template_infos_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_solution_template_infos_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_solution_template_infos_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getSolutionTemplateInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_solution_template_infos_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TenantSolutionTemplateInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_solution_template_infos_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/solutions/templates/infos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TenantSolutionTemplateInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_solution_template_instructions_using_get(self, solution_template_id, **kwargs):  # noqa: E501
        """getSolutionTemplateInstructions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_solution_template_instructions_using_get(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: TenantSolutionTemplateInstructions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_solution_template_instructions_using_get_with_http_info(solution_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_solution_template_instructions_using_get_with_http_info(solution_template_id, **kwargs)  # noqa: E501
            return data

    def get_solution_template_instructions_using_get_with_http_info(self, solution_template_id, **kwargs):  # noqa: E501
        """getSolutionTemplateInstructions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_solution_template_instructions_using_get_with_http_info(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: TenantSolutionTemplateInstructions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['solution_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_solution_template_instructions_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'solution_template_id' is set
        if ('solution_template_id' not in params or
                params['solution_template_id'] is None):
            raise ValueError("Missing the required parameter `solution_template_id` when calling `get_solution_template_instructions_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'solution_template_id' in params:
            path_params['solutionTemplateId'] = params['solution_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/solutions/templates/instructions/{solutionTemplateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantSolutionTemplateInstructions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def install_solution_template_using_post(self, solution_template_id, **kwargs):  # noqa: E501
        """installSolutionTemplate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_solution_template_using_post(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: SolutionInstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.install_solution_template_using_post_with_http_info(solution_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.install_solution_template_using_post_with_http_info(solution_template_id, **kwargs)  # noqa: E501
            return data

    def install_solution_template_using_post_with_http_info(self, solution_template_id, **kwargs):  # noqa: E501
        """installSolutionTemplate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_solution_template_using_post_with_http_info(solution_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str solution_template_id: solutionTemplateId (required)
        :return: SolutionInstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['solution_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_solution_template_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'solution_template_id' is set
        if ('solution_template_id' not in params or
                params['solution_template_id'] is None):
            raise ValueError("Missing the required parameter `solution_template_id` when calling `install_solution_template_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'solution_template_id' in params:
            path_params['solutionTemplateId'] = params['solution_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/solutions/templates/{solutionTemplateId}/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SolutionInstallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
