# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class TenantProfileControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_tenant_profile_using_delete(self, tenant_profile_id, **kwargs):  # noqa: E501
        """deleteTenantProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tenant_profile_using_delete(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tenant_profile_using_delete_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tenant_profile_using_delete_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
            return data

    def delete_tenant_profile_using_delete_with_http_info(self, tenant_profile_id, **kwargs):  # noqa: E501
        """deleteTenantProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tenant_profile_using_delete_with_http_info(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tenant_profile_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_profile_id' is set
        if ('tenant_profile_id' not in params or
                params['tenant_profile_id'] is None):
            raise ValueError("Missing the required parameter `tenant_profile_id` when calling `delete_tenant_profile_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_profile_id' in params:
            path_params['tenantProfileId'] = params['tenant_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfile/{tenantProfileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_default_tenant_profile_info_using_get(self, **kwargs):  # noqa: E501
        """getDefaultTenantProfileInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_default_tenant_profile_info_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EntityInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_default_tenant_profile_info_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_default_tenant_profile_info_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_default_tenant_profile_info_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getDefaultTenantProfileInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_default_tenant_profile_info_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EntityInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_default_tenant_profile_info_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfileInfo/default', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_profile_by_id_using_get(self, tenant_profile_id, **kwargs):  # noqa: E501
        """getTenantProfileById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profile_by_id_using_get(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: TenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_profile_by_id_using_get_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_profile_by_id_using_get_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
            return data

    def get_tenant_profile_by_id_using_get_with_http_info(self, tenant_profile_id, **kwargs):  # noqa: E501
        """getTenantProfileById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profile_by_id_using_get_with_http_info(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: TenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_profile_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_profile_id' is set
        if ('tenant_profile_id' not in params or
                params['tenant_profile_id'] is None):
            raise ValueError("Missing the required parameter `tenant_profile_id` when calling `get_tenant_profile_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_profile_id' in params:
            path_params['tenantProfileId'] = params['tenant_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfile/{tenantProfileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_profile_info_by_id_using_get(self, tenant_profile_id, **kwargs):  # noqa: E501
        """getTenantProfileInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profile_info_by_id_using_get(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: EntityInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_profile_info_by_id_using_get_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_profile_info_by_id_using_get_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
            return data

    def get_tenant_profile_info_by_id_using_get_with_http_info(self, tenant_profile_id, **kwargs):  # noqa: E501
        """getTenantProfileInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profile_info_by_id_using_get_with_http_info(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: EntityInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_profile_info_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_profile_id' is set
        if ('tenant_profile_id' not in params or
                params['tenant_profile_id'] is None):
            raise ValueError("Missing the required parameter `tenant_profile_id` when calling `get_tenant_profile_info_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_profile_id' in params:
            path_params['tenantProfileId'] = params['tenant_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfileInfo/{tenantProfileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_profile_infos_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getTenantProfileInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profile_infos_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataEntityInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_profile_infos_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_profile_infos_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_tenant_profile_infos_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getTenantProfileInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profile_infos_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataEntityInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_profile_infos_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_tenant_profile_infos_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_tenant_profile_infos_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfileInfos{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataEntityInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_profiles_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getTenantProfiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profiles_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataTenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_profiles_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_profiles_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_tenant_profiles_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getTenantProfiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_profiles_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataTenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_profiles_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_tenant_profiles_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_tenant_profiles_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfiles{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataTenantProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_tenant_profile_using_post(self, body, **kwargs):  # noqa: E501
        """saveTenantProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_tenant_profile_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TenantProfile body: tenantProfile (required)
        :return: TenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_tenant_profile_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.save_tenant_profile_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def save_tenant_profile_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """saveTenantProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_tenant_profile_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TenantProfile body: tenantProfile (required)
        :return: TenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_tenant_profile_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_tenant_profile_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfile', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_default_tenant_profile_using_post(self, tenant_profile_id, **kwargs):  # noqa: E501
        """setDefaultTenantProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_default_tenant_profile_using_post(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: TenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_default_tenant_profile_using_post_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_default_tenant_profile_using_post_with_http_info(tenant_profile_id, **kwargs)  # noqa: E501
            return data

    def set_default_tenant_profile_using_post_with_http_info(self, tenant_profile_id, **kwargs):  # noqa: E501
        """setDefaultTenantProfile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_default_tenant_profile_using_post_with_http_info(tenant_profile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_profile_id: tenantProfileId (required)
        :return: TenantProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_profile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_default_tenant_profile_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_profile_id' is set
        if ('tenant_profile_id' not in params or
                params['tenant_profile_id'] is None):
            raise ValueError("Missing the required parameter `tenant_profile_id` when calling `set_default_tenant_profile_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_profile_id' in params:
            path_params['tenantProfileId'] = params['tenant_profile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenantProfile/{tenantProfileId}/default', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
